/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.entity.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.elton.windmeter.WindMeter;
import net.elton.windmeter.block.entity.WindSockBlockEntity;
import net.elton.windmeter.block.entity.renderer.WindSockModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WindSockBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static Map<String, ResourceLocation> resLocMap = Maps.newHashMap();
    private static Map<String, Material> materialMap = Maps.newHashMap();
    public static String texture_location = "textures/block/wind_sock.png";
    protected final WindSockModel model = new WindSockModel(Minecraft.getInstance().getEntityModels().bakeLayer(WindSockModel.LAYER_LOCATION));

    public static Material getMaterial(String path) {
        return materialMap.computeIfAbsent(path, m -> WindSockBlockEntityRenderer.createMaterial(path));
    }

    public static Material createMaterial(String path) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, WindSockBlockEntityRenderer.getTexture(path));
    }

    public static ResourceLocation getTexture(String path) {
        return resLocMap.computeIfAbsent(path, k -> WindMeter.getPath(texture_location));
    }

    public int getViewDistance() {
        return (Integer)Minecraft.getInstance().options.renderDistance().get() * 16;
    }

    public static void renderModel(Material material, Model model, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        model.renderToBuffer(poseStack, buffer.getBuffer(model.renderType(material.texture())), combinedLightIn, combinedOverlayIn, -1);
    }

    public WindSockBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLightIn, int combinedOverlayIn) {
        this.model.mast.getAllParts().forEach(ModelPart::resetPose);
        this.model.sock.getAllParts().forEach(ModelPart::resetPose);
        ModelPart mp = this.model.mast;
        mp.x += 8.0f;
        mp.z += 8.0f;
        mp.xRot += (float)Math.toRadians(180.0);
        mp.yRot += (float)Math.toRadians(0.0);
        mp.y += -24.0f;
        mp = this.model.sock;
        mp.x += 8.0f;
        mp.z += 8.0f;
        mp.xRot += (float)Math.toRadians(0.0);
        mp.yRot += (float)Math.toRadians(0.0);
        mp.y += -1.0f;
        mp = this.model.sockII;
        mp.x += 0.0f;
        mp.z += 0.0f;
        mp.xRot += (float)Math.toRadians(0.0);
        mp.yRot += (float)Math.toRadians(0.0);
        mp.y += 0.0f;
        mp = this.model.sockIII;
        mp.x += 0.0f;
        mp.z += 0.0f;
        mp.xRot += (float)Math.toRadians(0.0);
        mp.yRot += (float)Math.toRadians(0.0);
        mp.y += 0.0f;
        mp = this.model.sockIV;
        mp.x += 0.0f;
        mp.z += 0.0f;
        mp.xRot += (float)Math.toRadians(0.0);
        mp.yRot += (float)Math.toRadians(0.0);
        mp.y += 0.0f;
        mp = this.model.sockV;
        mp.x += 0.0f;
        mp.z += 0.0f;
        mp.xRot += (float)Math.toRadians(0.0);
        mp.yRot += (float)Math.toRadians(0.0);
        mp.y += 0.0f;
        if (blockEntity instanceof WindSockBlockEntity) {
            WindSockBlockEntity windSockBlockEntity = (WindSockBlockEntity)((Object)blockEntity);
            float lerpAngle = Mth.lerp((float)partialTicks, (float)windSockBlockEntity.prevSmoothAngle, (float)windSockBlockEntity.smoothAngle);
            this.model.sock.yRot = -((float)Math.toRadians(windSockBlockEntity.vaneAngle));
            this.model.sockII.xRot = -((float)Math.toRadians(windSockBlockEntity.sockAngle2ToRender - 90.0f));
            this.model.sockII.xScale = windSockBlockEntity.Scale;
            this.model.sockII.yScale = windSockBlockEntity.Scale;
            this.model.sockII.zScale = windSockBlockEntity.Scale;
            this.model.sockIII.xRot = -((float)Math.toRadians(windSockBlockEntity.sockAngle3ToRender));
            this.model.sockIII.xScale = windSockBlockEntity.Scale;
            this.model.sockIII.yScale = windSockBlockEntity.Scale;
            this.model.sockIII.zScale = windSockBlockEntity.Scale;
            this.model.sockIV.xRot = -((float)Math.toRadians(windSockBlockEntity.sockAngle4ToRender));
            this.model.sockIV.xScale = windSockBlockEntity.Scale;
            this.model.sockIV.yScale = windSockBlockEntity.Scale;
            this.model.sockIV.zScale = windSockBlockEntity.Scale;
            this.model.sockV.xRot = -((float)Math.toRadians(windSockBlockEntity.sockAngle5ToRender));
            this.model.sockV.xScale = windSockBlockEntity.Scale;
            this.model.sockV.yScale = windSockBlockEntity.Scale;
            this.model.sockV.zScale = windSockBlockEntity.Scale;
        }
        WindSockBlockEntityRenderer.renderModel(WindSockBlockEntityRenderer.getMaterial("wind_sock"), (Model)this.model, poseStack, multiBufferSource, combinedLightIn, combinedOverlayIn);
    }
}

