/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.block.entity.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.elton.windmeter.WindMeter;
import net.elton.windmeter.block.entity.WindmeterHDBlockEntity;
import net.elton.windmeter.block.entity.renderer.WindmeterHDModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WindmeterHDBlockEntityRenderer<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private static Map<String, ResourceLocation> resLocMap = Maps.newHashMap();
    private static Map<String, Material> materialMap = Maps.newHashMap();
    protected final WindmeterHDModel model = new WindmeterHDModel(Minecraft.getInstance().getEntityModels().bakeLayer(WindmeterHDModel.LAYER_LOCATION));

    public static Material getMaterial(String path) {
        return materialMap.computeIfAbsent(path, m -> WindmeterHDBlockEntityRenderer.createMaterial(path));
    }

    public static Material createMaterial(String path) {
        return new Material(TextureAtlas.LOCATION_BLOCKS, WindmeterHDBlockEntityRenderer.getTexture(path));
    }

    public static ResourceLocation getTexture(String path) {
        return resLocMap.computeIfAbsent(path, k -> WindMeter.getPath("textures/block/wind_meter_hd.png"));
    }

    public static void renderModel(Material material, Model model, PoseStack poseStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        model.renderToBuffer(poseStack, buffer.getBuffer(model.renderType(material.texture())), combinedLightIn, combinedOverlayIn, -1);
    }

    public WindmeterHDBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(T blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int combinedLightIn, int combinedOverlayIn) {
        this.model.mast.getAllParts().forEach(ModelPart::resetPose);
        this.model.nacelle.getAllParts().forEach(ModelPart::resetPose);
        ModelPart mp = this.model.mast;
        mp.x += 8.0f;
        mp.z += 8.0f;
        mp.xRot += (float)Math.toRadians(180.0);
        mp.yRot += (float)Math.toRadians(180.0);
        mp.y += -24.0f;
        mp = this.model.nacelle;
        mp.x += 8.0f;
        mp.z += 8.0f;
        mp.xRot += (float)Math.toRadians(180.0);
        mp.yRot += (float)Math.toRadians(180.0);
        mp.y += 3.0f;
        if (blockEntity instanceof WindmeterHDBlockEntity) {
            WindmeterHDBlockEntity windmeterHDBlockEntity = (WindmeterHDBlockEntity)((Object)blockEntity);
            float lerpAngle = Mth.lerp((float)partialTicks, (float)windmeterHDBlockEntity.prevSmoothAngle, (float)windmeterHDBlockEntity.smoothAngle);
            this.model.rotor.xRot = -((float)Math.toRadians(lerpAngle));
            this.model.nacelle.yRot = -((float)Math.toRadians(windmeterHDBlockEntity.vaneAngle - 90.0f));
        }
        WindmeterHDBlockEntityRenderer.renderModel(WindmeterHDBlockEntityRenderer.getMaterial("wind_meter_hd"), (Model)this.model, poseStack, multiBufferSource, combinedLightIn, combinedOverlayIn);
    }
}

