/*
 * Decompiled with CFR 0.152.
 */
package net.elton.windmeter.screen.custon;

import com.mojang.blaze3d.systems.RenderSystem;
import net.elton.windmeter.block.entity.WeatherDisplayBlockEntity;
import net.elton.windmeter.screen.custon.WeatherDisplayMenu;
import net.elton.windmeter.util.WindMeterUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class WeatherDisplayScreen
extends AbstractContainerScreen<WeatherDisplayMenu> {
    private static final Component TITLE = Component.translatable((String)"gui.windmeter.weather_display_screen");
    private static final Component BUTTON10 = Component.translatable((String)"gui.windmeter.weather_display_screen.button10.button_10");
    private static final Component BUTTON1 = Component.translatable((String)"gui.windmeter.weather_display_screen.button1.button_1");
    private static final Component BUTTON100 = Component.translatable((String)"gui.windmeter.weather_display_screen.button100.button_100");
    private static final Component BUTTONS10 = Component.translatable((String)"gui.windmeter.weather_display_screen.buttons10.button_s10");
    private static final Component BUTTONS1 = Component.translatable((String)"gui.windmeter.weather_display_screen.buttons1.button_s1");
    private static final Component BUTTONS100 = Component.translatable((String)"gui.windmeter.weather_display_screen.buttons100.button_s100");
    private static final Component BUTTON0 = Component.translatable((String)"gui.windmeter.weather_display_screen.button0.button_0");
    private static final Component BUTTON_CONFIRM = Component.translatable((String)"gui.windmeter.weather_display_screen.button_confirm.button_confirm");
    private WeatherDisplayBlockEntity blockEntity;
    private int leftPos;
    private int topPos;
    private int channel_to_set;
    private String chStatus = "Selected channel is transmitting";
    private Button button10;
    private Button button1;
    private Button button100;
    private Button buttonS10;
    private Button buttonS1;
    private Button buttonS100;
    private Button button0;
    private Button buttonConfirm;
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"windmeter", (String)"textures/gui/windmeter/windmeter_gui.png");

    public WeatherDisplayScreen(WeatherDisplayMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 256;
        this.imageHeight = 166;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.channel_to_set = ((WeatherDisplayMenu)this.menu).getMenuChannel();
        if (this.minecraft == null) {
            return;
        }
        ClientLevel level = this.minecraft.level;
        if (level == null) {
            return;
        }
        this.button1 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTON1, this::handleButton1).bounds(this.leftPos + 140, this.topPos + 19, 30, 20).tooltip(Tooltip.create((Component)BUTTON1)).build());
        this.button10 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTON10, this::handleButton10).bounds(this.leftPos + 172, this.topPos + 19, 30, 20).tooltip(Tooltip.create((Component)BUTTON10)).build());
        this.button100 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTON100, this::handleButton100).bounds(this.leftPos + 204, this.topPos + 19, 30, 20).tooltip(Tooltip.create((Component)BUTTON100)).build());
        this.buttonS1 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTONS1, this::handleButtonS1).bounds(this.leftPos + 86, this.topPos + 19, 30, 20).tooltip(Tooltip.create((Component)BUTTONS1)).build());
        this.buttonS10 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTONS10, this::handleButtonS10).bounds(this.leftPos + 54, this.topPos + 19, 30, 20).tooltip(Tooltip.create((Component)BUTTONS10)).build());
        this.buttonS100 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTONS100, this::handleButtonS100).bounds(this.leftPos + 22, this.topPos + 19, 30, 20).tooltip(Tooltip.create((Component)BUTTONS100)).build());
        this.button0 = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTON0, this::handleButton0).bounds(this.leftPos + 36, this.topPos + 40, 80, 20).tooltip(Tooltip.create((Component)BUTTON0)).build());
        this.buttonConfirm = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)BUTTON_CONFIRM, this::handleButtonConfirm).bounds(this.leftPos + 140, this.topPos + 40, 80, 20).tooltip(Tooltip.create((Component)BUTTON_CONFIRM)).build());
    }

    private void handleButton10(Button button) {
        int ch = ((WeatherDisplayMenu)this.menu).getMenuChannel();
        if (this.channel_to_set <= 90) {
            this.channel_to_set += 10;
        } else if (this.channel_to_set >= 91) {
            this.channel_to_set = 100;
        }
    }

    private void handleButton1(Button button) {
        int ch = ((WeatherDisplayMenu)this.menu).getMenuChannel();
        if (this.channel_to_set <= 99) {
            ++this.channel_to_set;
        }
    }

    private void handleButton100(Button button) {
        int ch = ((WeatherDisplayMenu)this.menu).getMenuChannel();
        if (this.channel_to_set <= 0) {
            this.channel_to_set += 100;
        } else if (this.channel_to_set >= 1) {
            this.channel_to_set = 100;
        }
    }

    private void handleButtonS1(Button button) {
        int ch = ((WeatherDisplayMenu)this.menu).getMenuChannel();
        if (this.channel_to_set >= 1) {
            --this.channel_to_set;
        }
    }

    private void handleButtonS10(Button button) {
        int ch = ((WeatherDisplayMenu)this.menu).getMenuChannel();
        if (this.channel_to_set >= 10) {
            this.channel_to_set -= 10;
        } else if (this.channel_to_set < 10) {
            this.channel_to_set = 0;
        }
    }

    private void handleButtonS100(Button button) {
        int ch = ((WeatherDisplayMenu)this.menu).getMenuChannel();
        if (this.channel_to_set >= 100) {
            this.channel_to_set -= 100;
        } else if (this.channel_to_set < 100) {
            this.channel_to_set = 0;
        }
    }

    private void handleButton0(Button button) {
        this.channel_to_set = 0;
    }

    private void handleButtonConfirm(Button button) {
        ((WeatherDisplayMenu)this.menu).setMenuChannel(this.channel_to_set);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2 - 80;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        this.renderBackground(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.deleteTexture((int)0);
        int TextShift = this.font.width("" + this.channel_to_set);
        int TextShift2 = this.font.width("Channel setup") / 2;
        int TextShift4 = this.font.width(this.chStatus) / 2;
        super.render(guiGraphics, pMouseX, pMouseY, pPartialTicks);
        guiGraphics.drawString(this.font, "%d".formatted(this.channel_to_set), this.leftPos + 128 - TextShift + 9, this.topPos + 26, 16737095, false);
        guiGraphics.drawString(this.font, "Channel setup", this.leftPos + 128 - TextShift2, this.topPos + 9, 0xFFFFFF, false);
        if (WindMeterUtils.posArrayXClient.get(this.channel_to_set) != 0 || WindMeterUtils.posArrayYClient.get(this.channel_to_set) != 0 || WindMeterUtils.posArrayZClient.get(this.channel_to_set) != 0) {
            guiGraphics.drawString(this.font, this.chStatus, this.leftPos + 128 - TextShift4, this.topPos + 90, 0xFFFFFF, false);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

