/*
 * Decompiled with CFR 0.152.
 */
package us.timinc.mc.cobblemon.unchained.booster;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.FossilRevivedEvent;
import com.cobblemon.mod.common.api.events.pokemon.HatchEggEvent;
import com.cobblemon.mod.common.api.events.pokemon.PokemonCapturedEvent;
import com.cobblemon.mod.common.api.spawning.SpawnBucket;
import com.cobblemon.mod.common.api.spawning.context.SpawningContext;
import com.cobblemon.mod.common.api.spawning.context.calculators.SpawningContextCalculator;
import com.cobblemon.mod.common.api.spawning.detail.PokemonSpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnAction;
import com.cobblemon.mod.common.api.spawning.detail.SpawnDetail;
import com.cobblemon.mod.common.api.spawning.influence.SpawningInfluence;
import com.cobblemon.mod.common.api.spawning.spawner.PlayerSpawnerFactory;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.platform.events.PlatformEvents;
import com.cobblemon.mod.common.pokemon.Pokemon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.timinc.mc.cobblemon.timcore.AbstractHandler;
import us.timinc.mc.cobblemon.timcore.PokemonExtensionsKt;
import us.timinc.mc.cobblemon.timcore.PokemonRepresentation;
import us.timinc.mc.cobblemon.unchained.Unchained;
import us.timinc.mc.cobblemon.unchained.booster.AbstractBooster;
import us.timinc.mc.cobblemon.unchained.booster.AbstractBoosterRunner;
import us.timinc.mc.cobblemon.unchained.booster.HiddenBooster;
import us.timinc.mc.cobblemon.unchained.config.HiddenBoosterConfig;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\u0006\u0007\b\t\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003\u00a8\u0006\u000b"}, d2={"Lus/timinc/mc/cobblemon/unchained/booster/HiddenBooster;", "Lus/timinc/mc/cobblemon/unchained/booster/AbstractBooster;", "<init>", "()V", "", "initialize", "HiddenBoosterInfluence", "HiddenCaptureHandler", "HiddenEggHandler", "HiddenFossilHandler", "Runner", "common"})
public final class HiddenBooster
extends AbstractBooster {
    @NotNull
    public static final HiddenBooster INSTANCE = new HiddenBooster();

    private HiddenBooster() {
    }

    @Override
    public void initialize() {
        PlayerSpawnerFactory.INSTANCE.getInfluenceBuilders().add(initialize.1.INSTANCE);
        PlatformEvents.SERVER_STARTED.subscribe(Priority.LOWEST, (Function1)initialize.2.INSTANCE);
        CobblemonEvents.HATCH_EGG_PRE.subscribe(Priority.LOWEST, (Function1)new Function1<HatchEggEvent.Pre, Unit>((Object)HiddenEggHandler.INSTANCE){

            public final void invoke(@NotNull HatchEggEvent.Pre p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((HiddenEggHandler)((Object)this.receiver)).handle(p0);
            }
        });
        CobblemonEvents.FOSSIL_REVIVED.subscribe(Priority.LOWEST, (Function1)new Function1<FossilRevivedEvent, Unit>((Object)HiddenFossilHandler.INSTANCE){

            public final void invoke(@NotNull FossilRevivedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((HiddenFossilHandler)((Object)this.receiver)).handle(p0);
            }
        });
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.LOWEST, (Function1)new Function1<PokemonCapturedEvent, Unit>((Object)HiddenCaptureHandler.INSTANCE){

            public final void invoke(@NotNull PokemonCapturedEvent p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((HiddenCaptureHandler)((Object)this.receiver)).handle(p0);
            }
        });
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\u000b\u001a\u00020\n2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\rR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lus/timinc/mc/cobblemon/unchained/booster/HiddenBooster$HiddenBoosterInfluence;", "Lcom/cobblemon/mod/common/api/spawning/influence/SpawningInfluence;", "Lus/timinc/mc/cobblemon/unchained/config/HiddenBoosterConfig;", "config", "Lnet/minecraft/server/level/ServerPlayer;", "player", "<init>", "(Lus/timinc/mc/cobblemon/unchained/config/HiddenBoosterConfig;Lnet/minecraft/server/level/ServerPlayer;)V", "Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;", "action", "", "affectAction", "(Lcom/cobblemon/mod/common/api/spawning/detail/SpawnAction;)V", "Lus/timinc/mc/cobblemon/unchained/config/HiddenBoosterConfig;", "Lnet/minecraft/server/level/ServerPlayer;", "common"})
    public static final class HiddenBoosterInfluence
    implements SpawningInfluence {
        @NotNull
        private final HiddenBoosterConfig config;
        @Nullable
        private final ServerPlayer player;

        public HiddenBoosterInfluence(@NotNull HiddenBoosterConfig config, @Nullable ServerPlayer player) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            this.config = config;
            this.player = player;
        }

        public /* synthetic */ HiddenBoosterInfluence(HiddenBoosterConfig hiddenBoosterConfig, ServerPlayer serverPlayer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                serverPlayer = null;
            }
            this(hiddenBoosterConfig, serverPlayer);
        }

        public void affectAction(@NotNull SpawnAction<?> action) {
            Entity entity;
            Intrinsics.checkNotNullParameter(action, (String)"action");
            if (!(action instanceof PokemonSpawnAction)) {
                return;
            }
            ServerPlayer serverPlayer = this.player;
            if (serverPlayer == null && (serverPlayer = (entity = action.getCtx().getCause().getEntity()) instanceof ServerPlayer ? (ServerPlayer)entity : null) == null) {
                return;
            }
            ServerPlayer player = serverPlayer;
            PokemonRepresentation.FromProperties pokemonRep = new PokemonRepresentation.FromProperties(((PokemonSpawnAction)action).getProps());
            new Runner(player, (PokemonRepresentation)pokemonRep, this.config, (Function0<Unit>)((Function0)new Function0<Unit>(action, player){
                final /* synthetic */ SpawnAction<?> $action;
                final /* synthetic */ ServerPlayer $player;
                {
                    this.$action = $action;
                    this.$player = $player;
                    super(0);
                }

                public final void invoke() {
                    PokemonExtensionsKt.reserveFor((Pokemon)((PokemonEntity)((PokemonSpawnAction)this.$action).getEntity().await()).getPokemon(), (ServerPlayer)this.$player);
                }
            })).runThrough();
        }

        public float affectBucketWeight(@NotNull SpawnBucket bucket, float weight) {
            return SpawningInfluence.DefaultImpls.affectBucketWeight((SpawningInfluence)this, (SpawnBucket)bucket, (float)weight);
        }

        public void affectSpawn(@NotNull Entity entity) {
            SpawningInfluence.DefaultImpls.affectSpawn((SpawningInfluence)this, (Entity)entity);
        }

        public boolean affectSpawnable(@NotNull SpawnDetail detail, @NotNull SpawningContext ctx) {
            return SpawningInfluence.DefaultImpls.affectSpawnable((SpawningInfluence)this, (SpawnDetail)detail, (SpawningContext)ctx);
        }

        public float affectWeight(@NotNull SpawnDetail detail, @NotNull SpawningContext ctx, float weight) {
            return SpawningInfluence.DefaultImpls.affectWeight((SpawningInfluence)this, (SpawnDetail)detail, (SpawningContext)ctx, (float)weight);
        }

        public boolean isAllowedPosition(@NotNull ServerLevel world, @NotNull BlockPos pos, @NotNull SpawningContextCalculator<?, ?> contextCalculator) {
            return SpawningInfluence.DefaultImpls.isAllowedPosition((SpawningInfluence)this, (ServerLevel)world, (BlockPos)pos, contextCalculator);
        }

        public boolean isExpired() {
            return SpawningInfluence.DefaultImpls.isExpired((SpawningInfluence)this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lus/timinc/mc/cobblemon/unchained/booster/HiddenBooster$HiddenCaptureHandler;", "Lus/timinc/mc/cobblemon/timcore/AbstractHandler;", "Lcom/cobblemon/mod/common/api/events/pokemon/PokemonCapturedEvent;", "<init>", "()V", "evt", "", "handle", "(Lcom/cobblemon/mod/common/api/events/pokemon/PokemonCapturedEvent;)V", "common"})
    public static final class HiddenCaptureHandler
    extends AbstractHandler<PokemonCapturedEvent> {
        @NotNull
        public static final HiddenCaptureHandler INSTANCE = new HiddenCaptureHandler();

        private HiddenCaptureHandler() {
        }

        public void handle(@NotNull PokemonCapturedEvent evt) {
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            new Runner(evt.getPlayer(), (PokemonRepresentation)new PokemonRepresentation.FromPokemon(evt.getPokemon()), Unchained.INSTANCE.getHiddenCaptureBooster(), null, 8, null).runThrough();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lus/timinc/mc/cobblemon/unchained/booster/HiddenBooster$HiddenEggHandler;", "Lus/timinc/mc/cobblemon/timcore/AbstractHandler;", "Lcom/cobblemon/mod/common/api/events/pokemon/HatchEggEvent$Pre;", "<init>", "()V", "evt", "", "handle", "(Lcom/cobblemon/mod/common/api/events/pokemon/HatchEggEvent$Pre;)V", "common"})
    public static final class HiddenEggHandler
    extends AbstractHandler<HatchEggEvent.Pre> {
        @NotNull
        public static final HiddenEggHandler INSTANCE = new HiddenEggHandler();

        private HiddenEggHandler() {
        }

        public void handle(@NotNull HatchEggEvent.Pre evt) {
            Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
            ServerPlayer player = evt.getPlayer();
            PokemonRepresentation.FromProperties pokemonRep = new PokemonRepresentation.FromProperties(evt.getEgg());
            new Runner(player, (PokemonRepresentation)pokemonRep, Unchained.INSTANCE.getHiddenEggBooster(), null, 8, null).runThrough();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lus/timinc/mc/cobblemon/unchained/booster/HiddenBooster$HiddenFossilHandler;", "Lus/timinc/mc/cobblemon/timcore/AbstractHandler;", "Lcom/cobblemon/mod/common/api/events/pokemon/FossilRevivedEvent;", "<init>", "()V", "evt", "", "handle", "(Lcom/cobblemon/mod/common/api/events/pokemon/FossilRevivedEvent;)V", "common"})
    public static final class HiddenFossilHandler
    extends AbstractHandler<FossilRevivedEvent> {
        @NotNull
        public static final HiddenFossilHandler INSTANCE = new HiddenFossilHandler();

        private HiddenFossilHandler() {
        }

        public void handle(@NotNull FossilRevivedEvent evt) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                ServerPlayer serverPlayer = evt.getPlayer();
                if (serverPlayer == null) break block0;
                ServerPlayer it = serverPlayer;
                boolean bl = false;
                new Runner(it, (PokemonRepresentation)new PokemonRepresentation.FromPokemon(evt.getPokemon()), Unchained.INSTANCE.getHiddenRezBooster(), null, 8, null).runThrough();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\u00028\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lus/timinc/mc/cobblemon/unchained/booster/HiddenBooster$Runner;", "Lus/timinc/mc/cobblemon/unchained/booster/AbstractBoosterRunner;", "Lus/timinc/mc/cobblemon/unchained/config/HiddenBoosterConfig;", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lus/timinc/mc/cobblemon/timcore/PokemonRepresentation;", "pokemon", "config", "Lkotlin/Function0;", "", "lockToPlayer", "<init>", "(Lnet/minecraft/server/level/ServerPlayer;Lus/timinc/mc/cobblemon/timcore/PokemonRepresentation;Lus/timinc/mc/cobblemon/unchained/config/HiddenBoosterConfig;Lkotlin/jvm/functions/Function0;)V", "boost", "()V", "", "roll", "()Z", "test", "Lus/timinc/mc/cobblemon/unchained/config/HiddenBoosterConfig;", "getConfig", "()Lus/timinc/mc/cobblemon/unchained/config/HiddenBoosterConfig;", "common"})
    public static final class Runner
    extends AbstractBoosterRunner<HiddenBoosterConfig> {
        @NotNull
        private final HiddenBoosterConfig config;

        public Runner(@NotNull ServerPlayer player, @NotNull PokemonRepresentation<?> pokemon, @NotNull HiddenBoosterConfig config, @NotNull Function0<Unit> lockToPlayer) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Intrinsics.checkNotNullParameter(pokemon, (String)"pokemon");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter(lockToPlayer, (String)"lockToPlayer");
            super(player, pokemon, lockToPlayer);
            this.config = config;
        }

        public /* synthetic */ Runner(ServerPlayer serverPlayer, PokemonRepresentation pokemonRepresentation, HiddenBoosterConfig hiddenBoosterConfig, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                function0 = 1.INSTANCE;
            }
            this(serverPlayer, pokemonRepresentation, hiddenBoosterConfig, (Function0<Unit>)function0);
        }

        @Override
        @NotNull
        public HiddenBoosterConfig getConfig() {
            return this.config;
        }

        @Override
        public boolean roll() {
            int totalMarbles = this.getConfig().getMarbles();
            float roll = Random.Default.nextFloat() * (float)totalMarbles;
            boolean successfulRoll = roll < this.getUnlockedBoost();
            AbstractBoosterRunner.debug$default(this, this.getPlayer().getName().getString() + " has a boost of " + this.getUnlockedBoost() + ", has a " + this.getUnlockedBoost() + " out of " + totalMarbles + ", rolls a " + roll + ", " + (successfulRoll ? "wins" : "loses"), false, 2, null);
            return successfulRoll;
        }

        @Override
        public boolean test() {
            if (!this.getPokemon().getHasHiddenAbility()) {
                AbstractBoosterRunner.debug$default(this, this.getSpecies().getResourceIdentifier() + "|" + this.getForm().getName() + " doesn't have hidden ability.", false, 2, null);
                return false;
            }
            return true;
        }

        @Override
        public void boost() {
            this.getPokemon().giveHiddenAbility();
            AbstractBoosterRunner.debug$default(this, "Gave hidden ability " + this.getPokemon().getAbilityName(), false, 2, null);
        }
    }
}

