/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.bootifulblockoutline;

import com.fox2code.foxloader.config.ConfigEntry;
import com.fox2code.foxloader.config.ConfigIO;
import com.fox2code.foxloader.loader.Mod;
import com.fox2code.foxloader.loader.ModContainer;
import java.awt.Color;

public class BootifulBlockOutline
extends Mod {
    public static final ModConfig CONFIG = new ModConfig();
    private static ModContainer INTERNAL_CONTAINER;

    public void onPreInit() {
        INTERNAL_CONTAINER = this.getModContainer();
        this.setConfigObject(CONFIG);
    }

    public static void forceSaveConfig() {
        ConfigIO.writeConfiguration((ModContainer)INTERNAL_CONTAINER, (Object)CONFIG);
    }

    public static short safeStringToShort(String s) {
        if (s == null || s.isEmpty()) {
            return 0;
        }
        return (short)Math.max(0, Math.min(255, Integer.parseInt(s)));
    }

    public static boolean isValidInputDigit(char eventChar, int eventKey) {
        return Character.isDigit(eventChar) || eventKey == 14 || eventKey == 203 || eventKey == 205;
    }

    public static boolean isValidInputHEX(char c, int eventKey) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || eventKey == 14 || eventKey == 203 || eventKey == 205;
    }

    public static boolean withinUnsignedByte(short value, char input) {
        if (Character.isDigit(input)) {
            return Short.parseShort(String.valueOf(value) + input) < 256;
        }
        return true;
    }

    public static String fixColorHex(String damaged) {
        if (damaged.length() == 8) {
            return damaged;
        }
        if (damaged.length() > 8) {
            return damaged.substring(0, 8);
        }
        return damaged + "0".repeat(8 - damaged.length());
    }

    public static float normalizeFloat(float value, float lower, float upper) {
        return (float)Math.round((value - lower) / upper * 10.0f) / 10.0f;
    }

    public static float denormalizeFloat(float value, float lower, float upper) {
        return (float)Math.round((lower + value * upper) * 10.0f) / 10.0f;
    }

    public static int getSilverARGB() {
        return Color.HSBtoRGB((float)(System.currentTimeMillis() % 5000L) / 5000.0f, 1.0f, 1.0f) & 0xFFFFFF | 0xFF000000;
    }

    public static class ModConfig {
        @ConfigEntry(configComment="0 - disabled (no render), 1 - ARGB static color, 2 - RGB rainbow color", lowerBounds=0.0, upperBounds=2.0)
        public byte blockOutlineMode = 1;
        @ConfigEntry(configComment="Follows 0xAARRGGBB format but int")
        public int blockOutlineColor = -16777216;
        @ConfigEntry(lowerBounds=1.0, upperBounds=4.0)
        public float blockOutlineWidth = 2.0f;
        @ConfigEntry(configComment="0 - disabled (no render), 1 - ARGB static color, 2 - RGB rainbow color", lowerBounds=0.0, upperBounds=2.0)
        public byte entityOutlineMode = 1;
        @ConfigEntry(configComment="Follows 0xAARRGGBB format but int")
        public int entityOutlineColor = -16777216;
        @ConfigEntry(lowerBounds=1.0, upperBounds=4.0)
        public float entityOutlineWidth = 2.0f;
    }
}

