/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.bootifulblockoutline.gui;

import java.util.function.IntConsumer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.common.util.i18n.StringTranslate;
import net.tracystacktrace.bootifulblockoutline.BootifulBlockOutline;
import net.tracystacktrace.bootifulblockoutline.gui.element.GuiSliderCompact;
import net.tracystacktrace.bootifulblockoutline.gui.element.IUpdateSliders;
import org.lwjgl.input.Keyboard;

public class GuiChangeARGB
extends GuiScreen
implements IUpdateSliders {
    private GuiTextField redIntTextField;
    private GuiSliderCompact redIntSlider;
    private short red;
    private GuiTextField greenIntTextField;
    private GuiSliderCompact greenIntSlider;
    private short green;
    private GuiTextField blueIntTextField;
    private GuiSliderCompact blueIntSlider;
    private short blue;
    private GuiTextField alphaIntTextField;
    private GuiSliderCompact alphaIntSlider;
    private short alpha;
    private GuiTextField hexTextField;
    private final GuiScreen parentScreen;
    private final IntConsumer handleResult;
    protected final String screenTitle;

    public GuiChangeARGB(GuiScreen parentScreen, String title, int argb, IntConsumer onAcceptChange) {
        this.parentScreen = parentScreen;
        this.screenTitle = StringTranslate.getInstance().translateKey(title);
        this.handleResult = onAcceptChange;
        this.alpha = (short)(argb >> 24 & 0xFF);
        this.red = (short)(argb >> 16 & 0xFF);
        this.green = (short)(argb >> 8 & 0xFF);
        this.blue = (short)(argb & 0xFF);
    }

    public void initGui() {
        this.controlList.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        int offsetX = this.width / 2 - 120;
        int offsetY = this.height / 2 - 55;
        StringTranslate translate = StringTranslate.getInstance();
        this.controlList.add(new GuiButton(1, this.width / 2 - 45, offsetY + 120, 90, 20, translate.translateKey("gui.done")));
        this.redIntSlider = new GuiSliderCompact(2, offsetX, offsetY, translate.translateKeyFormat("bootifulblockoutline.red", (int)this.red), (float)this.red / 255.0f, this);
        this.greenIntSlider = new GuiSliderCompact(3, offsetX, offsetY + 30, translate.translateKeyFormat("bootifulblockoutline.green", (int)this.green), (float)this.green / 255.0f, this);
        this.blueIntSlider = new GuiSliderCompact(4, offsetX, offsetY + 60, translate.translateKeyFormat("bootifulblockoutline.blue", (int)this.blue), (float)this.blue / 255.0f, this);
        this.alphaIntSlider = new GuiSliderCompact(5, offsetX, offsetY + 90, translate.translateKeyFormat("bootifulblockoutline.alpha", (int)this.alpha), (float)this.alpha / 255.0f, this);
        this.controlList.add(this.redIntSlider);
        this.controlList.add(this.greenIntSlider);
        this.controlList.add(this.blueIntSlider);
        this.controlList.add(this.alphaIntSlider);
        this.redIntTextField = new GuiTextField(offsetX + 110, offsetY, 50, 20, String.valueOf(this.red));
        this.greenIntTextField = new GuiTextField(offsetX + 110, offsetY + 30, 50, 20, String.valueOf(this.green));
        this.blueIntTextField = new GuiTextField(offsetX + 110, offsetY + 60, 50, 20, String.valueOf(this.blue));
        this.alphaIntTextField = new GuiTextField(offsetX + 110, offsetY + 90, 50, 20, String.valueOf(this.alpha));
        this.redIntTextField.setMaxStringLength(3);
        this.redIntTextField.isEnabled = true;
        this.greenIntTextField.setMaxStringLength(3);
        this.greenIntTextField.isEnabled = true;
        this.blueIntTextField.setMaxStringLength(3);
        this.blueIntTextField.isEnabled = true;
        this.alphaIntTextField.setMaxStringLength(3);
        this.alphaIntTextField.isEnabled = true;
        this.hexTextField = new GuiTextField(offsetX + 170, offsetY, 70, 20, "");
        this.hexTextField.setMaxStringLength(8);
        this.hexTextField.isEnabled = true;
        this.updateHexTextFieldDisplayString();
    }

    public void onGuiClosed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void updateScreen() {
        super.updateScreen();
        this.redIntTextField.updateCursorCounter();
        this.greenIntTextField.updateCursorCounter();
        this.blueIntTextField.updateCursorCounter();
        this.alphaIntTextField.updateCursorCounter();
        this.hexTextField.updateCursorCounter();
    }

    public void keyTyped(char eventChar, int eventKey) {
        if (this.redIntTextField.isFocused && BootifulBlockOutline.isValidInputDigit(eventChar, eventKey) && BootifulBlockOutline.withinUnsignedByte(this.red, eventChar)) {
            this.redIntTextField.textboxKeyTyped(eventChar, eventKey);
            this.onUpdateFromTextFields();
        }
        if (this.greenIntTextField.isFocused && BootifulBlockOutline.isValidInputDigit(eventChar, eventKey) && BootifulBlockOutline.withinUnsignedByte(this.green, eventChar)) {
            this.greenIntTextField.textboxKeyTyped(eventChar, eventKey);
            this.onUpdateFromTextFields();
        }
        if (this.blueIntTextField.isFocused && BootifulBlockOutline.isValidInputDigit(eventChar, eventKey) && BootifulBlockOutline.withinUnsignedByte(this.blue, eventChar)) {
            this.blueIntTextField.textboxKeyTyped(eventChar, eventKey);
            this.onUpdateFromTextFields();
        }
        if (this.alphaIntTextField.isFocused && BootifulBlockOutline.isValidInputDigit(eventChar, eventKey) && BootifulBlockOutline.withinUnsignedByte(this.alpha, eventChar)) {
            this.alphaIntTextField.textboxKeyTyped(eventChar, eventKey);
            this.onUpdateFromTextFields();
        }
        if (this.hexTextField.isFocused && BootifulBlockOutline.isValidInputHEX(eventChar, eventKey)) {
            this.hexTextField.textboxKeyTyped(eventChar, eventKey);
            this.onUpdateFromHexField();
        }
        if (eventKey == 1) {
            this.mc.displayGuiScreen(this.parentScreen);
        }
        if (eventChar == '\r') {
            this.saveResult();
            this.mc.displayGuiScreen(this.parentScreen);
        }
    }

    public void mouseClicked(float x, float y, int click) {
        super.mouseClicked(x, y, click);
        this.redIntTextField.mouseClicked(x, y, click);
        this.greenIntTextField.mouseClicked(x, y, click);
        this.blueIntTextField.mouseClicked(x, y, click);
        this.alphaIntTextField.mouseClicked(x, y, click);
        this.hexTextField.mouseClicked(x, y, click);
    }

    public void drawScreen(float mouseX, float mouseY, float deltaTicks) {
        this.drawDefaultBackground();
        this.redIntTextField.drawTextBox();
        this.greenIntTextField.drawTextBox();
        this.blueIntTextField.drawTextBox();
        this.alphaIntTextField.drawTextBox();
        this.hexTextField.drawTextBox();
        int offsetX = this.width / 2 - 120;
        int offsetY = this.height / 2 - 40;
        this.drawCenteredString(this.fontRenderer, this.screenTitle, (float)this.width / 2.0f, offsetY - 34, 0xFFFFFF);
        super.drawScreen(mouseX, mouseY, deltaTicks);
        GuiChangeARGB.drawRect((float)(offsetX + 170), (float)(offsetY + 15), (float)(offsetX + 170 + 70), (float)(offsetY + 15 + 80), (int)((this.alpha & 0xFF) << 24 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF));
    }

    protected void actionPerformed(GuiButton guiButton) {
        if (guiButton.enabled && guiButton.id == 1) {
            this.saveResult();
            this.mc.displayGuiScreen(this.parentScreen);
        }
    }

    public void saveResult() {
        this.handleResult.accept((this.alpha & 0xFF) << 24 | (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF);
    }

    private void onUpdateFromTextFields() {
        this.red = BootifulBlockOutline.safeStringToShort(this.redIntTextField.getText());
        this.green = BootifulBlockOutline.safeStringToShort(this.greenIntTextField.getText());
        this.blue = BootifulBlockOutline.safeStringToShort(this.blueIntTextField.getText());
        this.alpha = BootifulBlockOutline.safeStringToShort(this.alphaIntTextField.getText());
        this.updateSlidersDisplayString();
        this.updateHexTextFieldDisplayString();
    }

    @Override
    public void onUpdateFromSliders() {
        this.red = (short)(this.redIntSlider.sliderValue * 255.0f + 0.5f);
        this.green = (short)(this.greenIntSlider.sliderValue * 255.0f + 0.5f);
        this.blue = (short)(this.blueIntSlider.sliderValue * 255.0f + 0.5f);
        this.alpha = (short)(this.alphaIntSlider.sliderValue * 255.0f + 0.5f);
        StringTranslate translate = StringTranslate.getInstance();
        this.redIntSlider.displayString = translate.translateKeyFormat("bootifulblockoutline.red", (int)this.red);
        this.greenIntSlider.displayString = translate.translateKeyFormat("bootifulblockoutline.green", (int)this.green);
        this.blueIntSlider.displayString = translate.translateKeyFormat("bootifulblockoutline.blue", (int)this.blue);
        this.alphaIntSlider.displayString = translate.translateKeyFormat("bootifulblockoutline.alpha", (int)this.alpha);
        this.updateTextFieldsDisplayString();
        this.updateHexTextFieldDisplayString();
    }

    private void onUpdateFromHexField() {
        String safeHex = BootifulBlockOutline.fixColorHex(this.hexTextField.getText());
        this.alpha = (short)Integer.parseInt(safeHex.substring(0, 2), 16);
        this.red = (short)Integer.parseInt(safeHex.substring(2, 4), 16);
        this.green = (short)Integer.parseInt(safeHex.substring(4, 6), 16);
        this.blue = (short)Integer.parseInt(safeHex.substring(6, 8), 16);
        this.updateSlidersDisplayString();
        this.updateTextFieldsDisplayString();
    }

    private void updateSlidersDisplayString() {
        this.redIntSlider.sliderValue = (float)this.red / 255.0f;
        this.greenIntSlider.sliderValue = (float)this.green / 255.0f;
        this.blueIntSlider.sliderValue = (float)this.blue / 255.0f;
        this.alphaIntSlider.sliderValue = (float)this.alpha / 255.0f;
        StringTranslate translate = StringTranslate.getInstance();
        this.redIntSlider.displayString = translate.translateKeyFormat("bootifulblockoutline.red", (int)this.red);
        this.greenIntSlider.displayString = translate.translateKeyFormat("bootifulblockoutline.green", (int)this.green);
        this.blueIntSlider.displayString = translate.translateKeyFormat("bootifulblockoutline.blue", (int)this.blue);
        this.alphaIntSlider.displayString = translate.translateKeyFormat("bootifulblockoutline.alpha", (int)this.alpha);
    }

    private void updateTextFieldsDisplayString() {
        this.redIntTextField.setText(String.valueOf(this.red));
        this.greenIntTextField.setText(String.valueOf(this.green));
        this.blueIntTextField.setText(String.valueOf(this.blue));
        this.alphaIntTextField.setText(String.valueOf(this.alpha));
        this.redIntTextField.moveCursorBy(4);
        this.greenIntTextField.moveCursorBy(4);
        this.blueIntTextField.moveCursorBy(4);
        this.alphaIntTextField.moveCursorBy(4);
    }

    private void updateHexTextFieldDisplayString() {
        String formatted = String.format("%02X%02X%02X%02X", this.alpha, this.red, this.green, this.blue);
        this.hexTextField.setText(formatted);
        this.hexTextField.moveCursorBy(6);
    }
}

