/*
 * Decompiled with CFR 0.152.
 */
package net.tracystacktrace.bootifulblockoutline.mixins;

import net.minecraft.client.renderer.world.RenderGlobal;
import net.minecraft.client.renderer.world.Tessellator;
import net.minecraft.common.entity.player.EntityPlayer;
import net.minecraft.common.util.math.AxisAlignedBB;
import net.minecraft.common.util.physics.MovingObjectPosition;
import net.minecraft.common.world.EnumMovingObjectType;
import net.tracystacktrace.bootifulblockoutline.BootifulBlockOutline;
import net.tracystacktrace.bootifulblockoutline.inject.CustomOutlineRenderer;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RenderGlobal.class})
public class MixinRenderGlobal {
    @Inject(method={"drawSelectionBox"}, at={@At(value="HEAD")}, cancellable=true)
    private void bootifulblockoutline$injectInitialChecks(EntityPlayer player, MovingObjectPosition hitResult, float deltaTicks, CallbackInfo ci) {
        if (BootifulBlockOutline.CONFIG.blockOutlineMode == 0 && hitResult.typeOfHit == EnumMovingObjectType.TILE) {
            ci.cancel();
            return;
        }
        if (BootifulBlockOutline.CONFIG.entityOutlineMode == 0 && hitResult.typeOfHit == EnumMovingObjectType.ENTITY) {
            ci.cancel();
            return;
        }
        if (BootifulBlockOutline.CONFIG.entityOutlineMode != 0 && hitResult.typeOfHit == EnumMovingObjectType.ENTITY) {
            CustomOutlineRenderer.renderEntityOutline(player, hitResult, deltaTicks);
            ci.cancel();
        }
    }

    @Redirect(method={"drawSelectionBox"}, at=@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glLineWidth(F)V"))
    private void bootifulblockoutline$injectWidth(float width) {
        GL11.glLineWidth((float)BootifulBlockOutline.CONFIG.blockOutlineWidth);
    }

    @Redirect(method={"drawOutlinedBoundingBox"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/world/Tessellator;setColorOpaque_I(I)V"))
    private void bootifulblockoutline$redirectToBlockColor(Tessellator instance, int color) {
        int argb = BootifulBlockOutline.CONFIG.blockOutlineMode == 1 ? BootifulBlockOutline.CONFIG.blockOutlineColor : BootifulBlockOutline.getSilverARGB();
        short alpha = (short)(argb >> 24 & 0xFF);
        short red = (short)(argb >> 16 & 0xFF);
        short green = (short)(argb >> 8 & 0xFF);
        short blue = (short)(argb & 0xFF);
        instance.setColorRGBA((int)red, (int)green, (int)blue, (int)alpha);
    }

    @ModifyVariable(method={"drawOutlinedBoundingBox"}, at=@At(value="STORE"), ordinal=0, argsOnly=true)
    private AxisAlignedBB bootifulblockoutline$modifyAABBOffset(AxisAlignedBB aabb) {
        float offset = BootifulBlockOutline.CONFIG.blockOutlineWidth / 2.0f * 0.002f;
        return aabb.expand((double)offset, (double)offset, (double)offset);
    }
}

