/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfcmd.argument;

import dev.jorel.commandapi.nametag.arguments.GreedyStringArgument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlagArgument
extends GreedyStringArgument {
    protected final Set<Character> allFlags;
    protected final Set<Character> valueFlags;

    public FlagArgument(String nodeName, Set<Character> flags) {
        this(nodeName, flags, new HashSet<Character>());
    }

    public FlagArgument(String nodeName, Set<Character> flags, Set<Character> valueFlags) {
        super(nodeName);
        this.valueFlags = valueFlags;
        this.allFlags = new HashSet<Character>(flags);
        this.allFlags.addAll(valueFlags);
        this.replaceSuggestions((info, builder) -> {
            String fullInput = info.currentInput().trim();
            String currentArg = info.currentArg();
            boolean endsWithSpace = info.currentInput().endsWith(" ");
            HashSet<Character> usedFlags = new HashSet<Character>();
            for (String part : fullInput.split("\\s+")) {
                if (!part.startsWith("-") || part.length() <= 1) continue;
                for (char c2 : part.substring(1).toCharArray()) {
                    usedFlags.add(Character.valueOf(c2));
                }
            }
            List<Character> unusedFlags = this.allFlags.stream().filter(f -> !usedFlags.contains(f)).toList();
            if (!endsWithSpace) {
                String clean = currentArg.substring(1);
                for (Character f2 : unusedFlags) {
                    builder.suggest("-" + clean + f2);
                }
            } else {
                for (Character f3 : unusedFlags) {
                    builder.suggest(currentArg + "-" + f3);
                }
            }
            return builder.buildFuture();
        });
    }

    public static boolean hasFlags(String input, String flagSet) {
        String[] parts;
        if (flagSet == null || flagSet.isEmpty() || input == null) {
            return false;
        }
        HashSet<Character> presentFlags = new HashSet<Character>();
        for (String part : parts = input.trim().split("\\s+")) {
            if (!part.startsWith("-") || part.length() <= 1 || part.matches("-\\d+")) continue;
            String chunk = part.substring(1);
            for (char c2 : chunk.toCharArray()) {
                presentFlags.add(Character.valueOf(c2));
            }
        }
        for (char c3 : flagSet.toCharArray()) {
            if (presentFlags.contains(Character.valueOf(c3))) continue;
            return false;
        }
        return true;
    }

    public static ParsedFlags parseFlags(String input, Set<Character> flagsWithValue) {
        ParsedFlags parsed = new ParsedFlags();
        if (input == null || input.isEmpty()) {
            return parsed;
        }
        String[] args = input.trim().split("\\s+");
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.startsWith("-") || arg.length() < 2 || arg.matches("-\\d+")) continue;
            String chunk = arg.substring(1);
            for (int j = 0; j < chunk.length(); ++j) {
                char flag = chunk.charAt(j);
                parsed.activeFlags.add(Character.valueOf(flag));
                boolean isLastInChunk = j == chunk.length() - 1;
                boolean expectsValue = flagsWithValue.contains(Character.valueOf(flag));
                if (expectsValue && isLastInChunk && i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    parsed.flagValues.put(Character.valueOf(flag), args[++i]);
                    continue;
                }
                if (!expectsValue || !isLastInChunk) continue;
                parsed.flagValues.put(Character.valueOf(flag), null);
            }
        }
        return parsed;
    }

    public static String sanitizeInput(String input, Set<Character> flagsWithValue) {
        if (input == null || input.isEmpty()) {
            return "";
        }
        String[] args = input.trim().split("\\s+");
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-") && arg.length() > 1 && !arg.matches("-\\d+")) {
                String chunk = arg.substring(1);
                char lastFlag = chunk.charAt(chunk.length() - 1);
                if (!flagsWithValue.contains(Character.valueOf(lastFlag)) || i + 1 >= args.length || args[i + 1].startsWith("-")) continue;
                ++i;
                continue;
            }
            result.add(arg);
        }
        return String.join((CharSequence)" ", result);
    }

    public static class ParsedFlags {
        private final Set<Character> activeFlags = new HashSet<Character>();
        private final Map<Character, String> flagValues = new HashMap<Character, String>();

        public boolean hasFlag(char flag) {
            return this.activeFlags.contains(Character.valueOf(flag)) || this.flagValues.containsKey(Character.valueOf(flag));
        }

        public String getFlagValue(char flag) {
            return this.flagValues.get(Character.valueOf(flag));
        }
    }
}

