/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.validator;

import com.mongodb.assertions.Assertions;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import java.util.Arrays;
import java.util.List;
import org.bson.FieldNameValidator;

public class ReplacingDocumentFieldNameValidator
implements FieldNameValidator {
    private static final NoOpFieldNameValidator NO_OP_FIELD_NAME_VALIDATOR = new NoOpFieldNameValidator();
    private static final List<String> EXCEPTIONS = Arrays.asList("$db", "$ref", "$id");

    @Override
    public boolean validate(String fieldName) {
        return !fieldName.startsWith("$") || EXCEPTIONS.contains(fieldName);
    }

    @Override
    public String getValidationErrorMessage(String fieldName) {
        Assertions.assertFalse(this.validate(fieldName));
        return String.format("Field names in a replacement document can not start with '$' but '%s' does", fieldName);
    }

    @Override
    public FieldNameValidator getValidatorForField(String fieldName) {
        return NO_OP_FIELD_NAME_VALIDATOR;
    }
}

