/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfapi.api.compat;

import java.lang.reflect.Method;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class LuckPermsCompat {
    public static String getGroupNodeValue(UUID uuid, String startsWith) {
        try {
            if (Bukkit.getPluginManager().getPlugin("LuckPerms") == null) {
                return null;
            }
            Class<?> providerClass = Class.forName("net.luckperms.api.LuckPermsProvider");
            Object luckPerms = providerClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
            Method getUserManager = luckPerms.getClass().getMethod("getUserManager", new Class[0]);
            Object userManager = getUserManager.invoke(luckPerms, new Object[0]);
            Method getUser = userManager.getClass().getMethod("getUser", UUID.class);
            Object user = getUser.invoke(userManager, uuid);
            if (user == null) {
                return null;
            }
            String primaryGroup = (String)user.getClass().getMethod("getPrimaryGroup", new Class[0]).invoke(user, new Object[0]);
            Method getGroupManager = luckPerms.getClass().getMethod("getGroupManager", new Class[0]);
            Object groupManager = getGroupManager.invoke(luckPerms, new Object[0]);
            Method getGroup = groupManager.getClass().getMethod("getGroup", String.class);
            Object group = getGroup.invoke(groupManager, primaryGroup);
            if (group == null) {
                return null;
            }
            Object nodeSet = group.getClass().getMethod("getNodes", new Class[0]).invoke(group, new Object[0]);
            for (Object node : (Iterable)nodeSet) {
                String key = (String)node.getClass().getMethod("getKey", new Class[0]).invoke(node, new Object[0]);
                if (!key.startsWith(startsWith)) continue;
                String[] split = key.split("\\.");
                return split.length > 2 ? split[2] : split[1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean hasPermission(UUID uniqueId, String permission) {
        try {
            if (Bukkit.getPluginManager().getPlugin("LuckPerms") != null) {
                Class<?> providerClass = Class.forName("net.luckperms.api.LuckPermsProvider");
                Object luckPerms = providerClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
                Method getUserManager = luckPerms.getClass().getMethod("getUserManager", new Class[0]);
                Object userManager = getUserManager.invoke(luckPerms, new Object[0]);
                Method getUser = userManager.getClass().getMethod("getUser", UUID.class);
                Object user = getUser.invoke(userManager, uniqueId);
                if (user != null) {
                    Method data = user.getClass().getMethod("getCachedData", new Class[0]);
                    Object cachedData = data.invoke(user, new Object[0]);
                    Method metaData = cachedData.getClass().getMethod("getPermissionData", new Class[0]);
                    Object permissionData = metaData.invoke(cachedData, new Object[0]);
                    Method check = permissionData.getClass().getMethod("checkPermission", String.class);
                    Object result = check.invoke(permissionData, permission);
                    Method asBoolean = result.getClass().getMethod("asBoolean", new Class[0]);
                    return (Boolean)asBoolean.invoke(result, new Object[0]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean hasPermission(Player player, String permission) {
        try {
            if (Bukkit.getPluginManager().getPlugin("LuckPerms") != null) {
                Class<?> providerClass = Class.forName("net.luckperms.api.LuckPermsProvider");
                Object luckPerms = providerClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
                Method getUserManager = luckPerms.getClass().getMethod("getUserManager", new Class[0]);
                Object userManager = getUserManager.invoke(luckPerms, new Object[0]);
                Method getUser = userManager.getClass().getMethod("getUser", UUID.class);
                Object user = getUser.invoke(userManager, player.getUniqueId());
                if (user != null) {
                    Method data = user.getClass().getMethod("getCachedData", new Class[0]);
                    Object cachedData = data.invoke(user, new Object[0]);
                    Method metaData = cachedData.getClass().getMethod("getPermissionData", new Class[0]);
                    Object permissionData = metaData.invoke(cachedData, new Object[0]);
                    Method check = permissionData.getClass().getMethod("checkPermission", String.class);
                    Object result = check.invoke(permissionData, permission);
                    Method asBoolean = result.getClass().getMethod("asBoolean", new Class[0]);
                    return (Boolean)asBoolean.invoke(result, new Object[0]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return player.hasPermission(permission);
    }
}

