/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.session;

import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoClientException;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.internal.binding.ReferenceCounted;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.lang.Nullable;
import com.mongodb.session.ClientSession;
import com.mongodb.session.ServerSession;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

public class BaseClientSessionImpl
implements ClientSession {
    private static final String CLUSTER_TIME_KEY = "clusterTime";
    private final ServerSessionPool serverSessionPool;
    private ServerSession serverSession;
    private final Object originator;
    private final ClientSessionOptions options;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private BsonDocument clusterTime;
    private BsonTimestamp operationTime;
    private BsonTimestamp snapshotTimestamp;
    private ServerAddress pinnedServerAddress;
    private BsonDocument recoveryToken;
    private ReferenceCounted transactionContext;

    public BaseClientSessionImpl(ServerSessionPool serverSessionPool, Object originator, ClientSessionOptions options) {
        this.serverSessionPool = serverSessionPool;
        this.originator = originator;
        this.options = options;
        this.pinnedServerAddress = null;
    }

    @Override
    @Nullable
    public ServerAddress getPinnedServerAddress() {
        return this.pinnedServerAddress;
    }

    @Override
    public Object getTransactionContext() {
        return this.transactionContext;
    }

    @Override
    public void setTransactionContext(ServerAddress address, Object transactionContext) {
        Assertions.assertTrue(transactionContext instanceof ReferenceCounted);
        this.pinnedServerAddress = address;
        this.transactionContext = (ReferenceCounted)transactionContext;
        this.transactionContext.retain();
    }

    @Override
    public void clearTransactionContext() {
        this.pinnedServerAddress = null;
        if (this.transactionContext != null) {
            this.transactionContext.release();
            this.transactionContext = null;
        }
    }

    @Override
    public BsonDocument getRecoveryToken() {
        return this.recoveryToken;
    }

    @Override
    public void setRecoveryToken(BsonDocument recoveryToken) {
        this.recoveryToken = recoveryToken;
    }

    @Override
    public ClientSessionOptions getOptions() {
        return this.options;
    }

    @Override
    public boolean isCausallyConsistent() {
        Boolean causallyConsistent = this.options.isCausallyConsistent();
        return causallyConsistent == null || causallyConsistent != false;
    }

    @Override
    public Object getOriginator() {
        return this.originator;
    }

    @Override
    public BsonDocument getClusterTime() {
        return this.clusterTime;
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.operationTime;
    }

    @Override
    public ServerSession getServerSession() {
        Assertions.isTrue("open", !this.closed.get());
        if (this.serverSession == null) {
            this.serverSession = this.serverSessionPool.get();
        }
        return this.serverSession;
    }

    @Override
    public void advanceOperationTime(@Nullable BsonTimestamp newOperationTime) {
        Assertions.isTrue("open", !this.closed.get());
        this.operationTime = this.greaterOf(newOperationTime);
    }

    @Override
    public void advanceClusterTime(@Nullable BsonDocument newClusterTime) {
        Assertions.isTrue("open", !this.closed.get());
        this.clusterTime = this.greaterOf(newClusterTime);
    }

    @Override
    public void setSnapshotTimestamp(@Nullable BsonTimestamp snapshotTimestamp) {
        Assertions.isTrue("open", !this.closed.get());
        if (snapshotTimestamp != null) {
            if (this.snapshotTimestamp != null && !snapshotTimestamp.equals(this.snapshotTimestamp)) {
                throw new MongoClientException("Snapshot timestamps should not change during the lifetime of the session.  Current timestamp is " + this.snapshotTimestamp + ", and attempting to set it to " + snapshotTimestamp);
            }
            this.snapshotTimestamp = snapshotTimestamp;
        }
    }

    @Override
    @Nullable
    public BsonTimestamp getSnapshotTimestamp() {
        Assertions.isTrue("open", !this.closed.get());
        return this.snapshotTimestamp;
    }

    private BsonDocument greaterOf(@Nullable BsonDocument newClusterTime) {
        if (newClusterTime == null) {
            return this.clusterTime;
        }
        if (this.clusterTime == null) {
            return newClusterTime;
        }
        return newClusterTime.getTimestamp(CLUSTER_TIME_KEY).compareTo(this.clusterTime.getTimestamp(CLUSTER_TIME_KEY)) > 0 ? newClusterTime : this.clusterTime;
    }

    private BsonTimestamp greaterOf(@Nullable BsonTimestamp newOperationTime) {
        if (newOperationTime == null) {
            return this.operationTime;
        }
        if (this.operationTime == null) {
            return newOperationTime;
        }
        return newOperationTime.compareTo(this.operationTime) > 0 ? newOperationTime : this.operationTime;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            if (this.serverSession != null) {
                this.serverSessionPool.release(this.serverSession);
            }
            this.clearTransactionContext();
        }
    }
}

