/*
 * Decompiled with CFR 0.152.
 */
package net.infumia.titleupdater;

import java.lang.reflect.Field;
import net.infumia.titleupdater.Nms;
import net.infumia.titleupdater.Version;

final class NmsProvider {
    private static final int MAXIMUM_PATCH = 9;
    private static final String CLASS_PATTERN = "NmsV%s_%s%s";
    private static final String PACKAGE_NAME = "net.infumia.titleupdater.versions.";
    private static Nms nms;

    static Nms nms() {
        if (nms == null) {
            NmsProvider.init();
        }
        return nms;
    }

    private static void init() {
        int major = Version.major();
        int minor = Version.minor();
        int patch = Version.patch();
        for (int m = minor; m >= 0; --m) {
            for (int i = patch; i >= 0; --i) {
                Nms found = NmsProvider.find(major, m, patch);
                if (found == null) continue;
                nms = found;
                return;
            }
        }
        throw new IllegalStateException("Unsupported server version: v" + major + "." + minor + "." + patch);
    }

    private static Nms find(int major, int minor, int patch) {
        String patchVersion = patch == 0 ? "" : "_" + patch;
        String className = String.format(CLASS_PATTERN, major, minor, patchVersion);
        try {
            Class<?> cls = Class.forName(PACKAGE_NAME + className);
            Field field = cls.getDeclaredField("INSTANCE");
            return (Nms)field.get(null);
        }
        catch (ClassNotFoundException cls) {
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException("Please contact us to report this error!", exception);
        }
        return null;
    }

    private NmsProvider() {
        throw new IllegalArgumentException("Utility class!");
    }
}

