/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nametag.arguments;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.nametag.AbstractArgumentTree;
import dev.jorel.commandapi.nametag.CommandPermission;
import dev.jorel.commandapi.nametag.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.nametag.arguments.CommandAPIArgumentType;
import dev.jorel.commandapi.nametag.executors.CommandArguments;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public abstract class AbstractArgument<T, Impl extends AbstractArgument<T, Impl, Argument, CommandSender>, Argument extends AbstractArgument<?, ?, Argument, CommandSender>, CommandSender>
extends AbstractArgumentTree<Impl, Argument, CommandSender> {
    private final String nodeName;
    private final ArgumentType<?> rawType;
    private Optional<ArgumentSuggestions<CommandSender>> suggestions = Optional.empty();
    private Optional<ArgumentSuggestions<CommandSender>> addedSuggestions = Optional.empty();
    private CommandPermission permission = CommandPermission.NONE;
    private Predicate<CommandSender> requirements = s -> true;
    private boolean isListed = true;
    private boolean isOptional = false;
    private final List<Argument> combinedArguments = new ArrayList<Argument>();

    public abstract Class<T> getPrimitiveType();

    public abstract CommandAPIArgumentType getArgumentType();

    protected AbstractArgument(String nodeName, ArgumentType<?> rawType) {
        this.nodeName = nodeName;
        this.rawType = rawType;
    }

    public final ArgumentType<?> getRawType() {
        return this.rawType;
    }

    public final String getNodeName() {
        return this.nodeName;
    }

    public abstract <Source> T parseArgument(CommandContext<Source> var1, String var2, CommandArguments var3) throws CommandSyntaxException;

    public Impl includeSuggestions(ArgumentSuggestions<CommandSender> suggestions) {
        this.addedSuggestions = Optional.of(suggestions);
        return (Impl)((AbstractArgument)this.instance());
    }

    public Optional<ArgumentSuggestions<CommandSender>> getIncludedSuggestions() {
        return this.addedSuggestions;
    }

    public Impl replaceSuggestions(ArgumentSuggestions<CommandSender> suggestions) {
        this.suggestions = Optional.of(suggestions);
        return (Impl)((AbstractArgument)this.instance());
    }

    public final Optional<ArgumentSuggestions<CommandSender>> getOverriddenSuggestions() {
        return this.suggestions;
    }

    public final Impl withPermission(CommandPermission permission) {
        this.permission = permission;
        return (Impl)((AbstractArgument)this.instance());
    }

    public final Impl withPermission(String permission) {
        this.permission = CommandPermission.fromString(permission);
        return (Impl)((AbstractArgument)this.instance());
    }

    public final CommandPermission getArgumentPermission() {
        return this.permission;
    }

    public final Predicate<CommandSender> getRequirements() {
        return this.requirements;
    }

    public final Impl withRequirement(Predicate<CommandSender> requirement) {
        this.requirements = this.requirements.and(requirement);
        return (Impl)((AbstractArgument)this.instance());
    }

    void resetRequirements() {
        this.requirements = s -> true;
    }

    public boolean isListed() {
        return this.isListed;
    }

    public Impl setListed(boolean listed) {
        this.isListed = listed;
        return (Impl)((AbstractArgument)this.instance());
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public Impl setOptional(boolean optional) {
        this.isOptional = optional;
        return (Impl)((AbstractArgument)this.instance());
    }

    public List<Argument> getCombinedArguments() {
        return this.combinedArguments;
    }

    public boolean hasCombinedArguments() {
        return !this.combinedArguments.isEmpty();
    }

    @SafeVarargs
    public final Impl combineWith(Argument ... combinedArguments) {
        for (Argument argument : combinedArguments) {
            this.combinedArguments.add(argument);
        }
        return (Impl)((AbstractArgument)this.instance());
    }

    public List<String> getEntityNames(Object argument) {
        return Collections.singletonList(null);
    }

    public void copyPermissionsAndRequirements(Argument argument) {
        this.resetRequirements();
        this.withRequirement(((AbstractArgument)argument).getRequirements());
        this.withPermission(((AbstractArgument)argument).getArgumentPermission());
    }

    public String getHelpString() {
        return "<" + this.getNodeName() + ">";
    }

    public String toString() {
        return this.getNodeName() + "<" + this.getClass().getSimpleName() + ">";
    }
}

