/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfapi.api.util;

import gg.lode.bookshelfapi.api.util.MiniMessageHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;

public class VariableContext {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("<<([a-zA-Z0-9_]+?)(?::([a-zA-Z]))?>>|<([a-zA-Z0-9_]+?)(?::([a-zA-Z]))?>");
    private final Map<String, String> variables = new HashMap<String, String>();

    public void set(String key, Object value) {
        this.variables.put(key, String.valueOf(value));
    }

    public String get(String key) {
        return this.variables.get(key);
    }

    public static void main(String[] args) {
        VariableContext context = new VariableContext();
        context.set("test", "Hello, World!");
        System.out.println(context.replace("<<test>>"));
    }

    private String applyFormatter(String value, String format) {
        if (format == null) {
            return value;
        }
        return switch (format.toLowerCase()) {
            case "u" -> value.toUpperCase();
            case "l" -> value.toLowerCase();
            default -> value;
        };
    }

    public Component replaceAsComponent(String input) {
        String result = this.replace(input);
        return MiniMessageHelper.deserialize(result);
    }

    public String replace(String input) {
        boolean replaced;
        if (input == null) {
            return "";
        }
        String result = input;
        int maxIterations = 10;
        int iterations = 0;
        do {
            replaced = false;
            Matcher matcher = PLACEHOLDER_PATTERN.matcher(result);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                Object value;
                String format;
                String key;
                boolean isDoubleBracketed;
                boolean bl = isDoubleBracketed = matcher.group(1) != null;
                if (isDoubleBracketed) {
                    key = matcher.group(1);
                    format = matcher.group(2);
                } else {
                    key = matcher.group(3);
                    format = matcher.group(4);
                }
                if ((value = this.variables.get(key)) == null) continue;
                value = this.applyFormatter((String)value, format);
                if (isDoubleBracketed) {
                    value = "<" + (String)value + ">";
                }
                matcher.appendReplacement(buffer, Matcher.quoteReplacement((String)value));
                replaced = true;
            }
            matcher.appendTail(buffer);
            result = buffer.toString();
        } while (replaced && ++iterations < maxIterations);
        return result;
    }
}

