/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.nametag;

import dev.jorel.commandapi.nametag.CommandAPI;
import dev.jorel.commandapi.nametag.CommandAPIBukkitConfig;
import gg.lode.bookshelfapi.api.Configuration;
import gg.lode.bookshelfapi.api.Task;
import gg.lode.bookshelfapi.api.VersionUpdater;
import gg.lode.bookshelfapi.api.mojang.MojangProfile;
import gg.lode.bookshelfapi.api.util.Metrics;
import gg.lode.bookshelfapi.api.util.MiniMessageHelper;
import gg.lode.nametag.command.NickCommand;
import gg.lode.nametag.command.RandomNickCommand;
import gg.lode.nametag.storage.StorageManager;
import gg.lode.nametag.storage.data.NameTagPlayer;
import gg.lode.nametagapi.INameTagAPI;
import gg.lode.nametagapi.NameTagAPI;
import gg.lode.nametagapi.api.Skin;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.event.player.PlayerLoadEvent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import xyz.haoshoku.nick.api.NickAPI;

public final class NameTagPlugin
extends JavaPlugin
implements INameTagAPI {
    public static final String VERSION = "v1.0.42";
    private final ConcurrentHashMap<UUID, NameTagPlayer> playerCache = new ConcurrentHashMap();
    private StorageManager storageManager;
    private Configuration config;
    private static final int CONFIG_VERSION = 2;

    @Nullable
    private static String[] fetchTextureAndSignatureFromMineskinId(String skinId) {
        try {
            String apiEndpoint = "https://api.mineskin.org/v2/skins/" + skinId;
            URL url = new URL(apiEndpoint);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            JSONParser parser = new JSONParser();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                String jsonResponse = response.toString();
                JSONObject object = (JSONObject)parser.parse(jsonResponse);
                String[] outputToReturn = new String[]{(String)((JSONObject)((JSONObject)((JSONObject)object.get((Object)"skin")).get((Object)"texture")).get((Object)"data")).get((Object)"value"), (String)((JSONObject)((JSONObject)((JSONObject)object.get((Object)"skin")).get((Object)"texture")).get((Object)"data")).get((Object)"signature")};
                reader.close();
                return outputToReturn;
            }
            return null;
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    public void onLoad() {
        new Metrics(this, 24781);
        CommandAPI.onLoad(new CommandAPIBukkitConfig(this).shouldHookPaperReload(true).setNamespace("minecraft"));
        this.storageManager = new StorageManager(this);
        this.storageManager.initialize().whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.getLogger().severe("Failed to initialize storage system: " + throwable.getMessage());
                throwable.printStackTrace();
            } else {
                this.getLogger().info("Storage system initialized successfully");
            }
        });
        this.config = new Configuration(this, "config.yml");
        this.config.initialize();
        this.updateConfigToLatest();
        NameTagAPI.setApi(this);
    }

    private void updateConfigToLatest() {
        if (this.config.getInt("version") < 2) {
            this.getLogger().info("Updating configuration to the latest version...");
            switch (this.config.getInt("version")) {
                case 1: {
                    this.config.set("change_uuids", (Object)false);
                }
            }
            this.config.set("version", (Object)(this.config.getInt("version") + 1));
            if (this.config.getInt("version") < 2) {
                this.updateConfigToLatest();
            } else {
                this.config.save();
                this.getLogger().info("Configuration updated to the latest version successfully.");
            }
        }
    }

    public void onEnable() {
        CommandAPI.onEnable();
        this.getServer().getPluginManager().registerEvents((Listener)new VersionUpdater(this, "Name Tag", "https://lode.gg/plugin/nametag", "https://lode.gg/api/plugins/nametag/version", VERSION), (Plugin)this);
        this.registerCommands();
        if (this.getServer().getPluginManager().isPluginEnabled("TAB")) {
            try {
                Class<?> tabClass = Class.forName("me.neznamy.tab.api.TabAPI");
                Method getInstanceMethod = tabClass.getMethod("getInstance", new Class[0]);
                TabAPI tabApiInstance = (TabAPI)getInstanceMethod.invoke(null, new Object[0]);
                Objects.requireNonNull(tabApiInstance.getEventBus()).register(PlayerLoadEvent.class, event -> this.updateTabPlayer(event.getPlayer()));
                this.getLogger().warning("==========================================");
                this.getLogger().warning("Hooked into TAB!");
                this.getLogger().warning("Name Tag will now use TAB to display nicknames.");
                this.getLogger().warning("==========================================");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!this.getServer().getPluginManager().isPluginEnabled("NickAPI")) {
            this.getLogger().severe("=============================");
            this.getLogger().severe("Name Tag - Dependency Warning");
            this.getLogger().severe("NickAPI.jar not found! Installing it and then restarting your server!");
            this.getLogger().severe("=============================");
            this.loadDependency(this, "https://lode.gg/files/NickAPI.jar", "NickAPI.jar");
        }
    }

    private void loadDependency(JavaPlugin plugin, String urlString, String outputName) {
        File outJar = new File(plugin.getDataFolder().getParentFile(), outputName);
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            int contentLength = connection.getContentLength();
            if (connection.getResponseCode() != 200 || contentLength == -1) {
                plugin.getLogger().severe("Failed to connect or get file size from: " + urlString);
                return;
            }
            InputStream in = connection.getInputStream();
            if (!outJar.exists() || outJar.length() != (long)contentLength) {
                Files.copy(in, outJar.toPath(), StandardCopyOption.REPLACE_EXISTING);
                plugin.getLogger().info("Downloaded " + outputName + " to /plugins");
                this.getServer().shutdown();
            } else {
                plugin.getLogger().info(outputName + " already exists and matches size.");
            }
            in.close();
            connection.disconnect();
        }
        catch (Exception e) {
            plugin.getLogger().severe("Failed to download dependency: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void updateTabPlayer(TabPlayer player) {
        String name = this.hasNick(player.getUniqueId()) ? this.getNick(player.getUniqueId()) : player.getName();
        try {
            Class<?> tabClass = Class.forName("me.neznamy.tab.api.TabAPI");
            Method getInstanceMethod = tabClass.getMethod("getInstance", new Class[0]);
            TabAPI tabApiInstance = (TabAPI)getInstanceMethod.invoke(null, new Object[0]);
            this.getLogger().warning("[TAB] Successfully updated " + player.getName() + " to " + name);
            Objects.requireNonNull(tabApiInstance.getTabListFormatManager()).setName(player, name);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.getLogger().warning("Failed to load player " + player.getName() + " into TAB.");
        }
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public ConcurrentHashMap<UUID, NameTagPlayer> getPlayerCache() {
        return this.playerCache;
    }

    private <T> void executeStorageOperation(CompletableFuture<T> future, String operation) {
        this.executeStorageOperation(future, operation, () -> {});
    }

    private <T> void executeStorageOperation(CompletableFuture<T> future, String operation, Runnable callback) {
        future.whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.getLogger().severe("Storage operation failed (" + operation + "): " + throwable.getMessage());
                throwable.printStackTrace();
            } else {
                this.getLogger().warning("Successfully executed operation (" + operation + ")");
                callback.run();
            }
        });
    }

    private void registerCommands() {
        new NickCommand(this).register();
        new RandomNickCommand(this).register();
    }

    public Configuration config() {
        return this.config;
    }

    public void onDisable() {
        CommandAPI.onDisable();
        if (this.storageManager != null) {
            this.storageManager.close().whenComplete((result, throwable) -> {
                if (throwable != null) {
                    this.getLogger().severe("Failed to close storage system: " + throwable.getMessage());
                    throwable.printStackTrace();
                } else {
                    this.getLogger().info("Storage system closed successfully");
                }
            });
        }
    }

    @Override
    public boolean hasNick(Player player) {
        NameTagPlayer cached = this.playerCache.get(player.getUniqueId());
        if (cached != null) {
            return cached.hasNick();
        }
        NameTagPlayer nameTagPlayer = this.storageManager.getStorage().loadPlayer(player.getUniqueId()).join();
        return nameTagPlayer != null && nameTagPlayer.hasNick();
    }

    @Override
    @Nullable
    public String getNick(Player player) {
        NameTagPlayer cached = this.playerCache.get(player.getUniqueId());
        if (cached != null) {
            return cached.getNickname();
        }
        NameTagPlayer nameTagPlayer = this.storageManager.getStorage().loadPlayer(player.getUniqueId()).join();
        if (nameTagPlayer != null) {
            this.playerCache.put(player.getUniqueId(), nameTagPlayer);
        }
        return nameTagPlayer != null ? nameTagPlayer.getNickname() : null;
    }

    @Override
    @Nullable
    public String getNick(UUID uniqueId) {
        NameTagPlayer cached = this.playerCache.get(uniqueId);
        if (cached != null) {
            return cached.getNickname();
        }
        NameTagPlayer nameTagPlayer = this.storageManager.getStorage().loadPlayer(uniqueId).join();
        if (nameTagPlayer != null) {
            this.playerCache.put(uniqueId, nameTagPlayer);
        }
        return nameTagPlayer != null ? nameTagPlayer.getNickname() : null;
    }

    @Override
    @Nullable
    public Component getNickComponent(Player player) {
        String nickname = this.getNick(player);
        return nickname != null ? MiniMessageHelper.deserialize(nickname) : null;
    }

    @Override
    @Nullable
    public Component getNickComponent(UUID uniqueId) {
        String nickname = this.getNick(uniqueId);
        return nickname != null ? MiniMessageHelper.deserialize(nickname) : null;
    }

    @Override
    @Nullable
    public Skin getSkin(Player player) {
        NameTagPlayer cached = this.playerCache.get(player.getUniqueId());
        if (cached != null) {
            return cached.getSkin();
        }
        NameTagPlayer nameTagPlayer = this.storageManager.getStorage().loadPlayer(player.getUniqueId()).join();
        if (nameTagPlayer != null) {
            this.playerCache.put(player.getUniqueId(), nameTagPlayer);
        }
        return nameTagPlayer != null ? nameTagPlayer.getSkin() : null;
    }

    @Override
    @Nullable
    public Skin getSkin(UUID uniqueId) {
        NameTagPlayer cached = this.playerCache.get(uniqueId);
        if (cached != null) {
            return cached.getSkin();
        }
        NameTagPlayer nameTagPlayer = this.storageManager.getStorage().loadPlayer(uniqueId).join();
        if (nameTagPlayer != null) {
            this.playerCache.put(uniqueId, nameTagPlayer);
        }
        return nameTagPlayer != null ? nameTagPlayer.getSkin() : null;
    }

    @Override
    public void resetAllNicks() {
        int[] onlineResetCount = new int[]{0};
        for (Player player : this.getServer().getOnlinePlayers()) {
            if (!this.hasNick(player)) continue;
            this.resetNick(player);
            onlineResetCount[0] = onlineResetCount[0] + 1;
        }
        this.storageManager.getStorage().getAllPlayers().whenComplete((storedPlayers, throwable) -> {
            if (throwable != null) {
                this.getLogger().severe("Failed to reset stored data: " + throwable.getMessage());
                throwable.printStackTrace();
                return;
            }
            if (storedPlayers == null || storedPlayers.isEmpty()) {
                this.getLogger().info("Successfully reset " + onlineResetCount[0] + " online players. No stored data found.");
                return;
            }
            ArrayList<CompletableFuture<Void>> deleteFutures = new ArrayList<CompletableFuture<Void>>();
            for (NameTagPlayer storedPlayer : storedPlayers) {
                deleteFutures.add(this.storageManager.getStorage().deletePlayer(storedPlayer.getUuid()));
            }
            CompletableFuture.allOf(deleteFutures.toArray(new CompletableFuture[0])).whenComplete((result, deleteThrowable) -> {
                if (deleteThrowable != null) {
                    this.getLogger().severe("Failed to delete some stored data: " + deleteThrowable.getMessage());
                    deleteThrowable.printStackTrace();
                    return;
                }
                this.playerCache.clear();
                this.getLogger().info("Successfully reset " + onlineResetCount[0] + " online players and " + storedPlayers.size() + " stored players. All nickname data has been cleared.");
            });
        });
    }

    @Override
    public void shouldChangeUniqueId(boolean shouldChange) {
        this.config.set("change_uuids", (Object)shouldChange);
    }

    @Override
    public boolean shouldChangeUniqueId() {
        return this.config.getBoolean("change_uuids");
    }

    public void saveAllPlayersData() {
        this.getLogger().info("Starting sequential save of all online players' data...");
        ArrayList onlinePlayers = new ArrayList(this.getServer().getOnlinePlayers());
        int totalPlayers = onlinePlayers.size();
        int savedCount = 0;
        for (Player player : onlinePlayers) {
            NameTagPlayer cached = this.playerCache.get(player.getUniqueId());
            if (cached == null || !cached.hasNick()) continue;
            try {
                this.storageManager.getStorage().savePlayer(cached).join();
                this.getLogger().info("Saved data for " + player.getName() + " (" + ++savedCount + "/" + totalPlayers + ")");
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to save data for " + player.getName() + ": " + e.getMessage());
            }
        }
        this.getLogger().info("Completed saving data for " + savedCount + " players out of " + totalPlayers + " online players.");
    }

    public void saveAllCachedPlayersData() {
        this.getLogger().info("Starting sequential save of all cached players' data...");
        ArrayList<NameTagPlayer> cachedPlayers = new ArrayList<NameTagPlayer>(this.playerCache.values());
        int totalPlayers = cachedPlayers.size();
        int savedCount = 0;
        for (NameTagPlayer cachedPlayer : cachedPlayers) {
            if (!cachedPlayer.hasNick()) continue;
            try {
                this.storageManager.getStorage().savePlayer(cachedPlayer).join();
                this.getLogger().info("Saved cached data for " + String.valueOf(cachedPlayer.getUuid()) + " (" + ++savedCount + "/" + totalPlayers + ")");
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to save cached data for " + String.valueOf(cachedPlayer.getUuid()) + ": " + e.getMessage());
            }
        }
        this.getLogger().info("Completed saving data for " + savedCount + " cached players out of " + totalPlayers + " total cached players.");
    }

    public boolean hasNick(UUID uniqueId) {
        NameTagPlayer cached = this.playerCache.get(uniqueId);
        if (cached != null) {
            return cached.hasNick();
        }
        return this.storageManager.getStorage().hasPlayer(uniqueId).join();
    }

    @Override
    public void setNickname(Player player, String name) {
        this.setNickname(player, MiniMessageHelper.deserialize(name));
    }

    @Override
    public void setNickname(Player player, Component component) {
        String rawString = MiniMessageHelper.serialize(component);
        String translatedText = LegacyComponentSerializer.legacySection().serialize(MiniMessageHelper.deserialize(rawString));
        NickAPI.setNick((Player)player, (String)translatedText);
        NickAPI.setProfileName((Player)player, (String)translatedText);
        if (this.config().getBoolean("change_uuids")) {
            NickAPI.setUniqueId((Player)player, (String)translatedText);
        }
        NickAPI.refreshPlayer((Player)player);
        player.playerListName(component);
        player.displayName(component);
        ((CompletableFuture)this.storageManager.getStorage().loadPlayer(player.getUniqueId()).thenAccept(nameTagPlayer -> {
            NameTagPlayer playerData = nameTagPlayer != null ? nameTagPlayer : new NameTagPlayer(player.getUniqueId());
            playerData.setNickname(rawString);
            this.playerCache.put(player.getUniqueId(), playerData);
            this.executeStorageOperation(this.storageManager.getStorage().savePlayer(playerData), "save nickname for " + player.getName(), () -> {
                if (this.getServer().getPluginManager().isPluginEnabled("TAB")) {
                    this.attemptToUpdateTabPlayer(player);
                }
            });
        })).whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.getLogger().severe("Failed to load player data for nickname update: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        });
    }

    public void attemptToUpdateTabPlayer(Player player) {
        try {
            Class<?> tabClass = Class.forName("me.neznamy.tab.api.TabAPI");
            Method getInstanceMethod = tabClass.getMethod("getInstance", new Class[0]);
            TabAPI tabApiInstance = (TabAPI)getInstanceMethod.invoke(null, new Object[0]);
            TabPlayer tabPlayer = tabApiInstance.getPlayer(player.getUniqueId());
            if (tabPlayer == null) {
                throw new Exception("fucking tab player cant be found");
            }
            this.updateTabPlayer(tabPlayer);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    @Override
    public void setSkinFromPlayer(Player player, String playerName) {
        NickAPI.setSkin((Player)player, (String)playerName);
        NickAPI.refreshPlayer((Player)player);
        ((CompletableFuture)this.storageManager.getStorage().loadPlayer(player.getUniqueId()).thenAccept(nameTagPlayer -> {
            NameTagPlayer playerData = nameTagPlayer != null ? nameTagPlayer : new NameTagPlayer(player.getUniqueId());
            playerData.setSkinName(playerName);
            playerData.setTexture(null);
            playerData.setSignature(null);
            this.playerCache.put(player.getUniqueId(), playerData);
            this.executeStorageOperation(this.storageManager.getStorage().savePlayer(playerData), "save skin for " + player.getName(), () -> {
                if (this.getServer().getPluginManager().isPluginEnabled("TAB")) {
                    this.attemptToUpdateTabPlayer(player);
                }
            });
        })).whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.getLogger().severe("Failed to load player data for skin update: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        });
    }

    @Override
    public void setNickFromPlayer(Player player, String playerName) {
        NickAPI.setSkin((Player)player, (String)playerName);
        NickAPI.setProfileName((Player)player, (String)playerName);
        NickAPI.setNick((Player)player, (String)playerName);
        Task.runAsync(this, () -> {
            if (this.config().getBoolean("change_uuids")) {
                try {
                    if (MojangProfile.getMojangProfile(playerName) == null) {
                        NickAPI.setUniqueId((Player)player, (UUID)UUID.randomUUID());
                    } else {
                        NickAPI.setUniqueId((Player)player, (String)playerName);
                    }
                }
                catch (Exception ignored) {
                    NickAPI.setUniqueId((Player)player, (String)playerName);
                }
            }
        });
        NickAPI.refreshPlayer((Player)player);
        player.playerListName(MiniMessageHelper.deserialize(playerName));
        player.displayName(MiniMessageHelper.deserialize(playerName));
        ((CompletableFuture)this.storageManager.getStorage().loadPlayer(player.getUniqueId()).thenAccept(nameTagPlayer -> {
            NameTagPlayer playerData = nameTagPlayer != null ? nameTagPlayer : new NameTagPlayer(player.getUniqueId());
            playerData.setNickname(playerName);
            playerData.setSkinName(playerName);
            playerData.setTexture(null);
            playerData.setSignature(null);
            this.playerCache.put(player.getUniqueId(), playerData);
            this.executeStorageOperation(this.storageManager.getStorage().savePlayer(playerData), "save nick from player for " + player.getName(), () -> {
                if (this.getServer().getPluginManager().isPluginEnabled("TAB")) {
                    this.attemptToUpdateTabPlayer(player);
                }
            });
        })).whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.getLogger().severe("Failed to load player data for nick from player update: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        });
    }

    @Override
    public boolean setSkinFromTextureAndSignature(Player player, String texture, String signature) {
        NickAPI.setSkin((Player)player, (String)texture, (String)signature);
        NickAPI.refreshPlayer((Player)player);
        ((CompletableFuture)this.storageManager.getStorage().loadPlayer(player.getUniqueId()).thenAccept(nameTagPlayer -> {
            NameTagPlayer playerData = nameTagPlayer != null ? nameTagPlayer : new NameTagPlayer(player.getUniqueId());
            playerData.setTexture(texture);
            playerData.setSignature(signature);
            playerData.setSkinName(null);
            this.playerCache.put(player.getUniqueId(), playerData);
            this.executeStorageOperation(this.storageManager.getStorage().savePlayer(playerData), "save mineskin for " + player.getName(), () -> {
                if (this.getServer().getPluginManager().isPluginEnabled("TAB")) {
                    this.attemptToUpdateTabPlayer(player);
                }
            });
        })).whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.getLogger().severe("Failed to load player data for mineskin update: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        });
        return true;
    }

    @Override
    public boolean setSkinFromMineskinId(Player player, String id) {
        @Nullable String[] textureAndSignature = NameTagPlugin.fetchTextureAndSignatureFromMineskinId(id);
        if (textureAndSignature == null) {
            return false;
        }
        return this.setSkinFromTextureAndSignature(player, textureAndSignature[0], textureAndSignature[1]);
    }

    @Override
    public boolean setSkinFromMineskinUrl(Player player, String url) {
        String skinId = url.replaceAll(".*/", "");
        return this.setSkinFromMineskinId(player, skinId);
    }

    @Override
    @Nullable
    public Skin getSkinFromMineskinId(String id) {
        @Nullable String[] textureAndSignature = NameTagPlugin.fetchTextureAndSignatureFromMineskinId(id);
        if (textureAndSignature == null) {
            return null;
        }
        return new Skin(textureAndSignature[0], textureAndSignature[1]);
    }

    @Override
    @Nullable
    public Skin getSkinFromMineskinUrl(String url) {
        String skinId = url.replaceAll(".*/", "");
        return this.getSkinFromMineskinId(skinId);
    }

    @Override
    public void resetNickname(Player player) {
        ((CompletableFuture)this.storageManager.getStorage().loadPlayer(player.getUniqueId()).thenAccept(nameTagPlayer -> {
            if (nameTagPlayer != null) {
                nameTagPlayer.setNickname(null);
                this.playerCache.put(player.getUniqueId(), (NameTagPlayer)nameTagPlayer);
                this.executeStorageOperation(this.storageManager.getStorage().savePlayer((NameTagPlayer)nameTagPlayer), "reset nickname for " + player.getName(), () -> {
                    if (this.getServer().getPluginManager().isPluginEnabled("TAB")) {
                        this.attemptToUpdateTabPlayer(player);
                    }
                });
            }
        })).whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.getLogger().severe("Failed to load player data for nickname reset: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        });
        NickAPI.resetNick((Player)player);
        NickAPI.refreshPlayer((Player)player);
        player.playerListName(MiniMessageHelper.deserialize(player.getName()));
        player.displayName(MiniMessageHelper.deserialize(player.getName()));
    }

    @Override
    public void resetSkin(Player player) {
        ((CompletableFuture)this.storageManager.getStorage().loadPlayer(player.getUniqueId()).thenAccept(nameTagPlayer -> {
            if (nameTagPlayer != null) {
                nameTagPlayer.setTexture(null);
                nameTagPlayer.setSignature(null);
                nameTagPlayer.setSkinName(null);
                this.playerCache.put(player.getUniqueId(), (NameTagPlayer)nameTagPlayer);
                this.executeStorageOperation(this.storageManager.getStorage().savePlayer((NameTagPlayer)nameTagPlayer), "reset skin for " + player.getName(), () -> {
                    if (this.getServer().getPluginManager().isPluginEnabled("TAB")) {
                        this.attemptToUpdateTabPlayer(player);
                    }
                });
            }
        })).whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.getLogger().severe("Failed to load player data for skin reset: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        });
        NickAPI.resetSkin((Player)player);
        NickAPI.refreshPlayer((Player)player);
    }

    @Override
    public void resetNick(Player player) {
        ((CompletableFuture)this.storageManager.getStorage().loadPlayer(player.getUniqueId()).thenAccept(nameTagPlayer -> {
            if (nameTagPlayer != null) {
                nameTagPlayer.reset();
                this.playerCache.remove(player.getUniqueId());
                this.executeStorageOperation(this.storageManager.getStorage().savePlayer((NameTagPlayer)nameTagPlayer), "reset nick for " + player.getName(), () -> Task.later(this, () -> {
                    if (this.getServer().getPluginManager().isPluginEnabled("TAB")) {
                        this.attemptToUpdateTabPlayer(player);
                    }
                }, 3L));
            }
        })).whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.getLogger().severe("Failed to load player data for nick reset: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        });
        NickAPI.resetAll((Player)player);
        NickAPI.refreshPlayer((Player)player);
        player.playerListName(MiniMessageHelper.deserialize(player.getName()));
        player.displayName(MiniMessageHelper.deserialize(player.getName()));
    }
}

