/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.nametag.command;

import dev.jorel.commandapi.nametag.CommandAPICommand;
import dev.jorel.commandapi.nametag.arguments.Argument;
import dev.jorel.commandapi.nametag.arguments.PlayerArgument;
import dev.jorel.commandapi.nametag.executors.CommandArguments;
import dev.jorel.commandapi.nametag.executors.ExecutorType;
import gg.lode.bookshelfapi.api.mojang.MojangProfile;
import gg.lode.bookshelfapi.api.util.MiniMessageHelper;
import gg.lode.nametag.NameTagPlugin;
import gg.lode.nametag.util.SkinProvider;
import gg.lode.nametag.util.UsernameGenerator;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RandomNickCommand
extends CommandAPICommand {
    private final NameTagPlugin plugin;
    private static final int MAX_ATTEMPTS = 50;

    public RandomNickCommand(NameTagPlugin plugin) {
        super("randomnick");
        this.plugin = plugin;
        this.withPermission("lodestone.nametag.commands.randomnick");
        this.withOptionalArguments(new Argument[]{(Argument)new PlayerArgument("target").withPermission("lodestone.nametag.commands.randomnick.other")});
        this.executes((CommandSender sender, CommandArguments args) -> {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                this.generateAndApplyRandomNick(sender, player);
            } else {
                Object patt0$temp = args.get(0);
                if (patt0$temp instanceof Player) {
                    Player target = (Player)patt0$temp;
                    this.generateAndApplyRandomNick(sender, target);
                } else {
                    sender.sendMessage(MiniMessageHelper.deserialize("<red>This command can only be executed by players."));
                }
            }
        }, new ExecutorType[0]);
    }

    private void generateAndApplyRandomNick(CommandSender sender, Player target) {
        sender.sendMessage(MiniMessageHelper.deserialize("<yellow>Generating random nickname..."));
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            String generatedUsername = this.findAvailableUsername();
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                if (generatedUsername != null) {
                    if (this.plugin.hasNick(target)) {
                        this.plugin.resetNick(target);
                    }
                    this.plugin.setNickFromPlayer(target, generatedUsername);
                    String randomSkinPlayer = SkinProvider.getRandomPlayerName(generatedUsername);
                    this.plugin.setSkinFromPlayer(target, randomSkinPlayer);
                    String targetName = target == sender ? "your" : target.getName() + "'s";
                    sender.sendMessage(MiniMessageHelper.deserialize("Successfully set " + targetName + " nickname to <yellow>" + generatedUsername));
                } else {
                    sender.sendMessage(MiniMessageHelper.deserialize("<red>Failed to generate an available username after 50 attempts. Please try again."));
                }
            });
        });
    }

    private String findAvailableUsername() {
        for (int i = 0; i < 50; ++i) {
            String username = UsernameGenerator.generateUsername();
            if (username.length() < 3 || username.length() > 16) continue;
            try {
                if (MojangProfile.getMojangProfile(username) != null) continue;
                return username;
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to check username availability for '" + username + "': " + e.getMessage());
                return username;
            }
        }
        return null;
    }
}

