/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.nametag.storage;

import gg.lode.nametag.NameTagPlugin;
import gg.lode.nametag.storage.NameTagStorage;
import gg.lode.nametag.storage.impl.LocalNameTagStorage;
import gg.lode.nametag.storage.impl.MongoDBNameTagStorage;
import java.util.concurrent.CompletableFuture;
import org.bukkit.configuration.file.FileConfiguration;

public class StorageManager {
    private final NameTagPlugin plugin;
    private NameTagStorage storage;

    public StorageManager(NameTagPlugin plugin) {
        this.plugin = plugin;
    }

    public CompletableFuture<Void> initialize() {
        return CompletableFuture.runAsync(() -> {
            try {
                String storageType;
                FileConfiguration config = this.plugin.getConfig();
                switch (storageType = config.getString("storage.type", "LOCAL").toUpperCase()) {
                    case "LOCAL": {
                        this.storage = new LocalNameTagStorage(this.plugin);
                        this.plugin.getLogger().info("Using LOCAL storage");
                        break;
                    }
                    case "MONGODB": {
                        this.storage = new MongoDBNameTagStorage(this.plugin);
                        this.plugin.getLogger().info("Using MONGODB storage");
                        break;
                    }
                    default: {
                        this.plugin.getLogger().warning("Unknown storage type: " + storageType + ". Falling back to LOCAL");
                        this.storage = new LocalNameTagStorage(this.plugin);
                    }
                }
                this.storage.initialize().join();
                this.plugin.getLogger().info("Storage system initialized successfully");
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to initialize storage system: " + e.getMessage());
                e.printStackTrace();
                throw new RuntimeException("Storage initialization failed", e);
            }
        });
    }

    public NameTagStorage getStorage() {
        return this.storage;
    }

    public CompletableFuture<Void> close() {
        if (this.storage != null) {
            return this.storage.close();
        }
        return CompletableFuture.completedFuture(null);
    }
}

