/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.nametag.storage.data;

import gg.lode.nametagapi.api.Skin;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class NameTagPlayer {
    private final UUID uuid;
    private String nickname;
    private String skinName;
    private String texture;
    private String signature;

    public NameTagPlayer(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Nullable
    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(@Nullable String nickname) {
        this.nickname = nickname;
    }

    @Nullable
    public String getSkinName() {
        return this.skinName;
    }

    public void setSkinName(@Nullable String skinName) {
        this.skinName = skinName;
    }

    @Nullable
    public String getTexture() {
        return this.texture;
    }

    public void setTexture(@Nullable String texture) {
        this.texture = texture;
    }

    @Nullable
    public String getSignature() {
        return this.signature;
    }

    public void setSignature(@Nullable String signature) {
        this.signature = signature;
    }

    @Nullable
    public Skin getSkin() {
        if (this.texture != null && this.signature != null) {
            return new Skin(this.texture, this.signature);
        }
        return null;
    }

    public void setSkin(@Nullable Skin skin) {
        if (skin != null) {
            this.texture = skin.texture();
            this.signature = skin.signature();
        } else {
            this.texture = null;
            this.signature = null;
        }
    }

    public boolean hasNick() {
        return this.nickname != null || this.skinName != null || this.texture != null || this.signature != null;
    }

    public void reset() {
        this.nickname = null;
        this.skinName = null;
        this.texture = null;
        this.signature = null;
    }
}

