/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.nametag.storage.impl;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOptions;
import gg.lode.nametag.NameTagPlugin;
import gg.lode.nametag.storage.NameTagStorage;
import gg.lode.nametag.storage.data.NameTagPlayer;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bson.Document;
import org.bukkit.configuration.file.FileConfiguration;

public class MongoDBNameTagStorage
implements NameTagStorage {
    private final NameTagPlugin plugin;
    private MongoClient mongoClient;
    private MongoCollection<Document> collection;

    public MongoDBNameTagStorage(NameTagPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public CompletableFuture<Void> initialize() {
        return CompletableFuture.runAsync(() -> {
            try {
                FileConfiguration config = this.plugin.getConfig();
                String uri = config.getString("storage.mongodb.uri");
                String database = config.getString("storage.mongodb.database");
                String collectionName = config.getString("storage.mongodb.collection");
                if (uri == null || database == null || collectionName == null) {
                    throw new RuntimeException("MongoDB configuration is incomplete. Please check your config.yml");
                }
                this.mongoClient = MongoClients.create(uri);
                MongoDatabase mongoDatabase = this.mongoClient.getDatabase(database);
                this.collection = mongoDatabase.getCollection(collectionName);
                this.collection.createIndex(new Document("uuid", 1));
                this.plugin.getLogger().info("MongoDB storage initialized successfully");
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to initialize MongoDB storage: " + e.getMessage());
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> savePlayer(NameTagPlayer player) {
        return CompletableFuture.runAsync(() -> {
            try {
                Document doc = new Document().append("uuid", player.getUuid().toString()).append("name", player.getNickname()).append("skin_name", player.getSkinName()).append("texture", player.getTexture()).append("signature", player.getSignature());
                this.collection.replaceOne(Filters.eq("uuid", player.getUuid().toString()), doc, new ReplaceOptions().upsert(true));
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to save NameTag player: " + e.getMessage());
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public CompletableFuture<NameTagPlayer> loadPlayer(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Document doc = (Document)this.collection.find(Filters.eq("uuid", uuid.toString())).first();
                if (doc == null) {
                    return null;
                }
                NameTagPlayer player = new NameTagPlayer(uuid);
                player.setNickname(doc.getString("name"));
                player.setSkinName(doc.getString("skin_name"));
                player.setTexture(doc.getString("texture"));
                player.setSignature(doc.getString("signature"));
                return player;
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to load NameTag player: " + e.getMessage());
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> deletePlayer(UUID uuid) {
        return CompletableFuture.runAsync(() -> {
            try {
                this.collection.deleteOne(Filters.eq("uuid", uuid.toString()));
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to delete NameTag player: " + e.getMessage());
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Boolean> hasPlayer(UUID uuid) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Document doc = (Document)this.collection.find(Filters.eq("uuid", uuid.toString())).first();
                if (doc == null) {
                    return false;
                }
                return doc.get("name") != null || doc.get("skin_name") != null || doc.get("texture") != null || doc.get("signature") != null;
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to check if NameTag player exists: " + e.getMessage());
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public CompletableFuture<List<NameTagPlayer>> getAllPlayers() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                ArrayList<NameTagPlayer> players = new ArrayList<NameTagPlayer>();
                for (Document doc : this.collection.find()) {
                    try {
                        String uuidStr = doc.getString("uuid");
                        if (uuidStr == null) continue;
                        UUID uuid = UUID.fromString(uuidStr);
                        if (doc.get("name") == null && doc.get("skin_name") == null && doc.get("texture") == null && doc.get("signature") == null) continue;
                        NameTagPlayer player = new NameTagPlayer(uuid);
                        player.setNickname(doc.getString("name"));
                        player.setSkinName(doc.getString("skin_name"));
                        player.setTexture(doc.getString("texture"));
                        player.setSignature(doc.getString("signature"));
                        players.add(player);
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getLogger().warning("Found invalid UUID in MongoDB: " + doc.getString("uuid"));
                    }
                }
                return players;
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to get all NameTag players: " + e.getMessage());
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> close() {
        return CompletableFuture.runAsync(() -> {
            if (this.mongoClient != null) {
                this.mongoClient.close();
            }
        });
    }
}

