/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nametag;

import dev.jorel.commandapi.nametag.CommandAPI;
import dev.jorel.commandapi.nametag.CommandAPIConfig;
import dev.jorel.commandapi.nametag.CommandAPIPaper;
import dev.jorel.commandapi.nametag.CommandAPIPaperConfig;
import dev.jorel.commandapi.nametag.InternalPaperConfig;
import dev.jorel.commandapi.nametag.LoadContext;
import dev.jorel.commandapi.nametag.exceptions.UnsupportedVersionException;
import dev.jorel.commandapi.nametag.nms.APITypeProvider;
import dev.jorel.commandapi.nametag.nms.PaperNMS;
import dev.jorel.commandapi.nametag.nms.PaperNMS_1_20_R4;
import dev.jorel.commandapi.nametag.nms.PaperNMS_1_21_R1;
import dev.jorel.commandapi.nametag.nms.PaperNMS_1_21_R2;
import dev.jorel.commandapi.nametag.nms.PaperNMS_1_21_R3;
import dev.jorel.commandapi.nametag.nms.PaperNMS_1_21_R4;
import dev.jorel.commandapi.nametag.nms.PaperNMS_1_21_R5;
import dev.jorel.commandapi.nametag.nms.PaperNMS_1_21_R6;
import io.papermc.paper.ServerBuildInfo;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import net.minecraft.commands.CommandListenerWrapper;

public abstract class CommandAPIVersionHandler {
    static LoadContext getPlatform(CommandAPIConfig<?> config) {
        if (!(config instanceof CommandAPIPaperConfig)) {
            throw new IllegalArgumentException("CommandAPIPaper was loaded with non-Paper config!");
        }
        CommandAPIPaperConfig paperConfig = (CommandAPIPaperConfig)config;
        InternalPaperConfig internalPaperConfig = new InternalPaperConfig(paperConfig);
        try {
            PaperNMS<CommandListenerWrapper> versionAdapter;
            String version;
            ServerBuildInfo buildInfo = ServerBuildInfo.buildInfo();
            switch (version = buildInfo.minecraftVersionId()) {
                case "1.20.6": {
                    PaperNMS<CommandListenerWrapper> paperNMS = new PaperNMS_1_20_R4();
                    break;
                }
                case "1.21": 
                case "1.21.1": {
                    PaperNMS<CommandListenerWrapper> paperNMS = new PaperNMS_1_21_R1();
                    break;
                }
                case "1.21.2": 
                case "1.21.3": {
                    PaperNMS<CommandListenerWrapper> paperNMS = new PaperNMS_1_21_R2();
                    break;
                }
                case "1.21.4": {
                    PaperNMS<CommandListenerWrapper> paperNMS = new PaperNMS_1_21_R3();
                    break;
                }
                case "1.21.5": {
                    PaperNMS<CommandListenerWrapper> paperNMS = new PaperNMS_1_21_R4();
                    break;
                }
                case "1.21.6": 
                case "1.21.7": 
                case "1.21.8": {
                    PaperNMS<CommandListenerWrapper> paperNMS = new PaperNMS_1_21_R5();
                    break;
                }
                case "1.21.9": 
                case "1.21.10": {
                    PaperNMS<CommandListenerWrapper> paperNMS = new PaperNMS_1_21_R6();
                    break;
                }
                default: {
                    PaperNMS<CommandListenerWrapper> paperNMS = versionAdapter = null;
                }
            }
            if (versionAdapter != null) {
                return new LoadContext(new CommandAPIPaper<CommandSourceStack>(internalPaperConfig, new APITypeProvider(versionAdapter)), () -> CommandAPI.logNormal("Loaded version " + CommandAPI.getPlatformMessage(versionAdapter)));
            }
            if (CommandAPIPaper.getConfiguration().fallbackToLatestNMS()) {
                PaperNMS_1_21_R6 paperNMS = new PaperNMS_1_21_R6();
                return new LoadContext(new CommandAPIPaper<CommandSourceStack>(internalPaperConfig, new APITypeProvider(paperNMS)), () -> {
                    CommandAPI.logNormal("Loaded version " + CommandAPI.getPlatformMessage(paperNMS));
                    CommandAPI.logWarning("Loading the CommandAPI with the latest and potentially incompatible NMS implementation.");
                    CommandAPI.logWarning("While you may find success with this, further updates might be necessary to fully support the version you are using.");
                });
            }
            version = buildInfo.asString(ServerBuildInfo.StringRepresentation.VERSION_SIMPLE);
            throw new UnsupportedVersionException(version);
        }
        catch (Throwable error) {
            if (error instanceof ClassNotFoundException) {
                ClassNotFoundException cnfe = (ClassNotFoundException)error;
                throw new IllegalStateException("The CommandAPI doesn't support any version before Paper 1.20.6 build 79. Please update your server!", cnfe);
            }
            throw error;
        }
    }
}

