/*
 * Decompiled with CFR 0.152.
 */
package dev.jorel.commandapi.nametag.nms;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.jorel.commandapi.nametag.CommandAPI;
import dev.jorel.commandapi.nametag.CommandAPIBukkit;
import dev.jorel.commandapi.nametag.CommandAPIHandler;
import dev.jorel.commandapi.nametag.SafeVarHandle;
import dev.jorel.commandapi.nametag.arguments.SuggestionProviders;
import dev.jorel.commandapi.nametag.arguments.parser.EntitySelectorParser;
import dev.jorel.commandapi.nametag.arguments.parser.RegistryParser;
import dev.jorel.commandapi.nametag.commandsenders.AbstractCommandSender;
import dev.jorel.commandapi.nametag.commandsenders.BukkitCommandSender;
import dev.jorel.commandapi.nametag.commandsenders.BukkitNativeProxyCommandSender;
import dev.jorel.commandapi.nametag.nms.NMS_Common;
import dev.jorel.commandapi.nametag.nms.NativeProxyCommandSender_1_21_R4;
import dev.jorel.commandapi.nametag.wrappers.DoubleRange;
import dev.jorel.commandapi.nametag.wrappers.FunctionWrapper;
import dev.jorel.commandapi.nametag.wrappers.IntegerRange;
import dev.jorel.commandapi.nametag.wrappers.Location2D;
import dev.jorel.commandapi.nametag.wrappers.NativeProxyCommandSender;
import dev.jorel.commandapi.nametag.wrappers.ParticleData;
import dev.jorel.commandapi.nametag.wrappers.Rotation;
import dev.jorel.commandapi.nametag.wrappers.ScoreboardSlot;
import dev.jorel.commandapi.nametag.wrappers.SimpleFunctionWrapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.FunctionInstantiationException;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentChatComponent;
import net.minecraft.commands.arguments.ArgumentCriterionValue;
import net.minecraft.commands.arguments.ArgumentDimension;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ArgumentParticle;
import net.minecraft.commands.arguments.ArgumentScoreboardObjective;
import net.minecraft.commands.arguments.ArgumentScoreboardSlot;
import net.minecraft.commands.arguments.ArgumentScoreboardTeam;
import net.minecraft.commands.arguments.ArgumentScoreholder;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.commands.arguments.coordinates.ArgumentRotation;
import net.minecraft.commands.arguments.coordinates.ArgumentVec2;
import net.minecraft.commands.arguments.item.ArgumentItemPredicate;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.commands.arguments.item.ArgumentPredicateItemStack;
import net.minecraft.commands.arguments.item.ArgumentTag;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.commands.functions.InstantiatedFunction;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.ParticleParamItem;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.TrailParticleOption;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.block.entity.FuelValues;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreHolder;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Server;
import org.bukkit.Sound;
import org.bukkit.Vibration;
import org.bukkit.World;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_21_R5.CraftLootTable;
import org.bukkit.craftbukkit.v1_21_R5.CraftParticle;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.CraftSound;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R5.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R5.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R5.command.VanillaCommandWrapper;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.help.CustomHelpTopic;
import org.bukkit.craftbukkit.v1_21_R5.help.SimpleHelpMap;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.potion.CraftPotionEffectType;
import org.bukkit.entity.Entity;
import org.bukkit.help.HelpTopic;
import org.bukkit.inventory.Recipe;
import org.bukkit.loot.LootTable;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Team;

public class NMS_1_21_R4
extends NMS_Common {
    private static final SafeVarHandle<SimpleHelpMap, Map<String, HelpTopic>> helpMapTopics;
    private static final Field entitySelectorUsesSelector;
    private static final Field serverFunctionLibraryDispatcher;
    private static final MethodHandle minecraftServerSetSelected;
    private static final boolean vanillaCommandDispatcherFieldExists;
    private static final SafeVarHandle<MinecraftServer, FuelValues> minecraftServerFuelValues;
    private static final SafeVarHandle<ArgumentTileLocation, NBTTagCompound> blockInputTag;
    private final Supplier<CommandBuildContext> commandBuildContext;

    public NMS_1_21_R4(Supplier<CommandBuildContext> commandBuildContext) {
        this.commandBuildContext = commandBuildContext;
    }

    @Override
    protected CommandBuildContext getCommandBuildContext() {
        return this.commandBuildContext.get();
    }

    @Override
    public ArgumentType<?> _ArgumentAdvancement() {
        return ResourceKeyArgument.a((ResourceKey)Registries.bz);
    }

    @Override
    public ArgumentType<?> _ArgumentChatComponent() {
        return ArgumentChatComponent.a((CommandBuildContext)this.commandBuildContext.get());
    }

    @Override
    public final ArgumentType<?> _ArgumentEnchantment() {
        return ResourceArgument.a((CommandBuildContext)this.commandBuildContext.get(), (ResourceKey)Registries.aW);
    }

    @Override
    public ArgumentType<?> _ArgumentRecipe() {
        return ResourceKeyArgument.a((ResourceKey)Registries.bA);
    }

    @Override
    public final ArgumentType<?> _ArgumentSyntheticBiome() {
        return ResourceArgument.a((CommandBuildContext)this.commandBuildContext.get(), (ResourceKey)Registries.aK);
    }

    @Override
    public final Map<String, HelpTopic> getHelpMap() {
        return helpMapTopics.get((SimpleHelpMap)Bukkit.getHelpMap());
    }

    @Override
    public String[] compatibleVersions() {
        return new String[]{"1.21.5"};
    }

    private String serializeNMSItemStack(ItemStack is) {
        return new ArgumentPredicateItemStack(is.i(), is.d()).a((HolderLookup.a)this.commandBuildContext.get());
    }

    @Override
    public final String convert(org.bukkit.inventory.ItemStack is) {
        return this.serializeNMSItemStack(CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)is));
    }

    @Override
    public final String convert(ParticleData<?> particle) {
        ParticleParam particleOptions = CraftParticle.createParticleParam((org.bukkit.Particle)particle.particle(), particle.data());
        MinecraftKey particleKey = BuiltInRegistries.i.b((Object)particleOptions.a());
        Codec codec = particleOptions.a().c().codec();
        DataResult result = codec.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)particleOptions);
        NBTTagCompound particleOptionsTag = (NBTTagCompound)result.result().get();
        String dataString = particleOptionsTag.e().isEmpty() ? "" : particleOptionsTag.toString();
        return particleKey.toString() + dataString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int runCommandFunction(CommandFunction<CommandListenerWrapper> commandFunction, CommandListenerWrapper css) {
        GameProfilerFiller profiler = Profiler.a();
        profiler.a(() -> "function " + String.valueOf(commandFunction.a()));
        AtomicInteger result = new AtomicInteger();
        CommandResultCallback onCommandResult = (succeeded, resultValue) -> result.set(resultValue);
        try {
            InstantiatedFunction instantiatedFunction = commandFunction.a((NBTTagCompound)null, CommandAPIBukkit.get().getBrigadierDispatcher());
            CommandDispatcher.a((CommandListenerWrapper)css, executioncontext -> ExecutionContext.a((ExecutionContext)executioncontext, (InstantiatedFunction)instantiatedFunction, (ExecutionCommandSource)css, (CommandResultCallback)onCommandResult));
        }
        catch (FunctionInstantiationException instantiatedFunction) {
        }
        catch (Exception exception) {
            LogUtils.getLogger().warn("Failed to execute function {}", (Object)commandFunction.a(), (Object)exception);
        }
        finally {
            profiler.c();
        }
        return result.get();
    }

    private final SimpleFunctionWrapper convertFunction(CommandFunction<CommandListenerWrapper> commandFunction) {
        ToIntFunction<CommandListenerWrapper> appliedObj = css -> this.runCommandFunction(commandFunction, (CommandListenerWrapper)css);
        String[] commands = new String[]{};
        try {
            InstantiatedFunction instantiatedFunction = commandFunction.a((NBTTagCompound)null, CommandAPIBukkit.get().getBrigadierDispatcher());
            List cArr = instantiatedFunction.b();
            commands = new String[cArr.size()];
            int size = cArr.size();
            for (int i = 0; i < size; ++i) {
                commands[i] = cArr.get(i).toString();
            }
        }
        catch (FunctionInstantiationException functionInstantiationException) {
            // empty catch block
        }
        return new SimpleFunctionWrapper(this.fromResourceLocation(commandFunction.a()), appliedObj, commands);
    }

    @Override
    public final HelpTopic generateHelpTopic(String commandName, String shortDescription, String fullDescription, String permission) {
        return new CustomHelpTopic(commandName, shortDescription, fullDescription, permission);
    }

    @Override
    public Advancement getAdvancement(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ResourceKeyArgument.e(cmdCtx, (String)key).toBukkit();
    }

    @Override
    public final RegistryParser<Biome> getBiome(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        MinecraftKey resourceLocation = ResourceArgument.a(cmdCtx, (String)key, (ResourceKey)Registries.aK).h().a();
        return new RegistryParser<Biome>(() -> {
            Biome biome;
            try {
                biome = Biome.valueOf((String)resourceLocation.a().toUpperCase());
            }
            catch (IllegalArgumentException biomeNotFound) {
                biome = null;
            }
            return biome;
        }, () -> this.fromResourceLocation(resourceLocation));
    }

    @Override
    public final BlockState getBlockState(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        ArgumentTileLocation input = ArgumentTile.a(cmdCtx, (String)key);
        BlockState snapshot = CraftBlockStates.getBlockState((IRegistryCustom)CraftRegistry.getMinecraftRegistry(), (BlockPosition)BlockPosition.c, (IBlockData)input.a(), null);
        if (blockInputTag.get(input) != null && snapshot instanceof CraftBlockEntityState) {
            CraftBlockEntityState blockEntitySnapshot = (CraftBlockEntityState)snapshot;
            blockEntitySnapshot.loadData(blockInputTag.get(input));
        }
        return snapshot;
    }

    @Override
    public CommandListenerWrapper getBrigadierSourceFromCommandSender(AbstractCommandSender<? extends CommandSender> sender) {
        return VanillaCommandWrapper.getListener((CommandSender)sender.getSource());
    }

    @Override
    public final World getDimension(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentDimension.a(cmdCtx, (String)key).getWorld();
    }

    @Override
    public final org.bukkit.enchantments.Enchantment getEnchantment(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Enchantment enchantment = (Enchantment)ResourceArgument.g(cmdCtx, (String)key).a();
        MinecraftKey resource = ((MinecraftServer)this.getMinecraftServer()).ba().f(Registries.aW).b((Object)enchantment);
        return (org.bukkit.enchantments.Enchantment)Registry.ENCHANTMENT.get(this.fromResourceLocation(resource));
    }

    @Override
    public final EntitySelectorParser getEntitySelector(CommandContext<CommandListenerWrapper> cmdCtx, String str) {
        EntitySelector argument = (EntitySelector)cmdCtx.getArgument(str, EntitySelector.class);
        try {
            entitySelectorUsesSelector.set(argument, false);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return new EntitySelectorParser(() -> argument.c((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity(), () -> argument.a((CommandListenerWrapper)cmdCtx.getSource()).getBukkitEntity(), allowEmpty -> {
            try {
                ArrayList<CraftPlayer> result = new ArrayList<CraftPlayer>();
                for (EntityPlayer player : argument.d((CommandListenerWrapper)cmdCtx.getSource())) {
                    result.add(player.getBukkitEntity());
                }
                if (result.isEmpty() && !allowEmpty.booleanValue()) {
                    throw ArgumentEntity.e.create();
                }
                return result;
            }
            catch (CommandSyntaxException e) {
                if (allowEmpty.booleanValue()) {
                    return new ArrayList();
                }
                throw e;
            }
        }, allowEmpty -> {
            try {
                ArrayList<CraftEntity> result = new ArrayList<CraftEntity>();
                for (net.minecraft.world.entity.Entity entity : argument.b((CommandListenerWrapper)cmdCtx.getSource())) {
                    result.add(entity.getBukkitEntity());
                }
                if (result.isEmpty() && !allowEmpty.booleanValue()) {
                    throw ArgumentEntity.d.create();
                }
                return result;
            }
            catch (CommandSyntaxException e) {
                if (allowEmpty.booleanValue()) {
                    return new ArrayList();
                }
                throw e;
            }
        });
    }

    @Override
    public DoubleRange getDoubleRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.DoubleRange range = ArgumentCriterionValue.a.a(cmdCtx, (String)key);
        Double lowBoxed = range.a().orElse(null);
        Double highBoxed = range.b().orElse(null);
        double low = lowBoxed == null ? -1.7976931348623157E308 : lowBoxed;
        double high = highBoxed == null ? Double.MAX_VALUE : highBoxed;
        return new DoubleRange(low, high);
    }

    @Override
    public final FunctionWrapper[] getFunction(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArrayList<FunctionWrapper> result = new ArrayList<FunctionWrapper>();
        CommandListenerWrapper css = ((CommandListenerWrapper)cmdCtx.getSource()).a().b(2);
        for (CommandFunction commandFunction : ArgumentTag.a(cmdCtx, (String)key)) {
            result.add(FunctionWrapper.fromSimpleFunctionWrapper(this.convertFunction((CommandFunction<CommandListenerWrapper>)commandFunction), css, entity -> ((CommandListenerWrapper)cmdCtx.getSource()).a(((CraftEntity)entity).getHandle())));
        }
        return result.toArray(new FunctionWrapper[0]);
    }

    @Override
    public SimpleFunctionWrapper getFunction(NamespacedKey key) {
        MinecraftKey resourceLocation = MinecraftKey.a((String)key.getNamespace(), (String)key.getKey());
        Optional commandFunctionOptional = ((MinecraftServer)this.getMinecraftServer()).aE().a(resourceLocation);
        if (commandFunctionOptional.isPresent()) {
            return this.convertFunction((CommandFunction<CommandListenerWrapper>)((CommandFunction)commandFunctionOptional.get()));
        }
        throw new IllegalStateException("Failed to get defined function " + String.valueOf(key) + "! This should never happen - please report this to the CommandAPIdevelopers, we'd love to know how you got this error message!");
    }

    @Override
    public Set<NamespacedKey> getFunctions() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (MinecraftKey resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aE().d()) {
            result.add(this.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    @Override
    public IntegerRange getIntRange(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        CriterionConditionValue.IntegerRange range = ArgumentCriterionValue.b.a(cmdCtx, (String)key);
        Integer lowBoxed = range.a().orElse(null);
        Integer highBoxed = range.b().orElse(null);
        int low = lowBoxed == null ? Integer.MIN_VALUE : lowBoxed;
        int high = highBoxed == null ? Integer.MAX_VALUE : highBoxed;
        return new IntegerRange(low, high);
    }

    @Override
    public final org.bukkit.inventory.ItemStack getItemStack(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArgumentPredicateItemStack input = ArgumentItemStack.a(cmdCtx, (String)key);
        ItemStack item = input.a(1, false);
        return CraftItemStack.asBukkitCopy((ItemStack)item);
    }

    @Override
    public final Predicate<org.bukkit.inventory.ItemStack> getItemStackPredicate(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        ArgumentItemPredicate.d predicate = ArgumentItemPredicate.a(cmdCtx, (String)key);
        return arg_0 -> NMS_1_21_R4.lambda$getItemStackPredicate$11((Predicate)predicate, arg_0);
    }

    @Override
    public final Location2D getLocation2DPrecise(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Vec2F vecPos = ArgumentVec2.a(cmdCtx, (String)key);
        return new Location2D(this.getWorldForCSS((CommandListenerWrapper)cmdCtx.getSource()), vecPos.j, vecPos.k);
    }

    @Override
    public final LootTable getLootTable(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return CraftLootTable.minecraftToBukkit((MinecraftKey)ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key));
    }

    @Override
    public NamespacedKey getMinecraftKey(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return this.fromResourceLocation(ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key));
    }

    @Override
    public final Objective getObjective(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        String objectiveName = ArgumentScoreboardObjective.a(cmdCtx, (String)key).c();
        return Bukkit.getScoreboardManager().getMainScoreboard().getObjective(objectiveName);
    }

    @Override
    public final ParticleData<?> getParticle(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        org.bukkit.Particle particle;
        ParticleParam particleOptions = ArgumentParticle.a(cmdCtx, (String)key);
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            particle = CraftParticle.minecraftToBukkit((Particle)particleOptions.a());
        } else {
            particle = null;
        }
        if (particleOptions instanceof ParticleType) {
            return new ParticleData<Object>(particle, null);
        }
        if (particleOptions instanceof ParticleParamBlock) {
            ParticleParamBlock options = (ParticleParamBlock)particleOptions;
            return new ParticleData<CraftBlockData>(particle, CraftBlockData.fromData((IBlockData)options.b()));
        }
        if (particleOptions instanceof DustColorTransitionOptions) {
            DustColorTransitionOptions options = (DustColorTransitionOptions)particleOptions;
            return this.getParticleDataAsDustColorTransitionOption(particle, options);
        }
        if (particleOptions instanceof ParticleParamRedstone) {
            ParticleParamRedstone options = (ParticleParamRedstone)particleOptions;
            Color color = Color.fromRGB((int)((int)(options.b().x() * 255.0f)), (int)((int)(options.b().y() * 255.0f)), (int)((int)(options.b().z() * 255.0f)));
            return new ParticleData<Particle.DustOptions>(particle, new Particle.DustOptions(color, options.d()));
        }
        if (particleOptions instanceof ParticleParamItem) {
            ParticleParamItem options = (ParticleParamItem)particleOptions;
            return new ParticleData<org.bukkit.inventory.ItemStack>(particle, CraftItemStack.asBukkitCopy((ItemStack)options.b()));
        }
        if (particleOptions instanceof VibrationParticleOption) {
            VibrationParticleOption options = (VibrationParticleOption)particleOptions;
            return this.getParticleDataAsVibrationParticleOption(cmdCtx, particle, options);
        }
        if (particleOptions instanceof ShriekParticleOption) {
            ShriekParticleOption options = (ShriekParticleOption)particleOptions;
            return new ParticleData<Integer>(particle, options.b());
        }
        if (particleOptions instanceof SculkChargeParticleOptions) {
            SculkChargeParticleOptions options = (SculkChargeParticleOptions)particleOptions;
            return new ParticleData<Float>(particle, Float.valueOf(options.b()));
        }
        if (particleOptions instanceof ColorParticleOption) {
            ColorParticleOption options = (ColorParticleOption)particleOptions;
            return this.getParticleDataAsColorParticleOption(particle, options);
        }
        if (particleOptions instanceof TrailParticleOption) {
            TrailParticleOption options = (TrailParticleOption)particleOptions;
            return this.getParticleDataAsTrailParticleOption(cmdCtx, particle, options);
        }
        CommandAPI.getLogger().warning("Invalid particle data type for " + particle.getDataType().toString());
        return new ParticleData<Object>(particle, null);
    }

    private ParticleData<Particle.Trail> getParticleDataAsTrailParticleOption(CommandContext<CommandListenerWrapper> cmdCtx, org.bukkit.Particle particle, TrailParticleOption options) {
        WorldServer level = ((CommandListenerWrapper)cmdCtx.getSource()).e();
        Vec3D target = options.b();
        Location targetLocation = new Location((World)level.getWorld(), target.d, target.e, target.f);
        Color color = Color.fromARGB((int)options.c());
        return new ParticleData<Particle.Trail>(particle, new Particle.Trail(targetLocation, color, options.d()));
    }

    private ParticleData<Color> getParticleDataAsColorParticleOption(org.bukkit.Particle particle, ColorParticleOption options) {
        Color color = Color.fromARGB((int)((int)(options.e() * 255.0f)), (int)((int)(options.b() * 255.0f)), (int)((int)(options.c() * 255.0f)), (int)((int)(options.d() * 255.0f)));
        return new ParticleData<Color>(particle, color);
    }

    private ParticleData<Particle.DustTransition> getParticleDataAsDustColorTransitionOption(org.bukkit.Particle particle, DustColorTransitionOptions options) {
        Color color = Color.fromRGB((int)((int)(options.b().x() * 255.0f)), (int)((int)(options.b().y() * 255.0f)), (int)((int)(options.b().z() * 255.0f)));
        Color toColor = Color.fromRGB((int)((int)(options.c().x() * 255.0f)), (int)((int)(options.c().y() * 255.0f)), (int)((int)(options.c().z() * 255.0f)));
        return new ParticleData<Particle.DustTransition>(particle, new Particle.DustTransition(color, toColor, options.d()));
    }

    private ParticleData<?> getParticleDataAsVibrationParticleOption(CommandContext<CommandListenerWrapper> cmdCtx, org.bukkit.Particle particle, VibrationParticleOption options) {
        Vec3D origin = ((CommandListenerWrapper)cmdCtx.getSource()).d();
        WorldServer level = ((CommandListenerWrapper)cmdCtx.getSource()).e();
        Location from = new Location((World)level.getWorld(), origin.d, origin.e, origin.f);
        PositionSource positionSource = options.b();
        if (!(positionSource instanceof BlockPositionSource)) {
            CommandAPI.getLogger().warning("Unknown or unsupported vibration destination " + String.valueOf(options.b()));
            return new ParticleData<Object>(particle, null);
        }
        BlockPositionSource positionSource2 = (BlockPositionSource)positionSource;
        Vec3D to = (Vec3D)positionSource2.a((net.minecraft.world.level.World)level).get();
        Vibration.Destination.BlockDestination destination = new Vibration.Destination.BlockDestination(new Location((World)level.getWorld(), to.a(), to.b(), to.c()));
        return new ParticleData<Vibration>(particle, new Vibration(from, (Vibration.Destination)destination, options.c()));
    }

    @Override
    public RegistryParser<PotionEffectType> getPotionEffect(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return new RegistryParser<PotionEffectType>(() -> CraftPotionEffectType.minecraftToBukkit((MobEffectList)((MobEffectList)ResourceArgument.f((CommandContext)cmdCtx, (String)key).a())), () -> this.fromResourceLocation(ArgumentMinecraftKeyRegistered.a((CommandContext)cmdCtx, (String)key)));
    }

    @Override
    public final <T extends Recipe> T getRecipe(CommandContext<CommandListenerWrapper> cmdCtx, String key, BiFunction<NamespacedKey, Recipe, T> result) throws CommandSyntaxException {
        RecipeHolder recipe = ResourceKeyArgument.d(cmdCtx, (String)key);
        return (T)((Recipe)result.apply(this.fromResourceLocation(recipe.a().b()), recipe.toBukkitRecipe()));
    }

    @Override
    public final Rotation getRotation(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        Vec2F rotation = ArgumentRotation.a(cmdCtx, (String)key).b((CommandListenerWrapper)cmdCtx.getSource());
        return new Rotation(rotation.k, rotation.j);
    }

    @Override
    public ScoreboardSlot getScoreboardSlot(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        return ScoreboardSlot.ofMinecraft(ArgumentScoreboardSlot.a(cmdCtx, (String)key).a());
    }

    @Override
    public Collection<String> getScoreHolderMultiple(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        Collection scoreHolders = ArgumentScoreholder.b(cmdCtx, (String)key);
        HashSet<String> scoreHolderNames = new HashSet<String>();
        for (ScoreHolder scoreHolder : scoreHolders) {
            scoreHolderNames.add(scoreHolder.cM());
        }
        return scoreHolderNames;
    }

    @Override
    public String getScoreHolderSingle(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        return ArgumentScoreholder.a(cmdCtx, (String)key).cM();
    }

    @Override
    public BukkitCommandSender<? extends CommandSender> getSenderForCommand(CommandContext<CommandListenerWrapper> cmdCtx, boolean isNative) {
        net.minecraft.world.entity.Entity proxyEntity;
        CraftEntity proxy;
        CommandListenerWrapper css = (CommandListenerWrapper)cmdCtx.getSource();
        CommandSender sender = css.getBukkitSender();
        if (sender == null) {
            sender = Bukkit.getConsoleSender();
        }
        CraftEntity craftEntity = proxy = (proxyEntity = css.f()) == null ? null : proxyEntity.getBukkitEntity();
        if (isNative || proxy != null && !sender.equals((Object)proxy)) {
            if (proxy == null) {
                proxy = sender;
            }
            return new BukkitNativeProxyCommandSender(new NativeProxyCommandSender_1_21_R4(css, sender, (CommandSender)proxy));
        }
        return CommandAPIBukkit.get().wrapCommandSender(sender);
    }

    @Override
    public NativeProxyCommandSender createNativeProxyCommandSender(CommandSender caller, CommandSender callee, Location location, World world) {
        if (callee == null) {
            callee = caller;
        }
        CommandListenerWrapper css = this.getBrigadierSourceFromCommandSender(CommandAPIBukkit.get().wrapCommandSender(caller));
        if (location != null) {
            css = css.a(new Vec3D(location.getX(), location.getY(), location.getZ())).a(new Vec2F(location.getPitch(), location.getYaw()));
        }
        if (world == null && location != null) {
            world = location.getWorld();
        }
        if (world != null) {
            css = css.a(((CraftWorld)world).getHandle());
        }
        if (callee instanceof Entity) {
            Entity e = (Entity)callee;
            css = css.a(((CraftEntity)e).getHandle());
        }
        return new NativeProxyCommandSender_1_21_R4(css, caller, callee);
    }

    @Override
    public final SimpleCommandMap getSimpleCommandMap() {
        return ((CraftServer)Bukkit.getServer()).getCommandMap();
    }

    @Override
    public final RegistryParser<Sound> getSound(CommandContext<CommandListenerWrapper> cmdCtx, String key) {
        MinecraftKey soundResource = ArgumentMinecraftKeyRegistered.a(cmdCtx, (String)key);
        return new RegistryParser<Sound>(() -> {
            Optional soundEvent = BuiltInRegistries.b.c(soundResource);
            if (soundEvent.isEmpty()) {
                return null;
            }
            return CraftSound.minecraftToBukkit((SoundEffect)((SoundEffect)((Holder.c)soundEvent.get()).a()));
        }, () -> NamespacedKey.fromString((String)(soundResource.b() + ":" + soundResource.a())));
    }

    @Override
    public SuggestionProvider<CommandListenerWrapper> getSuggestionProvider(SuggestionProviders provider) {
        return switch (provider) {
            case SuggestionProviders.FUNCTION -> (context, builder) -> {
                CustomFunctionData functionData = ((MinecraftServer)this.getMinecraftServer()).aE();
                ICompletionProvider.a((Iterable)functionData.e(), (SuggestionsBuilder)builder, (String)"#");
                return ICompletionProvider.a((Iterable)functionData.d(), (SuggestionsBuilder)builder);
            };
            case SuggestionProviders.RECIPES -> (cmdCtx, builder) -> ICompletionProvider.a(((MinecraftServer)this.getMinecraftServer()).aI().d().stream().map(holder -> holder.a().a()), (SuggestionsBuilder)builder);
            case SuggestionProviders.SOUNDS -> CompletionProviders.b;
            case SuggestionProviders.ADVANCEMENTS -> (cmdCtx, builder) -> ICompletionProvider.a(((MinecraftServer)this.getMinecraftServer()).aD().b().stream().map(AdvancementHolder::a), (SuggestionsBuilder)builder);
            case SuggestionProviders.LOOT_TABLES -> (cmdCtx, builder) -> ICompletionProvider.a((Iterable)((MinecraftServer)this.getMinecraftServer()).bc().getKeys(Registries.bw), (SuggestionsBuilder)builder);
            case SuggestionProviders.BIOMES -> (arg_0, arg_1) -> this._ArgumentSyntheticBiome().listSuggestions(arg_0, arg_1);
            case SuggestionProviders.ENTITIES -> CompletionProviders.c;
            case SuggestionProviders.POTION_EFFECTS -> (context, builder) -> ICompletionProvider.a((Iterable)BuiltInRegistries.d.i(), (SuggestionsBuilder)builder);
            default -> (context, builder) -> Suggestions.empty();
        };
    }

    @Override
    public final SimpleFunctionWrapper[] getTag(NamespacedKey key) {
        List customFunctions = ((MinecraftServer)this.getMinecraftServer()).aE().b(MinecraftKey.a((String)key.getNamespace(), (String)key.getKey()));
        SimpleFunctionWrapper[] convertedCustomFunctions = new SimpleFunctionWrapper[customFunctions.size()];
        int index = 0;
        for (CommandFunction customFunction : customFunctions) {
            convertedCustomFunctions[index++] = this.convertFunction((CommandFunction<CommandListenerWrapper>)customFunction);
        }
        return convertedCustomFunctions;
    }

    @Override
    public Set<NamespacedKey> getTags() {
        HashSet<NamespacedKey> result = new HashSet<NamespacedKey>();
        for (MinecraftKey resourceLocation : ((MinecraftServer)this.getMinecraftServer()).aE().e()) {
            result.add(this.fromResourceLocation(resourceLocation));
        }
        return result;
    }

    @Override
    public final Team getTeam(CommandContext<CommandListenerWrapper> cmdCtx, String key) throws CommandSyntaxException {
        String teamName = ArgumentScoreboardTeam.a(cmdCtx, (String)key).c();
        return Bukkit.getScoreboardManager().getMainScoreboard().getTeam(teamName);
    }

    @Override
    public World getWorldForCSS(CommandListenerWrapper css) {
        return css.e() == null ? null : css.e().getWorld();
    }

    @Override
    public final void reloadDataPacks() {
        CommandAPI.logNormal("Reloading datapacks...");
        Iterator recipes = Bukkit.recipeIterator();
        MinecraftServer.ReloadableResources serverResources = ((MinecraftServer)this.getMinecraftServer()).aA;
        serverResources.b().d = ((MinecraftServer)this.getMinecraftServer()).aG();
        try {
            serverFunctionLibraryDispatcher.set(serverResources.b().a(), CommandAPIBukkit.get().getBrigadierDispatcher());
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        ArrayList<String> packIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aF().e());
        List disabledPacks = ((MinecraftServer)this.getMinecraftServer()).aZ().D().a().b();
        for (String availablePack : ((MinecraftServer)this.getMinecraftServer()).aF().c()) {
            if (disabledPacks.contains(availablePack) || packIDs.contains(availablePack)) continue;
            packIDs.add(availablePack);
        }
        ArrayList<String> collection = packIDs;
        CompletionStage first = CompletableFuture.supplyAsync(() -> {
            ResourcePackRepository serverPackRepository = ((MinecraftServer)this.getMinecraftServer()).aF();
            ArrayList<IResourcePack> packResources = new ArrayList<IResourcePack>();
            for (String packID : collection) {
                ResourcePackLoader pack = serverPackRepository.c(packID);
                if (pack == null) continue;
                packResources.add(pack.f());
            }
            return packResources;
        }).exceptionally(exception -> {
            CommandAPI.logException("Something went wrong while trying to collect resource packs!", exception);
            return ((MinecraftServer)this.getMinecraftServer()).aF().h();
        });
        CompletionStage second = ((CompletableFuture)((CompletableFuture)first).thenCompose(packResources -> {
            ResourceManager resourceManager = new ResourceManager(EnumResourcePackType.b, packResources);
            CompletableFuture simpleReloadInstance = Reloadable.a((IResourceManager)resourceManager, (List)serverResources.b().f(), (Executor)((MinecraftServer)this.getMinecraftServer()).ay, (Executor)((Executor)this.getMinecraftServer()), CompletableFuture.completedFuture(Unit.a), (boolean)LogUtils.getLogger().isDebugEnabled()).a();
            return simpleReloadInstance.thenApply(x -> serverResources);
        })).exceptionally(exception -> {
            CommandAPI.logException("Something went wrong while trying to convert resource packs into ReloadableResources", exception);
            return ((MinecraftServer)this.getMinecraftServer()).aA;
        });
        CompletionStage third = ((CompletableFuture)((CompletableFuture)second).thenAcceptAsync(resources -> {
            ((MinecraftServer)this.getMinecraftServer()).aA.close();
            ((MinecraftServer)this.getMinecraftServer()).aA = serverResources;
            ((MinecraftServer)this.getMinecraftServer()).server.syncCommands();
            if (minecraftServerSetSelected == null) {
                ((MinecraftServer)this.getMinecraftServer()).aF().setSelected(collection);
            } else {
                try {
                    minecraftServerSetSelected.invoke(((MinecraftServer)this.getMinecraftServer()).aF(), collection, true);
                }
                catch (Throwable e) {
                    CommandAPI.logException("Something went wrong while trying to invoke PackRepository#setSelected(Collection, boolean)", e);
                }
            }
            FeatureFlagSet enabledFeatures = ((MinecraftServer)this.getMinecraftServer()).aZ().D().b();
            Collection selectedIDs = ((MinecraftServer)this.getMinecraftServer()).aF().e();
            ImmutableList enabledIDs = ImmutableList.copyOf((Collection)selectedIDs);
            ArrayList<String> disabledIDs = new ArrayList<String>(((MinecraftServer)this.getMinecraftServer()).aF().c());
            disabledIDs.removeIf(((List)enabledIDs)::contains);
            ((MinecraftServer)this.getMinecraftServer()).aZ().a(new WorldDataConfiguration(new DataPackConfiguration((List)enabledIDs, disabledIDs), enabledFeatures));
            ((MinecraftServer)this.getMinecraftServer()).aA.b().g();
            ((MinecraftServer)this.getMinecraftServer()).aA.b().c().a(enabledFeatures);
            ((MinecraftServer)this.getMinecraftServer()).aY().a((IResourceManager)((MinecraftServer)this.getMinecraftServer()).aA.a());
            minecraftServerFuelValues.set((MinecraftServer)this.getMinecraftServer(), FuelValues.a((HolderLookup.a)((MinecraftServer)this.getMinecraftServer()).bb().a(), (FeatureFlagSet)enabledFeatures));
        })).exceptionally(exception -> {
            CommandAPI.logException("Something went wrong while trying to load resources.", exception);
            return null;
        });
        if (((MinecraftServer)this.getMinecraftServer()).bx()) {
            ((MinecraftServer)this.getMinecraftServer()).b(((CompletableFuture)third)::isDone);
        }
        try {
            CommandAPIBukkit.get().registerBukkitRecipesSafely(recipes);
            CommandAPI.logNormal("Finished reloading datapacks");
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            e.printStackTrace(printWriter);
            CommandAPI.logError("Failed to load datapacks, can't proceed with normal server load procedure. Try fixing your datapacks?\n" + stringWriter.toString());
        }
    }

    @Override
    public Message generateMessageFromJson(String json) {
        return Component.Serializer.fromJson((String)json, (HolderLookup.a)((HolderLookup.a)this.commandBuildContext.get()));
    }

    @Override
    public <T> T getMinecraftServer() {
        Server server = Bukkit.getServer();
        if (server instanceof CraftServer) {
            CraftServer server2 = (CraftServer)server;
            return (T)server2.getServer();
        }
        return null;
    }

    @Override
    public ArgumentType<?> _ArgumentMobEffect() {
        return ResourceArgument.a((CommandBuildContext)this.commandBuildContext.get(), (ResourceKey)Registries.Z);
    }

    @Override
    public ArgumentType<?> _ArgumentEntitySummon() {
        return ResourceArgument.a((CommandBuildContext)this.commandBuildContext.get(), (ResourceKey)Registries.D);
    }

    private static /* synthetic */ boolean lambda$getItemStackPredicate$11(Predicate predicate, org.bukkit.inventory.ItemStack item) {
        return predicate.test(CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)item));
    }

    static {
        boolean fieldExists;
        MethodHandle setSelected;
        helpMapTopics = SafeVarHandle.ofOrNull(SimpleHelpMap.class, "helpTopics", "helpTopics", Map.class);
        entitySelectorUsesSelector = CommandAPIHandler.getField(EntitySelector.class, "p", "usesSelector");
        serverFunctionLibraryDispatcher = CommandAPIHandler.getField(CustomFunctionManager.class, "h", "dispatcher");
        blockInputTag = SafeVarHandle.ofOrNull(ArgumentTileLocation.class, "c", "tag", NBTTagCompound.class);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            setSelected = lookup.findVirtual(ResourcePackRepository.class, "setSelected", MethodType.methodType(Void.TYPE, Collection.class, Boolean.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            setSelected = null;
        }
        minecraftServerSetSelected = setSelected;
        try {
            MinecraftServer.class.getDeclaredField("vanillaCommandDispatcher");
            fieldExists = true;
        }
        catch (NoSuchFieldException | SecurityException e) {
            fieldExists = false;
        }
        vanillaCommandDispatcherFieldExists = fieldExists;
        minecraftServerFuelValues = SafeVarHandle.ofOrNull(MinecraftServer.class, "aE", "fuelValues", FuelValues.class);
    }
}

