/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfapi;

import gg.lode.bookshelfapi.IBookshelfAPI;
import gg.lode.bookshelfapi.api.manager.IChatManager;
import gg.lode.bookshelfapi.api.manager.ICooldownManager;
import gg.lode.bookshelfapi.api.manager.ICustomItemManager;
import gg.lode.bookshelfapi.api.manager.IGameManager;
import gg.lode.bookshelfapi.api.manager.IMenuManager;
import gg.lode.bookshelfapi.api.manager.IPlayerManager;
import gg.lode.bookshelfapi.api.manager.IScoreboardManager;
import gg.lode.bookshelfapi.api.manager.IVanishManager;
import gg.lode.bookshelfapi.api.manager.impl.APICooldownManager;
import gg.lode.bookshelfapi.api.manager.impl.APICustomItemManager;
import gg.lode.bookshelfapi.api.manager.impl.APIMenuManager;
import gg.lode.bookshelfapi.api.manager.impl.APIScoreboardManager;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BookshelfAPI {
    private static IBookshelfAPI api;

    public static void init(final JavaPlugin plugin, final Builder builder) {
        api = new IBookshelfAPI(){
            private final APIMenuManager menuManager;
            private final APICooldownManager cooldownManager;
            private final APICustomItemManager itemManager;
            private final APIScoreboardManager scoreboardManager;
            {
                this.menuManager = builder.shouldRegisterMenuManager ? new APIMenuManager(plugin) : null;
                this.cooldownManager = builder.shouldRegisterCooldownManager ? new APICooldownManager(plugin) : null;
                this.itemManager = builder.shouldRegisterItemManager ? new APICustomItemManager((Plugin)plugin) : null;
                this.scoreboardManager = builder.shouldRegisterScoreboardManager ? new APIScoreboardManager(plugin) : null;
            }

            @Override
            public IScoreboardManager getScoreboardManager() {
                if (builder.shouldRegisterScoreboardManager) {
                    return this.scoreboardManager;
                }
                throw new UnsupportedOperationException("ScoreboardManager is disabled, please enable it in BookshelfAPI.Builder!");
            }

            @Override
            public IMenuManager getMenuManager() {
                if (builder.shouldRegisterMenuManager) {
                    return this.menuManager;
                }
                throw new UnsupportedOperationException("MenuManager is disabled, please enable it in BookshelfAPI.Builder!");
            }

            @Override
            public ICooldownManager getCooldownManager() {
                if (builder.shouldRegisterCooldownManager) {
                    return this.cooldownManager;
                }
                throw new UnsupportedOperationException("CooldownManager is disabled, please enable it in BookshelfAPI.Builder!");
            }

            @Override
            public IChatManager getChatManager() {
                throw new UnsupportedOperationException("ChatManager is only available with the Bookshelf plugin! Please install Bookshelf to use this feature.");
            }

            @Override
            public IGameManager getGameManager() {
                throw new UnsupportedOperationException("GameManager is only available with the Bookshelf plugin! Please install Bookshelf to use this feature.");
            }

            @Override
            public IPlayerManager getPlayerManager() {
                throw new UnsupportedOperationException("PlayerManager is only available with the Bookshelf plugin! Please install Bookshelf to use this feature.");
            }

            @Override
            public ICustomItemManager getItemManager() {
                if (builder.shouldRegisterItemManager) {
                    return this.itemManager;
                }
                throw new UnsupportedOperationException("ItemManager is disabled, please enable it in BookshelfAPI.Builder!");
            }

            @Override
            public IVanishManager getVanishManager() {
                throw new UnsupportedOperationException("VanishManager is only available with the Bookshelf plugin! Please install Bookshelf to use this feature.");
            }
        };
    }

    public static void init(JavaPlugin plugin) {
        BookshelfAPI.init(plugin, Builder.create());
    }

    public static void initInternalApi(IBookshelfAPI api) {
        BookshelfAPI.api = api;
    }

    public static IBookshelfAPI getApi() {
        return api;
    }

    public static boolean is1_21() {
        return Bukkit.getServer().getMinecraftVersion().startsWith("1.21");
    }

    public static boolean isHigher1_21_4() {
        String version;
        String[] split;
        if (BookshelfAPI.is1_21() && (split = (version = Bukkit.getServer().getMinecraftVersion()).split("\\.")).length >= 3) {
            int minor = Integer.parseInt(split[1]);
            int patch = Integer.parseInt(split[2]);
            return minor > 21 || minor == 21 && patch >= 4;
        }
        return false;
    }

    public static class Builder {
        private boolean shouldRegisterScoreboardManager = true;
        private boolean shouldRegisterMenuManager = true;
        private boolean shouldRegisterCooldownManager = true;
        private boolean shouldRegisterItemManager = true;

        public static Builder create() {
            return new Builder();
        }

        public static Builder createDisabled() {
            return new Builder().useMenuManager(false).useCooldownManager(false).useItemManager(false).useScoreboardManager(false);
        }

        public Builder useScoreboardManager(boolean shouldRegisterScoreboardManager) {
            this.shouldRegisterScoreboardManager = shouldRegisterScoreboardManager;
            return this;
        }

        public Builder useMenuManager(boolean shouldRegisterMenuManager) {
            this.shouldRegisterMenuManager = shouldRegisterMenuManager;
            return this;
        }

        public Builder useCooldownManager(boolean shouldRegisterCooldownManager) {
            this.shouldRegisterCooldownManager = shouldRegisterCooldownManager;
            return this;
        }

        public Builder useItemManager(boolean shouldRegisterItemManager) {
            this.shouldRegisterItemManager = shouldRegisterItemManager;
            return this;
        }
    }
}

