/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfapi.api.manager.impl;

import gg.lode.bookshelfapi.api.item.CustomItem;
import gg.lode.bookshelfapi.api.item.ItemBuilder;
import gg.lode.bookshelfapi.api.manager.ICustomItemManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class APICustomItemManager
implements ICustomItemManager,
Listener {
    private static final String ID = "custom_item";
    private final ConcurrentHashMap<String, CustomItem> items = new ConcurrentHashMap();
    private final ConcurrentHashMap<CustomItem, String> mirroredItems = new ConcurrentHashMap();
    private final Plugin plugin;
    private final NamespacedKey itemKey;

    public APICustomItemManager(Plugin plugin) {
        this.plugin = plugin;
        this.itemKey = new NamespacedKey(plugin, ID);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, plugin);
    }

    @Override
    public void register(CustomItem ... i) {
        for (CustomItem item : i) {
            this.items.put(item.id(), item);
            this.mirroredItems.put(item, item.id());
        }
    }

    @Override
    @Nullable
    public ItemStack getItemStackByClass(Class<? extends CustomItem> itemClass) {
        try {
            CustomItem item = this.getItemByClass(itemClass);
            if (item == null) {
                return null;
            }
            return item.getBuilder().build();
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    @Override
    @Nullable
    public CustomItem getItemByClass(Class<? extends CustomItem> customItem) {
        return this.items.values().stream().filter(i -> i.getClass() == customItem).findFirst().orElse(null);
    }

    @Override
    public boolean isCustomItem(ItemStack itemStack, Class<? extends CustomItem> itemClass) {
        return this.getItemByItemStack(itemStack) != null && Objects.requireNonNull(this.getItemByItemStack(itemStack)).getClass().hashCode() == itemClass.hashCode();
    }

    @Override
    public CustomItem getItemById(String id) {
        if (id == null) {
            return null;
        }
        return this.items.get(id);
    }

    @Override
    public CustomItem getItemByItemStack(ItemStack itemStack) {
        if (this.isEmpty(itemStack)) {
            return null;
        }
        String id = this.getIdByItemStack(itemStack);
        return this.getItemById(id);
    }

    @Override
    public String getIdByCustomItem(CustomItem customItem) {
        return this.mirroredItems.get(customItem);
    }

    @Override
    public boolean isCustomItem(ItemStack itemStack, String id) {
        CustomItem customItem = this.getItemByItemStack(itemStack);
        return customItem != null && customItem.id().equalsIgnoreCase(id);
    }

    @Override
    public String getIdByItemStack(ItemStack itemStack) {
        if (this.isEmpty(itemStack) || !this.hasData(itemStack)) {
            return null;
        }
        return (String)itemStack.getItemMeta().getPersistentDataContainer().get(this.itemKey, PersistentDataType.STRING);
    }

    private boolean isEmpty(ItemStack item) {
        return item == null || item.getType().isAir();
    }

    @Override
    @Nullable
    public ItemStack getItemStackById(String id) {
        ItemBuilder builder = this.getItemBuilderById(id);
        return builder == null ? null : builder.build();
    }

    @Override
    public ItemBuilder getItemBuilderById(String id) {
        CustomItem item = this.getItemById(id);
        if (item == null) {
            return null;
        }
        ItemBuilder builder = new ItemBuilder().tag(this.itemKey, item.id());
        item.builder(builder);
        return builder;
    }

    @Override
    public ItemBuilder getItemBuilderByClass(Class<? extends CustomItem> itemClass) {
        return this.getItemBuilderById(Objects.requireNonNull(this.getItemByClass(itemClass)).id());
    }

    private boolean hasData(ItemStack itemStack) {
        return itemStack.hasItemMeta() && !itemStack.getItemMeta().getPersistentDataContainer().isEmpty();
    }

    @Override
    public List<CustomItem> getItems() {
        return new ArrayList<CustomItem>(this.items.values());
    }

    @Override
    public void unregister(String id) {
        CustomItem customItem = this.items.remove(id);
        if (customItem != null) {
            this.mirroredItems.remove(customItem);
        }
    }

    @EventHandler
    public void onAnvil(PrepareAnvilEvent event) {
        CustomItem CustomItem2 = this.getItemByItemStack(event.getInventory().getFirstItem());
        if (CustomItem2 != null && !CustomItem2.isCombinable()) {
            event.setResult(null);
        }
    }

    @EventHandler
    public void on(EntityShootBowEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        CustomItem customItem = this.getItemByItemStack(event.getBow());
        if (customItem != null) {
            customItem.onShoot(player, event, event.getBow());
        }
    }

    @EventHandler
    public void onEnchant(PrepareItemEnchantEvent event) {
        CustomItem customItem = this.getItemByItemStack(event.getItem());
        if (customItem != null && !customItem.isEnchantable()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onHeld(PlayerItemHeldEvent event) {
        CustomItem customItem;
        ItemStack unheldItem = event.getPlayer().getInventory().getItem(event.getPreviousSlot());
        ItemStack heldItem = event.getPlayer().getInventory().getItem(event.getNewSlot());
        Player player = event.getPlayer();
        CustomItem customUnheldItem = this.getItemByItemStack(unheldItem);
        if (customUnheldItem != null) {
            customUnheldItem.onUnheld(player, event, unheldItem);
        }
        if ((customItem = this.getItemByItemStack(heldItem)) != null) {
            customItem.onHeld(player, event, heldItem);
        }
    }

    @EventHandler
    public void onShift(PlayerToggleSneakEvent event) {
        Player player = event.getPlayer();
        ItemStack heldItem = player.getInventory().getItemInMainHand().getType().isEmpty() ? player.getInventory().getItemInOffHand() : player.getInventory().getItemInMainHand();
        CustomItem customItem = this.getItemByItemStack(heldItem);
        if (customItem != null) {
            customItem.onShift(player, event, heldItem);
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        ItemStack heldItem = event.getItem();
        Player player = event.getPlayer();
        Action action = event.getAction();
        if (heldItem == null) {
            return;
        }
        CustomItem customItem = this.getItemByItemStack(heldItem);
        if (customItem != null) {
            customItem.onInteract(player, event, heldItem);
            if (action.equals((Object)Action.RIGHT_CLICK_BLOCK) || action.equals((Object)Action.RIGHT_CLICK_AIR)) {
                customItem.onRightInteract(player, event, heldItem);
            }
            if (action.equals((Object)Action.LEFT_CLICK_BLOCK) || action.equals((Object)Action.LEFT_CLICK_AIR)) {
                customItem.onLeftInteract(player, event, heldItem);
            }
        }
    }

    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        ItemStack heldItem = event.getPlayer().getInventory().getItemInMainHand();
        Player player = event.getPlayer();
        CustomItem customItem = this.getItemByItemStack(heldItem);
        if (customItem != null) {
            customItem.onBlockBreak(player, event, heldItem);
        }
    }

    @EventHandler
    public void onPlace(BlockPlaceEvent event) {
        ItemStack heldItem = event.getPlayer().getInventory().getItemInMainHand();
        Player player = event.getPlayer();
        CustomItem customItem = this.getItemByItemStack(heldItem);
        if (customItem != null) {
            customItem.onBlockPlace(player, event, heldItem);
        }
    }

    @EventHandler
    public void onFish(PlayerFishEvent event) {
        Player player = event.getPlayer();
        ItemStack heldItem = player.getInventory().getItemInMainHand().getType().isAir() ? player.getInventory().getItemInOffHand() : player.getInventory().getItemInMainHand();
        CustomItem customItem = this.getItemByItemStack(heldItem);
        if (customItem != null) {
            customItem.onFish(player, event, heldItem);
        }
    }

    @EventHandler
    public void onDeath(EntityDamageByEntityEvent event) {
        Entity entity = event.getDamager();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack heldItem = player.getInventory().getItemInMainHand().getType().isAir() ? player.getInventory().getItemInOffHand() : player.getInventory().getItemInMainHand();
        CustomItem customItem = this.getItemByItemStack(heldItem);
        if (customItem != null) {
            customItem.onHurt(player, event, heldItem);
        }
    }

    @EventHandler
    public void onKill(EntityDeathEvent event) {
        Player player = event.getEntity().getKiller();
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.getInventory().getItemInMainHand().getType().isAir() ? player.getInventory().getItemInOffHand() : player.getInventory().getItemInMainHand();
        CustomItem customItem = this.getItemByItemStack(heldItem);
        if (customItem != null) {
            customItem.onKill(player, event, heldItem);
        }
    }

    @EventHandler
    public void on(PlayerHarvestBlockEvent event) {
        Player player = event.getPlayer();
        ItemStack heldItem = player.getInventory().getItemInMainHand().getType().isAir() ? player.getInventory().getItemInOffHand() : player.getInventory().getItemInMainHand();
        CustomItem customItem = this.getItemByItemStack(heldItem);
        if (customItem != null) {
            customItem.onHarvest(player, event, heldItem);
        }
    }

    @EventHandler
    public void on(PlayerDropItemEvent event) {
        ItemStack heldItem = event.getItemDrop().getItemStack();
        CustomItem customItem = this.getItemByItemStack(heldItem);
        if (customItem != null) {
            customItem.onDrop(event.getPlayer(), event, heldItem);
        }
    }

    @EventHandler
    public void on(PlayerSwapHandItemsEvent event) {
        CustomItem offHandItem;
        Player player = event.getPlayer();
        @Nullable ItemStack mainHand = event.getMainHandItem();
        @Nullable ItemStack offHand = event.getOffHandItem();
        CustomItem mainCustomItem = this.getItemByItemStack(mainHand);
        if (mainCustomItem != null) {
            mainCustomItem.onOffhand(player, event, mainHand);
        }
        if ((offHandItem = this.getItemByItemStack(offHand)) != null) {
            offHandItem.onOffhand(player, event, mainHand);
        }
    }

    @EventHandler
    public void on(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack heldItem = event.getCurrentItem();
        if (heldItem != null) {
            CustomItem customItem = this.getItemByItemStack(heldItem);
            if (customItem != null) {
                customItem.onInventoryClick(player, event, heldItem);
            }
        } else {
            CustomItem customItem;
            heldItem = event.getCursor();
            if (!heldItem.isEmpty()) {
                CustomItem customItem2 = this.getItemByItemStack(heldItem);
                if (customItem2 != null) {
                    customItem2.onInventoryPlace(player, event, heldItem);
                }
            } else if (event.getHotbarButton() != -1 && (customItem = this.getItemByItemStack(heldItem = player.getInventory().getItem(event.getHotbarButton()))) != null) {
                customItem.onInventoryHotbar(player, event, heldItem);
            }
        }
    }
}

