/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfapi.api.manager.impl;

import gg.lode.bookshelfapi.api.Task;
import gg.lode.bookshelfapi.api.manager.IMenuManager;
import gg.lode.bookshelfapi.api.menu.Menu;
import gg.lode.bookshelfapi.api.menu.build.MenuBuilder;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public class APIMenuManager
implements IMenuManager,
Listener {
    private static final HashMap<UUID, Menu> activeMenus = new HashMap();
    private final JavaPlugin plugin;

    public APIMenuManager(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public void register(Player player, Menu menu) {
        this.register(player.getUniqueId(), menu);
    }

    @Override
    public void register(UUID uniqueId, Menu menu) {
        if (activeMenus.containsKey(uniqueId)) {
            Menu menu2 = activeMenus.remove(uniqueId);
        }
        activeMenus.put(uniqueId, menu);
    }

    @Override
    public void registerAndOpen(Player player, Menu menu) {
        this.registerAndOpen(player.getUniqueId(), menu);
    }

    @Override
    public void registerAndOpen(UUID uniqueId, Menu menu) {
        this.register(uniqueId, menu);
        menu.open();
    }

    @Override
    @Nullable
    public Menu getActiveMenu(Player player) {
        return this.getActiveMenu(player.getUniqueId());
    }

    @Override
    @Nullable
    public Menu getActiveMenu(UUID uniqueId) {
        return activeMenus.get(uniqueId);
    }

    @EventHandler
    public void on(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null) {
            return;
        }
        InventoryView view = event.getView();
        if (activeMenus.containsKey(player.getUniqueId())) {
            int slot = event.getSlot();
            Menu menu = activeMenus.get(player.getUniqueId());
            if (view.getTopInventory().equals(clickedInventory)) {
                menu.getTopMenuBuilder().getClickActions().forEach(c2 -> c2.accept(event));
                menu.getTopMenuBuilder().process(slot, event);
            } else if (view.getBottomInventory().equals(clickedInventory)) {
                MenuBuilder bottomMenuBuilder = menu.getBottomMenuBuilder();
                if (bottomMenuBuilder == null) {
                    return;
                }
                bottomMenuBuilder.process(slot, event);
            }
        }
    }

    @EventHandler
    public void on(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Menu menu = activeMenus.get(player.getUniqueId());
        if (menu == null) {
            return;
        }
        menu.getTopMenuBuilder().getCloseActions().forEach(closeEvent -> closeEvent.accept(event));
        if (!event.getReason().equals((Object)InventoryCloseEvent.Reason.OPEN_NEW)) {
            Task.later(this.plugin, () -> activeMenus.remove(player.getUniqueId()), 1L);
        }
    }

    @EventHandler
    public void on(PlayerQuitEvent event) {
        activeMenus.remove(event.getPlayer().getUniqueId());
    }
}

