/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfapi.api.manager.impl;

import gg.lode.bookshelfapi.api.board.AbstractBoard;
import gg.lode.bookshelfapi.api.manager.IScoreboardManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.Nullable;

public class APIScoreboardManager
extends BukkitRunnable
implements IScoreboardManager,
Listener {
    private static final String DEFAULT_TEAM_NAME = "default_team";
    protected final JavaPlugin plugin;
    protected final HashMap<UUID, AbstractBoard> playerBoards = new HashMap();

    public APIScoreboardManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.startScoreboard(plugin, 1);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @Override
    public void changeColor(Player player, Player other, NamedTextColor color, @Nullable String teamName) {
        Team scoreboardTeam;
        if (teamName == null) {
            teamName = DEFAULT_TEAM_NAME;
        }
        if ((scoreboardTeam = player.getScoreboard().getTeam(teamName)) == null) {
            try {
                scoreboardTeam = player.getScoreboard().registerNewTeam(teamName);
                if (color != null) {
                    scoreboardTeam.color(color);
                }
                if (!teamName.equalsIgnoreCase(DEFAULT_TEAM_NAME)) {
                    scoreboardTeam.prefix((Component)Component.empty());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        assert (scoreboardTeam != null);
        if (scoreboardTeam.hasEntry(other.getName())) {
            return;
        }
        this.removeFromTeams(player, other);
        scoreboardTeam.addEntry(other.getName());
    }

    @Override
    public void changeColor(Player player, Player other, NamedTextColor color) {
        this.changeColor(player, other, color, null);
    }

    @Override
    public void removeFromTeams(Player player, Player other) {
        if (player == null || other == null) {
            return;
        }
        for (Team team : player.getScoreboard().getTeams()) {
            if (!team.hasEntry(other.getName())) continue;
            team.removeEntry(other.getName());
        }
    }

    @Override
    public void addPlayer(Player player, AbstractBoard board) {
        this.addPlayer(player.getUniqueId(), board);
    }

    @Override
    public void addPlayer(UUID uniqueId, AbstractBoard board) {
        this.playerBoards.put(uniqueId, board);
    }

    @Override
    public void removePlayer(Player player) {
        this.removePlayer(player.getUniqueId());
    }

    @Override
    public void removePlayer(UUID uniqueId) {
        this.playerBoards.remove(uniqueId);
    }

    @Override
    public boolean hasScoreboard(Player player) {
        return this.hasScoreboard(player.getUniqueId());
    }

    @Override
    public boolean hasScoreboard(UUID uniqueId) {
        return this.playerBoards.containsKey(uniqueId);
    }

    @Override
    public Map<UUID, AbstractBoard> getAllScoreboards() {
        return this.playerBoards;
    }

    @Override
    public void startScoreboard(JavaPlugin plugin, int tick) {
        this.runTaskTimerAsynchronously((Plugin)plugin, tick, tick);
    }

    @Override
    public void endScoreboard() {
        this.playerBoards.clear();
        this.cancel();
    }

    public void run() {
        for (Map.Entry<UUID, AbstractBoard> entry : this.playerBoards.entrySet()) {
            Player player;
            UUID uniqueId = entry.getKey();
            AbstractBoard board = entry.getValue();
            if (board == null || (player = this.plugin.getServer().getPlayer(uniqueId)) == null || !player.isOnline()) continue;
            board.update();
            AbstractBoard.TabList tabList = board.getTabList();
            if (tabList.getTopTabList() != null) {
                player.sendPlayerListHeader(tabList.getTopTabList());
            }
            if (tabList.getBottomTabList() == null) continue;
            player.sendPlayerListFooter(tabList.getBottomTabList());
        }
    }
}

