/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfapi.api.util;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;

public class PackHelper {
    public static byte[] convertHexToByteArray(String hexString) {
        int length = hexString.length();
        byte[] byteArray = new byte[length / 2];
        for (int i = 0; i < length; i += 2) {
            byteArray[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return byteArray;
    }

    public static String retrieveSHA1FromURL(String fileUrl) throws Exception {
        URL url = new URL(fileUrl);
        Path tempFile = Files.createTempFile("downloaded", ".zip", new FileAttribute[0]);
        try (InputStream in = url.openStream();){
            Files.copy(in, tempFile, StandardCopyOption.REPLACE_EXISTING);
        }
        return PackHelper.calculateSHA1(tempFile);
    }

    private static String calculateSHA1(Path file) throws Exception {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        try (InputStream fis = Files.newInputStream(file, new OpenOption[0]);){
            int bytesCount;
            byte[] byteArray = new byte[1024];
            while ((bytesCount = fis.read(byteArray)) != -1) {
                digest.update(byteArray, 0, bytesCount);
            }
        }
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (byte b2 : bytes) {
            sb.append(String.format("%02x", b2));
        }
        return sb.toString();
    }
}

