/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfapi.api.util;

import gg.lode.bookshelfapi.api.util.MiniMessageHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;

public class VariableContext {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("<<([a-zA-Z0-9_]+?)(?::([a-zA-Z]))?>>|<([a-zA-Z0-9_]+?)(?::([a-zA-Z]))?>");
    private final Map<String, String> variables;

    public void set(String key, Object value) {
        this.variables.put(key, String.valueOf(value));
    }

    public String get(String key) {
        return this.variables.get(key);
    }

    public VariableContext() {
        this.variables = new HashMap<String, String>();
    }

    public VariableContext(Map<String, String> variables) {
        this.variables = variables;
    }

    public static void main(String[] args) {
        VariableContext context = VariableContext.of();
        context.set("test", "Hello, World!");
        System.out.println(context.replace("<<test>>"));
    }

    public static VariableContext of() {
        return new VariableContext();
    }

    public static VariableContext of(String key, String value) {
        VariableContext ctx = new VariableContext();
        ctx.set(key, value);
        return ctx;
    }

    public VariableContext fromVariables(Map<String, String> values) {
        return new VariableContext(values);
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public VariableContext with(String key, String value) {
        this.set(key, value);
        return this;
    }

    private String applyFormatter(String value, String format) {
        if (format == null) {
            return value;
        }
        return switch (format.toLowerCase()) {
            case "u" -> value.toUpperCase();
            case "l" -> value.toLowerCase();
            default -> value;
        };
    }

    public Component replaceAsComponent(String input) {
        String result = this.replace(input);
        return MiniMessageHelper.deserialize(result);
    }

    public String replace(String input) {
        boolean replaced;
        if (input == null) {
            return "";
        }
        String result = input;
        int maxIterations = 10;
        int iterations = 0;
        do {
            replaced = false;
            Matcher matcher = PLACEHOLDER_PATTERN.matcher(result);
            StringBuilder buffer = new StringBuilder();
            while (matcher.find()) {
                Object value;
                String format;
                String key;
                boolean isDoubleBracketed;
                boolean bl = isDoubleBracketed = matcher.group(1) != null;
                if (isDoubleBracketed) {
                    key = matcher.group(1);
                    format = matcher.group(2);
                } else {
                    key = matcher.group(3);
                    format = matcher.group(4);
                }
                if ((value = this.variables.get(key)) == null) continue;
                value = this.applyFormatter((String)value, format);
                if (isDoubleBracketed) {
                    value = "<" + (String)value + ">";
                }
                matcher.appendReplacement(buffer, Matcher.quoteReplacement((String)value));
                replaced = true;
            }
            matcher.appendTail(buffer);
            result = buffer.toString();
        } while (replaced && ++iterations < maxIterations);
        return result;
    }
}

