/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.bookshelfcmd.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.jorel.commandapi.nametag.CommandAPIBukkit;
import dev.jorel.commandapi.nametag.SuggestionInfo;
import dev.jorel.commandapi.nametag.arguments.ArgumentSuggestions;
import dev.jorel.commandapi.nametag.arguments.SuggestionsBranch;
import dev.jorel.commandapi.nametag.executors.CommandArguments;
import gg.lode.bookshelfcmd.argument.FlagArgument;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandFlagArgument
extends FlagArgument {
    private final SuggestionsBranch<CommandSender> replacements = SuggestionsBranch.suggest(new ArgumentSuggestions[0]);

    public CommandFlagArgument(String nodeName, Set<Character> flags, Set<Character> valueFlags) {
        super(nodeName, flags, valueFlags);
        this.replaceSuggestions((info, builder) -> {
            Player player;
            Block block;
            CommandSender sender = (CommandSender)info.sender();
            CommandMap commandMap = CommandAPIBukkit.get().getCommandMap();
            String command = info.currentArg();
            StringReader context = new StringReader(command);
            if (!command.contains(" ")) {
                ArgumentSuggestions<CommandSender> replacement = this.replacements.getNextSuggestion(sender, new String[0]);
                if (replacement != null) {
                    return replacement.suggest(new SuggestionInfo<CommandSender>(sender, new CommandArguments(new Object[0], new LinkedHashMap<String, Object>(), new String[0], new LinkedHashMap<String, String>(), info.currentInput()), command, command), builder);
                }
                List results = commandMap.tabComplete(sender, command);
                if (results == null) {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext((ImmutableStringReader)context);
                }
                if (sender instanceof Player) {
                    for (String result : results) {
                        builder.suggest(result.substring(1));
                    }
                } else {
                    for (String result : results) {
                        builder.suggest(result);
                    }
                }
                return builder.buildFuture();
            }
            String commandLabel = command.substring(0, command.indexOf(" "));
            Command target = commandMap.getCommand(commandLabel);
            if (target == null) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext((ImmutableStringReader)context);
            }
            String[] arguments = command.split(" ");
            if (!arguments[0].isEmpty() && command.endsWith(" ")) {
                arguments = Arrays.copyOf(arguments, arguments.length + 1);
                arguments[arguments.length - 1] = "";
            }
            builder = builder.createOffset(builder.getStart() + command.lastIndexOf(" ") + 1);
            int lastIndex = arguments.length - 1;
            Object[] previousArguments = Arrays.copyOf(arguments, lastIndex);
            ArgumentSuggestions<CommandSender> replacement = this.replacements.getNextSuggestion(sender, (String[])previousArguments);
            if (replacement != null) {
                return replacement.suggest(new SuggestionInfo<CommandSender>(sender, new CommandArguments(previousArguments, new LinkedHashMap<String, Object>(), (String[])previousArguments, new LinkedHashMap<String, String>(), info.currentInput()), command, arguments[lastIndex]), builder);
            }
            arguments = Arrays.copyOfRange(arguments, 1, arguments.length);
            Location location = null;
            if (sender instanceof Player && (block = (player = (Player)sender).getTargetBlockExact(5, FluidCollisionMode.NEVER)) != null) {
                location = block.getLocation();
            }
            for (String tabCompletion : target.tabComplete(sender, commandLabel, arguments, location)) {
                builder.suggest(tabCompletion);
            }
            for (String str : command.split(" ")) {
                if (!str.startsWith("-")) continue;
                HashSet<Character> usedFlags = new HashSet<Character>();
                for (String part : info.currentInput().split("\\s+")) {
                    if (!part.startsWith("-") || part.length() <= 1) continue;
                    for (char c2 : part.substring(1).toCharArray()) {
                        usedFlags.add(Character.valueOf(c2));
                    }
                }
                List<Character> unusedFlags = this.allFlags.stream().filter(f -> !usedFlags.contains(f)).toList();
                if (!info.currentInput().endsWith(" ")) {
                    for (Character f2 : unusedFlags) {
                        String clean = str.substring(1);
                        builder.suggest("-" + clean + f2);
                    }
                    continue;
                }
                for (Character f3 : unusedFlags) {
                    builder.suggest("-" + f3);
                }
            }
            return builder.buildFuture();
        });
    }

    public CommandFlagArgument(String nodeName, Set<Character> flags) {
        this(nodeName, flags, Set.of());
    }
}

