/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.nametag;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import dev.jorel.commandapi.nametag.CommandAPI;
import dev.jorel.commandapi.nametag.CommandAPIPaperConfig;
import gg.lode.bookshelfapi.api.Configuration;
import gg.lode.bookshelfapi.api.Task;
import gg.lode.bookshelfapi.api.VersionUpdater;
import gg.lode.bookshelfapi.api.mojang.MojangProfile;
import gg.lode.bookshelfapi.api.util.Metrics;
import gg.lode.bookshelfapi.api.util.MiniMessageHelper;
import gg.lode.nametag.command.NameTagCommand;
import gg.lode.nametag.command.NickCommand;
import gg.lode.nametag.command.RandomNickCommand;
import gg.lode.nametag.nms.PaperSkinManager;
import gg.lode.nametag.storage.StorageManager;
import gg.lode.nametagapi.INameTagAPI;
import gg.lode.nametagapi.NameTagAPI;
import gg.lode.nametagapi.api.NickPlayer;
import gg.lode.nametagapi.api.Skin;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventOwner;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import me.neznamy.tab.api.TabAPI;
import me.neznamy.tab.api.TabPlayer;
import me.neznamy.tab.api.event.player.PlayerLoadEvent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public final class NameTagPlugin
extends JavaPlugin
implements INameTagAPI {
    public static final String VERSION = "v1.0.52";
    private final ConcurrentHashMap<UUID, NickPlayer> playerCache = new ConcurrentHashMap();
    private StorageManager storageManager;
    private PaperSkinManager paperSkinManager;
    private Configuration config;
    private static final int CONFIG_VERSION = 3;
    private static NameTagPlugin instance;

    @Nullable
    private static String[] fetchTextureAndSignatureFromMineskinId(String skinId) {
        try {
            String apiEndpoint = "https://api.mineskin.org/v2/skins/" + skinId;
            URL url = new URL(apiEndpoint);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            JSONParser parser = new JSONParser();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                String jsonResponse = response.toString();
                JSONObject object = (JSONObject)parser.parse(jsonResponse);
                String[] outputToReturn = new String[]{(String)((JSONObject)((JSONObject)((JSONObject)object.get((Object)"skin")).get((Object)"texture")).get((Object)"data")).get((Object)"value"), (String)((JSONObject)((JSONObject)((JSONObject)object.get((Object)"skin")).get((Object)"texture")).get((Object)"data")).get((Object)"signature")};
                reader.close();
                return outputToReturn;
            }
            return null;
        }
        catch (Exception err) {
            err.printStackTrace();
            return null;
        }
    }

    public static boolean isPaper12004OrNewer() {
        String version = Bukkit.getMinecraftVersion();
        return NameTagPlugin.isVersionAtLeast(version, "1.20.4");
    }

    public static boolean isPaper1219OrNewer() {
        String version = Bukkit.getMinecraftVersion();
        return NameTagPlugin.isVersionAtLeast(version, "1.21.9");
    }

    private static boolean isVersionAtLeast(String current, String required) {
        String[] a2 = current.split("\\.");
        String[] b2 = required.split("\\.");
        for (int i = 0; i < Math.max(a2.length, b2.length); ++i) {
            int bi;
            int ai = i < a2.length ? Integer.parseInt(a2[i]) : 0;
            int n = bi = i < b2.length ? Integer.parseInt(b2[i]) : 0;
            if (ai == bi) continue;
            return ai > bi;
        }
        return true;
    }

    public void onLoad() {
        new Metrics(this, 24781);
        CommandAPI.onLoad(((CommandAPIPaperConfig)new CommandAPIPaperConfig((LifecycleEventOwner)this).setNamespace("minecraft")).fallbackToLatestNMS(true));
        this.storageManager = new StorageManager(this);
        this.storageManager.initialize().whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.getLogger().severe("Failed to initialize storage system: " + throwable.getMessage());
                throwable.printStackTrace();
            } else {
                this.getLogger().info("Storage system initialized successfully");
            }
        });
        this.config = new Configuration(this, "config.yml");
        this.config.initialize();
        this.updateConfigToLatest();
        NameTagAPI.setApi(this);
    }

    private void updateConfigToLatest() {
        if (this.config.getInt("version") < 3) {
            this.getLogger().info("Updating configuration to the latest version...");
            switch (this.config.getInt("version")) {
                case 1: {
                    this.config.set("change_uuids", (Object)false);
                    break;
                }
                case 2: {
                    this.config.set("can_use_existing_players", (Object)false);
                    this.config.set("change_uuids", null);
                }
            }
            this.config.set("version", (Object)(this.config.getInt("version") + 1));
            if (this.config.getInt("version") < 3) {
                this.updateConfigToLatest();
            } else {
                this.config.save();
                this.getLogger().info("Configuration updated to the latest version successfully.");
            }
        }
    }

    public void onEnable() {
        CommandAPI.onEnable();
        instance = this;
        this.paperSkinManager = new PaperSkinManager();
        for (Player player : this.getServer().getOnlinePlayers()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> this.storageManager.getStorage().loadPlayer(player.getUniqueId()).thenAccept(nameTagPlayer -> {
                if (nameTagPlayer == null) {
                    nameTagPlayer = new NickPlayer(player.getUniqueId());
                    nameTagPlayer.setOriginalName(player.getName());
                    try {
                        GameProfile profile = this.paperSkinManager.getProfile(player);
                        Method propertiesMethod = NameTagPlugin.isPaper1219OrNewer() ? GameProfile.class.getMethod("properties", new Class[0]) : GameProfile.class.getMethod("getProperties", new Class[0]);
                        PropertyMap propertyMap = (PropertyMap)propertiesMethod.invoke((Object)profile, new Object[0]);
                        Collection textures = propertyMap.get((Object)"textures");
                        if (textures != null && !textures.isEmpty()) {
                            Property skinProperty = (Property)textures.iterator().next();
                            nameTagPlayer.setOriginalTexture(skinProperty.value());
                            nameTagPlayer.setOriginalSignature(skinProperty.signature());
                            this.getLogger().info("Stored original skin for " + player.getName());
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().warning("Could not fetch original skin for " + player.getName() + ": " + e.getMessage());
                    }
                    this.storageManager.getStorage().savePlayer((NickPlayer)nameTagPlayer);
                }
                this.playerCache.put(player.getUniqueId(), (NickPlayer)nameTagPlayer);
            }));
        }
        this.getLogger().info("NickAPI UserHandler initialized for " + this.getServer().getOnlinePlayers().size() + " online players");
        this.getServer().getPluginManager().registerEvents((Listener)new VersionUpdater(this, "Name Tag", "https://lode.gg/plugin/nametag", "https://lode.gg/api/plugins/nametag/version", VERSION), (Plugin)this);
        this.registerCommands();
        if (this.getServer().getPluginManager().isPluginEnabled("TAB")) {
            try {
                Class<?> tabClass = Class.forName("me.neznamy.tab.api.TabAPI");
                Method getInstanceMethod = tabClass.getMethod("getInstance", new Class[0]);
                TabAPI tabApiInstance = (TabAPI)getInstanceMethod.invoke(null, new Object[0]);
                Objects.requireNonNull(tabApiInstance.getEventBus()).register(PlayerLoadEvent.class, event -> this.updateTabPlayer(event.getPlayer()));
                this.getLogger().warning("==========================================");
                this.getLogger().warning("Hooked into TAB!");
                this.getLogger().warning("Name Tag will now use TAB to display nicknames.");
                this.getLogger().warning("==========================================");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public PaperSkinManager getPaperSkinManager() {
        return this.paperSkinManager;
    }

    public void updateTabPlayer(TabPlayer player) {
        String name = this.hasNick(player.getUniqueId()) ? this.getNick(player.getUniqueId()) : player.getName();
        try {
            Class<?> tabClass = Class.forName("me.neznamy.tab.api.TabAPI");
            Method getInstanceMethod = tabClass.getMethod("getInstance", new Class[0]);
            TabAPI tabApiInstance = (TabAPI)getInstanceMethod.invoke(null, new Object[0]);
            this.getLogger().warning("[TAB] Successfully updated " + player.getName() + " to " + name);
            Objects.requireNonNull(tabApiInstance.getTabListFormatManager()).setName(player, name);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.getLogger().warning("Failed to load player " + player.getName() + " into TAB.");
        }
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public static NameTagPlugin instance() {
        return instance;
    }

    public ConcurrentHashMap<UUID, NickPlayer> getPlayerCache() {
        return this.playerCache;
    }

    private <T> void executeStorageOperation(CompletableFuture<T> future, String operation) {
        this.executeStorageOperation(future, operation, () -> {});
    }

    private <T> void executeStorageOperation(CompletableFuture<T> future, String operation, Runnable callback) {
        future.whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.getLogger().severe("Storage operation failed (" + operation + "): " + throwable.getMessage());
                throwable.printStackTrace();
            } else {
                this.getLogger().warning("Successfully executed operation (" + operation + ")");
                callback.run();
            }
        });
    }

    private void registerCommands() {
        new NickCommand(this).register();
        new RandomNickCommand(this).register();
        new NameTagCommand(this).register();
    }

    public Configuration config() {
        return this.config;
    }

    public void onDisable() {
        CommandAPI.onDisable();
        if (this.storageManager != null) {
            this.storageManager.close().whenComplete((result, throwable) -> {
                if (throwable != null) {
                    this.getLogger().severe("Failed to close storage system: " + throwable.getMessage());
                    throwable.printStackTrace();
                } else {
                    this.getLogger().info("Storage system closed successfully");
                }
            });
        }
    }

    @Override
    public boolean hasNick(Player player) {
        NickPlayer cached = this.playerCache.get(player.getUniqueId());
        if (cached != null) {
            return cached.hasNick();
        }
        NickPlayer nickPlayer = this.storageManager.getStorage().loadPlayer(player.getUniqueId()).join();
        return nickPlayer != null && nickPlayer.hasNick();
    }

    @Override
    @Nullable
    public String getNick(Player player) {
        NickPlayer cached = this.playerCache.get(player.getUniqueId());
        if (cached != null) {
            return cached.getNickname();
        }
        NickPlayer nickPlayer = this.storageManager.getStorage().loadPlayer(player.getUniqueId()).join();
        if (nickPlayer != null) {
            this.playerCache.put(player.getUniqueId(), nickPlayer);
        }
        return nickPlayer != null ? nickPlayer.getNickedName() : null;
    }

    @Override
    @Nullable
    public String getNick(UUID uniqueId) {
        NickPlayer cached = this.playerCache.get(uniqueId);
        if (cached != null) {
            return cached.getNickname();
        }
        NickPlayer nickPlayer = this.storageManager.getStorage().loadPlayer(uniqueId).join();
        if (nickPlayer != null) {
            this.playerCache.put(uniqueId, nickPlayer);
        }
        return nickPlayer != null ? nickPlayer.getNickname() : null;
    }

    @Override
    @Nullable
    public Component getNickComponent(Player player) {
        String nickname = this.getNick(player);
        return nickname != null ? MiniMessageHelper.deserialize(nickname) : null;
    }

    @Override
    @Nullable
    public Component getNickComponent(UUID uniqueId) {
        String nickname = this.getNick(uniqueId);
        return nickname != null ? MiniMessageHelper.deserialize(nickname) : null;
    }

    @Override
    @Nullable
    public Skin getSkin(Player player) {
        NickPlayer cached = this.playerCache.get(player.getUniqueId());
        if (cached != null) {
            return cached.getSkin();
        }
        NickPlayer nickPlayer = this.storageManager.getStorage().loadPlayer(player.getUniqueId()).join();
        if (nickPlayer != null) {
            this.playerCache.put(player.getUniqueId(), nickPlayer);
        }
        return nickPlayer != null ? nickPlayer.getSkin() : null;
    }

    @Override
    @Nullable
    public Skin getSkin(UUID uniqueId) {
        NickPlayer cached = this.playerCache.get(uniqueId);
        if (cached != null) {
            return cached.getSkin();
        }
        NickPlayer nickPlayer = this.storageManager.getStorage().loadPlayer(uniqueId).join();
        if (nickPlayer != null) {
            this.playerCache.put(uniqueId, nickPlayer);
        }
        return nickPlayer != null ? nickPlayer.getSkin() : null;
    }

    @Override
    public void resetAllNicks() {
        int[] onlineResetCount = new int[]{0};
        for (Player player : this.getServer().getOnlinePlayers()) {
            if (!this.hasNick(player)) continue;
            this.resetNick(player);
            onlineResetCount[0] = onlineResetCount[0] + 1;
        }
        this.storageManager.getStorage().getAllPlayers().whenComplete((storedPlayers, throwable) -> {
            if (throwable != null) {
                this.getLogger().severe("Failed to reset stored data: " + throwable.getMessage());
                throwable.printStackTrace();
                return;
            }
            if (storedPlayers == null || storedPlayers.isEmpty()) {
                this.getLogger().info("Successfully reset " + onlineResetCount[0] + " online players. No stored data found.");
                return;
            }
            ArrayList<CompletableFuture<Void>> deleteFutures = new ArrayList<CompletableFuture<Void>>();
            for (NickPlayer storedPlayer : storedPlayers) {
                deleteFutures.add(this.storageManager.getStorage().deletePlayer(storedPlayer.getUuid()));
            }
            CompletableFuture.allOf(deleteFutures.toArray(new CompletableFuture[0])).whenComplete((result, deleteThrowable) -> {
                if (deleteThrowable != null) {
                    this.getLogger().severe("Failed to delete some stored data: " + deleteThrowable.getMessage());
                    deleteThrowable.printStackTrace();
                    return;
                }
                this.playerCache.clear();
                this.getLogger().info("Successfully reset " + onlineResetCount[0] + " online players and " + storedPlayers.size() + " stored players. All nickname data has been cleared.");
            });
        });
    }

    @Override
    public void shouldChangeUniqueId(boolean shouldChange) {
        this.config.set("change_uuids", (Object)shouldChange);
    }

    @Override
    public boolean shouldChangeUniqueId() {
        return this.config.getBoolean("change_uuids");
    }

    public void saveAllPlayersData() {
        this.getLogger().info("Starting sequential save of all online players' data...");
        ArrayList onlinePlayers = new ArrayList(this.getServer().getOnlinePlayers());
        int totalPlayers = onlinePlayers.size();
        int savedCount = 0;
        for (Player player : onlinePlayers) {
            NickPlayer cached = this.playerCache.get(player.getUniqueId());
            if (cached == null || !cached.hasNick()) continue;
            try {
                this.storageManager.getStorage().savePlayer(cached).join();
                this.getLogger().info("Saved data for " + player.getName() + " (" + ++savedCount + "/" + totalPlayers + ")");
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to save data for " + player.getName() + ": " + e.getMessage());
            }
        }
        this.getLogger().info("Completed saving data for " + savedCount + " players out of " + totalPlayers + " online players.");
    }

    public void saveAllCachedPlayersData() {
        this.getLogger().info("Starting sequential save of all cached players' data...");
        ArrayList<NickPlayer> cachedPlayers = new ArrayList<NickPlayer>(this.playerCache.values());
        int totalPlayers = cachedPlayers.size();
        int savedCount = 0;
        for (NickPlayer cachedPlayer : cachedPlayers) {
            if (!cachedPlayer.hasNick()) continue;
            try {
                this.storageManager.getStorage().savePlayer(cachedPlayer).join();
                this.getLogger().info("Saved cached data for " + String.valueOf(cachedPlayer.getUuid()) + " (" + ++savedCount + "/" + totalPlayers + ")");
            }
            catch (Exception e) {
                this.getLogger().severe("Failed to save cached data for " + String.valueOf(cachedPlayer.getUuid()) + ": " + e.getMessage());
            }
        }
        this.getLogger().info("Completed saving data for " + savedCount + " cached players out of " + totalPlayers + " total cached players.");
    }

    public boolean hasNick(UUID uniqueId) {
        NickPlayer cached = this.playerCache.get(uniqueId);
        if (cached != null) {
            return cached.hasNick();
        }
        return this.storageManager.getStorage().hasPlayer(uniqueId).join();
    }

    @Override
    public void setNickname(Player player, String name) {
        this.setNickname(player, MiniMessageHelper.deserialize(name));
    }

    @Override
    public void setNickname(Player player, Component component) {
        String rawString = MiniMessageHelper.serialize(component);
        String translatedText = LegacyComponentSerializer.legacySection().serialize(MiniMessageHelper.deserialize(rawString));
        this.paperSkinManager.setProfileName(player, translatedText);
        if (this.config().getBoolean("change_uuids")) {
            this.paperSkinManager.setUniqueId(player, translatedText);
        }
        this.paperSkinManager.refreshPlayer(player);
        player.playerListName(component);
        player.displayName(component);
        ((CompletableFuture)this.storageManager.getStorage().loadPlayer(player.getUniqueId()).thenAccept(nameTagPlayer -> {
            NickPlayer playerData = nameTagPlayer != null ? nameTagPlayer : new NickPlayer(player.getUniqueId());
            playerData.setNickname(rawString);
            this.playerCache.put(player.getUniqueId(), playerData);
            this.executeStorageOperation(this.storageManager.getStorage().savePlayer(playerData), "save nickname for " + player.getName(), () -> {
                if (this.getServer().getPluginManager().isPluginEnabled("TAB")) {
                    this.attemptToUpdateTabPlayer(player);
                }
            });
        })).whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.getLogger().severe("Failed to load player data for nickname update: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        });
    }

    public void attemptToUpdateTabPlayer(Player player) {
        try {
            Class<?> tabClass = Class.forName("me.neznamy.tab.api.TabAPI");
            Method getInstanceMethod = tabClass.getMethod("getInstance", new Class[0]);
            TabAPI tabApiInstance = (TabAPI)getInstanceMethod.invoke(null, new Object[0]);
            TabPlayer tabPlayer = tabApiInstance.getPlayer(player.getUniqueId());
            if (tabPlayer == null) {
                throw new Exception("fucking tab player cant be found");
            }
            this.updateTabPlayer(tabPlayer);
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    @Override
    public void setSkinFromPlayer(Player player, String playerName) {
        this.paperSkinManager.setSkinFromName(this, player, playerName);
        ((CompletableFuture)this.storageManager.getStorage().loadPlayer(player.getUniqueId()).thenAccept(nameTagPlayer -> {
            NickPlayer playerData = nameTagPlayer != null ? nameTagPlayer : new NickPlayer(player.getUniqueId());
            playerData.setSkinName(playerName);
            playerData.setTexture(null);
            playerData.setSignature(null);
            this.playerCache.put(player.getUniqueId(), playerData);
            this.executeStorageOperation(this.storageManager.getStorage().savePlayer(playerData), "save skin for " + player.getName(), () -> {
                if (this.getServer().getPluginManager().isPluginEnabled("TAB")) {
                    this.attemptToUpdateTabPlayer(player);
                }
            });
        })).whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.getLogger().severe("Failed to load player data for skin update: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        });
    }

    @Override
    public void setNickFromPlayer(Player player, String playerName) {
        String originalName = player.getName();
        this.paperSkinManager.setProfileName(player, playerName);
        this.paperSkinManager.setSkinFromName(this, player, playerName);
        this.storageManager.getStorage().loadPlayer(player.getUniqueId()).thenAccept(nameTagPlayer -> {
            NickPlayer playerData;
            NickPlayer nickPlayer = playerData = nameTagPlayer != null ? nameTagPlayer : new NickPlayer(player.getUniqueId());
            if (playerData.getOriginalName() == null || !playerData.hasNick()) {
                playerData.setOriginalName(originalName);
                try {
                    GameProfile profile = this.paperSkinManager.getProfile(player);
                    Method propertiesMethod = NameTagPlugin.isPaper1219OrNewer() ? GameProfile.class.getMethod("properties", new Class[0]) : GameProfile.class.getMethod("getProperties", new Class[0]);
                    PropertyMap propertyMap = (PropertyMap)propertiesMethod.invoke((Object)profile, new Object[0]);
                    Collection textures = propertyMap.get((Object)"textures");
                    if (textures != null && !textures.isEmpty()) {
                        Property skinProperty = (Property)textures.iterator().next();
                        playerData.setOriginalTexture(skinProperty.value());
                        playerData.setOriginalSignature(skinProperty.signature());
                        this.getLogger().info("Stored original skin for " + originalName);
                    }
                }
                catch (Exception e) {
                    this.getLogger().warning("Could not fetch original skin for " + originalName + ": " + e.getMessage());
                }
            }
            playerData.setNickname(playerName);
            playerData.setSkinName(playerName);
            playerData.setTexture(null);
            playerData.setSignature(null);
            this.playerCache.put(player.getUniqueId(), playerData);
            this.executeStorageOperation(this.storageManager.getStorage().savePlayer(playerData), "save nick from player for " + player.getName(), () -> {
                if (this.getServer().getPluginManager().isPluginEnabled("TAB")) {
                    this.attemptToUpdateTabPlayer(player);
                }
            });
        });
        Task.runAsync(this, () -> {
            if (this.config().getBoolean("change_uuids")) {
                try {
                    if (MojangProfile.getMojangProfile(playerName) == null) {
                        this.paperSkinManager.setUniqueId(player, UUID.randomUUID());
                    } else {
                        this.paperSkinManager.setUniqueId(player, playerName);
                    }
                }
                catch (Exception ignored) {
                    this.paperSkinManager.setUniqueId(player, playerName);
                }
            }
        });
    }

    @Override
    public boolean setSkinFromTextureAndSignature(Player player, String texture, String signature) {
        this.paperSkinManager.setSkin(player, texture, signature);
        this.paperSkinManager.refreshPlayer(player);
        ((CompletableFuture)this.storageManager.getStorage().loadPlayer(player.getUniqueId()).thenAccept(nameTagPlayer -> {
            NickPlayer playerData = nameTagPlayer != null ? nameTagPlayer : new NickPlayer(player.getUniqueId());
            playerData.setTexture(texture);
            playerData.setSignature(signature);
            playerData.setSkinName(null);
            this.playerCache.put(player.getUniqueId(), playerData);
            this.executeStorageOperation(this.storageManager.getStorage().savePlayer(playerData), "save mineskin for " + player.getName(), () -> {
                if (this.getServer().getPluginManager().isPluginEnabled("TAB")) {
                    this.attemptToUpdateTabPlayer(player);
                }
            });
        })).whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.getLogger().severe("Failed to load player data for mineskin update: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        });
        return true;
    }

    @Override
    public boolean setSkinFromMineskinId(Player player, String id) {
        @Nullable String[] textureAndSignature = NameTagPlugin.fetchTextureAndSignatureFromMineskinId(id);
        if (textureAndSignature == null) {
            return false;
        }
        return this.setSkinFromTextureAndSignature(player, textureAndSignature[0], textureAndSignature[1]);
    }

    @Override
    public boolean setSkinFromMineskinUrl(Player player, String url) {
        String skinId = url.replaceAll(".*/", "");
        return this.setSkinFromMineskinId(player, skinId);
    }

    @Override
    @Nullable
    public Skin getSkinFromMineskinId(String id) {
        @Nullable String[] textureAndSignature = NameTagPlugin.fetchTextureAndSignatureFromMineskinId(id);
        if (textureAndSignature == null) {
            return null;
        }
        return new Skin(textureAndSignature[0], textureAndSignature[1]);
    }

    @Override
    @Nullable
    public Skin getSkinFromMineskinUrl(String url) {
        String skinId = url.replaceAll(".*/", "");
        return this.getSkinFromMineskinId(skinId);
    }

    @Override
    public void resetNickname(Player player) {
        NickPlayer cached = this.playerCache.get(player.getUniqueId());
        if (cached == null) {
            this.storageManager.getStorage().loadPlayer(player.getUniqueId()).thenAccept(nameTagPlayer -> this.resetNicknameSync(player, (NickPlayer)nameTagPlayer));
        } else {
            this.resetNicknameSync(player, cached);
        }
    }

    private void resetNicknameSync(Player player, NickPlayer nickPlayer) {
        if (nickPlayer != null && nickPlayer.getOriginalName() != null) {
            this.paperSkinManager.setProfileName(player, nickPlayer.getOriginalName());
            if (nickPlayer.getOriginalTexture() != null && nickPlayer.getOriginalSignature() != null) {
                this.paperSkinManager.setSkin(player, nickPlayer.getOriginalTexture(), nickPlayer.getOriginalSignature());
            }
            this.paperSkinManager.refreshPlayer(player);
            nickPlayer.setNickname(null);
            nickPlayer.setNickedName(nickPlayer.getOriginalName());
            this.playerCache.put(player.getUniqueId(), nickPlayer);
            String originalName = nickPlayer.getOriginalName();
            player.playerListName(MiniMessageHelper.deserialize(originalName));
            player.displayName(MiniMessageHelper.deserialize(originalName));
            this.executeStorageOperation(this.storageManager.getStorage().savePlayer(nickPlayer), "reset nickname for " + player.getName(), () -> {
                if (this.getServer().getPluginManager().isPluginEnabled("TAB")) {
                    this.attemptToUpdateTabPlayer(player);
                }
            });
        }
    }

    @Override
    public void resetSkin(Player player) {
        NickPlayer cached = this.playerCache.get(player.getUniqueId());
        if (cached == null) {
            this.storageManager.getStorage().loadPlayer(player.getUniqueId()).thenAccept(nameTagPlayer -> this.resetSkinSync(player, (NickPlayer)nameTagPlayer));
        } else {
            this.resetSkinSync(player, cached);
        }
    }

    private void resetSkinSync(Player player, NickPlayer nickPlayer) {
        if (nickPlayer != null && nickPlayer.getOriginalTexture() != null) {
            this.paperSkinManager.setSkin(player, nickPlayer.getOriginalTexture(), nickPlayer.getOriginalSignature());
            this.paperSkinManager.refreshPlayer(player);
            nickPlayer.setTexture(null);
            nickPlayer.setSignature(null);
            nickPlayer.setSkinName(null);
            this.playerCache.put(player.getUniqueId(), nickPlayer);
            this.executeStorageOperation(this.storageManager.getStorage().savePlayer(nickPlayer), "reset skin for " + player.getName(), () -> {
                if (this.getServer().getPluginManager().isPluginEnabled("TAB")) {
                    this.attemptToUpdateTabPlayer(player);
                }
            });
        }
    }

    @Override
    public void resetNick(Player player) {
        NickPlayer cached = this.playerCache.get(player.getUniqueId());
        if (cached == null) {
            this.storageManager.getStorage().loadPlayer(player.getUniqueId()).thenAccept(nameTagPlayer -> Task.run(this, () -> this.resetNickSync(player, (NickPlayer)nameTagPlayer)));
        } else {
            Task.run(this, () -> this.resetNickSync(player, cached));
        }
    }

    private void resetNickSync(Player player, NickPlayer nickPlayer) {
        if (nickPlayer != null && nickPlayer.getOriginalName() != null) {
            String originalName = nickPlayer.getOriginalName();
            String originalTexture = nickPlayer.getOriginalTexture();
            String originalSignature = nickPlayer.getOriginalSignature();
            this.getLogger().info("Resetting nick for " + player.getName() + " back to " + originalName);
            this.paperSkinManager.setProfileName(player, originalName);
            if (originalTexture != null) {
                this.getLogger().info("Restoring original skin...");
                this.paperSkinManager.setSkin(player, originalTexture, originalSignature);
            } else {
                this.getLogger().warning("No original texture to restore for " + originalName);
            }
            this.paperSkinManager.refreshPlayer(player);
            player.playerListName(MiniMessageHelper.deserialize(originalName));
            player.displayName(MiniMessageHelper.deserialize(originalName));
            nickPlayer.setNickname(null);
            nickPlayer.setSkinName(null);
            nickPlayer.setTexture(null);
            nickPlayer.setSignature(null);
            nickPlayer.setNickedName(null);
            this.playerCache.put(player.getUniqueId(), nickPlayer);
            this.executeStorageOperation(this.storageManager.getStorage().savePlayer(nickPlayer), "reset nick for " + originalName, () -> {
                if (this.getServer().getPluginManager().isPluginEnabled("TAB")) {
                    this.attemptToUpdateTabPlayer(player);
                }
            });
        }
    }
}

