/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.nametag.nms;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import gg.lode.bookshelfapi.api.Task;
import gg.lode.bookshelfapi.api.util.MiniMessageHelper;
import gg.lode.nametag.NameTagPlugin;
import gg.lode.nametag.util.MojangSkinFetcher;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PaperSkinManager {
    private static final String TEXTURES_PROPERTY = "textures";

    public GameProfile getProfile(Player player) {
        try {
            Method getProfileMethod = player.getClass().getMethod("getProfile", new Class[0]);
            return (GameProfile)getProfileMethod.invoke((Object)player, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to fetch profile for " + player.getName(), e);
        }
    }

    public void setSkin(Player player, String texture, String signature) {
        NameTagPlugin plugin = NameTagPlugin.instance();
        try {
            if (NameTagPlugin.isPaper12004OrNewer()) {
                PlayerProfile playerProfile = player.getPlayerProfile();
                playerProfile.setProperty(new ProfileProperty(TEXTURES_PROPERTY, texture, signature));
                player.setPlayerProfile(playerProfile);
            } else {
                GameProfile profile = this.getProfile(player);
                Method propertiesMethod = NameTagPlugin.isPaper1219OrNewer() ? GameProfile.class.getMethod("properties", new Class[0]) : GameProfile.class.getMethod("getProperties", new Class[0]);
                PropertyMap propertyMap = (PropertyMap)propertiesMethod.invoke((Object)profile, new Object[0]);
                propertyMap.removeAll((Object)TEXTURES_PROPERTY);
                Property skinProperty = signature != null ? new Property(TEXTURES_PROPERTY, texture, signature) : new Property(TEXTURES_PROPERTY, texture);
                propertyMap.put((Object)TEXTURES_PROPERTY, (Object)skinProperty);
                plugin.getLogger().info("Set skin for " + player.getName() + " - texture length: " + texture.length());
            }
        }
        catch (Exception e) {
            plugin.getLogger().severe("Failed to set skin for " + player.getName() + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void setProfileName(Player player, String name) {
        if (name.length() > 16) {
            name = name.substring(0, 16);
        }
        try {
            if (NameTagPlugin.isPaper12004OrNewer()) {
                PlayerProfile playerProfile = player.getPlayerProfile();
                playerProfile.setName(name);
                player.setPlayerProfile(playerProfile);
            } else {
                GameProfile profile = this.getProfile(player);
                Field uuidField = GameProfile.class.getDeclaredField("name");
                uuidField.setAccessible(true);
                uuidField.set(profile, name);
            }
            player.playerListName(MiniMessageHelper.deserialize(name));
            player.displayName(MiniMessageHelper.deserialize(name));
            this.forcePlayerUpdate(player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUniqueId(Player player, String name) {
        NameTagPlugin plugin = NameTagPlugin.instance();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try {
                UUID uuid = MojangSkinFetcher.fetchUUID(name);
                if (uuid != null) {
                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                        this.setUniqueId(player, uuid);
                        plugin.getLogger().info("Set UUID for " + player.getName() + " to " + String.valueOf(uuid));
                    });
                } else {
                    Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
                        UUID randomUuid = UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes());
                        this.setUniqueId(player, randomUuid);
                        plugin.getLogger().info("Set random UUID for " + player.getName() + " to " + String.valueOf(randomUuid));
                    });
                }
            }
            catch (Exception e) {
                plugin.getLogger().severe("Failed to fetch UUID for " + name + ": " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    public void setUniqueId(Player player, UUID uuid) {
        NameTagPlugin plugin = NameTagPlugin.instance();
        try {
            if (NameTagPlugin.isPaper12004OrNewer()) {
                PlayerProfile playerProfile = player.getPlayerProfile();
                playerProfile.setId(uuid);
                player.setPlayerProfile(playerProfile);
            } else {
                GameProfile profile = this.getProfile(player);
                Field uuidField = GameProfile.class.getDeclaredField("id");
                uuidField.setAccessible(true);
                uuidField.set(profile, uuid);
            }
            this.forcePlayerUpdate(player);
            plugin.getLogger().warning("Successfully changed " + player.getName() + "'s unique id.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void forcePlayerUpdate(Player player) {
        NameTagPlugin plugin = NameTagPlugin.instance();
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
            for (Player online : Bukkit.getOnlinePlayers()) {
                try {
                    online.hidePlayer((Plugin)plugin, player);
                    Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
                        try {
                            online.showPlayer((Plugin)plugin, player);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }, 1L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setSkinFromName(JavaPlugin plugin, Player player, String playerName) {
        if (!plugin.isEnabled()) {
            plugin.getLogger().severe("Cannot fetch skin - plugin is disabled!");
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            try {
                plugin.getLogger().info("Fetching skin for player: " + playerName);
                String[] skinData = MojangSkinFetcher.fetchSkinDataFromUsername(playerName);
                if (skinData != null && skinData.length >= 1) {
                    String textureValue = skinData[0];
                    String signature = skinData.length > 1 ? skinData[1] : null;
                    plugin.getLogger().info("Successfully fetched skin for " + playerName);
                    Task.later(plugin, () -> {
                        this.setSkin(player, textureValue, signature);
                        this.refreshPlayer(player);
                    }, 1L);
                } else {
                    plugin.getLogger().warning("Failed to fetch skin for " + playerName + " - player may not exist or have an API error");
                    plugin.getLogger().warning("skinData is " + (String)(skinData == null ? "null" : "not null but length is " + skinData.length));
                }
            }
            catch (Exception e) {
                plugin.getLogger().severe("Error fetching skin for " + playerName + ": " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    public void refreshPlayer(Player player) {
        NameTagPlugin plugin = NameTagPlugin.instance();
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
            for (Player online : Bukkit.getOnlinePlayers()) {
                try {
                    online.hidePlayer((Plugin)plugin, player);
                    Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
                        try {
                            online.showPlayer((Plugin)plugin, player);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }, 1L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

