/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.nametag.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class MojangSkinFetcher {
    public static UUID fetchUUID(String username) {
        try {
            String apiEndpoint = "https://api.mojang.com/users/profiles/minecraft/" + username;
            URL url = new URL(apiEndpoint);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                String jsonResponse = response.toString();
                if (jsonResponse.isEmpty()) {
                    return null;
                }
                JSONParser parser = new JSONParser();
                JSONObject object = (JSONObject)parser.parse(jsonResponse);
                Object uuidString = (String)object.get((Object)"id");
                if (uuidString != null && !((String)uuidString).contains("-")) {
                    uuidString = ((String)uuidString).substring(0, 8) + "-" + ((String)uuidString).substring(8, 12) + "-" + ((String)uuidString).substring(12, 16) + "-" + ((String)uuidString).substring(16, 20) + "-" + ((String)uuidString).substring(20);
                }
                return UUID.fromString((String)uuidString);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] fetchSkinData(UUID uuid) {
        try {
            String apiEndpoint = "https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replace("-", "") + "?unsigned=false";
            URL url = new URL(apiEndpoint);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                reader.close();
                String jsonResponse = response.toString();
                JSONParser parser = new JSONParser();
                JSONObject profile = (JSONObject)parser.parse(jsonResponse);
                JSONArray properties = (JSONArray)profile.get((Object)"properties");
                for (Object prop : properties) {
                    JSONObject property = (JSONObject)prop;
                    String name = (String)property.get((Object)"name");
                    if (!"textures".equals(name)) continue;
                    String value = (String)property.get((Object)"value");
                    String signature = (String)property.get((Object)"signature");
                    if (value != null && value.startsWith("\"") && value.endsWith("\"")) {
                        value = value.substring(1, value.length() - 1);
                    }
                    if (signature != null && signature.startsWith("\"") && signature.endsWith("\"")) {
                        signature = signature.substring(1, signature.length() - 1);
                    }
                    return new String[]{value, signature};
                }
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String[] fetchSkinDataFromUsername(String username) {
        UUID uuid = MojangSkinFetcher.fetchUUID(username);
        if (uuid == null) {
            return null;
        }
        return MojangSkinFetcher.fetchSkinData(uuid);
    }
}

