/*
 * Decompiled with CFR 0.152.
 */
package gg.lode.nametag.command;

import dev.jorel.commandapi.nametag.CommandAPICommand;
import dev.jorel.commandapi.nametag.SuggestionInfo;
import dev.jorel.commandapi.nametag.exceptions.WrapperCommandSyntaxException;
import dev.jorel.commandapi.nametag.executors.CommandArguments;
import gg.lode.bookshelfapi.api.Task;
import gg.lode.bookshelfapi.api.util.MiniMessageHelper;
import gg.lode.bookshelfcmd.argument.FlagArgument;
import gg.lode.nametag.NameTagPlugin;
import gg.lode.nametag.util.MojangSkinFetcher;
import gg.lode.nametagapi.api.NickPlayer;
import gg.lode.nametagapi.api.Skin;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerAdvancementDoneEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Nullable;

public class NickCommand
extends CommandAPICommand
implements Listener {
    private final NameTagPlugin plugin;

    /*
     * Exception decompiling
     */
    public NickCommand(NameTagPlugin plugin) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.applyExpressionRewriter(NewAnonymousArray.java:112)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void on(PlayerDeathEvent event) {
        Player player = event.getPlayer();
        @Nullable String nickName = this.plugin.getNick(player);
        if (nickName == null) {
            return;
        }
        event.deathMessage(event.deathMessage() == null ? null : Objects.requireNonNull(event.deathMessage()).replaceText(builder -> builder.match(player.getName()).replacement(nickName)));
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void on(PlayerAdvancementDoneEvent event) {
        Player player = event.getPlayer();
        @Nullable String nickName = this.plugin.getNick(player);
        if (nickName == null) {
            return;
        }
        event.message(event.message() == null ? null : Objects.requireNonNull(event.message()).replaceText(builder -> builder.match(player.getName()).replacement(nickName)));
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void on(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Component originalJoinMessage = event.joinMessage();
        event.joinMessage(null);
        this.plugin.getStorageManager().getStorage().loadPlayer(player.getUniqueId()).whenComplete((nameTagPlayer, throwable) -> {
            if (throwable != null) {
                this.plugin.getLogger().severe("Failed to load player data for " + player.getName() + ": " + throwable.getMessage());
                throwable.printStackTrace();
                return;
            }
            if (nameTagPlayer != null) {
                this.plugin.getPlayerCache().put(player.getUniqueId(), (NickPlayer)nameTagPlayer);
                String name = nameTagPlayer.getNickname();
                Skin skin = nameTagPlayer.getSkin();
                String skinName = nameTagPlayer.getSkinName();
                if (name != null) {
                    Task.run(this.plugin, () -> this.plugin.setNickFromPlayer(player, name));
                    if (originalJoinMessage != null) {
                        this.handleJoinMessageWithNick(Objects.requireNonNullElse(nameTagPlayer.getOriginalName(), name), originalJoinMessage, name);
                    }
                } else if (originalJoinMessage != null) {
                    Task.run(this.plugin, () -> this.handleJoinMessageWithNick(player.getName(), originalJoinMessage, player.getName()));
                }
                if (skinName != null) {
                    this.plugin.setSkinFromPlayer(player, skinName);
                }
                if (skin != null) {
                    this.plugin.setSkinFromTextureAndSignature(player, skin.texture(), skin.signature());
                }
                if (this.plugin.getServer().getPluginManager().isPluginEnabled("TAB")) {
                    this.plugin.attemptToUpdateTabPlayer(player);
                }
            } else if (originalJoinMessage != null) {
                Task.run(this.plugin, () -> this.handleJoinMessageWithNick(player.getName(), originalJoinMessage, player.getName()));
            }
        });
    }

    private void handleJoinMessageWithNick(@RegExp String originalName, Component originalJoinMessage, String nickName) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                Object joinMsg = MiniMessageHelper.serialize(originalJoinMessage);
                if (((String)joinMsg).contains("(formerly known as")) {
                    Pattern pattern = Pattern.compile("^(.+)\\s+\\(formerly known as (.+)\\)\\s+(.+)$");
                    Matcher matcher = pattern.matcher((CharSequence)joinMsg);
                    if (matcher.find()) {
                        String restOfMessage = matcher.group(3).trim();
                        joinMsg = nickName + " " + restOfMessage;
                        this.plugin.getServer().broadcast(MiniMessageHelper.deserialize((String)joinMsg).color(originalJoinMessage.color()));
                    } else {
                        Component modifiedMessage = originalJoinMessage.replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(originalName).replacement(nickName).build());
                        this.plugin.getServer().broadcast(modifiedMessage);
                    }
                } else {
                    Component modifiedMessage = originalJoinMessage.replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(originalName).replacement(nickName).build());
                    this.plugin.getServer().broadcast(modifiedMessage);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to handle join message with nick: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void on(PlayerQuitEvent event) {
        NickPlayer playerData;
        Player player = event.getPlayer();
        @Nullable String name = this.plugin.getNick(player);
        if (name != null) {
            this.plugin.getPaperSkinManager().setProfileName(player, name);
            if (this.plugin.shouldChangeUniqueId()) {
                this.plugin.getPaperSkinManager().setUniqueId(player, name);
            }
            this.plugin.getPaperSkinManager().refreshPlayer(player);
            Component quitMessage = event.quitMessage();
            if (quitMessage != null) {
                event.quitMessage(quitMessage.replaceText((TextReplacementConfig)TextReplacementConfig.builder().match(player.getName()).replacement(name).build()));
            }
        }
        if ((playerData = this.plugin.getPlayerCache().get(player.getUniqueId())) != null) {
            this.plugin.getStorageManager().getStorage().savePlayer(playerData).whenComplete((result, throwable) -> {
                if (throwable != null) {
                    this.plugin.getLogger().warning("Failed to save data for " + player.getName() + " on quit: " + throwable.getMessage());
                } else {
                    this.plugin.getLogger().info("Saved data for " + player.getName() + " on quit");
                }
            });
        }
    }

    private static /* synthetic */ void lambda$new$11(NameTagPlugin plugin, CommandSender sender, CommandArguments args) throws WrapperCommandSyntaxException {
        List targets = (List)args.get("targets");
        if (targets == null || targets.isEmpty()) {
            sender.sendMessage(MiniMessageHelper.deserialize("<red>Invalid arguments. /nick [<targets>] <reset|as|with_name|with_skin|from_url> <name>"));
            return;
        }
        Iterator patt0$temp = args.get(1);
        if (patt0$temp instanceof String) {
            Object patt1$temp;
            String action = (String)((Object)patt0$temp);
            if (action.equalsIgnoreCase("reset")) {
                for (Player target : targets) {
                    if (!sender.hasPermission("lodestone.nametag.commands.nick.others") && target != sender) {
                        sender.sendMessage(MiniMessageHelper.deserialize("<red>You do not have permission to nick other players."));
                        return;
                    }
                    if (!plugin.hasNick(target)) {
                        if (targets.size() != 1) continue;
                        sender.sendMessage(MiniMessageHelper.deserialize(String.format("<red>%s isn't currently nicked", MiniMessageHelper.serialize((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(target.getName())))));
                        return;
                    }
                    plugin.resetNick(target);
                    sender.sendMessage(MiniMessageHelper.deserialize("Successfully reset " + MiniMessageHelper.serialize((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(target.getName())) + "'s nick"));
                    return;
                }
            }
            if ((patt1$temp = args.get(2)) instanceof String) {
                String text = (String)patt1$temp;
                for (Player target : targets) {
                    if (!sender.hasPermission("lodestone.nametag.commands.nick.others") && target != sender) {
                        sender.sendMessage(MiniMessageHelper.deserialize("<red>You do not have permission to nick other players."));
                        return;
                    }
                    String originalName = MiniMessageHelper.serialize((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(target.getName()));
                    switch (action.toLowerCase()) {
                        case "as": {
                            boolean force = FlagArgument.hasFlags(text, "f");
                            if (text.split(" ").length > 1 && !FlagArgument.hasFlags(text, "f")) {
                                sender.sendMessage(MiniMessageHelper.deserialize("<red>Your nick cannot contain spaces"));
                                return;
                            }
                            String rawText = FlagArgument.sanitizeInput(text, Set.of(Character.valueOf('f')));
                            String sanitizedText = LegacyComponentSerializer.legacySection().serialize(MiniMessageHelper.deserialize(rawText));
                            Task.runAsync(plugin, () -> {
                                if (!plugin.config().getBoolean("can_use_existing_players") && !force && MojangSkinFetcher.fetchUUID(sanitizedText) != null) {
                                    sender.sendMessage(MiniMessageHelper.deserialize("<red>You cannot nick as an existing Minecraft player!"));
                                    return;
                                }
                                if (plugin.hasNick(target)) {
                                    plugin.resetNick(target);
                                }
                                Task.run(plugin, () -> plugin.setNickFromPlayer(target, sanitizedText));
                                sender.sendMessage(MiniMessageHelper.deserialize("Successfully nicked " + originalName + " as " + sanitizedText));
                            });
                            break;
                        }
                        case "with_name": {
                            boolean force = FlagArgument.hasFlags(text, "f");
                            String rawText = FlagArgument.sanitizeInput(text, Set.of(Character.valueOf('f')));
                            String sanitizedText = LegacyComponentSerializer.legacySection().serialize(MiniMessageHelper.deserialize(rawText));
                            if (rawText.split(" ").length > 1 && !force) {
                                sender.sendMessage(MiniMessageHelper.deserialize("<red>Your nick name cannot contain spaces"));
                                return;
                            }
                            if (!plugin.config().getBoolean("can_use_existing_players") && !force && MojangSkinFetcher.fetchUUID(sanitizedText) != null) {
                                sender.sendMessage(MiniMessageHelper.deserialize("<red>You cannot nick as an existing Minecraft player!"));
                                return;
                            }
                            plugin.setNickname(target, rawText);
                            sender.sendMessage(MiniMessageHelper.deserialize("Successfully set " + originalName + "'s name to " + sanitizedText));
                            break;
                        }
                        case "with_skin": {
                            if (text.split(" ").length > 1) {
                                sender.sendMessage(MiniMessageHelper.deserialize("<red>Your nick skin cannot contain spaces"));
                                return;
                            }
                            plugin.setSkinFromPlayer(target, text);
                            sender.sendMessage(MiniMessageHelper.deserialize("Successfully set " + originalName + "'s skin to " + text));
                            break;
                        }
                        case "from_url": {
                            if (text.matches("https://(?:minesk\\.in|www\\.mineskin\\.org/skins)/[a-f0-9]{32}")) {
                                if (plugin.setSkinFromMineskinUrl(target, text)) {
                                    sender.sendMessage(MiniMessageHelper.deserialize("Successfully set " + originalName + "'s skin to the skin from the URL"));
                                    break;
                                }
                                sender.sendMessage(MiniMessageHelper.deserialize("<red>Failed to fetch skin from the Mineskin URL"));
                                return;
                            }
                            if (plugin.setSkinFromMineskinId(target, text)) {
                                sender.sendMessage(MiniMessageHelper.deserialize("Successfully set " + originalName + "'s skin to the skin from the URL"));
                                break;
                            }
                            sender.sendMessage(MiniMessageHelper.deserialize("<red>Failed to fetch skin. Please supply a valid Mineskin ID or URL."));
                            return;
                        }
                    }
                }
            } else {
                sender.sendMessage(MiniMessageHelper.deserialize("<red>Invalid arguments. /nick <sender> <reset|as|with_name|with_skin|from_url> <name>"));
            }
        }
    }

    private static /* synthetic */ String[] lambda$new$8(NameTagPlugin plugin, SuggestionInfo s) {
        return (String[])plugin.getServer().getOnlinePlayers().stream().map(Player::getName).toArray(String[]::new);
    }
}

