/*
 * Decompiled with CFR 0.152.
 */
package org.gacstudio.locationcopy.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import org.gacstudio.locationcopy.client.ui.SettingsGUI;
import org.lwjgl.glfw.GLFW;

public class LocationcopyClient
implements ClientModInitializer {
    private static class_304 copyLocationsKey;
    private static class_304 openSettingsKey;
    public static int copyMode;
    public static boolean showLocationInChat;
    public static String customLocationFormat;
    public static String simplyFormat;
    public static String defaultFormat;
    public static int defaultCopyMode;
    static String configFilePath;
    private static final class_304.class_11900 LOCATION_COPY_CATEGORY;

    public void onInitializeClient() {
        LocationcopyClient.loadConfig();
        copyLocationsKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.locationCopy.copyLocation", class_3675.class_307.field_1668, 66, LOCATION_COPY_CATEGORY));
        openSettingsKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.locationCopy.openSettings", class_3675.class_307.field_1668, 73, LOCATION_COPY_CATEGORY));
        ClientTickEvents.END_CLIENT_TICK.register(client -> LocationcopyClient.handleKeybindings());
    }

    public static void handleKeybindings() {
        while (copyLocationsKey.method_1436()) {
            LocationcopyClient.copyLocations();
        }
        while (openSettingsKey.method_1436()) {
            if (class_310.method_1551().field_1755 != null) continue;
            SettingsGUI settingsGUI = new SettingsGUI(null);
            class_310.method_1551().method_1507((class_437)settingsGUI);
        }
    }

    public static void loadConfig() {
        block12: {
            File configFile = new File(class_310.method_1551().field_1697, configFilePath);
            try {
                if (!configFile.exists()) {
                    configFile.getParentFile().mkdirs();
                    Properties defaultProperties = new Properties();
                    defaultProperties.setProperty("settings.copyMode", String.valueOf(copyMode));
                    defaultProperties.setProperty("settings.showLocationInChat", String.valueOf(showLocationInChat));
                    defaultProperties.setProperty("settings.locationFormat", customLocationFormat);
                    FileOutputStream fileOutputStream = new FileOutputStream(configFile);
                    try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
                        defaultProperties.store(writer, "GacStudio LocationCopy Mod Configuration");
                    }
                    fileOutputStream.close();
                    break block12;
                }
                Properties properties = new Properties();
                FileInputStream fileInputStream = new FileInputStream(configFile);
                properties.load(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));
                fileInputStream.close();
                copyMode = Integer.parseInt(properties.getProperty("settings.copyMode", String.valueOf(copyMode)));
                showLocationInChat = Boolean.parseBoolean(properties.getProperty("settings.showLocationInChat", String.valueOf(showLocationInChat)));
                customLocationFormat = properties.getProperty("settings.locationFormat", customLocationFormat);
                if (copyMode != 0 && copyMode != 1 && copyMode != 2) {
                    copyMode = defaultCopyMode;
                }
                if (copyMode == 0 && !simplyFormat.equals(customLocationFormat)) {
                    customLocationFormat = simplyFormat;
                }
                if (copyMode == 1 && !defaultFormat.equals(customLocationFormat) || customLocationFormat == null || customLocationFormat.isEmpty()) {
                    customLocationFormat = defaultFormat;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveConfig() {
        if (copyMode != 0 && copyMode != 1 && copyMode != 2) {
            copyMode = defaultCopyMode;
        }
        if (copyMode == 0 && !simplyFormat.equals(customLocationFormat)) {
            customLocationFormat = simplyFormat;
        }
        if (copyMode == 1 && !defaultFormat.equals(customLocationFormat) || customLocationFormat == null || customLocationFormat.isEmpty()) {
            customLocationFormat = defaultFormat;
        }
        File configFile = new File(class_310.method_1551().field_1697, configFilePath);
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(configFile);
            properties.load(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));
            fileInputStream.close();
            properties.setProperty("settings.copyMode", String.valueOf(copyMode));
            properties.setProperty("settings.showLocationInChat", String.valueOf(showLocationInChat));
            properties.setProperty("settings.locationFormat", customLocationFormat);
            FileOutputStream fileOutputStream = new FileOutputStream(configFile);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, StandardCharsets.UTF_8);){
                properties.store(writer, "GacStudio LocationCopy Mod Configuration");
            }
            fileOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void copyLocations() {
        class_310 client = class_310.method_1551();
        if (client.field_1687 != null && client.field_1724 != null) {
            String worldName;
            class_638 world = client.field_1687;
            double x = client.field_1724.method_23317();
            double y = client.field_1724.method_23318();
            double z = client.field_1724.method_23321();
            worldName = switch (worldName = world.method_27983().method_29177().toString()) {
                case "minecraft:overworld" -> "Overworld";
                case "minecraft:the_nether" -> "The Nether";
                case "minecraft:the_end" -> "The End";
                default -> worldName;
            };
            String locations = "";
            switch (copyMode) {
                case 0: {
                    locations = String.format("%.2f %.2f %.2f", x, y, z);
                    break;
                }
                case 1: {
                    locations = String.format("X: %.2f, Y: %.2f, Z: %.2f, World: %s", x, y, z, worldName);
                    break;
                }
                case 2: {
                    locations = LocationcopyClient.formatLocations(customLocationFormat, x, y, z, worldName);
                    break;
                }
                default: {
                    locations = String.format("X: %.2f, Y: %.2f, Z: %.2f, World: %s", x, y, z, worldName);
                }
            }
            LocationcopyClient.copyToClipboard(locations);
            class_5250 translatedMessage = class_2561.method_43471((String)"message.CopySuccess");
            client.field_1724.method_7353((class_2561)translatedMessage, false);
            if (showLocationInChat) {
                client.field_1724.method_7353(class_2561.method_30163((String)locations), false);
            }
        }
    }

    private static String formatLocations(String format, double x, double y, double z, String worldName) {
        Pattern pattern = Pattern.compile("([xyz])(%.\\df)|worldName");
        Matcher matcher = pattern.matcher(format);
        StringBuilder formatted = new StringBuilder();
        while (matcher.find()) {
            String replacement;
            String placeholder = matcher.group(1);
            String formatSpecifier = matcher.group(2);
            if (placeholder != null && formatSpecifier != null) {
                replacement = switch (placeholder) {
                    case "x" -> String.format(formatSpecifier, x);
                    case "y" -> String.format(formatSpecifier, y);
                    case "z" -> String.format(formatSpecifier, z);
                    default -> "";
                };
            } else {
                replacement = "worldName".equals(matcher.group(0)) ? worldName : "";
            }
            matcher.appendReplacement(formatted, replacement);
        }
        matcher.appendTail(formatted);
        return formatted.toString();
    }

    private static void copyToClipboard(String text) {
        GLFW.glfwSetClipboardString((long)class_310.method_1551().method_22683().method_4490(), (CharSequence)text);
    }

    static {
        copyMode = 1;
        showLocationInChat = true;
        customLocationFormat = "X: x%.2f, Y: y%.2f, Z: z%.2f, World: worldName";
        simplyFormat = "x%.2f y%.2f z%.2f";
        defaultFormat = "X: x%.2f, Y: y%.2f, Z: z%.2f, World: worldName";
        defaultCopyMode = 1;
        configFilePath = "config/LocationCopy.properties";
        LOCATION_COPY_CATEGORY = class_304.class_11900.method_74698((class_2960)class_2960.method_60654((String)"locationcopy"));
    }
}

