/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.powertools.entity;

import javax.annotation.Nullable;
import net.mcreator.powertools.init.PowerToolsModEntities;
import net.mcreator.powertools.procedures.SonicBoomProjectileHitsLivingEntityProcedure;
import net.mcreator.powertools.procedures.SonicBoomWhileProjectileFlyingTickProcedure;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class SonicBoomEntity
extends AbstractArrow
implements ItemSupplier {
    public static final ItemStack PROJECTILE_ITEM = new ItemStack((ItemLike)Blocks.AIR);
    private int knockback = 0;

    public SonicBoomEntity(EntityType<? extends SonicBoomEntity> type, Level world) {
        super(type, world);
        this.setNoGravity(true);
    }

    public SonicBoomEntity(EntityType<? extends SonicBoomEntity> type, double x, double y, double z, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, x, y, z, world, PROJECTILE_ITEM, firedFromWeapon);
        this.setNoGravity(true);
        if (firedFromWeapon != null) {
            this.setKnockback(EnchantmentHelper.getItemEnchantmentLevel((Holder)world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), (ItemStack)firedFromWeapon));
        }
    }

    public SonicBoomEntity(EntityType<? extends SonicBoomEntity> type, LivingEntity entity, Level world, @Nullable ItemStack firedFromWeapon) {
        super(type, entity, world, PROJECTILE_ITEM, firedFromWeapon);
        this.setNoGravity(true);
        if (firedFromWeapon != null) {
            this.setKnockback(EnchantmentHelper.getItemEnchantmentLevel((Holder)world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.KNOCKBACK), (ItemStack)firedFromWeapon));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getItem() {
        return PROJECTILE_ITEM;
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Blocks.AIR);
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        super.doPostHurtEffects(entity);
        entity.setArrowCount(entity.getArrowCount() - 1);
    }

    public void setKnockback(int knockback) {
        this.knockback = knockback;
    }

    protected void doKnockback(LivingEntity livingEntity, DamageSource damageSource) {
        if ((double)this.knockback > 0.0) {
            double d1 = Math.max(0.0, 1.0 - livingEntity.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE));
            Vec3 vec3 = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)this.knockback * 0.6 * d1);
            if (vec3.lengthSqr() > 0.0) {
                livingEntity.push(vec3.x, 0.1, vec3.z);
            }
        } else {
            super.doKnockback(livingEntity, damageSource);
        }
    }

    public void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        SonicBoomProjectileHitsLivingEntityProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), entityHitResult.getEntity());
    }

    public void tick() {
        super.tick();
        SonicBoomWhileProjectileFlyingTickProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
        if (this.inGround) {
            this.discard();
        }
    }

    public static SonicBoomEntity shoot(Level world, LivingEntity entity, RandomSource source) {
        return SonicBoomEntity.shoot(world, entity, source, 4.0f, 3.0, 10);
    }

    public static SonicBoomEntity shoot(Level world, LivingEntity entity, RandomSource source, float pullingPower) {
        return SonicBoomEntity.shoot(world, entity, source, pullingPower * 4.0f, 3.0, 10);
    }

    public static SonicBoomEntity shoot(Level world, LivingEntity entity, RandomSource random, float power, double damage, int knockback) {
        SonicBoomEntity entityarrow = new SonicBoomEntity((EntityType<? extends SonicBoomEntity>)((EntityType)PowerToolsModEntities.SONIC_BOOM.get()), entity, world, null);
        entityarrow.shoot(entity.getViewVector((float)1.0f).x, entity.getViewVector((float)1.0f).y, entity.getViewVector((float)1.0f).z, power * 2.0f, 0.0f);
        entityarrow.setSilent(true);
        entityarrow.setCritArrow(true);
        entityarrow.setBaseDamage(damage);
        entityarrow.setKnockback(knockback);
        world.addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }

    public static SonicBoomEntity shoot(LivingEntity entity, LivingEntity target) {
        SonicBoomEntity entityarrow = new SonicBoomEntity((EntityType<? extends SonicBoomEntity>)((EntityType)PowerToolsModEntities.SONIC_BOOM.get()), entity, entity.level(), null);
        double dx = target.getX() - entity.getX();
        double dy = target.getY() + (double)target.getEyeHeight() - 1.1;
        double dz = target.getZ() - entity.getZ();
        entityarrow.shoot(dx, dy - entityarrow.getY() + Math.hypot(dx, dz) * (double)0.2f, dz, 8.0f, 12.0f);
        entityarrow.setSilent(true);
        entityarrow.setBaseDamage(3.0);
        entityarrow.setKnockback(10);
        entityarrow.setCritArrow(true);
        entity.level().addFreshEntity((Entity)entityarrow);
        return entityarrow;
    }
}

