/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.mutils;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.ultimatchamp.mutils.config.ModpackUtilsConfig;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import net.minecraft.client.Minecraft;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModpackUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"mutils");
    private static final HttpClient client = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();

    public static String getLatestVersion() {
        try {
            String response = ModpackUtils.sendGetRequest(ModpackUtils.getURLForPlatform());
            return switch (ModpackUtilsConfig.instance().platform) {
                default -> throw new MatchException(null, null);
                case ModpackUtilsConfig.Platforms.MODRINTH -> ModpackUtils.parseModrinthResponse(response);
                case ModpackUtilsConfig.Platforms.CURSEFORGE -> ModpackUtils.parseCurseForgeResponse(response);
                case ModpackUtilsConfig.Platforms.CUSTOM -> ModpackUtils.parseOtherPlatformResponse(response);
            };
        }
        catch (Exception e) {
            LOGGER.error("[ModpackUtils] Failed to fetch the modpack info!", (Throwable)e);
            return null;
        }
    }

    private static String getURLForPlatform() {
        return switch (ModpackUtilsConfig.instance().platform) {
            default -> throw new MatchException(null, null);
            case ModpackUtilsConfig.Platforms.MODRINTH -> "https://api.modrinth.com/v2/project/" + ModpackUtilsConfig.instance().modpackId + "/version";
            case ModpackUtilsConfig.Platforms.CURSEFORGE -> "https://api.curseforge.com/v1/mods/" + ModpackUtilsConfig.instance().modpackId + "/files";
            case ModpackUtilsConfig.Platforms.CUSTOM -> ModpackUtilsConfig.instance().versionAPI;
        };
    }

    private static String sendGetRequest(String url) throws IOException, InterruptedException {
        HttpRequest request;
        HttpResponse<String> response;
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(10L));
        if (ModpackUtilsConfig.instance().platform == ModpackUtilsConfig.Platforms.CURSEFORGE) {
            requestBuilder.header("x-api-key", ModpackUtils.getCurseForgeApiKey());
        }
        if ((response = client.send(request = requestBuilder.build(), HttpResponse.BodyHandlers.ofString())).statusCode() == 200) {
            return response.body();
        }
        throw new IOException("[ModpackUtils] Failed to fetch the modpack info: " + response.statusCode());
    }

    private static String parseModrinthResponse(String response) {
        JsonArray jsonArray = JsonParser.parseString((String)response).getAsJsonArray();
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject jsonObject = jsonArray.get(i).getAsJsonObject();
            if (!ModpackUtilsConfig.instance().versionType.contains(jsonObject.get("version_type").getAsString()) || !ModpackUtilsConfig.instance().loader.equals(jsonObject.get("loaders").getAsJsonArray().get(0).getAsString())) continue;
            boolean hasNameFilter = true;
            if (!ModpackUtilsConfig.instance().nameFilters.isEmpty()) {
                for (String filter : ModpackUtilsConfig.instance().nameFilters) {
                    if (jsonObject.get("name").getAsString().contains(filter)) continue;
                    hasNameFilter = false;
                }
            }
            boolean hasVersionFilter = true;
            if (!ModpackUtilsConfig.instance().versionFilters.isEmpty()) {
                for (String filter : ModpackUtilsConfig.instance().versionFilters) {
                    if (jsonObject.get("version_number").getAsString().contains(filter)) continue;
                    hasVersionFilter = false;
                }
            }
            if (!hasNameFilter || !hasVersionFilter) continue;
            if (ModpackUtilsConfig.instance().checkMcVersion.booleanValue()) {
                if (!Minecraft.getInstance().getLaunchedVersion().equals(jsonObject.get("game_versions").getAsJsonArray().get(0).getAsString())) continue;
                return jsonObject.get("version_number").getAsString();
            }
            return jsonObject.get("version_number").getAsString();
        }
        return null;
    }

    private static String getCurseForgeApiKey() {
        return "";
    }

    private static String parseCurseForgeResponse(String response) {
        JsonObject jsonObject = JsonParser.parseString((String)response).getAsJsonObject();
        JsonArray dataArray = jsonObject.getAsJsonArray("data");
        for (int i = 0; i < dataArray.size(); ++i) {
            JsonObject versionObject = dataArray.get(i).getAsJsonObject();
            String versionType = "release";
            if (versionObject.get("releaseType").getAsString().equals("2")) {
                versionType = "beta";
            } else if (versionObject.get("releaseType").getAsString().equals("3")) {
                versionType = "alpha";
            }
            if (!versionObject.get("isAvailable").getAsBoolean() || !ModpackUtilsConfig.instance().versionType.contains(versionType) || !ModpackUtilsConfig.instance().loader.equalsIgnoreCase(versionObject.getAsJsonArray("gameVersions").get(0).getAsString())) continue;
            boolean hasNameFilter = true;
            if (!ModpackUtilsConfig.instance().nameFilters.isEmpty()) {
                for (String filter : ModpackUtilsConfig.instance().nameFilters) {
                    if (versionObject.get("displayName").getAsString().contains(filter)) continue;
                    hasNameFilter = false;
                }
            }
            boolean hasVersionFilter = true;
            if (!ModpackUtilsConfig.instance().versionFilters.isEmpty()) {
                for (String filter : ModpackUtilsConfig.instance().versionFilters) {
                    if (versionObject.get("displayName").getAsString().contains(filter)) continue;
                    hasVersionFilter = false;
                }
            }
            if (!hasNameFilter || !hasVersionFilter) continue;
            if (ModpackUtilsConfig.instance().checkMcVersion.booleanValue()) {
                if (!Minecraft.getInstance().getLaunchedVersion().equals(versionObject.getAsJsonArray("gameVersions").get(1).getAsString())) continue;
                return versionObject.get("displayName").getAsString();
            }
            return jsonObject.get("displayName").getAsString();
        }
        return null;
    }

    public static String getLatestFileId() {
        try {
            JsonObject jsonObject = JsonParser.parseString((String)ModpackUtils.sendGetRequest(ModpackUtils.getURLForPlatform())).getAsJsonObject();
            JsonArray dataArray = jsonObject.getAsJsonArray("data");
            for (int i = 0; i < dataArray.size(); ++i) {
                JsonObject versionObject = dataArray.get(i).getAsJsonObject();
                if (!versionObject.get("isAvailable").getAsBoolean() || !ModpackUtils.getLatestVersion().equals(versionObject.get("displayName").getAsString())) continue;
                return versionObject.get("id").getAsString();
            }
        }
        catch (Exception e) {
            LOGGER.error("[ModpackUtils] Failed to fetch the modpack info!", (Throwable)e);
        }
        return null;
    }

    public static String getLocalFileId() {
        try {
            JsonObject jsonObject = JsonParser.parseString((String)ModpackUtils.sendGetRequest(ModpackUtils.getURLForPlatform())).getAsJsonObject();
            JsonArray dataArray = jsonObject.getAsJsonArray("data");
            for (int i = 0; i < dataArray.size(); ++i) {
                JsonObject versionObject = dataArray.get(i).getAsJsonObject();
                if (!versionObject.get("isAvailable").getAsBoolean() || !ModpackUtilsConfig.instance().localVersion.equals(versionObject.get("displayName").getAsString())) continue;
                return versionObject.get("id").getAsString();
            }
        }
        catch (Exception e) {
            LOGGER.error("[ModpackUtils] Failed to fetch the modpack info!", (Throwable)e);
        }
        return null;
    }

    private static String parseOtherPlatformResponse(String response) {
        return response.lines().filter(line -> line.startsWith("version = \"") || line.startsWith("version_number = \"")).map(line -> line.substring(line.indexOf(34) + 1, line.length() - 1)).findFirst().orElse(null);
    }

    public static boolean updateAvailable() {
        return !ModpackUtilsConfig.instance().localVersion.equals(ModpackUtils.getLatestVersion());
    }

    public static int getAllocatedRam() {
        return (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
    }
}

