/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.mutils.config;

import com.google.common.collect.Lists;
import dev.isxander.yacl3.api.NameableEnum;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import dev.ultimatchamp.mutils.config.ModpackUtilsGui;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLPaths;
import org.jetbrains.annotations.Nullable;

public class ModpackUtilsConfig {
    public static Path CONFIG_DIR = FMLPaths.CONFIGDIR.get();
    private static final ConfigClassHandler<ModpackUtilsConfig> GSON = ConfigClassHandler.createBuilder(ModpackUtilsConfig.class).id(ResourceLocation.fromNamespaceAndPath((String)"mutils", (String)"config")).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(CONFIG_DIR.resolve("mutils/mutils.json5")).setJson5(true).build()).build();
    @SerialEntry(comment="Update Notifier")
    public boolean menuAlert = false;
    @SerialEntry
    public boolean chatAlert = false;
    @SerialEntry
    public String chatMessage = "There is an update available for your modpack!";
    @SerialEntry
    public Platforms platform = Platforms.MODRINTH;
    @SerialEntry
    public String modpackName = "My Modpack";
    @SerialEntry
    public String modpackId = "my-modpack";
    @SerialEntry
    public String modpackHome = "https://github.com/me/My-Modpack";
    @SerialEntry
    public String localVersion = "1.0.0";
    @SerialEntry
    public Boolean checkMcVersion = false;
    @SerialEntry
    public String loader = "neoforge";
    @SerialEntry
    public String versionAPI = "https://raw.githubusercontent.com/me/My-Modpack/main/Packwiz/pack.toml";
    @SerialEntry
    public String changelogLink = "https://raw.githubusercontent.com/me/My-Modpack/main/CHANGELOG.md";
    @SerialEntry
    public List<String> versionType = List.of("release", "beta", "alpha");
    @SerialEntry
    public List<String> nameFilters = Lists.newArrayList();
    @SerialEntry
    public List<String> versionFilters = Lists.newArrayList();
    @SerialEntry(comment="Chat Welcome")
    public Boolean chatWelcome = false;
    @SerialEntry
    public String chatWelcomeMessage = "Welcome to <modpack-name> <version>!";
    @SerialEntry(comment="Window Utils")
    public boolean customIcon = false;
    @SerialEntry
    public boolean customTitle = false;
    @SerialEntry
    public String title = "<modpack-name> <version> | Minecraft <mc>";
    @SerialEntry(comment="Ram Alert")
    public boolean ramMenuAlert = false;
    @SerialEntry
    public boolean ramChatAlert = false;
    @SerialEntry
    public Integer minRam = 8192;

    public static ConfigClassHandler<ModpackUtilsConfig> handler() {
        return GSON;
    }

    public static void load() {
        GSON.load();
    }

    public static ModpackUtilsConfig instance() {
        return (ModpackUtilsConfig)GSON.instance();
    }

    public static Screen createScreen(@Nullable Screen parent) {
        return ModpackUtilsGui.createConfigScreen(parent);
    }

    public static enum Platforms implements NameableEnum
    {
        CUSTOM("generator.custom"),
        MODRINTH("mutils.modrinth"),
        CURSEFORGE("mutils.curseforge");

        private final String displayName;

        private Platforms(String displayName) {
            this.displayName = displayName;
        }

        public Component getDisplayName() {
            return Component.translatable((String)this.displayName);
        }
    }
}

