/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.mutils.mixin;

import com.mojang.blaze3d.platform.IconSet;
import dev.ultimatchamp.mutils.ModpackUtils;
import dev.ultimatchamp.mutils.config.ModpackUtilsConfig;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={IconSet.class})
public class IconSetMixin {
    @Inject(method={"getFile(Lnet/minecraft/server/packs/PackResources;Ljava/lang/String;)Lnet/minecraft/server/packs/resources/IoSupplier;"}, at={@At(value="RETURN")}, cancellable=true)
    private void mutils$setIcons(PackResources resources, String filename, CallbackInfoReturnable<IoSupplier<InputStream>> cir) {
        if (ModpackUtilsConfig.instance().customIcon) {
            Path icon = ModpackUtilsConfig.CONFIG_DIR.resolve("mutils/icons/" + filename);
            if (Files.exists(icon, new LinkOption[0])) {
                cir.setReturnValue(() -> Files.newInputStream(icon, new OpenOption[0]));
            } else {
                ModpackUtils.LOGGER.error("[ModpackUtils] Custom icon file not found: {}", (Object)filename);
            }
        }
    }
}

