/*
 * Decompiled with CFR 0.152.
 */
package dev.ultimatchamp.mutils.mixin;

import dev.ultimatchamp.mutils.ModpackUtils;
import dev.ultimatchamp.mutils.config.ModpackUtilsConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Shadow
    public abstract ToastComponent getToasts();

    @Inject(method={"onGameLoadFinished(Lnet/minecraft/client/Minecraft$GameLoadCookie;)V"}, at={@At(value="RETURN")})
    private void mutils$showUpdateToast(CallbackInfo ci) {
        if (ModpackUtilsConfig.instance().menuAlert && ModpackUtils.updateAvailable() && ModpackUtils.getLatestVersion() != null) {
            SystemToast.add((ToastComponent)this.getToasts(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)Component.translatable((String)"mutils.text.updateAvailable").withStyle(new ChatFormatting[]{ChatFormatting.DARK_AQUA, ChatFormatting.BOLD}), (Component)Component.literal((String)(ModpackUtilsConfig.instance().modpackName + " ")).withStyle(ChatFormatting.BOLD).append((Component)Component.literal((String)(ModpackUtilsConfig.instance().localVersion + " --> " + ModpackUtils.getLatestVersion())).withStyle(ChatFormatting.GOLD)));
            ModpackUtils.LOGGER.warn("[ModpackUtils] {}: {} --> {}", new Object[]{ModpackUtilsConfig.instance().chatMessage, ModpackUtilsConfig.instance().localVersion, ModpackUtils.getLatestVersion()});
        }
        if (ModpackUtilsConfig.instance().ramMenuAlert) {
            int allocatedRam = ModpackUtils.getAllocatedRam();
            Integer minRam = ModpackUtilsConfig.instance().minRam;
            if (minRam > allocatedRam) {
                SystemToast.add((ToastComponent)this.getToasts(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)Component.translatable((String)"mutils.text.lowRam").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}), (Component)Component.literal((String)(allocatedRam + " --> " + minRam)).withStyle(ChatFormatting.GOLD));
                ModpackUtils.LOGGER.error("[ModpackUtils] Low ram allocated: {} --> {}", (Object)allocatedRam, (Object)minRam);
            }
        }
    }
}

