/*
 * Decompiled with CFR 0.152.
 */
package ru.velfan;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class main
extends JavaPlugin
implements CommandExecutor {
    private FileConfiguration config;

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.initializeDatabase();
        this.registerCommands();
        this.getLogger().info("\u041f\u043b\u0430\u0433\u0438\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0437\u0430\u043f\u0443\u0449\u0435\u043d!");
    }

    private void registerCommands() {
        this.getCommand("saveexp").setExecutor((CommandExecutor)this);
        this.getCommand("loadexp").setExecutor((CommandExecutor)this);
        this.getCommand("showexp").setExecutor((CommandExecutor)this);
        this.getCommand("vexpr").setExecutor((CommandExecutor)this);
    }

    private void initializeDatabase() {
        try (Connection conn = DriverManager.getConnection("jdbc:mysql://" + this.config.getString("database.host") + ":" + this.config.getString("database.port") + "/", this.config.getString("database.user"), this.config.getString("database.password"));){
            String createDBSQL = "CREATE DATABASE IF NOT EXISTS " + this.config.getString("database.name");
            try (PreparedStatement stmt = conn.prepareStatement(createDBSQL);){
                stmt.executeUpdate();
            }
            try (Connection tableConn = this.getConnection();){
                String createTableSQL = "CREATE TABLE IF NOT EXISTS playerdata (uuid VARCHAR(36) PRIMARY KEY, experience INT NOT NULL DEFAULT 0, level INT NOT NULL DEFAULT 0)";
                try (PreparedStatement stmt = tableConn.prepareStatement(createTableSQL);){
                    stmt.executeUpdate();
                }
            }
        }
        catch (SQLException e) {
            this.getLogger().severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0411\u0414: " + e.getMessage());
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private Connection getConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:mysql://" + this.config.getString("database.host") + ":" + this.config.getString("database.port") + "/" + this.config.getString("database.name"), this.config.getString("database.user"), this.config.getString("database.password"));
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.colorize(this.config.getString("messages.not_a_player")));
            return false;
        }
        Player player = (Player)sender;
        String playerUUID = player.getUniqueId().toString();
        String command = cmd.getName().toLowerCase();
        try {
            switch (command) {
                case "vexpr": {
                    this.handleVexprCommand(player);
                    return true;
                }
                case "saveexp": {
                    this.handleSaveExp(player, playerUUID);
                    return true;
                }
                case "loadexp": {
                    this.handleLoadExp(player, playerUUID);
                    return true;
                }
                case "showexp": {
                    this.handleShowExp(player, playerUUID);
                    return true;
                }
            }
            return false;
        }
        catch (SQLException e) {
            player.sendMessage(this.colorize(this.config.getString("messages.database_error")));
            this.getLogger().severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u0411\u0414: " + e.getMessage());
            return false;
        }
    }

    private void handleVexprCommand(Player player) {
        if (!this.checkPermission(player, "veexp.vexpr")) {
            return;
        }
        player.sendMessage(this.colorize(this.config.getString("messages.plugin_restarting")));
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            Bukkit.getPluginManager().enablePlugin((Plugin)this);
            player.sendMessage(this.colorize(this.config.getString("messages.plugin_restarted")));
        }, 20L);
    }

    private void handleSaveExp(Player player, String uuid) throws SQLException {
        if (!this.checkPermission(player, "veexp.saveexp")) {
            return;
        }
        int exp = player.getTotalExperience();
        int level = player.getLevel();
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement("INSERT INTO playerdata (uuid, experience, level) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE experience = ?, level = ?");
            stmt.setString(1, uuid);
            stmt.setInt(2, exp);
            stmt.setInt(3, level);
            stmt.setInt(4, exp);
            stmt.setInt(5, level);
            stmt.executeUpdate();
            player.setTotalExperience(0);
            player.setLevel(0);
            this.playSuccessSound(player);
            player.sendMessage(this.colorize(this.config.getString("messages.experience_saved")));
        }
    }

    private void handleLoadExp(Player player, String uuid) throws SQLException {
        if (!this.checkPermission(player, "veexp.loadexp")) {
            return;
        }
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement("SELECT experience, level FROM playerdata WHERE uuid = ?");
            stmt.setString(1, uuid);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                int savedExp = rs.getInt("experience");
                int savedLevel = rs.getInt("level");
                if (savedExp > 0 || savedLevel > 0) {
                    player.setTotalExperience(savedExp);
                    player.setLevel(savedLevel);
                    PreparedStatement clearStmt = conn.prepareStatement("UPDATE playerdata SET experience = 0, level = 0 WHERE uuid = ?");
                    clearStmt.setString(1, uuid);
                    clearStmt.executeUpdate();
                    this.playSuccessSound(player);
                    player.sendMessage(this.colorize(this.config.getString("messages.experience_loaded")));
                } else {
                    player.sendMessage(this.colorize(this.config.getString("messages.no_data_to_load")));
                }
            } else {
                player.sendMessage(this.colorize(this.config.getString("messages.file_not_found")));
            }
        }
    }

    private void handleShowExp(Player player, String uuid) throws SQLException {
        if (!this.checkPermission(player, "veexp.showexp")) {
            return;
        }
        try (Connection conn = this.getConnection();){
            PreparedStatement stmt = conn.prepareStatement("SELECT experience, level FROM playerdata WHERE uuid = ?");
            stmt.setString(1, uuid);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                String separator = this.colorize(this.config.getString("messages.separator"));
                String message = this.colorize(this.config.getString("messages.saved_experience")).replace("%exp%", String.valueOf(rs.getInt("experience"))).replace("%level%", String.valueOf(rs.getInt("level")));
                player.sendMessage(separator);
                player.sendMessage(message);
                player.sendMessage(separator);
            } else {
                player.sendMessage(this.colorize(this.config.getString("messages.file_not_found")));
            }
        }
    }

    private boolean checkPermission(Player player, String permission) {
        if (!player.hasPermission(permission)) {
            player.sendMessage(this.colorize(this.config.getString("messages.no_permission")));
            return false;
        }
        return true;
    }

    private void playSuccessSound(Player player) {
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
    }

    private String colorize(String text) {
        return text.replace('&', '\u00a7');
    }

    public void onDisable() {
        this.getLogger().info("\u041f\u043b\u0430\u0433\u0438\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d!");
    }
}

