/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.ColorManager;
import com.mamiyaotaru.voxelmap.DebugRenderState;
import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.VoxelMap;
import com.mamiyaotaru.voxelmap.WaypointManager;
import com.mamiyaotaru.voxelmap.gui.GuiAddWaypoint;
import com.mamiyaotaru.voxelmap.gui.GuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.GuiWelcomeScreen;
import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.interfaces.IChangeObserver;
import com.mamiyaotaru.voxelmap.persistent.GuiPersistentMap;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.BlockRepository;
import com.mamiyaotaru.voxelmap.util.CPULightmap;
import com.mamiyaotaru.voxelmap.util.ColorUtils;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.DynamicMoveableTexture;
import com.mamiyaotaru.voxelmap.util.FullMapData;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.LayoutVariables;
import com.mamiyaotaru.voxelmap.util.MapChunkCache;
import com.mamiyaotaru.voxelmap.util.MapUtils;
import com.mamiyaotaru.voxelmap.util.MutableBlockPos;
import com.mamiyaotaru.voxelmap.util.MutableBlockPosCache;
import com.mamiyaotaru.voxelmap.util.ScaledDynamicMutableTexture;
import com.mamiyaotaru.voxelmap.util.VoxelMapCachedOrthoProjectionMatrixBuffer;
import com.mamiyaotaru.voxelmap.util.VoxelMapGuiGraphics;
import com.mamiyaotaru.voxelmap.util.VoxelMapPipelines;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.OptionalInt;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.class_10366;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10539;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2506;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_418;
import net.minecraft.class_428;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5539;
import net.minecraft.class_638;
import net.minecraft.class_765;
import net.minecraft.class_7924;
import net.minecraft.class_9801;
import net.minecraft.class_9848;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class Map
implements Runnable,
IChangeObserver {
    private final class_310 minecraft = class_310.method_1551();
    private final float[] lastLightBrightnessTable = new float[16];
    private final Object coordinateLock = new Object();
    private final class_2960 resourceArrow = class_2960.method_60655((String)"voxelmap", (String)"images/mmarrow.png");
    private final class_2960 resourceSquareMap = class_2960.method_60655((String)"voxelmap", (String)"images/squaremap.png");
    private final class_2960 resourceRoundMap = class_2960.method_60655((String)"voxelmap", (String)"images/roundmap.png");
    private final class_2960 squareStencil = class_2960.method_60655((String)"voxelmap", (String)"images/square.png");
    private final class_2960 circleStencil = class_2960.method_60655((String)"voxelmap", (String)"images/circle.png");
    private class_638 world;
    private final MapSettingsManager options;
    private final LayoutVariables layoutVariables;
    private final ColorManager colorManager;
    private final WaypointManager waypointManager;
    private final int availableProcessors = Runtime.getRuntime().availableProcessors();
    private final boolean multicore = this.availableProcessors > 1;
    private final int heightMapResetHeight = this.multicore ? 2 : 5;
    private final int heightMapResetTime = this.multicore ? 300 : 3000;
    private final boolean threading = this.multicore;
    private final FullMapData[] mapData = new FullMapData[5];
    private final MapChunkCache[] chunkCache = new MapChunkCache[5];
    private DynamicMoveableTexture[] mapImages;
    private class_2960[] mapResources;
    private final DynamicMoveableTexture[] mapImagesFiltered = new DynamicMoveableTexture[5];
    private final DynamicMoveableTexture[] mapImagesUnfiltered = new DynamicMoveableTexture[5];
    private class_2680 transparentBlockState;
    private class_2680 surfaceBlockState;
    private boolean imageChanged = true;
    private class_765 lightmapTexture;
    private boolean needLightmapRefresh = true;
    private int tickWithLightChange;
    private boolean lastPaused = true;
    private double lastGamma;
    private float lastSunBrightness;
    private float lastLightning;
    private float lastPotion;
    private final int[] lastLightmapValues = new int[]{-16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216};
    private boolean lastBeneathRendering;
    private boolean needSkyColor;
    private boolean lastAboveHorizon = true;
    private int lastBiome;
    private int lastSkyColor;
    private final Random generator = new Random();
    private class_437 lastGuiScreen;
    private boolean fullscreenMap;
    private int zoom;
    private int scWidth;
    private int scHeight;
    private String error = "";
    private int ztimer;
    private int heightMapFudge;
    private int timer;
    private boolean doFullRender = true;
    private boolean zoomChanged;
    private int lastX;
    private int lastZ;
    private int lastY;
    private int lastImageX;
    private int lastImageZ;
    private boolean lastFullscreen;
    private float direction;
    private float percentX;
    private float percentY;
    private int northRotate;
    private Thread zCalc = new Thread((Runnable)this, "Voxelmap LiveMap Calculation Thread");
    private int zCalcTicker;
    private int[] lightmapColors = new int[256];
    private double zoomScale = 1.0;
    private double zoomScaleAdjusted = 1.0;
    private static double minTablistOffset;
    private static float statusIconOffset;
    private final class_2960[] resourceMapImageFiltered = new class_2960[5];
    private final class_2960[] resourceMapImageUnfiltered = new class_2960[5];
    private GpuTexture fboTexture;
    private GpuTextureView fboTextureView;
    private class_289 fboTessellator = new class_289(4096);
    private VoxelMapCachedOrthoProjectionMatrixBuffer projection;

    public Map() {
        this.resourceMapImageFiltered[0] = class_2960.method_60655((String)"voxelmap", (String)"map/filtered/0");
        this.resourceMapImageFiltered[1] = class_2960.method_60655((String)"voxelmap", (String)"map/filtered/1");
        this.resourceMapImageFiltered[2] = class_2960.method_60655((String)"voxelmap", (String)"map/filtered/2");
        this.resourceMapImageFiltered[3] = class_2960.method_60655((String)"voxelmap", (String)"map/filtered/3");
        this.resourceMapImageFiltered[4] = class_2960.method_60655((String)"voxelmap", (String)"map/filtered/4");
        this.resourceMapImageUnfiltered[0] = class_2960.method_60655((String)"voxelmap", (String)"map/unfiltered/0");
        this.resourceMapImageUnfiltered[1] = class_2960.method_60655((String)"voxelmap", (String)"map/unfiltered/1");
        this.resourceMapImageUnfiltered[2] = class_2960.method_60655((String)"voxelmap", (String)"map/unfiltered/2");
        this.resourceMapImageUnfiltered[3] = class_2960.method_60655((String)"voxelmap", (String)"map/unfiltered/3");
        this.resourceMapImageUnfiltered[4] = class_2960.method_60655((String)"voxelmap", (String)"map/unfiltered/4");
        this.options = VoxelConstants.getVoxelMapInstance().getMapOptions();
        this.colorManager = VoxelConstants.getVoxelMapInstance().getColorManager();
        this.waypointManager = VoxelConstants.getVoxelMapInstance().getWaypointManager();
        this.layoutVariables = new LayoutVariables();
        ArrayList<class_304> tempBindings = new ArrayList<class_304>();
        tempBindings.addAll(Arrays.asList(this.minecraft.field_1690.field_1839));
        tempBindings.addAll(Arrays.asList(this.options.keyBindings));
        this.minecraft.field_1690.field_1839 = tempBindings.toArray(new class_304[0]);
        this.zCalc.start();
        this.mapData[0] = new FullMapData(32, 32);
        this.mapData[1] = new FullMapData(64, 64);
        this.mapData[2] = new FullMapData(128, 128);
        this.mapData[3] = new FullMapData(256, 256);
        this.mapData[4] = new FullMapData(512, 512);
        this.chunkCache[0] = new MapChunkCache(3, 3, this);
        this.chunkCache[1] = new MapChunkCache(5, 5, this);
        this.chunkCache[2] = new MapChunkCache(9, 9, this);
        this.chunkCache[3] = new MapChunkCache(17, 17, this);
        this.chunkCache[4] = new MapChunkCache(33, 33, this);
        this.mapImagesFiltered[0] = new DynamicMoveableTexture("voxelmap-map-32", 32, 32, true);
        this.mapImagesFiltered[1] = new DynamicMoveableTexture("voxelmap-map-64", 64, 64, true);
        this.mapImagesFiltered[2] = new DynamicMoveableTexture("voxelmap-map-128", 128, 128, true);
        this.mapImagesFiltered[3] = new DynamicMoveableTexture("voxelmap-map-256", 256, 256, true);
        this.mapImagesFiltered[4] = new DynamicMoveableTexture("voxelmap-map-512", 512, 512, true);
        this.mapImagesFiltered[0].method_4527(true, false);
        this.mapImagesFiltered[1].method_4527(true, false);
        this.mapImagesFiltered[2].method_4527(true, false);
        this.mapImagesFiltered[3].method_4527(true, false);
        this.mapImagesFiltered[4].method_4527(true, false);
        this.minecraft.method_1531().method_4616(this.resourceMapImageFiltered[0], (class_1044)this.mapImagesFiltered[0]);
        this.minecraft.method_1531().method_4616(this.resourceMapImageFiltered[1], (class_1044)this.mapImagesFiltered[1]);
        this.minecraft.method_1531().method_4616(this.resourceMapImageFiltered[2], (class_1044)this.mapImagesFiltered[2]);
        this.minecraft.method_1531().method_4616(this.resourceMapImageFiltered[3], (class_1044)this.mapImagesFiltered[3]);
        this.minecraft.method_1531().method_4616(this.resourceMapImageFiltered[4], (class_1044)this.mapImagesFiltered[4]);
        this.mapImagesUnfiltered[0] = new ScaledDynamicMutableTexture("voxelmap-map-unfiltered-32", 32, 32, true);
        this.mapImagesUnfiltered[1] = new ScaledDynamicMutableTexture("voxelmap-map-unfiltered-64", 64, 64, true);
        this.mapImagesUnfiltered[2] = new ScaledDynamicMutableTexture("voxelmap-map-unfiltered-128", 128, 128, true);
        this.mapImagesUnfiltered[3] = new ScaledDynamicMutableTexture("voxelmap-map-unfiltered-256", 256, 256, true);
        this.mapImagesUnfiltered[4] = new ScaledDynamicMutableTexture("voxelmap-map-unfiltered-512", 512, 512, true);
        this.mapImagesUnfiltered[0].method_4527(true, false);
        this.mapImagesUnfiltered[1].method_4527(true, false);
        this.mapImagesUnfiltered[2].method_4527(true, false);
        this.mapImagesUnfiltered[3].method_4527(true, false);
        this.mapImagesUnfiltered[4].method_4527(true, false);
        this.minecraft.method_1531().method_4616(this.resourceMapImageUnfiltered[0], (class_1044)this.mapImagesUnfiltered[0]);
        this.minecraft.method_1531().method_4616(this.resourceMapImageUnfiltered[1], (class_1044)this.mapImagesUnfiltered[1]);
        this.minecraft.method_1531().method_4616(this.resourceMapImageUnfiltered[2], (class_1044)this.mapImagesUnfiltered[2]);
        this.minecraft.method_1531().method_4616(this.resourceMapImageUnfiltered[3], (class_1044)this.mapImagesUnfiltered[3]);
        this.minecraft.method_1531().method_4616(this.resourceMapImageUnfiltered[4], (class_1044)this.mapImagesUnfiltered[4]);
        if (this.options.filtering) {
            this.mapImages = this.mapImagesFiltered;
            this.mapResources = this.resourceMapImageFiltered;
        } else {
            this.mapImages = this.mapImagesUnfiltered;
            this.mapResources = this.resourceMapImageUnfiltered;
        }
        this.zoom = this.options.zoom;
        this.setZoomScale();
        int fboTextureSize = 512;
        this.fboTexture = RenderSystem.getDevice().createTexture("voxelmap-fbotexture", 15, TextureFormat.RGBA8, 512, 512, 1, 1);
        this.fboTextureView = RenderSystem.getDevice().createTextureView(this.fboTexture);
        this.projection = new VoxelMapCachedOrthoProjectionMatrixBuffer("VoxelMap Map To Screen Proj", -256.0f, 256.0f, 256.0f, -256.0f, 1000.0f, 21000.0f);
        try {
            class_1043 arrowTexture = new class_1043(() -> "Minimap Arrow", class_10539.method_65871((class_3300)class_310.method_1551().method_1478(), (class_2960)this.resourceArrow).comp_3447());
            arrowTexture.method_4527(true, false);
            this.minecraft.method_1531().method_4616(this.resourceArrow, (class_1044)arrowTexture);
            class_1043 squareMapTexture = new class_1043(() -> "Minimap Square Map Frame", class_10539.method_65871((class_3300)class_310.method_1551().method_1478(), (class_2960)this.resourceSquareMap).comp_3447());
            squareMapTexture.method_4527(true, false);
            this.minecraft.method_1531().method_4616(this.resourceSquareMap, (class_1044)squareMapTexture);
            class_1043 roundMapTexture = new class_1043(() -> "Minimap Round Map Frame", class_10539.method_65871((class_3300)class_310.method_1551().method_1478(), (class_2960)this.resourceRoundMap).comp_3447());
            roundMapTexture.method_4527(true, false);
            this.minecraft.method_1531().method_4616(this.resourceRoundMap, (class_1044)roundMapTexture);
        }
        catch (Exception exception) {
            VoxelConstants.getLogger().error("Failed getting map images " + exception.getLocalizedMessage(), (Throwable)exception);
        }
    }

    public void forceFullRender(boolean forceFullRender) {
        this.doFullRender = forceFullRender;
        VoxelConstants.getVoxelMapInstance().getSettingsAndLightingChangeNotifier().notifyOfChanges();
    }

    public float getPercentX() {
        return this.percentX;
    }

    public float getPercentY() {
        return this.percentY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.minecraft != null) {
            while (true) {
                if (this.world != null) {
                    if (!this.options.hide && this.options.minimapAllowed) {
                        try {
                            this.mapCalc(this.doFullRender);
                            if (!this.doFullRender) {
                                MutableBlockPos blockPos = MutableBlockPosCache.get();
                                this.chunkCache[this.zoom].centerChunks((class_2338)blockPos.withXYZ(this.lastX, 0, this.lastZ));
                                MutableBlockPosCache.release(blockPos);
                                this.chunkCache[this.zoom].checkIfChunksChanged();
                            }
                        }
                        catch (Exception exception) {
                            VoxelConstants.getLogger().error("Voxelmap LiveMap Calculation Thread", (Throwable)exception);
                        }
                    }
                    this.doFullRender = this.zoomChanged;
                    this.zoomChanged = false;
                }
                this.zCalcTicker = 0;
                Thread thread = this.zCalc;
                synchronized (thread) {
                    try {
                        this.zCalc.wait(0L);
                    }
                    catch (InterruptedException exception) {
                        VoxelConstants.getLogger().error("Voxelmap LiveMap Calculation Thread", (Throwable)exception);
                    }
                }
            }
        }
    }

    public void newWorld(class_638 world) {
        this.world = world;
        this.lightmapTexture = this.getLightmapTexture();
        this.mapData[this.zoom].blank();
        this.doFullRender = true;
        VoxelConstants.getVoxelMapInstance().getSettingsAndLightingChangeNotifier().notifyOfChanges();
    }

    public void newWorldName() {
        String subworldName = this.waypointManager.getCurrentSubworldDescriptor(true);
        StringBuilder subworldNameBuilder = new StringBuilder("\u00a7r").append(class_1074.method_4662((String)"worldmap.multiworld.newWorld", (Object[])new Object[0])).append(":").append(" ");
        if (subworldName.isEmpty() && this.waypointManager.isMultiworld()) {
            subworldNameBuilder.append("???");
        } else if (!subworldName.isEmpty()) {
            subworldNameBuilder.append(subworldName);
        }
        this.error = subworldNameBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTickInGame(class_332 drawContext) {
        int n = this.northRotate = this.options.oldNorth ? 90 : 0;
        if (this.lightmapTexture == null) {
            this.lightmapTexture = this.getLightmapTexture();
        }
        if (this.minecraft.field_1755 == null && this.options.welcome) {
            this.minecraft.method_1507((class_437)new GuiWelcomeScreen(null));
        }
        if (this.minecraft.field_1755 == null && this.options.keyBindMenu.method_1436()) {
            this.minecraft.method_1507((class_437)new GuiPersistentMap(null));
        }
        if (this.minecraft.field_1755 == null && this.options.keyBindWaypointMenu.method_1436() && VoxelMap.mapOptions.waypointsAllowed) {
            this.minecraft.method_1507((class_437)new GuiWaypoints(null));
        }
        if (this.minecraft.field_1755 == null && this.options.keyBindWaypoint.method_1436() && VoxelMap.mapOptions.waypointsAllowed) {
            float b;
            float g;
            float r;
            if (this.waypointManager.getWaypoints().isEmpty()) {
                r = 0.0f;
                g = 1.0f;
                b = 0.0f;
            } else {
                r = this.generator.nextFloat();
                g = this.generator.nextFloat();
                b = this.generator.nextFloat();
            }
            TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
            dimensions.add(VoxelConstants.getVoxelMapInstance().getDimensionManager().getDimensionContainerByWorld(VoxelConstants.getPlayer().method_73183()));
            double dimensionScale = VoxelConstants.getPlayer().method_73183().method_8597().comp_646();
            Waypoint newWaypoint = new Waypoint("", (int)((double)GameVariableAccessShim.xCoord() * dimensionScale), (int)((double)GameVariableAccessShim.zCoord() * dimensionScale), GameVariableAccessShim.yCoord(), true, r, g, b, "", VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(false), dimensions);
            this.minecraft.method_1507((class_437)new GuiAddWaypoint(null, newWaypoint, false));
        }
        if (this.minecraft.field_1755 == null && this.options.keyBindMobToggle.method_1436()) {
            VoxelConstants.getVoxelMapInstance().getRadarOptions().setOptionValue(EnumOptionsMinimap.SHOW_RADAR);
            this.options.saveAll();
        }
        if (this.minecraft.field_1755 == null && this.options.keyBindWaypointToggle.method_1436()) {
            this.options.toggleIngameWaypoints();
        }
        if (this.minecraft.field_1755 == null && this.options.keyBindZoom.method_1436()) {
            this.cycleZoomLevel();
        }
        if (this.minecraft.field_1755 == null && this.options.keyBindFullscreen.method_1436()) {
            boolean bl = this.fullscreenMap = !this.fullscreenMap;
            this.error = this.zoom == 4 ? class_1074.method_4662((String)"minimap.ui.zoomLevel", (Object[])new Object[0]) + " (0.25x)" : (this.zoom == 3 ? class_1074.method_4662((String)"minimap.ui.zoomLevel", (Object[])new Object[0]) + " (0.5x)" : (this.zoom == 2 ? class_1074.method_4662((String)"minimap.ui.zoomLevel", (Object[])new Object[0]) + " (1.0x)" : (this.zoom == 1 ? class_1074.method_4662((String)"minimap.ui.zoomLevel", (Object[])new Object[0]) + " (2.0x)" : class_1074.method_4662((String)"minimap.ui.zoomLevel", (Object[])new Object[0]) + " (4.0x)")));
        }
        if (this.minecraft.field_1755 == null && this.options.keyBindMinimapToggle.method_1436()) {
            this.options.setOptionValue(EnumOptionsMinimap.HIDE_MINIMAP);
        }
        this.checkForChanges();
        if (VoxelMap.mapOptions.deathWaypointAllowed && this.minecraft.field_1755 instanceof class_418 && !(this.lastGuiScreen instanceof class_418)) {
            this.waypointManager.handleDeath();
        }
        this.lastGuiScreen = this.minecraft.field_1755;
        this.calculateCurrentLightAndSkyColor();
        if (this.threading) {
            if (!this.zCalc.isAlive()) {
                this.zCalc = new Thread((Runnable)this, "Voxelmap LiveMap Calculation Thread");
                this.zCalc.start();
                this.zCalcTicker = 0;
            }
            if (!(this.minecraft.field_1755 instanceof class_418) && !(this.minecraft.field_1755 instanceof class_428)) {
                ++this.zCalcTicker;
                if (this.zCalcTicker > 2000) {
                    this.zCalcTicker = 0;
                    Exception ex = new Exception();
                    ex.setStackTrace(this.zCalc.getStackTrace());
                    DebugRenderState.print();
                    VoxelConstants.getLogger().error("Voxelmap LiveMap Calculation Thread is hanging?", (Throwable)ex);
                }
                Thread ex = this.zCalc;
                synchronized (ex) {
                    this.zCalc.notify();
                }
            }
        } else {
            if (!this.options.hide && this.options.minimapAllowed && this.world != null) {
                this.mapCalc(this.doFullRender);
                if (!this.doFullRender) {
                    MutableBlockPos blockPos = MutableBlockPosCache.get();
                    this.chunkCache[this.zoom].centerChunks((class_2338)blockPos.withXYZ(this.lastX, 0, this.lastZ));
                    MutableBlockPosCache.release(blockPos);
                    this.chunkCache[this.zoom].checkIfChunksChanged();
                }
            }
            this.doFullRender = false;
        }
        boolean enabled = !this.minecraft.field_1690.field_1842 && (this.options.showUnderMenus || this.minecraft.field_1755 == null) && !this.minecraft.field_61504.method_72776();
        this.direction = GameVariableAccessShim.rotationYaw() + 180.0f;
        while (this.direction >= 360.0f) {
            this.direction -= 360.0f;
        }
        while (this.direction < 0.0f) {
            this.direction += 360.0f;
        }
        if (!this.error.isEmpty() && this.ztimer == 0) {
            this.ztimer = 500;
        }
        if (this.ztimer > 0) {
            --this.ztimer;
        }
        if (this.ztimer == 0 && !this.error.isEmpty()) {
            this.error = "";
        }
        if (enabled && VoxelMap.mapOptions.minimapAllowed) {
            this.drawMinimap(drawContext);
        }
        this.timer = this.timer > 5000 ? 0 : this.timer + 1;
    }

    private void cycleZoomLevel() {
        if (this.options.zoom == 4) {
            this.options.zoom = 3;
            this.error = class_1074.method_4662((String)"minimap.ui.zoomLevel", (Object[])new Object[0]) + " (0.5x)";
        } else if (this.options.zoom == 3) {
            this.options.zoom = 2;
            this.error = class_1074.method_4662((String)"minimap.ui.zoomLevel", (Object[])new Object[0]) + " (1.0x)";
        } else if (this.options.zoom == 2) {
            this.options.zoom = 1;
            this.error = class_1074.method_4662((String)"minimap.ui.zoomLevel", (Object[])new Object[0]) + " (2.0x)";
        } else if (this.options.zoom == 1) {
            this.options.zoom = 0;
            this.error = class_1074.method_4662((String)"minimap.ui.zoomLevel", (Object[])new Object[0]) + " (4.0x)";
        } else if (this.options.zoom == 0) {
            this.options.zoom = 4;
            this.error = class_1074.method_4662((String)"minimap.ui.zoomLevel", (Object[])new Object[0]) + " (0.25x)";
        }
        this.options.saveAll();
        this.zoomChanged = true;
        this.zoom = this.options.zoom;
        this.setZoomScale();
        this.doFullRender = true;
    }

    private void setZoomScale() {
        this.zoomScale = Math.pow(2.0, this.zoom) / 2.0;
        this.zoomScaleAdjusted = this.options.squareMap && this.options.rotates ? this.zoomScale / (double)1.4142f : this.zoomScale;
    }

    private class_765 getLightmapTexture() {
        return this.minecraft.field_1773.method_22974();
    }

    public void calculateCurrentLightAndSkyColor() {
        try {
            if (this.world != null) {
                boolean aboveHorizon;
                boolean scheduledUpdate;
                int lastLightningBolt;
                int t;
                if (this.needLightmapRefresh && VoxelConstants.getElapsedTicks() != this.tickWithLightChange && !this.minecraft.method_1493() || this.options.realTimeTorches) {
                    this.needLightmapRefresh = false;
                    CPULightmap lightmap = CPULightmap.getInstance();
                    lightmap.setup();
                    for (int blockLight = 0; blockLight < 16; ++blockLight) {
                        for (int skyLight = 0; skyLight < 16; ++skyLight) {
                            this.lightmapColors[blockLight + skyLight * 16] = lightmap.getLight(blockLight, skyLight);
                        }
                    }
                }
                boolean lightChanged = false;
                if ((Double)this.minecraft.field_1690.method_42473().method_41753() != this.lastGamma) {
                    lightChanged = true;
                    this.lastGamma = (Double)this.minecraft.field_1690.method_42473().method_41753();
                }
                float[] providerLightBrightnessTable = new float[16];
                for (t = 0; t < 16; ++t) {
                    providerLightBrightnessTable[t] = this.world.method_8597().method_28528((long)t);
                }
                for (t = 0; t < 16; ++t) {
                    if (providerLightBrightnessTable[t] == this.lastLightBrightnessTable[t]) continue;
                    lightChanged = true;
                    this.lastLightBrightnessTable[t] = providerLightBrightnessTable[t];
                }
                float sunBrightness = this.world.method_23783(1.0f);
                if ((double)Math.abs(this.lastSunBrightness - sunBrightness) > 0.01 || (double)sunBrightness == 1.0 && sunBrightness != this.lastSunBrightness || (double)sunBrightness == 0.0 && sunBrightness != this.lastSunBrightness) {
                    lightChanged = true;
                    this.needSkyColor = true;
                    this.lastSunBrightness = sunBrightness;
                }
                float potionEffect = 0.0f;
                if (VoxelConstants.getPlayer().method_6059(class_1294.field_5925)) {
                    int duration = VoxelConstants.getPlayer().method_6112(class_1294.field_5925).method_5584();
                    float f = potionEffect = duration > 200 ? 1.0f : 0.7f + class_3532.method_15374((float)(((float)duration - 1.0f) * (float)Math.PI * 0.2f)) * 0.3f;
                }
                if (this.lastPotion != potionEffect) {
                    this.lastPotion = potionEffect;
                    lightChanged = true;
                }
                if (this.lastLightning != (float)(lastLightningBolt = this.world.method_23789())) {
                    this.lastLightning = lastLightningBolt;
                    lightChanged = true;
                }
                if (this.lastPaused != this.minecraft.method_1493()) {
                    this.lastPaused = !this.lastPaused;
                    lightChanged = true;
                }
                boolean bl = scheduledUpdate = (this.timer - 50) % (this.lastLightBrightnessTable[0] == 0.0f ? 50 : 100) == 0;
                if (lightChanged || scheduledUpdate) {
                    this.tickWithLightChange = VoxelConstants.getElapsedTicks();
                    this.needLightmapRefresh = true;
                }
                boolean bl2 = aboveHorizon = VoxelConstants.getPlayer().method_5836((float)0.0f).field_1351 >= this.world.method_28104().method_28105((class_5539)this.world);
                if (this.world.method_27983().method_29177().toString().toLowerCase().contains("ether")) {
                    aboveHorizon = true;
                }
                if (aboveHorizon != this.lastAboveHorizon) {
                    this.needSkyColor = true;
                    this.lastAboveHorizon = aboveHorizon;
                }
                MutableBlockPos blockPos = MutableBlockPosCache.get();
                int biomeID = this.world.method_30349().method_30530(class_7924.field_41236).method_10206((Object)((class_1959)this.world.method_23753((class_2338)blockPos.withXYZ(GameVariableAccessShim.xCoord(), GameVariableAccessShim.yCoord(), GameVariableAccessShim.zCoord())).comp_349()));
                MutableBlockPosCache.release(blockPos);
                if (biomeID != this.lastBiome) {
                    this.needSkyColor = true;
                    this.lastBiome = biomeID;
                }
                if (this.needSkyColor || scheduledUpdate) {
                    this.colorManager.setSkyColor(this.getSkyColor());
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private int getSkyColor() {
        this.needSkyColor = false;
        boolean aboveHorizon = this.lastAboveHorizon;
        Vector4f color = class_310.method_1551().field_1773.field_60793.method_62185(this.minecraft.field_1773.method_19418(), 0.0f, this.world, ((Integer)this.minecraft.field_1690.method_42503().method_41753()).intValue(), this.minecraft.field_1773.method_3195(0.0f), false);
        float r = color.x;
        float g = color.y;
        float b = color.z;
        if (!aboveHorizon) {
            return 0xA000000 + (int)(r * 255.0f) * 65536 + (int)(g * 255.0f) * 256 + (int)(b * 255.0f);
        }
        int backgroundColor = -16777216 + (int)(r * 255.0f) * 65536 + (int)(g * 255.0f) * 256 + (int)(b * 255.0f);
        if (!this.world.method_28103().method_62183(this.world.method_30274(0.0f))) {
            return backgroundColor;
        }
        int sunsetColor = this.world.method_28103().method_62184(this.world.method_30274(0.0f));
        return ColorUtils.colorAdder(sunsetColor, backgroundColor);
    }

    public int[] getLightmapArray() {
        return this.lightmapColors;
    }

    public int getLightmapColor(int skyLight, int blockLight) {
        if (this.lightmapColors == null) {
            return 0;
        }
        return class_9848.method_61337((int)this.lightmapColors[blockLight + skyLight * 16]);
    }

    public void drawMinimap(class_332 drawContext) {
        int scScaleOrig = 1;
        while (this.minecraft.method_22683().method_4489() / (scScaleOrig + 1) >= 320 && this.minecraft.method_22683().method_4506() / (scScaleOrig + 1) >= 240) {
            ++scScaleOrig;
        }
        int scScale = Math.max(1, scScaleOrig + (this.fullscreenMap ? 0 : this.options.sizeModifier));
        double scaledWidthD = (double)this.minecraft.method_22683().method_4489() / (double)scScale;
        double scaledHeightD = (double)this.minecraft.method_22683().method_4506() / (double)scScale;
        this.scWidth = class_3532.method_15384((double)scaledWidthD);
        this.scHeight = class_3532.method_15384((double)scaledHeightD);
        float scaleProj = (float)scScale / (float)this.minecraft.method_22683().method_4495();
        int mapX = this.options.mapCorner != 0 && this.options.mapCorner != 3 ? this.scWidth - 37 : 37;
        int mapY = this.options.mapCorner != 0 && this.options.mapCorner != 1 ? this.scHeight - 37 : 37;
        float statusIconOffset = 0.0f;
        if (VoxelMap.mapOptions.moveMapDownWhileStatusEffect && this.options.mapCorner == 1 && !VoxelConstants.getPlayer().method_6026().isEmpty()) {
            for (class_1293 statusEffectInstance : VoxelConstants.getPlayer().method_6026()) {
                if (!statusEffectInstance.method_5592()) continue;
                if (((class_1291)statusEffectInstance.method_5579().comp_349()).method_5573()) {
                    statusIconOffset = Math.max(statusIconOffset, 24.0f);
                    continue;
                }
                statusIconOffset = 50.0f;
            }
            int scHeight = this.minecraft.method_22683().method_4502();
            float resFactor = (float)this.scHeight / (float)scHeight;
            mapY += (int)(statusIconOffset * resFactor);
        }
        Map.statusIconOffset = statusIconOffset;
        if (!this.options.hide) {
            if (this.fullscreenMap) {
                this.renderMapFull(drawContext, this.scWidth, this.scHeight, scaleProj);
                this.drawArrow(drawContext, this.scWidth / 2, this.scHeight / 2, scaleProj);
            } else {
                this.renderMap(drawContext, mapX, mapY, scScale, scaleProj);
                this.drawDirections(drawContext, mapX, mapY, scaleProj);
                this.drawArrow(drawContext, mapX, mapY, scaleProj);
            }
        }
        if (this.options.coords) {
            this.showCoords(drawContext, mapX, mapY, scaleProj);
        }
    }

    private void checkForChanges() {
        boolean changed = false;
        if (this.colorManager.checkForChanges()) {
            changed = true;
        }
        if (this.options.isChanged()) {
            if (this.options.filtering) {
                this.mapImages = this.mapImagesFiltered;
                this.mapResources = this.resourceMapImageFiltered;
            } else {
                this.mapImages = this.mapImagesUnfiltered;
                this.mapResources = this.resourceMapImageUnfiltered;
            }
            changed = true;
            this.setZoomScale();
        }
        if (changed) {
            this.doFullRender = true;
            VoxelConstants.getVoxelMapInstance().getSettingsAndLightingChangeNotifier().notifyOfChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mapCalc(boolean full) {
        int color24;
        int imageX;
        int imageY;
        boolean beneathRendering;
        int currentX = GameVariableAccessShim.xCoord();
        int currentZ = GameVariableAccessShim.zCoord();
        int currentY = GameVariableAccessShim.yCoord();
        int offsetX = currentX - this.lastX;
        int offsetZ = currentZ - this.lastZ;
        int offsetY = currentY - this.lastY;
        int zoom = this.zoom;
        int multi = (int)Math.pow(2.0, zoom);
        class_638 world = this.world;
        boolean needHeightMap = false;
        boolean needLight = false;
        boolean skyColorChanged = false;
        int skyColor = this.colorManager.getAirColor();
        if (this.lastSkyColor != skyColor) {
            skyColorChanged = true;
            this.lastSkyColor = skyColor;
        }
        if (this.options.lightmap) {
            int torchOffset = this.options.realTimeTorches ? 8 : 0;
            for (int t = 0; t < 16; ++t) {
                int newValue = this.getLightmapColor(t, torchOffset);
                if (this.lastLightmapValues[t] == newValue) continue;
                needLight = true;
                this.lastLightmapValues[t] = newValue;
            }
        }
        if (offsetY != 0) {
            ++this.heightMapFudge;
        } else if (this.heightMapFudge != 0) {
            ++this.heightMapFudge;
        }
        if (full || Math.abs(offsetY) >= this.heightMapResetHeight || this.heightMapFudge > this.heightMapResetTime) {
            if (this.lastY != currentY) {
                needHeightMap = true;
            }
            this.lastY = currentY;
            this.heightMapFudge = 0;
        }
        if (Math.abs(offsetX) > 32 * multi || Math.abs(offsetZ) > 32 * multi) {
            full = true;
        }
        boolean nether = false;
        boolean caves = false;
        MutableBlockPos blockPos = MutableBlockPosCache.get();
        blockPos.setXYZ(this.lastX, Math.max(Math.min(GameVariableAccessShim.yCoord(), world.method_31600() - 1), world.method_31607()), this.lastZ);
        if (VoxelConstants.getPlayer().method_73183().method_8597().comp_643()) {
            boolean netherPlayerInOpen = world.method_22350((class_2338)blockPos).method_12005(class_2902.class_2903.field_13197, blockPos.method_10263() & 0xF, blockPos.method_10260() & 0xF) <= currentY;
            boolean bl = nether = currentY < 126;
            if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && currentY >= 126 && !netherPlayerInOpen) {
                caves = true;
            }
        } else if (VoxelConstants.getClientWorld().method_28103().method_29993() && !VoxelConstants.getClientWorld().method_8597().comp_642()) {
            boolean endPlayerInOpen;
            boolean bl = endPlayerInOpen = world.method_22350((class_2338)blockPos).method_12005(class_2902.class_2903.field_13197, blockPos.method_10263() & 0xF, blockPos.method_10260() & 0xF) <= currentY;
            if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && !endPlayerInOpen) {
                caves = true;
            }
        } else if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && world.method_8314(class_1944.field_9284, (class_2338)blockPos) <= 0) {
            caves = true;
        }
        MutableBlockPosCache.release(blockPos);
        boolean bl = beneathRendering = caves || nether;
        if (this.lastBeneathRendering != beneathRendering) {
            full = true;
        }
        this.lastBeneathRendering = beneathRendering;
        boolean needHeightAndID = needHeightMap && (nether || caves);
        Object object = this.coordinateLock;
        synchronized (object) {
            if (!full) {
                this.mapImages[zoom].moveY(offsetZ);
                this.mapImages[zoom].moveX(offsetX);
            }
            this.lastX = currentX;
            this.lastZ = currentZ;
        }
        int startX = currentX - 16 * multi;
        int startZ = currentZ - 16 * multi;
        if (!full) {
            this.mapData[zoom].moveZ(offsetZ);
            this.mapData[zoom].moveX(offsetX);
            for (imageY = offsetZ > 0 ? 32 * multi - 1 : -offsetZ - 1; imageY >= (offsetZ > 0 ? 32 * multi - offsetZ : 0); --imageY) {
                for (imageX = 0; imageX < 32 * multi; ++imageX) {
                    color24 = this.getPixelColor(true, true, true, true, nether, caves, world, zoom, multi, startX, startZ, imageX, imageY);
                    this.mapImages[zoom].setRGB(imageX, imageY, color24);
                }
            }
            for (imageY = 32 * multi - 1; imageY >= 0; --imageY) {
                for (imageX = offsetX > 0 ? 32 * multi - offsetX : 0; imageX < (offsetX > 0 ? 32 * multi : -offsetX); ++imageX) {
                    color24 = this.getPixelColor(true, true, true, true, nether, caves, world, zoom, multi, startX, startZ, imageX, imageY);
                    this.mapImages[zoom].setRGB(imageX, imageY, color24);
                }
            }
        }
        if (full || this.options.heightmap && needHeightMap || needHeightAndID || this.options.lightmap && needLight || skyColorChanged) {
            for (imageY = 32 * multi - 1; imageY >= 0; --imageY) {
                for (imageX = 0; imageX < 32 * multi; ++imageX) {
                    color24 = this.getPixelColor(full, full || needHeightAndID, full, full || needLight || needHeightAndID, nether, caves, world, zoom, multi, startX, startZ, imageX, imageY);
                    this.mapImages[zoom].setRGB(imageX, imageY, color24);
                }
            }
        }
        if ((full || offsetX != 0 || offsetZ != 0 || !this.lastFullscreen) && this.fullscreenMap && this.options.biomeOverlay != 0) {
            this.mapData[zoom].segmentBiomes();
            this.mapData[zoom].findCenterOfSegments(!this.options.oldNorth);
        }
        this.lastFullscreen = this.fullscreenMap;
        if (full || offsetX != 0 || offsetZ != 0 || needHeightMap || needLight || skyColorChanged) {
            this.imageChanged = true;
        }
        if (needLight || skyColorChanged) {
            VoxelConstants.getVoxelMapInstance().getSettingsAndLightingChangeNotifier().notifyOfChanges();
        }
    }

    @Override
    public void handleChangeInWorld(int chunkX, int chunkZ) {
        try {
            this.chunkCache[this.zoom].registerChangeAt(chunkX, chunkZ);
        }
        catch (Exception e) {
            VoxelConstants.getLogger().warn((Object)e);
        }
    }

    @Override
    public void processChunk(class_2818 chunk) {
        this.rectangleCalc(chunk.method_12004().field_9181 * 16, chunk.method_12004().field_9180 * 16, chunk.method_12004().field_9181 * 16 + 15, chunk.method_12004().field_9180 * 16 + 15);
    }

    private void rectangleCalc(int left, int top, int right, int bottom) {
        boolean nether = false;
        boolean caves = false;
        MutableBlockPos blockPos = MutableBlockPosCache.get();
        blockPos.setXYZ(this.lastX, Math.max(Math.min(GameVariableAccessShim.yCoord(), this.world.method_31600()), this.world.method_31607()), this.lastZ);
        int currentY = GameVariableAccessShim.yCoord();
        if (VoxelConstants.getPlayer().method_73183().method_8597().comp_643()) {
            boolean netherPlayerInOpen = this.world.method_22350((class_2338)blockPos).method_12005(class_2902.class_2903.field_13197, blockPos.method_10263() & 0xF, blockPos.method_10260() & 0xF) <= currentY;
            boolean bl = nether = currentY < 126;
            if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && currentY >= 126 && !netherPlayerInOpen) {
                caves = true;
            }
        } else if (VoxelConstants.getClientWorld().method_28103().method_29993() && !VoxelConstants.getClientWorld().method_8597().comp_642()) {
            boolean endPlayerInOpen;
            boolean bl = endPlayerInOpen = this.world.method_22350((class_2338)blockPos).method_12005(class_2902.class_2903.field_13197, blockPos.method_10263() & 0xF, blockPos.method_10260() & 0xF) <= currentY;
            if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && !endPlayerInOpen) {
                caves = true;
            }
        } else if (this.options.cavesAllowed.booleanValue() && this.options.showCaves && this.world.method_8314(class_1944.field_9284, (class_2338)blockPos) <= 0) {
            caves = true;
        }
        MutableBlockPosCache.release(blockPos);
        int zoom = this.zoom;
        int startX = this.lastX;
        int startZ = this.lastZ;
        class_638 world = this.world;
        int multi = (int)Math.pow(2.0, zoom);
        left = left - (startX -= 16 * multi) - 1;
        right = right - startX + 1;
        top = top - (startZ -= 16 * multi) - 1;
        bottom = bottom - startZ + 1;
        left = Math.max(0, left);
        right = Math.min(32 * multi - 1, right);
        top = Math.max(0, top);
        for (int imageY = bottom = Math.min(32 * multi - 1, bottom); imageY >= top; --imageY) {
            for (int imageX = left; imageX <= right; ++imageX) {
                int color24 = this.getPixelColor(true, true, true, true, nether, caves, world, zoom, multi, startX, startZ, imageX, imageY);
                this.mapImages[zoom].setRGB(imageX, imageY, color24);
            }
        }
        this.imageChanged = true;
    }

    private int getPixelColor(boolean needBiome, boolean needHeightAndID, boolean needTint, boolean needLight, boolean nether, boolean caves, class_638 world, int zoom, int multi, int startX, int startZ, int imageX, int imageY) {
        int color24;
        class_1959 biome;
        int surfaceHeight = Short.MIN_VALUE;
        int seafloorHeight = Short.MIN_VALUE;
        int transparentHeight = Short.MIN_VALUE;
        int foliageHeight = Short.MIN_VALUE;
        int seafloorColor = 0;
        int transparentColor = 0;
        int foliageColor = 0;
        this.surfaceBlockState = null;
        this.transparentBlockState = BlockRepository.air.method_9564();
        class_2680 foliageBlockState = BlockRepository.air.method_9564();
        class_2680 seafloorBlockState = BlockRepository.air.method_9564();
        boolean surfaceBlockChangeForcedTint = false;
        boolean transparentBlockChangeForcedTint = false;
        boolean foliageBlockChangeForcedTint = false;
        boolean seafloorBlockChangeForcedTint = false;
        MutableBlockPos blockPos = MutableBlockPosCache.get();
        MutableBlockPos tempBlockPos = MutableBlockPosCache.get();
        blockPos.withXYZ(startX + imageX, 64, startZ + imageY);
        if (needBiome) {
            biome = (class_1959)world.method_23753((class_2338)blockPos).comp_349();
            this.mapData[zoom].setBiome(imageX, imageY, biome);
        } else {
            biome = this.mapData[zoom].getBiome(imageX, imageY);
        }
        if (this.options.biomeOverlay == 1) {
            color24 = biome != null ? class_9848.method_61337((int)(BiomeRepository.getBiomeColor(biome) | 0xFF000000)) : 0;
        } else {
            int light;
            int surfaceColor;
            int seafloorBlockStateID;
            int transparentBlockStateID;
            int foliageBlockStateID;
            int surfaceBlockStateID;
            boolean solid = false;
            if (needHeightAndID) {
                if (!nether && !caves) {
                    class_265 voxelShape;
                    boolean hasOpacity;
                    class_2818 chunk = world.method_8500((class_2338)blockPos);
                    transparentHeight = chunk.method_12005(class_2902.class_2903.field_13197, blockPos.method_10263() & 0xF, blockPos.method_10260() & 0xF) + 1;
                    this.transparentBlockState = world.method_8320((class_2338)blockPos.withXYZ(startX + imageX, transparentHeight - 1, startZ + imageY));
                    class_3610 fluidState = this.transparentBlockState.method_26227();
                    if (fluidState != class_3612.field_15906.method_15785()) {
                        this.transparentBlockState = fluidState.method_15759();
                    }
                    surfaceHeight = transparentHeight;
                    this.surfaceBlockState = this.transparentBlockState;
                    boolean bl = hasOpacity = this.surfaceBlockState.method_26193() > 0;
                    if (!hasOpacity && this.surfaceBlockState.method_26225() && this.surfaceBlockState.method_26211()) {
                        voxelShape = this.surfaceBlockState.method_26173(class_2350.field_11033);
                        hasOpacity = class_259.method_20713((class_265)voxelShape, (class_265)class_259.method_1073());
                        voxelShape = this.surfaceBlockState.method_26173(class_2350.field_11036);
                        boolean bl2 = hasOpacity = hasOpacity || class_259.method_20713((class_265)class_259.method_1073(), (class_265)voxelShape);
                    }
                    while (!hasOpacity && surfaceHeight > world.method_31607()) {
                        foliageBlockState = this.surfaceBlockState;
                        this.surfaceBlockState = world.method_8320((class_2338)blockPos.withXYZ(startX + imageX, --surfaceHeight - 1, startZ + imageY));
                        fluidState = this.surfaceBlockState.method_26227();
                        if (fluidState != class_3612.field_15906.method_15785()) {
                            this.surfaceBlockState = fluidState.method_15759();
                        }
                        if ((hasOpacity = this.surfaceBlockState.method_26193() > 0) || !this.surfaceBlockState.method_26225() || !this.surfaceBlockState.method_26211()) continue;
                        voxelShape = this.surfaceBlockState.method_26173(class_2350.field_11033);
                        hasOpacity = class_259.method_20713((class_265)voxelShape, (class_265)class_259.method_1073());
                        voxelShape = this.surfaceBlockState.method_26173(class_2350.field_11036);
                        hasOpacity = hasOpacity || class_259.method_20713((class_265)class_259.method_1073(), (class_265)voxelShape);
                    }
                    if (surfaceHeight == transparentHeight) {
                        transparentHeight = Short.MIN_VALUE;
                        this.transparentBlockState = BlockRepository.air.method_9564();
                        foliageBlockState = world.method_8320((class_2338)blockPos.withXYZ(startX + imageX, surfaceHeight, startZ + imageY));
                    }
                    if (foliageBlockState.method_26204() == class_2246.field_10477) {
                        this.surfaceBlockState = foliageBlockState;
                        foliageBlockState = BlockRepository.air.method_9564();
                    }
                    if (foliageBlockState == this.transparentBlockState) {
                        foliageBlockState = BlockRepository.air.method_9564();
                    }
                    foliageHeight = foliageBlockState != null && !(foliageBlockState.method_26204() instanceof class_2189) ? surfaceHeight + 1 : Short.MIN_VALUE;
                    class_2248 material = this.surfaceBlockState.method_26204();
                    if (material == class_2246.field_10382 || material == class_2246.field_10295) {
                        seafloorHeight = surfaceHeight;
                        seafloorBlockState = world.method_8320((class_2338)blockPos.withXYZ(startX + imageX, surfaceHeight - 1, startZ + imageY));
                        while (seafloorBlockState.method_26193() < 5 && !(seafloorBlockState.method_26204() instanceof class_2397) && seafloorHeight > world.method_31607() + 1) {
                            material = seafloorBlockState.method_26204();
                            if (transparentHeight == Short.MIN_VALUE && material != class_2246.field_10295 && material != class_2246.field_10382 && class_2902.class_2903.field_13197.method_16402().test(seafloorBlockState)) {
                                transparentHeight = seafloorHeight;
                                this.transparentBlockState = seafloorBlockState;
                            }
                            if (foliageHeight == Short.MIN_VALUE && seafloorHeight != transparentHeight && this.transparentBlockState != seafloorBlockState && material != class_2246.field_10295 && material != class_2246.field_10382 && !(material instanceof class_2189) && material != class_2246.field_10422) {
                                foliageHeight = seafloorHeight;
                                foliageBlockState = seafloorBlockState;
                            }
                            seafloorBlockState = world.method_8320((class_2338)blockPos.withXYZ(startX + imageX, --seafloorHeight - 1, startZ + imageY));
                        }
                        if (seafloorBlockState.method_26204() == class_2246.field_10382) {
                            seafloorBlockState = BlockRepository.air.method_9564();
                        }
                    }
                } else {
                    surfaceHeight = this.getNetherHeight(startX + imageX, startZ + imageY);
                    this.surfaceBlockState = world.method_8320((class_2338)blockPos.withXYZ(startX + imageX, surfaceHeight - 1, startZ + imageY));
                    surfaceBlockStateID = BlockRepository.getStateId(this.surfaceBlockState);
                    foliageHeight = surfaceHeight + 1;
                    blockPos.setXYZ(startX + imageX, foliageHeight - 1, startZ + imageY);
                    foliageBlockState = world.method_8320((class_2338)blockPos);
                    class_2248 material = foliageBlockState.method_26204();
                    if (material != class_2246.field_10477 && !(material instanceof class_2189) && material != class_2246.field_10164 && material != class_2246.field_10382) {
                        foliageBlockStateID = BlockRepository.getStateId(foliageBlockState);
                    } else {
                        foliageHeight = Short.MIN_VALUE;
                    }
                }
                surfaceBlockStateID = BlockRepository.getStateId(this.surfaceBlockState);
                if (this.options.biomes && this.surfaceBlockState != this.mapData[zoom].getBlockstate(imageX, imageY)) {
                    surfaceBlockChangeForcedTint = true;
                }
                this.mapData[zoom].setHeight(imageX, imageY, surfaceHeight);
                this.mapData[zoom].setBlockstateID(imageX, imageY, surfaceBlockStateID);
                if (this.options.biomes && this.transparentBlockState != this.mapData[zoom].getTransparentBlockstate(imageX, imageY)) {
                    transparentBlockChangeForcedTint = true;
                }
                this.mapData[zoom].setTransparentHeight(imageX, imageY, transparentHeight);
                transparentBlockStateID = BlockRepository.getStateId(this.transparentBlockState);
                this.mapData[zoom].setTransparentBlockstateID(imageX, imageY, transparentBlockStateID);
                if (this.options.biomes && foliageBlockState != this.mapData[zoom].getFoliageBlockstate(imageX, imageY)) {
                    foliageBlockChangeForcedTint = true;
                }
                this.mapData[zoom].setFoliageHeight(imageX, imageY, foliageHeight);
                foliageBlockStateID = BlockRepository.getStateId(foliageBlockState);
                this.mapData[zoom].setFoliageBlockstateID(imageX, imageY, foliageBlockStateID);
                if (this.options.biomes && seafloorBlockState != this.mapData[zoom].getOceanFloorBlockstate(imageX, imageY)) {
                    seafloorBlockChangeForcedTint = true;
                }
                this.mapData[zoom].setOceanFloorHeight(imageX, imageY, seafloorHeight);
                seafloorBlockStateID = BlockRepository.getStateId(seafloorBlockState);
                this.mapData[zoom].setOceanFloorBlockstateID(imageX, imageY, seafloorBlockStateID);
            } else {
                surfaceHeight = this.mapData[zoom].getHeight(imageX, imageY);
                surfaceBlockStateID = this.mapData[zoom].getBlockstateID(imageX, imageY);
                this.surfaceBlockState = BlockRepository.getStateById(surfaceBlockStateID);
                transparentHeight = this.mapData[zoom].getTransparentHeight(imageX, imageY);
                transparentBlockStateID = this.mapData[zoom].getTransparentBlockstateID(imageX, imageY);
                this.transparentBlockState = BlockRepository.getStateById(transparentBlockStateID);
                foliageHeight = this.mapData[zoom].getFoliageHeight(imageX, imageY);
                foliageBlockStateID = this.mapData[zoom].getFoliageBlockstateID(imageX, imageY);
                foliageBlockState = BlockRepository.getStateById(foliageBlockStateID);
                seafloorHeight = this.mapData[zoom].getOceanFloorHeight(imageX, imageY);
                seafloorBlockStateID = this.mapData[zoom].getOceanFloorBlockstateID(imageX, imageY);
                seafloorBlockState = BlockRepository.getStateById(seafloorBlockStateID);
            }
            if (surfaceHeight == Short.MIN_VALUE) {
                surfaceHeight = this.lastY + 1;
                solid = true;
            }
            if (this.surfaceBlockState.method_26204() == class_2246.field_10164) {
                solid = false;
            }
            if (this.options.biomes) {
                int tint;
                surfaceColor = this.colorManager.getBlockColor(blockPos, surfaceBlockStateID, biome);
                if (!needTint && !surfaceBlockChangeForcedTint) {
                    tint = this.mapData[zoom].getBiomeTint(imageX, imageY);
                } else {
                    tint = this.colorManager.getBiomeTint(this.mapData[zoom], (class_1937)world, this.surfaceBlockState, surfaceBlockStateID, blockPos.withXYZ(startX + imageX, surfaceHeight - 1, startZ + imageY), tempBlockPos, startX, startZ);
                    this.mapData[zoom].setBiomeTint(imageX, imageY, tint);
                }
                if (tint != -1) {
                    surfaceColor = ColorUtils.colorMultiplier(surfaceColor, tint);
                }
            } else {
                surfaceColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, surfaceBlockStateID);
            }
            surfaceColor = this.applyHeight(surfaceColor, nether, caves, (class_1937)world, zoom, multi, startX, startZ, imageX, imageY, surfaceHeight, solid, 1);
            if (needLight) {
                light = this.getLight(surfaceColor, this.surfaceBlockState, (class_1937)world, startX + imageX, startZ + imageY, surfaceHeight, solid);
                this.mapData[zoom].setLight(imageX, imageY, light);
            } else {
                light = this.mapData[zoom].getLight(imageX, imageY);
            }
            if (light == 0) {
                surfaceColor = 0;
            } else if (light != 255) {
                surfaceColor = ColorUtils.colorMultiplier(surfaceColor, light);
            }
            if (this.options.waterTransparency && seafloorHeight != Short.MIN_VALUE) {
                int seafloorLight;
                if (!this.options.biomes) {
                    seafloorColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, seafloorBlockStateID);
                } else {
                    int tint;
                    seafloorColor = this.colorManager.getBlockColor(blockPos, seafloorBlockStateID, biome);
                    if (!needTint && !seafloorBlockChangeForcedTint) {
                        tint = this.mapData[zoom].getOceanFloorBiomeTint(imageX, imageY);
                    } else {
                        tint = this.colorManager.getBiomeTint(this.mapData[zoom], (class_1937)world, seafloorBlockState, seafloorBlockStateID, blockPos.withXYZ(startX + imageX, seafloorHeight - 1, startZ + imageY), tempBlockPos, startX, startZ);
                        this.mapData[zoom].setOceanFloorBiomeTint(imageX, imageY, tint);
                    }
                    if (tint != -1) {
                        seafloorColor = ColorUtils.colorMultiplier(seafloorColor, tint);
                    }
                }
                seafloorColor = this.applyHeight(seafloorColor, nether, caves, (class_1937)world, zoom, multi, startX, startZ, imageX, imageY, seafloorHeight, solid, 0);
                if (needLight) {
                    seafloorLight = this.getLight(seafloorColor, seafloorBlockState, (class_1937)world, startX + imageX, startZ + imageY, seafloorHeight, solid);
                    blockPos.setXYZ(startX + imageX, seafloorHeight, startZ + imageY);
                    class_2680 blockStateAbove = world.method_8320((class_2338)blockPos);
                    class_2248 materialAbove = blockStateAbove.method_26204();
                    if (this.options.lightmap && materialAbove == class_2246.field_10295) {
                        int multiplier = (Boolean)this.minecraft.field_1690.method_41792().method_41753() != false ? 200 : 120;
                        seafloorLight = ColorUtils.colorMultiplier(seafloorLight, 0xFF000000 | multiplier << 16 | multiplier << 8 | multiplier);
                    }
                    this.mapData[zoom].setOceanFloorLight(imageX, imageY, seafloorLight);
                } else {
                    seafloorLight = this.mapData[zoom].getOceanFloorLight(imageX, imageY);
                }
                if (seafloorLight == 0) {
                    seafloorColor = 0;
                } else if (seafloorLight != 255) {
                    seafloorColor = ColorUtils.colorMultiplier(seafloorColor, seafloorLight);
                }
            }
            if (this.options.blockTransparency) {
                if (transparentHeight != Short.MIN_VALUE && this.transparentBlockState != null && this.transparentBlockState != BlockRepository.air.method_9564()) {
                    int transparentLight;
                    if (this.options.biomes) {
                        int tint;
                        transparentColor = this.colorManager.getBlockColor(blockPos, transparentBlockStateID, biome);
                        if (!needTint && !transparentBlockChangeForcedTint) {
                            tint = this.mapData[zoom].getTransparentBiomeTint(imageX, imageY);
                        } else {
                            tint = this.colorManager.getBiomeTint(this.mapData[zoom], (class_1937)world, this.transparentBlockState, transparentBlockStateID, blockPos.withXYZ(startX + imageX, transparentHeight - 1, startZ + imageY), tempBlockPos, startX, startZ);
                            this.mapData[zoom].setTransparentBiomeTint(imageX, imageY, tint);
                        }
                        if (tint != -1) {
                            transparentColor = ColorUtils.colorMultiplier(transparentColor, tint);
                        }
                    } else {
                        transparentColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, transparentBlockStateID);
                    }
                    transparentColor = this.applyHeight(transparentColor, nether, caves, (class_1937)world, zoom, multi, startX, startZ, imageX, imageY, transparentHeight, solid, 3);
                    if (needLight) {
                        transparentLight = this.getLight(transparentColor, this.transparentBlockState, (class_1937)world, startX + imageX, startZ + imageY, transparentHeight, solid);
                        this.mapData[zoom].setTransparentLight(imageX, imageY, transparentLight);
                    } else {
                        transparentLight = this.mapData[zoom].getTransparentLight(imageX, imageY);
                    }
                    if (transparentLight == 0) {
                        transparentColor = 0;
                    } else if (transparentLight != 255) {
                        transparentColor = ColorUtils.colorMultiplier(transparentColor, transparentLight);
                    }
                }
                if (foliageHeight != Short.MIN_VALUE && foliageBlockState != null && foliageBlockState != BlockRepository.air.method_9564()) {
                    int foliageLight;
                    if (!this.options.biomes) {
                        foliageColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, foliageBlockStateID);
                    } else {
                        int tint;
                        foliageColor = this.colorManager.getBlockColor(blockPos, foliageBlockStateID, biome);
                        if (!needTint && !foliageBlockChangeForcedTint) {
                            tint = this.mapData[zoom].getFoliageBiomeTint(imageX, imageY);
                        } else {
                            tint = this.colorManager.getBiomeTint(this.mapData[zoom], (class_1937)world, foliageBlockState, foliageBlockStateID, blockPos.withXYZ(startX + imageX, foliageHeight - 1, startZ + imageY), tempBlockPos, startX, startZ);
                            this.mapData[zoom].setFoliageBiomeTint(imageX, imageY, tint);
                        }
                        if (tint != -1) {
                            foliageColor = ColorUtils.colorMultiplier(foliageColor, tint);
                        }
                    }
                    foliageColor = this.applyHeight(foliageColor, nether, caves, (class_1937)world, zoom, multi, startX, startZ, imageX, imageY, foliageHeight, solid, 2);
                    if (needLight) {
                        foliageLight = this.getLight(foliageColor, foliageBlockState, (class_1937)world, startX + imageX, startZ + imageY, foliageHeight, solid);
                        this.mapData[zoom].setFoliageLight(imageX, imageY, foliageLight);
                    } else {
                        foliageLight = this.mapData[zoom].getFoliageLight(imageX, imageY);
                    }
                    if (foliageLight == 0) {
                        foliageColor = 0;
                    } else if (foliageLight != 255) {
                        foliageColor = ColorUtils.colorMultiplier(foliageColor, foliageLight);
                    }
                }
            }
            if (seafloorColor != 0 && seafloorHeight > Short.MIN_VALUE) {
                color24 = seafloorColor;
                if (foliageColor != 0 && foliageHeight <= surfaceHeight) {
                    color24 = ColorUtils.colorAdder(foliageColor, seafloorColor);
                }
                if (transparentColor != 0 && transparentHeight <= surfaceHeight) {
                    color24 = ColorUtils.colorAdder(transparentColor, color24);
                }
                color24 = ColorUtils.colorAdder(surfaceColor, color24);
            } else {
                color24 = surfaceColor;
            }
            if (foliageColor != 0 && foliageHeight > surfaceHeight) {
                color24 = ColorUtils.colorAdder(foliageColor, color24);
            }
            if (transparentColor != 0 && transparentHeight > surfaceHeight) {
                color24 = ColorUtils.colorAdder(transparentColor, color24);
            }
            if (this.options.biomeOverlay == 2) {
                int bc = 0;
                if (biome != null) {
                    bc = class_9848.method_61337((int)BiomeRepository.getBiomeColor(biome));
                }
                bc = 0x7F000000 | bc;
                color24 = ColorUtils.colorAdder(bc, color24);
            }
        }
        MutableBlockPosCache.release(blockPos);
        MutableBlockPosCache.release(tempBlockPos);
        return MapUtils.doSlimeAndGrid(color24, world, startX + imageX, startZ + imageY);
    }

    private int getBlockHeight(boolean nether, boolean caves, class_1937 world, int x, int z) {
        MutableBlockPos blockPos = MutableBlockPosCache.get();
        int playerHeight = GameVariableAccessShim.yCoord();
        blockPos.setXYZ(x, playerHeight, z);
        class_2818 chunk = (class_2818)world.method_22350((class_2338)blockPos);
        int height = chunk.method_12005(class_2902.class_2903.field_13197, blockPos.method_10263() & 0xF, blockPos.method_10260() & 0xF) + 1;
        class_2680 blockState = world.method_8320((class_2338)blockPos.withXYZ(x, height - 1, z));
        class_3610 fluidState = this.transparentBlockState.method_26227();
        if (fluidState != class_3612.field_15906.method_15785()) {
            blockState = fluidState.method_15759();
        }
        while (blockState.method_26193() == 0 && height > world.method_31607()) {
            blockState = world.method_8320((class_2338)blockPos.withXYZ(x, --height - 1, z));
            fluidState = this.surfaceBlockState.method_26227();
            if (fluidState == class_3612.field_15906.method_15785()) continue;
            blockState = fluidState.method_15759();
        }
        MutableBlockPosCache.release(blockPos);
        return (nether || caves) && height > playerHeight ? this.getNetherHeight(x, z) : height;
    }

    private int getNetherHeight(int x, int z) {
        MutableBlockPos blockPos = MutableBlockPosCache.get();
        int y = this.lastY;
        blockPos.setXYZ(x, y, z);
        class_2680 blockState = this.world.method_8320((class_2338)blockPos);
        if (blockState.method_26193() == 0 && blockState.method_26204() != class_2246.field_10164) {
            while (y > this.world.method_31607()) {
                blockPos.setXYZ(x, --y, z);
                blockState = this.world.method_8320((class_2338)blockPos);
                if (blockState.method_26193() <= 0 && blockState.method_26204() != class_2246.field_10164) continue;
                MutableBlockPosCache.release(blockPos);
                return y + 1;
            }
            MutableBlockPosCache.release(blockPos);
            return y;
        }
        while (y <= this.lastY + 10 && y < this.world.method_31600()) {
            blockPos.setXYZ(x, ++y, z);
            blockState = this.world.method_8320((class_2338)blockPos);
            if (blockState.method_26193() != 0 || blockState.method_26204() == class_2246.field_10164) continue;
            MutableBlockPosCache.release(blockPos);
            return y;
        }
        MutableBlockPosCache.release(blockPos);
        return this.world.method_31607() - 1;
    }

    private int getSeafloorHeight(class_1937 world, int x, int z, int height) {
        MutableBlockPos blockPos = MutableBlockPosCache.get();
        class_2680 blockState = world.method_8320((class_2338)blockPos.withXYZ(x, height - 1, z));
        while (blockState.method_26193() < 5 && !(blockState.method_26204() instanceof class_2397) && height > world.method_31607() + 1) {
            blockState = world.method_8320((class_2338)blockPos.withXYZ(x, --height - 1, z));
        }
        MutableBlockPosCache.release(blockPos);
        return height;
    }

    private int getTransparentHeight(boolean nether, boolean caves, class_1937 world, int x, int z, int height) {
        int transHeight;
        MutableBlockPos blockPos = MutableBlockPosCache.get();
        if (!caves && !nether) {
            transHeight = world.method_8598(class_2902.class_2903.field_13197, (class_2338)blockPos.withXYZ(x, height, z)).method_10264();
            if (transHeight <= height) {
                transHeight = Short.MIN_VALUE;
            }
        } else {
            transHeight = Short.MIN_VALUE;
        }
        class_2680 blockState = world.method_8320((class_2338)blockPos.withXYZ(x, transHeight - 1, z));
        class_2248 material = blockState.method_26204();
        if (transHeight == height + 1 && material == class_2246.field_10477) {
            transHeight = Short.MIN_VALUE;
        }
        if (material == class_2246.field_10499 && (material = (blockState = world.method_8320((class_2338)blockPos.withXYZ(x, ++transHeight - 1, z))).method_26204()) instanceof class_2189) {
            transHeight = Short.MIN_VALUE;
        }
        MutableBlockPosCache.release(blockPos);
        return transHeight;
    }

    private int applyHeight(int color24, boolean nether, boolean caves, class_1937 world, int zoom, int multi, int startX, int startZ, int imageX, int imageY, int height, boolean solid, int layer) {
        if (color24 != this.colorManager.getAirColor() && color24 != 0 && (this.options.heightmap || this.options.slopemap) && !solid) {
            int heightComp = -1;
            double sc = 0.0;
            if (!this.options.slopemap) {
                int diff = height - this.lastY;
                sc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 1.8;
                if (diff < 0) {
                    sc = 0.0 - sc;
                }
            } else {
                int diff;
                if (imageX > 0 && imageY < 32 * multi - 1) {
                    class_2248 block;
                    if (layer == 0) {
                        heightComp = this.mapData[zoom].getOceanFloorHeight(imageX - 1, imageY + 1);
                    }
                    if (layer == 1) {
                        heightComp = this.mapData[zoom].getHeight(imageX - 1, imageY + 1);
                    }
                    if (layer == 2) {
                        heightComp = height;
                    }
                    if (layer == 3 && (heightComp = this.mapData[zoom].getTransparentHeight(imageX - 1, imageY + 1)) == Short.MIN_VALUE && ((block = BlockRepository.getStateById(this.mapData[zoom].getTransparentBlockstateID(imageX, imageY)).method_26204()) == class_2246.field_10033 || block instanceof class_2506)) {
                        heightComp = this.mapData[zoom].getHeight(imageX - 1, imageY + 1);
                    }
                } else {
                    int baseHeight;
                    if (layer == 0) {
                        baseHeight = this.getBlockHeight(nether, caves, world, startX + imageX - 1, startZ + imageY + 1);
                        heightComp = this.getSeafloorHeight(world, startX + imageX - 1, startZ + imageY + 1, baseHeight);
                    }
                    if (layer == 1) {
                        heightComp = this.getBlockHeight(nether, caves, world, startX + imageX - 1, startZ + imageY + 1);
                    }
                    if (layer == 2) {
                        heightComp = height;
                    }
                    if (layer == 3 && (heightComp = this.getTransparentHeight(nether, caves, world, startX + imageX - 1, startZ + imageY + 1, baseHeight = this.getBlockHeight(nether, caves, world, startX + imageX - 1, startZ + imageY + 1))) == Short.MIN_VALUE) {
                        MutableBlockPos blockPos = MutableBlockPosCache.get();
                        class_2680 blockState = world.method_8320((class_2338)blockPos.withXYZ(startX + imageX, height - 1, startZ + imageY));
                        MutableBlockPosCache.release(blockPos);
                        class_2248 block = blockState.method_26204();
                        if (block == class_2246.field_10033 || block instanceof class_2506) {
                            heightComp = baseHeight;
                        }
                    }
                }
                if (heightComp == Short.MIN_VALUE) {
                    heightComp = height;
                }
                if ((diff = heightComp - height) != 0) {
                    sc = diff > 0 ? 1.0 : -1.0;
                    sc /= 8.0;
                }
                if (this.options.heightmap) {
                    diff = height - this.lastY;
                    double heightsc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 3.0;
                    sc = diff > 0 ? sc + heightsc : sc - heightsc;
                }
            }
            int alpha = color24 >> 24 & 0xFF;
            int r = color24 >> 16 & 0xFF;
            int g = color24 >> 8 & 0xFF;
            int b = color24 & 0xFF;
            if (sc > 0.0) {
                r += (int)(sc * (double)(255 - r));
                g += (int)(sc * (double)(255 - g));
                b += (int)(sc * (double)(255 - b));
            } else if (sc < 0.0) {
                sc = Math.abs(sc);
                r -= (int)(sc * (double)r);
                g -= (int)(sc * (double)g);
                b -= (int)(sc * (double)b);
            }
            color24 = alpha * 0x1000000 + r * 65536 + g * 256 + b;
        }
        return color24;
    }

    private int getLight(int color24, class_2680 blockState, class_1937 world, int x, int z, int height, boolean solid) {
        int combinedLight = -1;
        if (solid) {
            combinedLight = 0;
        } else if (color24 != this.colorManager.getAirColor() && color24 != 0 && this.options.lightmap) {
            MutableBlockPos blockPos = MutableBlockPosCache.get();
            blockPos.setXYZ(x, Math.max(Math.min(height, world.method_31600()), world.method_31607()), z);
            int blockLight = world.method_8314(class_1944.field_9282, (class_2338)blockPos);
            int skyLight = world.method_8314(class_1944.field_9284, (class_2338)blockPos);
            if (blockState.method_26204() == class_2246.field_10164 || blockState.method_26204() == class_2246.field_10092) {
                blockLight = 14;
            }
            MutableBlockPosCache.release(blockPos);
            combinedLight = this.getLightmapColor(skyLight, blockLight);
        }
        return class_9848.method_61337((int)combinedLight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderMap(class_332 guiGraphics, int x, int y, int scScale, float scaleProj) {
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().scale(scaleProj, scaleProj);
        float scale = 1.0f;
        if (this.options.squareMap && this.options.rotates) {
            scale = 1.4142f;
        }
        Object object = this.coordinateLock;
        synchronized (object) {
            if (this.imageChanged) {
                this.imageChanged = false;
                this.mapImages[this.zoom].method_4524();
                this.lastImageX = this.lastX;
                this.lastImageZ = this.lastZ;
            }
        }
        float multi = (float)(1.0 / this.zoomScale);
        this.percentX = (float)(GameVariableAccessShim.xCoordDouble() - (double)this.lastImageX);
        this.percentY = (float)(GameVariableAccessShim.zCoordDouble() - (double)this.lastImageZ);
        this.percentX *= multi;
        this.percentY *= multi;
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().identity();
        class_287 bufferBuilder = this.fboTessellator.method_60827(VertexFormat.class_5596.field_27382, class_10799.field_56883.getVertexFormat());
        bufferBuilder.method_22912(-256.0f, 256.0f, -2500.0f).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, 255);
        bufferBuilder.method_22912(256.0f, 256.0f, -2500.0f).method_22913(1.0f, 0.0f).method_1336(255, 255, 255, 255);
        bufferBuilder.method_22912(256.0f, -256.0f, -2500.0f).method_22913(1.0f, 1.0f).method_1336(255, 255, 255, 255);
        bufferBuilder.method_22912(-256.0f, -256.0f, -2500.0f).method_22913(0.0f, 1.0f).method_1336(255, 255, 255, 255);
        if (!this.options.rotates) {
            guiGraphics.method_51448().rotate((float)(-this.northRotate) * ((float)Math.PI / 180));
        } else {
            guiGraphics.method_51448().rotate(this.direction * ((float)Math.PI / 180));
        }
        guiGraphics.method_51448().scale(scale, scale);
        guiGraphics.method_51448().translate(-this.percentX * 512.0f / 64.0f, this.percentY * 512.0f / 64.0f);
        Vector3f vector3f = new Vector3f();
        guiGraphics.method_51448().transform(-256.0f, 256.0f, 1.0f, vector3f);
        bufferBuilder.method_22912(vector3f.x, vector3f.y, -2500.0f).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, 255);
        guiGraphics.method_51448().transform(256.0f, 256.0f, 1.0f, vector3f);
        bufferBuilder.method_22912(vector3f.x, vector3f.y, -2500.0f).method_22913(1.0f, 0.0f).method_1336(255, 255, 255, 255);
        guiGraphics.method_51448().transform(256.0f, -256.0f, 1.0f, vector3f);
        bufferBuilder.method_22912(vector3f.x, vector3f.y, -2500.0f).method_22913(1.0f, 1.0f).method_1336(255, 255, 255, 255);
        guiGraphics.method_51448().transform(-256.0f, -256.0f, 1.0f, vector3f);
        bufferBuilder.method_22912(vector3f.x, vector3f.y, -2500.0f).method_22913(0.0f, 1.0f).method_1336(255, 255, 255, 255);
        class_10366 originalProjectionType = RenderSystem.getProjectionType();
        GpuBufferSlice originalProjectionMatrix = RenderSystem.getProjectionMatrixBuffer();
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projection.getBuffer(), (class_10366)class_10366.field_54954);
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().identity();
        GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)RenderSystem.getTextureMatrix(), RenderSystem.getShaderLineWidth());
        RenderPipeline renderPipeline = VoxelMapPipelines.GUI_TEXTURED_ANY_DEPTH_PIPELINE;
        try (class_9801 meshData = bufferBuilder.method_60794();){
            VertexFormat.class_5595 indexType;
            GpuBuffer indexBuffer;
            GpuBuffer vertexBuffer = renderPipeline.getVertexFormat().uploadImmediateVertexBuffer(meshData.method_60818());
            if (meshData.method_60821() == null) {
                RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)meshData.method_60822().comp_752());
                indexBuffer = autoStorageIndexBuffer.method_68274(meshData.method_60822().comp_751());
                indexType = autoStorageIndexBuffer.method_31924();
            } else {
                indexBuffer = renderPipeline.getVertexFormat().uploadImmediateIndexBuffer(meshData.method_60821());
                indexType = meshData.method_60822().comp_753();
            }
            GpuTextureView stencilTexture = null;
            stencilTexture = this.options.squareMap ? class_310.method_1551().method_1531().method_4619(this.squareStencil).method_71659() : class_310.method_1551().method_1531().method_4619(this.circleStencil).method_71659();
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Voxelmap: Map to screen", this.fboTextureView, OptionalInt.of(0));){
                renderPass.setPipeline(renderPipeline);
                RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                renderPass.setUniform("DynamicTransforms", gpuBufferSlice);
                renderPass.setVertexBuffer(0, vertexBuffer);
                renderPass.setIndexBuffer(indexBuffer, indexType);
                renderPass.bindSampler("Sampler0", stencilTexture);
                renderPass.drawIndexed(0, 0, meshData.method_60822().comp_751() / 2, 1);
                renderPass.setPipeline(VoxelMapPipelines.GUI_TEXTURED_ANY_DEPTH_DST_ALPHA_PIPELINE);
                renderPass.bindSampler("Sampler0", this.mapImages[this.zoom].method_71659());
                renderPass.drawIndexed(0, meshData.method_60822().comp_751() / 2, meshData.method_60822().comp_751() / 2, 1);
            }
        }
        RenderSystem.getModelViewStack().popMatrix();
        RenderSystem.setProjectionMatrix((GpuBufferSlice)originalProjectionMatrix, (class_10366)originalProjectionType);
        this.fboTessellator.method_60828();
        guiGraphics.method_51448().popMatrix();
        VoxelMapGuiGraphics.blitFloat(guiGraphics, class_10799.field_56883, this.fboTextureView, (float)(x - 32), (float)(y - 32), 64.0f, 64.0f, 0.0f, 1.0f, 0.0f, 1.0f, -1);
        if (VoxelConstants.getVoxelMapInstance().getRadar() != null) {
            this.layoutVariables.updateVars(scScale, x, y, this.zoomScale, this.zoomScaleAdjusted);
            VoxelConstants.getVoxelMapInstance().getRadar().onTickInGame(guiGraphics, this.layoutVariables, 1.0f);
        }
        double guiScale = (double)this.minecraft.method_22683().method_4489() / (double)this.scWidth;
        minTablistOffset = guiScale * 63.0;
        this.drawMapFrame(guiGraphics, x, y, this.options.squareMap);
        double lastXDouble = GameVariableAccessShim.xCoordDouble();
        double lastZDouble = GameVariableAccessShim.zCoordDouble();
        TextureAtlas textureAtlas = VoxelConstants.getVoxelMapInstance().getWaypointManager().getTextureAtlas();
        if (VoxelMap.mapOptions.waypointsAllowed) {
            Waypoint highlightedPoint = this.waypointManager.getHighlightedWaypoint();
            for (Waypoint pt : this.waypointManager.getWaypoints()) {
                double distanceSq;
                if (!pt.isActive() && pt != highlightedPoint || !((distanceSq = pt.getDistanceSqToEntity(this.minecraft.method_1560())) < (double)(this.options.maxWaypointDisplayDistance * this.options.maxWaypointDisplayDistance)) && this.options.maxWaypointDisplayDistance >= 0 && pt != highlightedPoint) continue;
                this.drawWaypoint(guiGraphics, pt, textureAtlas, x, y, scScale, lastXDouble, lastZDouble, null, null, null, null);
            }
            if (highlightedPoint != null) {
                this.drawWaypoint(guiGraphics, highlightedPoint, textureAtlas, x, y, scScale, lastXDouble, lastZDouble, textureAtlas.getAtlasSprite("voxelmap:images/waypoints/target.png"), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
            }
        }
        guiGraphics.method_51448().popMatrix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawWaypoint(class_332 guiGraphics, Waypoint pt, TextureAtlas textureAtlas, int x, int y, int scScale, double lastXDouble, double lastZDouble, Sprite icon, Float r, Float g, Float b) {
        boolean far;
        boolean uprightIcon;
        boolean bl = uprightIcon = icon != null;
        if (r == null) {
            r = Float.valueOf(pt.red);
        }
        if (g == null) {
            g = Float.valueOf(pt.green);
        }
        if (b == null) {
            b = Float.valueOf(pt.blue);
        }
        double wayX = lastXDouble - (double)pt.getX() - 0.5;
        double wayY = lastZDouble - (double)pt.getZ() - 0.5;
        float locate = (float)Math.toDegrees(Math.atan2(wayX, wayY));
        float hypot = (float)Math.sqrt(wayX * wayX + wayY * wayY);
        locate = this.options.rotates ? (locate += this.direction) : (locate -= (float)this.northRotate);
        hypot = (float)((double)hypot / this.zoomScaleAdjusted);
        if (this.options.squareMap) {
            double radLocate = Math.toRadians(locate);
            double dispX = (double)hypot * Math.cos(radLocate);
            double dispY = (double)hypot * Math.sin(radLocate);
            boolean bl2 = far = Math.abs(dispX) > 28.5 || Math.abs(dispY) > 28.5;
            if (far) {
                hypot = (float)((double)hypot / Math.max(Math.abs(dispX), Math.abs(dispY)) * 30.0);
            }
        } else {
            boolean bl3 = far = hypot >= 31.0f;
            if (far) {
                hypot = 34.0f;
            }
        }
        boolean target = false;
        if (far) {
            if (icon == null) {
                icon = scScale >= 3 ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/marker" + pt.imageSuffix + ".png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/marker" + pt.imageSuffix + "Small.png");
                if (icon == textureAtlas.getMissingImage()) {
                    icon = scScale >= 3 ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/marker.png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/markerSmall.png");
                }
            } else {
                target = true;
            }
            int color = pt.getUnifiedColor(!pt.enabled && !target ? 0.3f : 1.0f);
            try {
                guiGraphics.method_51448().pushMatrix();
                guiGraphics.method_51448().translate((float)x, (float)y);
                guiGraphics.method_51448().rotate(-locate * ((float)Math.PI / 180));
                if (uprightIcon) {
                    guiGraphics.method_51448().translate(0.0f, -hypot);
                    guiGraphics.method_51448().rotate(locate * ((float)Math.PI / 180));
                    guiGraphics.method_51448().translate((float)(-x), (float)(-y));
                } else {
                    guiGraphics.method_51448().translate((float)(-x), (float)(-y));
                    guiGraphics.method_51448().translate(0.0f, -hypot);
                }
                icon.blit(guiGraphics, VoxelMapPipelines.GUI_TEXTURED_LESS_OR_EQUAL_DEPTH_PIPELINE, x - 4, y - 4, 8.0f, 8.0f, color);
            }
            catch (Exception var40) {
                this.error = "Error: marker overlay not found!";
            }
            finally {
                guiGraphics.method_51448().popMatrix();
            }
        } else {
            if (icon == null) {
                icon = scScale >= 3 ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + ".png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + "Small.png");
                if (icon == textureAtlas.getMissingImage()) {
                    icon = scScale >= 3 ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint.png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypointSmall.png");
                }
            } else {
                target = true;
            }
            int color = pt.getUnifiedColor(!pt.enabled && !target ? 0.3f : 1.0f);
            try {
                guiGraphics.method_51448().pushMatrix();
                guiGraphics.method_51448().rotate(-locate * ((float)Math.PI / 180));
                guiGraphics.method_51448().translate(0.0f, -hypot);
                guiGraphics.method_51448().rotate(locate * ((float)Math.PI / 180));
                icon.blit(guiGraphics, VoxelMapPipelines.GUI_TEXTURED_LESS_OR_EQUAL_DEPTH_PIPELINE, x - 4, y - 4, 8.0f, 8.0f, color);
            }
            catch (Exception var42) {
                this.error = "Error: waypoint overlay not found!";
            }
            finally {
                guiGraphics.method_51448().popMatrix();
            }
        }
    }

    private void drawArrow(class_332 guiGraphics, int x, int y, float scaleProj) {
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().scale(scaleProj, scaleProj);
        guiGraphics.method_51448().translate((float)x, (float)y);
        guiGraphics.method_51448().rotate((this.options.rotates && !this.fullscreenMap ? 0.0f : this.direction + (float)this.northRotate) * ((float)Math.PI / 180));
        guiGraphics.method_51448().translate((float)(-x), (float)(-y));
        guiGraphics.method_25290(class_10799.field_56883, this.resourceArrow, x - 4, y - 4, 0.0f, 0.0f, 8, 8, 8, 8);
        guiGraphics.method_51448().popMatrix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderMapFull(class_332 guiGraphics, int scWidth, int scHeight, float scaleProj) {
        Object object = this.coordinateLock;
        synchronized (object) {
            if (this.imageChanged) {
                this.imageChanged = false;
                this.mapImages[this.zoom].method_4524();
                this.lastImageX = this.lastX;
                this.lastImageZ = this.lastZ;
            }
        }
        Matrix3x2fStack matrixStack = guiGraphics.method_51448();
        matrixStack.pushMatrix();
        matrixStack.scale(scaleProj, scaleProj);
        matrixStack.translate((float)scWidth / 2.0f, (float)scHeight / 2.0f);
        matrixStack.rotate((float)this.northRotate * ((float)Math.PI / 180));
        matrixStack.translate(-((float)scWidth / 2.0f), -((float)scHeight / 2.0f));
        int left = scWidth / 2 - 128;
        int top = scHeight / 2 - 128;
        guiGraphics.method_25290(class_10799.field_56883, this.mapResources[this.zoom], left, top, 0.0f, 0.0f, 256, 256, 256, 256);
        matrixStack.popMatrix();
        if (this.options.biomeOverlay != 0) {
            double factor = Math.pow(2.0, 3 - this.zoom);
            int minimumSize = (int)Math.pow(2.0, this.zoom);
            minimumSize *= minimumSize;
            ArrayList<AbstractMapData.BiomeLabel> labels = this.mapData[this.zoom].getBiomeLabels();
            matrixStack.pushMatrix();
            for (AbstractMapData.BiomeLabel o : labels) {
                if (o.segmentSize <= minimumSize) continue;
                String name = o.name;
                int nameWidth = this.textWidth(name);
                float x = (float)((double)o.x * factor);
                float z = (float)((double)o.z * factor);
                if (this.options.oldNorth) {
                    this.write(guiGraphics, name, (float)(left + 256) - z - (float)nameWidth / 2.0f, (float)top + x - 3.0f, -1);
                    continue;
                }
                this.write(guiGraphics, name, (float)left + x - (float)nameWidth / 2.0f, (float)top + z - 3.0f, -1);
            }
            matrixStack.popMatrix();
        }
    }

    private void drawMapFrame(class_332 guiGraphics, int x, int y, boolean squaremap) {
        class_2960 frameResource = squaremap ? this.resourceSquareMap : this.resourceRoundMap;
        guiGraphics.method_25290(VoxelMapPipelines.GUI_TEXTURED_LESS_OR_EQUAL_DEPTH_PIPELINE, frameResource, x - 32, y - 32, 0.0f, 0.0f, 64, 64, 64, 64);
    }

    private void drawDirections(class_332 drawContext, int x, int y, float scaleProj) {
        float distance;
        Matrix3x2fStack poseStack = drawContext.method_51448();
        boolean unicode = (Boolean)this.minecraft.field_1690.method_42437().method_41753();
        float scale = unicode ? 0.65f : 0.5f;
        float rotate = this.options.rotates ? -this.direction - 90.0f - (float)this.northRotate : -90.0f;
        if (this.options.squareMap) {
            if (this.options.rotates) {
                float tempdir = this.direction % 90.0f;
                tempdir = 45.0f - Math.abs(45.0f - tempdir);
                distance = (float)(33.5 / (double)scale / Math.cos(Math.toRadians(tempdir)));
            } else {
                distance = 33.5f / scale;
            }
        } else {
            distance = 32.0f / scale;
        }
        poseStack.pushMatrix();
        poseStack.scale(scaleProj, scaleProj);
        poseStack.scale(scale, scale);
        poseStack.pushMatrix();
        poseStack.translate((float)((double)distance * Math.sin(Math.toRadians(-((double)rotate - 90.0)))), (float)((double)distance * Math.cos(Math.toRadians(-((double)rotate - 90.0)))));
        this.write(drawContext, "N", (float)x / scale - 2.0f, (float)y / scale - 4.0f, -1);
        poseStack.popMatrix();
        poseStack.pushMatrix();
        poseStack.translate((float)((double)distance * Math.sin(Math.toRadians(-rotate))), (float)((double)distance * Math.cos(Math.toRadians(-rotate))));
        this.write(drawContext, "E", (float)x / scale - 2.0f, (float)y / scale - 4.0f, -1);
        poseStack.popMatrix();
        poseStack.pushMatrix();
        poseStack.translate((float)((double)distance * Math.sin(Math.toRadians(-((double)rotate + 90.0)))), (float)((double)distance * Math.cos(Math.toRadians(-((double)rotate + 90.0)))));
        this.write(drawContext, "S", (float)x / scale - 2.0f, (float)y / scale - 4.0f, -1);
        poseStack.popMatrix();
        poseStack.pushMatrix();
        poseStack.translate((float)((double)distance * Math.sin(Math.toRadians(-((double)rotate + 180.0)))), (float)((double)distance * Math.cos(Math.toRadians(-((double)rotate + 180.0)))));
        this.write(drawContext, "W", (float)x / scale - 2.0f, (float)y / scale - 4.0f, -1);
        poseStack.popMatrix();
        poseStack.popMatrix();
    }

    private void showCoords(class_332 drawContext, int x, int y, float scaleProj) {
        Matrix3x2fStack matrixStack = drawContext.method_51448();
        int textStart = y > this.scHeight - 37 - 32 - 4 - 15 ? y - 32 - 4 - 9 : y + 32 + 4;
        matrixStack.pushMatrix();
        matrixStack.scale(scaleProj, scaleProj);
        if (!this.options.hide && !this.fullscreenMap) {
            boolean unicode = (Boolean)this.minecraft.field_1690.method_42437().method_41753();
            float scale = unicode ? 0.65f : 0.5f;
            matrixStack.pushMatrix();
            matrixStack.scale(scale, scale);
            Object xy = this.dCoord(GameVariableAccessShim.xCoord()) + ", " + this.dCoord(GameVariableAccessShim.zCoord());
            int m = this.textWidth((String)xy) / 2;
            this.write(drawContext, (String)xy, (float)x / scale - (float)m, (float)textStart / scale, -1);
            xy = this.dCoord(GameVariableAccessShim.yCoord());
            m = this.textWidth((String)xy) / 2;
            this.write(drawContext, (String)xy, (float)x / scale - (float)m, (float)textStart / scale + 10.0f, -1);
            if (this.ztimer > 0) {
                m = this.textWidth(this.error) / 2;
                this.write(drawContext, this.error, (float)x / scale - (float)m, (float)textStart / scale + 19.0f, -1);
            }
            matrixStack.popMatrix();
        } else {
            int heading = (int)(this.direction + (float)this.northRotate);
            if (heading > 360) {
                heading -= 360;
            }
            String ns = "";
            String ew = "";
            if ((double)heading > 292.5 || (double)heading <= 67.5) {
                ns = "N";
            } else if ((double)heading > 112.5 && (double)heading <= 247.5) {
                ns = "S";
            }
            if ((double)heading > 22.5 && (double)heading <= 157.5) {
                ew = "E";
            } else if ((double)heading > 202.5 && (double)heading <= 337.5) {
                ew = "W";
            }
            String stats = "(" + this.dCoord(GameVariableAccessShim.xCoord()) + ", " + GameVariableAccessShim.yCoord() + ", " + this.dCoord(GameVariableAccessShim.zCoord()) + ") " + heading + "' " + ns + ew;
            int m = this.textWidth(stats) / 2;
            this.write(drawContext, stats, (float)this.scWidth / 2.0f - (float)m, 5.0f, -1);
            if (this.ztimer > 0) {
                m = this.textWidth(this.error) / 2;
                this.write(drawContext, this.error, (float)this.scWidth / 2.0f - (float)m, 15.0f, -1);
            }
        }
        matrixStack.popMatrix();
    }

    private String dCoord(int paramInt1) {
        if (paramInt1 < 0) {
            return "-" + Math.abs(paramInt1);
        }
        return paramInt1 > 0 ? "+" + paramInt1 : " " + paramInt1;
    }

    private int textWidth(String string) {
        return this.minecraft.field_1772.method_1727(string);
    }

    private void write(class_332 drawContext, String text, float x, float y, int color) {
        this.write(drawContext, class_2561.method_30163((String)text), x, y, color);
    }

    private int textWidth(class_2561 text) {
        return this.minecraft.field_1772.method_27525((class_5348)text);
    }

    private void write(class_332 drawContext, class_2561 text, float x, float y, int color) {
        drawContext.method_27535(this.minecraft.field_1772, text, (int)x, (int)y, color);
    }

    public static double getMinTablistOffset() {
        return minTablistOffset;
    }

    public static float getStatusIconOffset() {
        return statusIconOffset;
    }

    static {
        statusIconOffset = 0.0f;
    }
}

