/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.VoxelMap;
import com.mamiyaotaru.voxelmap.entityrender.EntityMapImageManager;
import com.mamiyaotaru.voxelmap.interfaces.IRadar;
import com.mamiyaotaru.voxelmap.util.Contact;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.LayoutVariables;
import com.mamiyaotaru.voxelmap.util.MobCategory;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.VoxelMapPipelines;
import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1456;
import net.minecraft.class_1463;
import net.minecraft.class_1493;
import net.minecraft.class_1569;
import net.minecraft.class_1590;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4466;
import net.minecraft.class_5348;
import net.minecraft.class_745;
import net.minecraft.class_7923;
import net.minecraft.class_9848;

public class Radar
implements IRadar {
    private final MapSettingsManager minimapOptions;
    private final RadarSettingsManager options;
    private final ArrayList<Contact> contacts = new ArrayList(40);
    private final EntityMapImageManager entityMapImageManager;
    private final class_310 minecraft = class_310.method_1551();
    private LayoutVariables layoutVariables;
    private int timer = 500;
    private float direction;
    private boolean lastOutlines = true;
    private int calculateMobsPart;

    public Radar() {
        this.entityMapImageManager = new EntityMapImageManager();
        this.minimapOptions = VoxelConstants.getVoxelMapInstance().getMapOptions();
        this.options = VoxelConstants.getVoxelMapInstance().getRadarOptions();
    }

    @Override
    public void onResourceManagerReload(class_3300 resourceManager) {
        this.entityMapImageManager.reset();
    }

    @Override
    public void onTickInGame(class_332 drawContext, LayoutVariables layoutVariables, float scaleProj) {
        this.entityMapImageManager.onRenderTick(drawContext);
        if (this.options.radarAllowed || this.options.radarMobsAllowed || this.options.radarPlayersAllowed) {
            this.layoutVariables = layoutVariables;
            if (this.options.isChanged()) {
                this.timer = 500;
                if (this.options.outlines != this.lastOutlines) {
                    this.lastOutlines = this.options.outlines;
                }
            }
            this.direction = GameVariableAccessShim.rotationYaw() + 180.0f;
            while (this.direction >= 360.0f) {
                this.direction -= 360.0f;
            }
            while (this.direction < 0.0f) {
                this.direction += 360.0f;
            }
            if (this.timer > 15) {
                this.calculateMobs();
                this.timer = 0;
            }
            ++this.timer;
            this.renderMapMobs(drawContext, this.layoutVariables.mapX, this.layoutVariables.mapY, scaleProj);
        }
    }

    private boolean isEntityShown(class_1297 entity) {
        return entity != null && !entity.method_5756((class_1657)VoxelConstants.getPlayer()) && (this.options.showHostiles && (this.options.radarAllowed || this.options.radarMobsAllowed) && this.isHostile(entity) || this.options.showPlayers && (this.options.radarAllowed || this.options.radarPlayersAllowed) && this.isPlayer(entity) || this.options.showNeutrals && this.options.radarMobsAllowed && this.isNeutral(entity));
    }

    public void calculateMobs() {
        this.calculateMobsPart = this.calculateMobsPart + 1 & 7;
        this.contacts.removeIf(e -> (e.uuid.getLeastSignificantBits() & 7L) == (long)this.calculateMobsPart);
        Iterable entities = VoxelConstants.getClientWorld().method_18112();
        for (class_1297 entity : entities) {
            if ((entity.method_5667().getLeastSignificantBits() & 7L) != (long)this.calculateMobsPart) continue;
            try {
                String scrubbedName;
                if (!this.isEntityShown(entity)) continue;
                int wayX = GameVariableAccessShim.xCoord() - (int)entity.method_73189().method_10216();
                int wayZ = GameVariableAccessShim.zCoord() - (int)entity.method_73189().method_10215();
                int wayY = GameVariableAccessShim.yCoord() - (int)entity.method_73189().method_10214();
                double scale = this.layoutVariables.zoomScaleAdjusted;
                boolean inRange = !this.minimapOptions.squareMap ? (double)(wayX * wayX + wayZ * wayZ) / (scale * scale) < 1024.0 : (double)class_3532.method_15382((int)wayX) / scale < 32.0 || (double)class_3532.method_15382((int)wayZ) / scale < 32.0;
                if (!(inRange = inRange && (double)class_3532.method_15382((int)wayY) / scale < 32.0)) continue;
                Contact contact = new Contact((class_1309)entity, MobCategory.forEntity(entity));
                if (contact.entity.method_5854() != null && this.isEntityShown(contact.entity.method_5854())) {
                    contact.yFudge = 1;
                }
                if (!VoxelMap.radarOptions.isMobEnabled(contact.entity)) continue;
                if (contact.icon == null) {
                    contact.icon = this.entityMapImageManager.requestImageForMob((class_1297)contact.entity, 32, this.options.outlines);
                }
                if (((scrubbedName = TextUtils.scrubCodes(contact.entity.method_5477().getString())).equals("Dinnerbone") || scrubbedName.equals("Grumm")) && (!(contact.entity instanceof class_1657) || ((class_1657)contact.entity).method_74091(class_1664.field_7559))) {
                    contact.setRotationFactor(contact.rotationFactor + 180);
                }
                if (this.options.showHelmetsPlayers && contact.category == MobCategory.PLAYER || !this.options.showHelmetsMobs || contact.category != MobCategory.PLAYER) {
                    // empty if block
                }
                this.contacts.add(contact);
            }
            catch (Exception var16) {
                VoxelConstants.getLogger().error(var16.getLocalizedMessage(), (Throwable)var16);
            }
        }
        this.contacts.sort((c1, c2) -> {
            double dy = c1.y - c2.y;
            if (dy != 0.0) {
                return dy > 0.0 ? 1 : -1;
            }
            double dx = c1.x - c2.x;
            if (dx != 0.0) {
                return dx > 0.0 ? 1 : -1;
            }
            double dz = c1.z - c2.z;
            if (dz != 0.0) {
                return dz > 0.0 ? 1 : -1;
            }
            return 0;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderMapMobs(class_332 guiGraphics, int x, int y, float scaleProj) {
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().scale(scaleProj, scaleProj);
        double max = this.layoutVariables.zoomScaleAdjusted * 32.0;
        double lastX = GameVariableAccessShim.xCoordDouble();
        double lastZ = GameVariableAccessShim.zCoordDouble();
        double lastY = GameVariableAccessShim.yCoordDouble();
        for (Contact contact : this.contacts) {
            boolean inRange;
            int color;
            contact.updateLocation();
            double contactX = contact.x;
            double contactZ = contact.z;
            double contactY = contact.y;
            double wayX = lastX - contactX;
            double wayZ = lastZ - contactZ;
            double wayY = lastY - contactY;
            double entityMax = max;
            if (contact.entity.method_5864() == class_1299.field_6078) {
                entityMax *= 2.0;
            }
            double adjustedDiff = entityMax - Math.max(Math.abs(wayY), 0.0);
            contact.brightness = (float)Math.max(adjustedDiff / entityMax, 0.0);
            contact.brightness *= contact.brightness;
            contact.angle = (float)Math.toDegrees(Math.atan2(wayX, wayZ));
            contact.distance = Math.sqrt(wayX * wayX + wayZ * wayZ) / this.layoutVariables.zoomScaleAdjusted;
            if (wayY < 0.0) {
                color = class_9848.method_61318((float)contact.brightness, (float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                if (contact.brightness < 0.3f) {
                    contact.brightness = 0.3f;
                }
                color = class_9848.method_61318((float)1.0f, (float)contact.brightness, (float)contact.brightness, (float)contact.brightness);
            }
            if (this.minimapOptions.rotates) {
                contact.angle += this.direction;
            } else if (this.minimapOptions.oldNorth) {
                contact.angle -= 90.0f;
            }
            if (!this.minimapOptions.squareMap) {
                inRange = contact.distance < 28.5;
            } else {
                double radLocate = Math.toRadians(contact.angle);
                double dispX = contact.distance * Math.cos(radLocate);
                double dispY = contact.distance * Math.sin(radLocate);
                boolean bl = inRange = Math.abs(dispX) <= 28.5 && Math.abs(dispY) <= 28.5;
            }
            if (!inRange) continue;
            try {
                guiGraphics.method_51448().pushMatrix();
                if (this.options.filtering) {
                    guiGraphics.method_51448().translate((float)x, (float)y);
                    guiGraphics.method_51448().rotate(-contact.angle * ((float)Math.PI / 180));
                    guiGraphics.method_51448().translate(0.0f, (float)(-contact.distance));
                    guiGraphics.method_51448().rotate((contact.angle + (float)contact.rotationFactor) * ((float)Math.PI / 180));
                    guiGraphics.method_51448().translate((float)(-x), (float)(-y));
                } else {
                    wayZ = Math.cos(Math.toRadians(contact.angle)) * contact.distance;
                    wayX = Math.sin(Math.toRadians(contact.angle)) * contact.distance;
                    guiGraphics.method_51448().translate((float)Math.round(-wayX * (double)this.layoutVariables.scScale) / (float)this.layoutVariables.scScale, (float)Math.round(-wayZ * (double)this.layoutVariables.scScale) / (float)this.layoutVariables.scScale);
                }
                float yOffset = 0.0f;
                if (contact.entity.method_5854() != null && this.isEntityShown(contact.entity.method_5854())) {
                    yOffset = -4.0f;
                }
                int imageSize = (int)((float)contact.icon.getIconWidth() / 8.0f);
                contact.icon.blit(guiGraphics, VoxelMapPipelines.GUI_TEXTURED_LESS_OR_EQUAL_DEPTH_PIPELINE, x - imageSize / 2, (float)y + yOffset - (float)(imageSize / 2), imageSize, imageSize, color);
                if (contact.name == null || (!this.options.showPlayerNames || contact.category != MobCategory.PLAYER) && (!this.options.showMobNames || contact.category == MobCategory.PLAYER || !contact.entity.method_16914())) continue;
                float scaleFactor = this.options.fontScale / 4.0f;
                guiGraphics.method_51448().scale(scaleFactor, scaleFactor);
                int m = this.minecraft.field_1772.method_27525((class_5348)contact.name) / 2;
                guiGraphics.method_51448().pushMatrix();
                guiGraphics.method_51439(this.minecraft.field_1772, contact.name, (int)((float)x / scaleFactor - (float)m), (int)((float)(y + 3) / scaleFactor), -1, false);
                guiGraphics.method_51448().popMatrix();
            }
            catch (Exception e) {
                VoxelConstants.getLogger().error("Error rendering mob icon! " + e.getLocalizedMessage() + " contact type " + String.valueOf(class_7923.field_41177.method_10221((Object)contact.entity.method_5864())), (Throwable)e);
            }
            finally {
                guiGraphics.method_51448().popMatrix();
            }
        }
        guiGraphics.method_51448().popMatrix();
    }

    private boolean isHostile(class_1297 entity) {
        if (entity instanceof class_1569) {
            return true;
        }
        if (entity instanceof class_1590) {
            class_1590 zombifiedPiglinEntity = (class_1590)entity;
            return zombifiedPiglinEntity.method_29508() != null && zombifiedPiglinEntity.method_29508().equals(VoxelConstants.getPlayer().method_5667());
        }
        if (entity instanceof class_4466) {
            class_4466 beeEntity = (class_4466)entity;
            return beeEntity.method_29511();
        }
        if (entity instanceof class_1456) {
            class_1456 polarBearEntity = (class_1456)entity;
            for (class_1456 object : polarBearEntity.method_73183().method_18467(class_1456.class, polarBearEntity.method_5829().method_1009(8.0, 4.0, 8.0))) {
                if (!object.method_6109()) continue;
                return true;
            }
            return false;
        }
        if (entity instanceof class_1463) {
            class_1463 rabbitEntity = (class_1463)entity;
            return rabbitEntity.method_47855() == class_1463.class_7990.field_41567;
        }
        if (entity instanceof class_1493) {
            class_1493 wolfEntity = (class_1493)entity;
            return wolfEntity.method_29511();
        }
        return false;
    }

    private boolean isPlayer(class_1297 entity) {
        return entity instanceof class_745;
    }

    private boolean isNeutral(class_1297 entity) {
        if (!(entity instanceof class_1309)) {
            return false;
        }
        return !(entity instanceof class_1657) && !this.isHostile(entity);
    }

    public void onJoinServer() {
        this.entityMapImageManager.reset();
    }

    public EntityMapImageManager getEntityMapImageManager() {
        return this.entityMapImageManager;
    }
}

