/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.interfaces.ISubSettingsManager;
import com.mojang.serialization.DataResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import net.minecraft.class_1074;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class RadarSettingsManager
implements ISubSettingsManager {
    private boolean somethingChanged;
    public int radarMode = 2;
    public boolean showRadar = true;
    public boolean showHostiles = true;
    public boolean showNeutrals;
    public boolean showPlayers = true;
    public boolean showPlayerNames = true;
    public boolean showMobNames = true;
    public boolean outlines = true;
    public boolean filtering = true;
    public boolean showHelmetsPlayers = true;
    public boolean showHelmetsMobs = true;
    public boolean showFacing = true;
    public boolean radarAllowed = true;
    public boolean radarPlayersAllowed = true;
    public boolean radarMobsAllowed = true;
    public final HashSet<class_2960> hiddenMobs = new HashSet();
    float fontScale = 1.0f;

    @Override
    public void loadSettings(File settingsFile) {
        try {
            String sCurrentLine;
            BufferedReader in = new BufferedReader(new FileReader(settingsFile));
            while ((sCurrentLine = in.readLine()) != null) {
                String[] curLine = sCurrentLine.split(":", 2);
                switch (curLine[0]) {
                    case "Radar Mode": {
                        this.radarMode = Math.max(1, Math.min(2, Integer.parseInt(curLine[1])));
                        break;
                    }
                    case "Show Radar": {
                        this.showRadar = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Show Hostiles": {
                        this.showHostiles = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Show Neutrals": {
                        this.showNeutrals = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Show Players": {
                        this.showPlayers = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Filter Mob Icons": {
                        this.filtering = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Outline Mob Icons": {
                        this.outlines = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Show Player Helmets": {
                        this.showHelmetsPlayers = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Show Mob Helmets": {
                        this.showHelmetsMobs = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Show Player Names": {
                        this.showPlayerNames = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Show Mob Names": {
                        this.showMobNames = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Font Scale": {
                        this.fontScale = Float.parseFloat(curLine[1]);
                        break;
                    }
                    case "Show Facing": {
                        this.showFacing = Boolean.parseBoolean(curLine[1]);
                        break;
                    }
                    case "Hidden Mobs": {
                        this.applyHiddenMobSettings(curLine[1]);
                    }
                }
            }
            in.close();
        }
        catch (IOException | ArrayIndexOutOfBoundsException exception) {
            // empty catch block
        }
    }

    private void applyHiddenMobSettings(String hiddenMobs) {
        String[] mobsToHide = hiddenMobs.split(",");
        this.hiddenMobs.clear();
        for (String s : mobsToHide) {
            DataResult location = class_2960.method_29186((String)s);
            if (!location.isSuccess()) continue;
            this.hiddenMobs.add((class_2960)location.getOrThrow());
        }
    }

    @Override
    public void saveAll(PrintWriter out) {
        out.println("Radar Mode:" + this.radarMode);
        out.println("Show Radar:" + this.showRadar);
        out.println("Show Hostiles:" + this.showHostiles);
        out.println("Show Neutrals:" + this.showNeutrals);
        out.println("Show Players:" + this.showPlayers);
        out.println("Filter Mob Icons:" + this.filtering);
        out.println("Outline Mob Icons:" + this.outlines);
        out.println("Show Player Helmets:" + this.showHelmetsPlayers);
        out.println("Show Mob Helmets:" + this.showHelmetsMobs);
        out.println("Show Player Names:" + this.showPlayerNames);
        out.println("Show Mob Names:" + this.showMobNames);
        out.println("Font Scale:" + this.fontScale);
        out.println("Show Facing:" + this.showFacing);
        out.print("Hidden Mobs:");
        for (class_2960 mob : this.hiddenMobs) {
            out.print(mob.toString() + ",");
        }
        out.println();
    }

    @Override
    public String getKeyText(EnumOptionsMinimap options) {
        String s = class_1074.method_4662((String)options.getName(), (Object[])new Object[0]) + ": ";
        if (options.isBoolean()) {
            return this.getOptionBooleanValue(options) ? s + class_1074.method_4662((String)"options.on", (Object[])new Object[0]) : s + class_1074.method_4662((String)"options.off", (Object[])new Object[0]);
        }
        if (options.isList()) {
            String state = this.getOptionListValue(options);
            return s + state;
        }
        return s;
    }

    public boolean getOptionBooleanValue(EnumOptionsMinimap par1EnumOptions) {
        return switch (par1EnumOptions) {
            case EnumOptionsMinimap.SHOW_RADAR -> this.showRadar;
            case EnumOptionsMinimap.SHOW_PLAYERS -> this.showPlayers;
            case EnumOptionsMinimap.SHOW_PLAYER_HELMETS -> this.showHelmetsPlayers;
            case EnumOptionsMinimap.SHOW_MOB_HELMETS -> this.showHelmetsMobs;
            case EnumOptionsMinimap.SHOW_PLAYER_NAMES -> this.showPlayerNames;
            case EnumOptionsMinimap.SHOW_MOB_NAMES -> this.showMobNames;
            case EnumOptionsMinimap.RADAR_OUTLINES -> this.outlines;
            case EnumOptionsMinimap.RADAR_FILTERING -> this.filtering;
            case EnumOptionsMinimap.SHOW_FACING -> this.showFacing;
            default -> throw new IllegalArgumentException("Add code to handle EnumOptionMinimap: " + par1EnumOptions.getName() + ". (possibly not a boolean)");
        };
    }

    public String getOptionListValue(EnumOptionsMinimap par1EnumOptions) {
        switch (par1EnumOptions) {
            case RADAR_MODE: {
                if (this.radarMode == 2) {
                    return class_1074.method_4662((String)"options.minimap.radar.radarMode.full", (Object[])new Object[0]);
                }
                return class_1074.method_4662((String)"options.minimap.radar.radarMode.simple", (Object[])new Object[0]);
            }
            case SHOW_MOBS: {
                if (!this.showHostiles && !this.showNeutrals) {
                    return class_1074.method_4662((String)"options.off", (Object[])new Object[0]);
                }
                if (this.showHostiles && !this.showNeutrals) {
                    return class_1074.method_4662((String)"options.minimap.radar.showMobs.showHostiles", (Object[])new Object[0]);
                }
                if (!this.showHostiles) {
                    return class_1074.method_4662((String)"options.minimap.radar.showMobs.showNeutrals", (Object[])new Object[0]);
                }
                return class_1074.method_4662((String)"options.minimap.radar.showMobs.showAll", (Object[])new Object[0]);
            }
        }
        throw new IllegalArgumentException("Add code to handle EnumOptionMinimap: " + par1EnumOptions.getName() + ". (possibly not a list value applicable to minimap)");
    }

    @Override
    public void setOptionFloatValue(EnumOptionsMinimap options, float value) {
    }

    public void setOptionValue(EnumOptionsMinimap par1EnumOptions) {
        switch (par1EnumOptions) {
            case SHOW_RADAR: {
                this.showRadar = !this.showRadar;
                break;
            }
            case SHOW_PLAYERS: {
                this.showPlayers = !this.showPlayers;
                break;
            }
            case SHOW_PLAYER_HELMETS: {
                this.showHelmetsPlayers = !this.showHelmetsPlayers;
                break;
            }
            case SHOW_MOB_HELMETS: {
                this.showHelmetsMobs = !this.showHelmetsMobs;
                break;
            }
            case SHOW_PLAYER_NAMES: {
                this.showPlayerNames = !this.showPlayerNames;
                break;
            }
            case SHOW_MOB_NAMES: {
                this.showMobNames = !this.showMobNames;
                break;
            }
            case RADAR_OUTLINES: {
                this.outlines = !this.outlines;
                break;
            }
            case RADAR_FILTERING: {
                this.filtering = !this.filtering;
                break;
            }
            case SHOW_FACING: {
                this.showFacing = !this.showFacing;
                break;
            }
            case RADAR_MODE: {
                if (this.radarMode == 2) {
                    this.radarMode = 1;
                    break;
                }
                this.radarMode = 2;
                break;
            }
            case SHOW_MOBS: {
                if (!this.showHostiles && !this.showNeutrals) {
                    this.showHostiles = true;
                    break;
                }
                if (this.showHostiles && !this.showNeutrals) {
                    this.showHostiles = false;
                    this.showNeutrals = true;
                    break;
                }
                if (!this.showHostiles) {
                    this.showHostiles = true;
                    break;
                }
                this.showHostiles = false;
                this.showNeutrals = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Add code to handle EnumOptionMinimap: " + par1EnumOptions.getName());
            }
        }
        this.somethingChanged = true;
    }

    public boolean isChanged() {
        if (this.somethingChanged) {
            this.somethingChanged = false;
            return true;
        }
        return false;
    }

    @Override
    public float getOptionFloatValue(EnumOptionsMinimap options) {
        return 0.0f;
    }

    public boolean isMobEnabled(class_1309 entity) {
        return this.isMobEnabled(entity.method_5864());
    }

    public boolean isMobEnabled(class_1299<?> type) {
        return !this.hiddenMobs.contains(class_7923.field_41177.method_10221(type));
    }
}

