/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.Events;
import com.mamiyaotaru.voxelmap.Map;
import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.ModApiBridge;
import com.mamiyaotaru.voxelmap.PacketBridge;
import com.mamiyaotaru.voxelmap.VoxelMap;
import com.mamiyaotaru.voxelmap.persistent.ThreadManager;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1132;
import net.minecraft.class_11906;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_746;
import net.minecraft.class_7591;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class VoxelConstants {
    private static final Logger LOGGER = LogManager.getLogger((String)"VoxelMap");
    private static final VoxelMap VOXELMAP_INSTANCE = new VoxelMap();
    private static int elapsedTicks;
    private static final class_2960 OPTIONS_BACKGROUND_TEXTURE;
    public static final boolean DEBUG = false;
    private static boolean initialized;
    private static Events events;
    private static PacketBridge packetBridge;
    private static ModApiBridge modApiBridge;

    private VoxelConstants() {
    }

    @NotNull
    public static class_310 getMinecraft() {
        return class_310.method_1551();
    }

    public static boolean isSystemMacOS() {
        return class_11906.field_62586;
    }

    public static boolean isFabulousGraphicsOrBetter() {
        return class_310.method_29611();
    }

    public static boolean isSinglePlayer() {
        return VoxelConstants.getMinecraft().method_1542();
    }

    public static boolean isRealmServer() {
        class_634 playNetworkHandler = VoxelConstants.getMinecraft().method_1562();
        class_642 serverInfo = playNetworkHandler != null ? VoxelConstants.getMinecraft().method_1562().method_45734() : null;
        return serverInfo != null && serverInfo.method_52811();
    }

    @NotNull
    public static Logger getLogger() {
        return LOGGER;
    }

    @NotNull
    public static Optional<class_1132> getIntegratedServer() {
        return Optional.ofNullable(VoxelConstants.getMinecraft().method_1576());
    }

    @NotNull
    public static Optional<class_1937> getWorldByKey(class_5321<class_1937> key) {
        return VoxelConstants.getIntegratedServer().map(integratedServer -> integratedServer.method_3847(key));
    }

    @NotNull
    public static class_638 getClientWorld() {
        return (class_638)VoxelConstants.getPlayer().method_73183();
    }

    @NotNull
    public static class_746 getPlayer() {
        class_746 player = VoxelConstants.getMinecraft().field_1724;
        if (player == null) {
            String error = "Attempted to fetch player entity while not in-game!";
            VoxelConstants.getLogger().fatal(error);
            throw new IllegalStateException(error);
        }
        return player;
    }

    @NotNull
    public static VoxelMap getVoxelMapInstance() {
        return VOXELMAP_INSTANCE;
    }

    static void tick() {
        elapsedTicks = elapsedTicks == Integer.MAX_VALUE ? 1 : elapsedTicks + 1;
    }

    public static int getElapsedTicks() {
        return elapsedTicks;
    }

    public static class_2960 getOptionsBackgroundTexture() {
        return OPTIONS_BACKGROUND_TEXTURE;
    }

    public static void lateInit() {
        initialized = true;
        VoxelConstants.getVoxelMapInstance().lateInit(true, false);
    }

    public static void clientTick() {
        if (!initialized) {
            VoxelConstants.lateInit();
        }
        if (initialized) {
            VoxelConstants.getVoxelMapInstance().onTick();
        }
    }

    public static void renderOverlay(class_332 guiGraphics) {
        if (!initialized) {
            VoxelConstants.lateInit();
        }
        try {
            VoxelConstants.getVoxelMapInstance().onTickInGame(guiGraphics);
        }
        catch (RuntimeException e) {
            VoxelConstants.getLogger().log(Level.ERROR, "Error while render overlay", (Throwable)e);
        }
    }

    public static boolean onChat(class_2561 chat, class_7591 indicator) {
        return CommandUtils.checkForWaypoints(chat, indicator);
    }

    public static boolean onSendChatMessage(String message) {
        if (message.startsWith("newWaypoint")) {
            CommandUtils.waypointClicked(message);
            return false;
        }
        if (message.startsWith("ztp")) {
            CommandUtils.teleport(message);
            return false;
        }
        return true;
    }

    public static void onRenderWaypoints(float gameTimeDeltaPartialTick, class_4587 poseStack, class_4597.class_4598 bufferSource, class_4184 camera) {
        try {
            VoxelConstants.getVoxelMapInstance().getWaypointManager().renderWaypoints(gameTimeDeltaPartialTick, poseStack, bufferSource, camera);
        }
        catch (RuntimeException e) {
            VoxelConstants.getLogger().log(Level.ERROR, "Error while render waypoints", (Throwable)e);
        }
    }

    public static void onShutDown() {
        VoxelConstants.getLogger().info("Saving all world maps");
        VoxelConstants.getVoxelMapInstance().getPersistentMap().purgeCachedRegions();
        VoxelConstants.getVoxelMapInstance().getMapOptions().saveAll();
        BiomeRepository.saveBiomeColors();
        long shutdownTime = System.currentTimeMillis();
        while (ThreadManager.executorService.getQueue().size() + ThreadManager.executorService.getActiveCount() > 0 && System.currentTimeMillis() - shutdownTime < 10000L) {
            Thread.onSpinWait();
        }
    }

    public static void playerRunTeleportCommand(double x, double y, double z) {
        MapSettingsManager mapSettingsManager = VoxelConstants.getVoxelMapInstance().getMapOptions();
        String cmd = mapSettingsManager.serverTeleportCommand == null ? mapSettingsManager.teleportCommand : mapSettingsManager.serverTeleportCommand;
        cmd = cmd.replace("%p", VoxelConstants.getPlayer().method_5477().getString()).replace("%x", String.valueOf(x + 0.5)).replace("%y", String.valueOf(y)).replace("%z", String.valueOf(z + 0.5));
        VoxelConstants.getPlayer().field_3944.method_45730(cmd);
    }

    public static int moveScoreboard(int bottomX, int entriesHeight) {
        double unscaledHeight = Map.getMinTablistOffset();
        if (VoxelMap.mapOptions.hide || !VoxelMap.mapOptions.minimapAllowed || VoxelMap.mapOptions.mapCorner != 1 || !VoxelMap.mapOptions.moveScoreBoardDown || !Double.isFinite(unscaledHeight)) {
            return bottomX;
        }
        double scaleFactor = class_310.method_1551().method_22683().method_4495();
        double mapHeightScaled = unscaledHeight * 1.37 / scaleFactor;
        Objects.requireNonNull(class_310.method_1551().field_1772);
        int fontHeight = 9;
        float statusIconOffset = Map.getStatusIconOffset();
        int statusIconOffsetInt = Float.isFinite(statusIconOffset) ? (int)statusIconOffset : 0;
        int minBottom = (int)(mapHeightScaled + (double)entriesHeight + (double)fontHeight + (double)statusIconOffsetInt);
        return Math.max(bottomX, minBottom);
    }

    public static void setEvents(Events events) {
        VoxelConstants.events = events;
    }

    public static Events getEvents() {
        return events;
    }

    public static PacketBridge getPacketBridge() {
        return packetBridge;
    }

    public static void setPacketBridge(PacketBridge packetBridge) {
        VoxelConstants.packetBridge = packetBridge;
    }

    public static void setModApiBride(ModApiBridge modApiBridge) {
        VoxelConstants.modApiBridge = modApiBridge;
    }

    public static ModApiBridge getModApiBridge() {
        return modApiBridge;
    }

    static {
        OPTIONS_BACKGROUND_TEXTURE = class_2960.method_60654((String)"textures/block/dirt.png");
        elapsedTicks = 0;
    }
}

