/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.entityrender;

import com.mamiyaotaru.voxelmap.entityrender.EntityVariantData;
import com.mamiyaotaru.voxelmap.entityrender.EntityVariantDataFactory;
import com.mamiyaotaru.voxelmap.entityrender.variants.DefaultEntityVariantData;
import com.mamiyaotaru.voxelmap.entityrender.variants.DefaultEntityVariantDataFactory;
import com.mamiyaotaru.voxelmap.entityrender.variants.HorseVariantDataFactory;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.AllocatedTexture;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.VoxelMapCachedOrthoProjectionMatrixBuffer;
import com.mamiyaotaru.voxelmap.util.VoxelMapPipelines;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_10017;
import net.minecraft.class_10366;
import net.minecraft.class_1044;
import net.minecraft.class_11260;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_332;
import net.minecraft.class_3730;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_561;
import net.minecraft.class_576;
import net.minecraft.class_578;
import net.minecraft.class_583;
import net.minecraft.class_599;
import net.minecraft.class_609;
import net.minecraft.class_612;
import net.minecraft.class_615;
import net.minecraft.class_621;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_7751;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import net.minecraft.class_922;
import net.minecraft.class_945;
import net.minecraft.class_9801;
import net.minecraft.class_997;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class EntityMapImageManager {
    public static final class_2960 resourceTextureAtlasMarker = class_2960.method_60655((String)"voxelmap", (String)"atlas/mobs");
    private final TextureAtlas textureAtlas;
    private final class_310 minecraft = class_310.method_1551();
    private GpuTexture fboDepthTexture;
    private GpuTexture fboTexture;
    private final class_2960 resourceFboTexture = class_2960.method_60655((String)"voxelmap", (String)"entityimagemanager/fbo");
    private class_289 fboTessellator = new class_289(4096);
    private int imageCreationRequests;
    private int fulfilledImageCreationRequests;
    private final HashMap<class_1299<?>, EntityVariantDataFactory> variantDataFactories = new HashMap();
    private ConcurrentLinkedQueue<Runnable> taskQueue = new ConcurrentLinkedQueue();
    private final class_4184 fakeCamera = new class_4184();
    private GpuTextureView fboTextureView;
    private GpuTextureView fboDepthTextureView;
    private VoxelMapCachedOrthoProjectionMatrixBuffer projection;
    private final HashMap<String, Properties> mobPropertiesMap = new HashMap();
    private final Class<?>[] fullRenderModels = new Class[]{class_561.class, class_576.class, class_599.class, class_609.class, class_612.class, class_615.class};

    public EntityMapImageManager() {
        this.textureAtlas = new TextureAtlas("mobsmap", resourceTextureAtlasMarker);
        this.textureAtlas.method_4527(true, false);
        int fboTextureSize = 512;
        this.fboTexture = RenderSystem.getDevice().createTexture("voxelmap-radarfbotexture", 15, TextureFormat.RGBA8, 512, 512, 1, 1);
        this.fboDepthTexture = RenderSystem.getDevice().createTexture("voxelmap-radarfbodepth", 15, TextureFormat.DEPTH32, 512, 512, 1, 1);
        class_310.method_1551().method_1531().method_4616(this.resourceFboTexture, (class_1044)new AllocatedTexture(this.fboTexture));
        this.fboTextureView = RenderSystem.getDevice().createTextureView(this.fboTexture);
        this.fboDepthTextureView = RenderSystem.getDevice().createTextureView(this.fboDepthTexture);
        this.projection = new VoxelMapCachedOrthoProjectionMatrixBuffer("VoxelMap Entity Map Image Proj", 256.0f, -256.0f, -256.0f, 256.0f, 1000.0f, 21000.0f);
    }

    public void reset() {
        this.textureAtlas.reset();
        this.textureAtlas.registerIconForBufferedImage((Object)"hostile", ImageUtils.loadImage(class_2960.method_60655((String)"voxelmap", (String)"images/radar/hostile.png"), 0, 0, 16, 16, 16, 16));
        this.textureAtlas.registerIconForBufferedImage((Object)"neutral", ImageUtils.loadImage(class_2960.method_60655((String)"voxelmap", (String)"images/radar/neutral.png"), 0, 0, 16, 16, 16, 16));
        this.textureAtlas.registerIconForBufferedImage((Object)"tame", ImageUtils.loadImage(class_2960.method_60655((String)"voxelmap", (String)"images/radar/tame.png"), 0, 0, 16, 16, 16, 16));
        this.textureAtlas.stitch();
        this.mobPropertiesMap.clear();
        this.variantDataFactories.clear();
        this.addVariantDataFactory(new DefaultEntityVariantDataFactory(class_1299.field_49148, class_2960.method_60656((String)"textures/entity/skeleton/bogged_overlay.png")));
        this.addVariantDataFactory(new DefaultEntityVariantDataFactory(class_1299.field_6123, class_2960.method_60656((String)"textures/entity/zombie/drowned_outer_layer.png")));
        this.addVariantDataFactory(new DefaultEntityVariantDataFactory(class_1299.field_6091, class_2960.method_60656((String)"textures/entity/enderman/enderman_eyes.png")));
        this.addVariantDataFactory(new HorseVariantDataFactory(class_1299.field_6139));
    }

    private void addVariantDataFactory(EntityVariantDataFactory factory) {
        this.variantDataFactories.put(factory.getType(), factory);
    }

    public Sprite requestImageForMobType(class_1299<?> type, boolean addBorder) {
        return this.requestImageForMobType(type, -1, addBorder);
    }

    public Sprite requestImageForMobType(class_1299<?> type, int size, boolean addBorder) {
        class_1297 class_12972;
        if (this.minecraft.field_1687 != null && (class_12972 = type.method_5883((class_1937)this.minecraft.field_1687, class_3730.field_52444)) instanceof class_1309) {
            class_1309 le = (class_1309)class_12972;
            return this.requestImageForMob((class_1297)le, size, addBorder);
        }
        return null;
    }

    public Sprite requestImageForMob(class_1309 e, boolean addBorder) {
        return this.requestImageForMob((class_1297)e, -1, addBorder);
    }

    private EntityVariantData getVariantData(class_1297 entity, class_897 renderer, class_10017 state, int size, boolean addBorder) {
        EntityVariantData data;
        EntityVariantDataFactory factory = this.variantDataFactories.get(entity.method_5864());
        if (factory != null && (data = factory.createVariantData(entity, renderer, state, size, addBorder)) != null) {
            return data;
        }
        return DefaultEntityVariantDataFactory.createSimpleVariantData(entity, renderer, state, size, addBorder);
    }

    public Sprite requestImageForMob(class_1297 entity, int size, boolean addBorder) {
        class_897 baseRenderer = this.minecraft.method_1561().method_3953(entity);
        EntityVariantData variant = null;
        class_10017 renderState = null;
        if (entity instanceof class_742) {
            class_742 player = (class_742)entity;
            variant = new DefaultEntityVariantData(entity.method_5864(), player.method_52814().comp_1626().comp_3627(), null, size, addBorder);
        } else if (entity instanceof class_1309 && baseRenderer instanceof class_922) {
            class_922 renderer = (class_922)baseRenderer;
            if (this.minecraft.method_1561().field_4686 == null) {
                this.minecraft.method_1561().field_4686 = this.fakeCamera;
            }
            renderState = renderer.method_62425(entity, 0.5f);
            if (this.minecraft.method_1561().field_4686 == this.fakeCamera) {
                this.minecraft.method_1561().field_4686 = null;
            }
            variant = this.getVariantData(entity, (class_897)renderer, renderState, size, addBorder);
        }
        if (variant == null) {
            return null;
        }
        Sprite existing = this.textureAtlas.getAtlasSpriteIncludingYetToBeStitched(variant);
        if (existing != null && existing != this.textureAtlas.getMissingImage()) {
            return existing;
        }
        Sprite sprite = this.textureAtlas.registerEmptyIcon(variant);
        class_2960 resourceLocation = variant.getPrimaryTexture();
        class_2960 resourceLocation2 = variant.getSecondaryTexture();
        RenderPipeline renderPipeline = VoxelMapPipelines.ENTITY_ICON_PIPELINE;
        class_287 bufferBuilder = this.fboTessellator.method_60827(VertexFormat.class_5596.field_27382, renderPipeline.getVertexFormat());
        class_4587 pose = new class_4587();
        pose.method_22903();
        float scale = 64.0f;
        pose.method_46416(0.0f, 0.0f, -3000.0f);
        pose.method_22905(scale, scale, -scale);
        Properties mobProperties = this.getMobProperties(entity);
        String rotation = mobProperties.getProperty("rotation", "");
        if (!rotation.isEmpty()) {
            for (String data : rotation.split(",")) {
                float degrees = Float.parseFloat(data.substring(1));
                if (data.startsWith("x")) {
                    pose.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(degrees));
                }
                if (data.startsWith("y")) {
                    pose.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(degrees));
                }
                if (!data.startsWith("z")) continue;
                pose.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(degrees));
            }
        }
        class_583 model = ((class_922)baseRenderer).method_4038();
        model.method_63514();
        for (class_630 part : this.getPartToRender(model)) {
            part.field_3654 = 0.0f;
            part.field_3675 = 0.0f;
            part.field_3674 = 0.0f;
            part.method_22699(pose, (class_4588)bufferBuilder, 15, 0, -1);
        }
        if (baseRenderer instanceof class_945) {
            class_945 slimeRenderer = (class_945)baseRenderer;
            class_997 slimeOuter = (class_997)slimeRenderer.field_4738.get(0);
            slimeOuter.field_4895.method_2819((Object)renderState);
            slimeOuter.field_4895.method_63512().method_22699(pose, (class_4588)bufferBuilder, 15, 0, -1);
        }
        class_1044 texture = this.minecraft.method_1531().method_4619(resourceLocation);
        class_1044 texture2 = resourceLocation2 == null ? null : this.minecraft.method_1531().method_4619(resourceLocation2);
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().identity();
        GpuBufferSlice gpuBufferSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)new Vector3f(), (Matrix4fc)RenderSystem.getTextureMatrix(), RenderSystem.getShaderLineWidth());
        try (class_9801 meshData = bufferBuilder.method_60794();){
            VertexFormat.class_5595 indexType;
            GpuBuffer indexBuffer;
            if (meshData == null) {
                Sprite sprite2 = sprite;
                return sprite2;
            }
            GpuBuffer vertexBuffer = renderPipeline.getVertexFormat().uploadImmediateVertexBuffer(meshData.method_60818());
            if (meshData.method_60821() == null) {
                RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)meshData.method_60822().comp_752());
                indexBuffer = autoStorageIndexBuffer.method_68274(meshData.method_60822().comp_751());
                indexType = autoStorageIndexBuffer.method_31924();
            } else {
                indexBuffer = renderPipeline.getVertexFormat().uploadImmediateIndexBuffer(meshData.method_60821());
                indexType = meshData.method_60822().comp_753();
            }
            class_10366 originalProjectionType = RenderSystem.getProjectionType();
            GpuBufferSlice originalProjectionMatrix = RenderSystem.getProjectionMatrixBuffer();
            RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projection.getBuffer(), (class_10366)class_10366.field_54954);
            try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "VoxelMap entity image renderer", this.fboTextureView, OptionalInt.of(0), this.fboDepthTextureView, OptionalDouble.of(1.0));){
                renderPass.setPipeline(renderPipeline);
                RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
                renderPass.setUniform("DynamicTransforms", gpuBufferSlice);
                renderPass.bindSampler("Sampler0", texture.method_71659());
                renderPass.setVertexBuffer(0, vertexBuffer);
                renderPass.setIndexBuffer(indexBuffer, indexType);
                renderPass.drawIndexed(0, 0, meshData.method_60822().comp_751(), 1);
                if (texture2 != null) {
                    renderPass.bindSampler("Sampler0", texture2.method_71659());
                    renderPass.drawIndexed(0, 0, meshData.method_60822().comp_751(), 1);
                }
            }
            RenderSystem.getModelViewStack().popMatrix();
            RenderSystem.setProjectionMatrix((GpuBufferSlice)originalProjectionMatrix, (class_10366)originalProjectionType);
        }
        ++this.imageCreationRequests;
        GLUtils.readTextureContentsToBufferedImage(this.fboTexture, image2 -> this.postProcessRenderedMobImage(entity, sprite, model, (BufferedImage)image2, addBorder));
        return sprite;
    }

    private void postProcessRenderedMobImage(class_1297 entity, Sprite sprite, class_583 model, BufferedImage image2, boolean addBorder) {
        class_156.method_18349().execute(() -> {
            float maxSize;
            Graphics2D g;
            BufferedImage image = image2;
            image = ImageUtils.flipHorizontal(image);
            if (model instanceof class_7751) {
                g = image.createGraphics();
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(0, 192, image.getWidth(), image.getHeight());
            }
            if (model instanceof class_578) {
                g = image.createGraphics();
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(0, 248, image.getWidth(), image.getHeight());
            }
            if (model instanceof class_11260) {
                g = image.createGraphics();
                g.setComposite(AlphaComposite.Clear);
                g.fillRect(0, 352, image.getWidth(), image.getHeight());
            }
            image = ImageUtils.trim(image);
            float targetSize = maxSize = (float)Math.max(image.getHeight(), image.getWidth());
            if (model instanceof class_599) {
                targetSize = 64.0f;
            }
            Properties mobProperties = this.getMobProperties(entity);
            if (maxSize > 0.0f && maxSize != (targetSize *= Float.parseFloat(mobProperties.getProperty("scale", "1.0")))) {
                image = ImageUtils.scaleImage(image, targetSize / maxSize);
            }
            BufferedImage image3 = image = ImageUtils.fillOutline(ImageUtils.pad(image), addBorder, 2);
            this.taskQueue.add(() -> {
                ++this.fulfilledImageCreationRequests;
                sprite.setTextureData(ImageUtils.nativeImageFromBufferedImage(image3));
                if (this.fulfilledImageCreationRequests == this.imageCreationRequests) {
                    this.textureAtlas.stitchNew();
                }
            });
        });
    }

    private Properties getMobProperties(class_1297 entity) {
        String entityId = entity.method_5864().method_5882();
        String filePath = ("textures/icons/" + entityId + ".properties").toLowerCase();
        if (this.mobPropertiesMap.containsKey(filePath)) {
            return this.mobPropertiesMap.get(filePath);
        }
        Properties properties = new Properties();
        Optional resource = this.minecraft.method_1478().method_14486(class_2960.method_60654((String)filePath));
        if (resource.isPresent()) {
            try (InputStream inputStream = ((class_3298)resource.get()).method_14482();){
                properties.load(inputStream);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mobPropertiesMap.put(filePath, properties);
        return properties;
    }

    private class_630[] getPartToRender(class_583<?> model) {
        for (Class<?> clazz : this.fullRenderModels) {
            if (!clazz.isInstance(model)) continue;
            return new class_630[]{model.method_63512()};
        }
        if (model instanceof class_621) {
            class_621 witherModel = (class_621)model;
            return new class_630[]{witherModel.method_63512().method_32086("left_head"), witherModel.method_63512().method_32086("center_head"), witherModel.method_63512().method_32086("right_head")};
        }
        for (class_630 part : model.method_63513()) {
            if (!part.method_41919("head_parts")) continue;
            return new class_630[]{part.method_32086("head_parts")};
        }
        for (class_630 part : model.method_63513()) {
            if (!part.method_41919("head")) continue;
            if (part.method_41919("body0")) {
                return new class_630[]{part.method_32086("head"), part.method_32086("body0")};
            }
            return new class_630[]{part.method_32086("head")};
        }
        for (class_630 part : model.method_63513()) {
            if (!part.method_41919("body")) continue;
            return new class_630[]{part.method_32086("body")};
        }
        for (class_630 part : model.method_63513()) {
            if (!part.method_41919("cube")) continue;
            return new class_630[]{part.method_32086("cube")};
        }
        for (class_630 part : model.method_63513()) {
            if (!part.method_41919("segment0")) continue;
            return new class_630[]{part.method_32086("segment0"), part.method_32086("segment1")};
        }
        return new class_630[]{model.method_63512()};
    }

    public void onRenderTick(class_332 drawContext) {
        Runnable task;
        while ((task = this.taskQueue.poll()) != null) {
            task.run();
        }
    }

    private /* synthetic */ void lambda$reset$0(class_1299 t) {
        this.requestImageForMobType(t, 32, true);
    }
}

