/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.gui.GuiMinimapControls;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_6382;
import net.minecraft.class_7919;

public class GuiButtonRowListKeys
extends class_350<RowItem> {
    private final MapSettingsManager options;
    private final GuiMinimapControls parentGui;
    private final ArrayList<RowItem> rowItems = new ArrayList();
    private class_304 keyForEdit;
    private final HashMap<class_304, class_2561> duplicateKeys = new HashMap();

    public GuiButtonRowListKeys(GuiMinimapControls parentScreen) {
        super(VoxelConstants.getMinecraft(), parentScreen.getWidth(), parentScreen.getHeight() - 114, 40, 20);
        this.parentGui = parentScreen;
        this.options = VoxelConstants.getVoxelMapInstance().getMapOptions();
        for (int i = 0; i < this.options.keyBindings.length; ++i) {
            int ii = i;
            this.rowItems.add(new RowItem(this.parentGui, new class_4185.class_7840((class_2561)class_2561.method_43473(), button -> {
                this.keyForEdit = this.options.keyBindings[ii];
            }).method_46434(0, 0, 75, 20).method_46431(), new class_4185.class_7840((class_2561)class_2561.method_43471((String)"controls.reset"), button -> this.resetKeyMapping(ii)).method_46434(0, 0, 50, 20).method_46431(), this.options.keyBindings[i]));
        }
        this.rowItems.sort(Comparator.comparing(entry -> entry.keyMapping));
        this.checkDuplicateKeys();
        this.rowItems.forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
    }

    public boolean keyEditing() {
        return this.keyForEdit != null;
    }

    private void resetKeyMapping(int index) {
        class_304 key = this.options.keyBindings[index];
        this.options.setKeyBinding(key, key.method_1429());
        this.checkDuplicateKeys();
        class_304.method_1426();
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClick) {
        if (this.keyEditing()) {
            this.options.setKeyBinding(this.keyForEdit, class_3675.class_307.field_1672.method_1447(mouseButtonEvent.method_74245()));
            this.keyForEdit = null;
            this.checkDuplicateKeys();
            class_304.method_1426();
            return true;
        }
        return super.method_25402(mouseButtonEvent, doubleClick);
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (this.keyEditing()) {
            if (keyEvent.comp_4795() == 256) {
                boolean isMenuKey = this.keyForEdit.method_1435(this.options.keyBindMenu);
                if (!isMenuKey) {
                    this.options.setKeyBinding(this.keyForEdit, class_3675.field_16237);
                }
            } else {
                this.options.setKeyBinding(this.keyForEdit, class_3675.method_15985((class_11908)keyEvent));
            }
            this.keyForEdit = null;
            this.checkDuplicateKeys();
            class_304.method_1426();
            return true;
        }
        return super.method_25404(keyEvent);
    }

    private void checkDuplicateKeys() {
        this.duplicateKeys.clear();
        for (class_304 key : this.options.keyBindings) {
            class_304[] duplicates;
            if (key.method_1415() || (duplicates = (class_304[])Arrays.stream(this.field_22740.field_1690.field_1839).filter(compare -> key != compare && key.method_1435(compare)).toArray(class_304[]::new)).length <= 0) continue;
            boolean bl = false;
            class_5250 details = class_2561.method_43473();
            for (class_304 duplicate : duplicates) {
                if (bl) {
                    details.method_27693(", ");
                }
                bl = true;
                details.method_10852((class_2561)class_2561.method_43471((String)duplicate.method_1431()));
            }
            this.duplicateKeys.put(key, (class_2561)class_2561.method_43469((String)"controls.keybinds.duplicateKeybinds", (Object[])new Object[]{details}));
        }
    }

    public int method_25322() {
        return 340;
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public class RowItem
    extends class_350.class_351<RowItem> {
        private final GuiMinimapControls parentGui;
        private final class_4185 button;
        private final class_4185 buttonReset;
        private final class_304 keyMapping;

        protected RowItem(GuiMinimapControls parentScreen, class_4185 button, class_4185 buttonReset, class_304 keyMapping) {
            this.parentGui = parentScreen;
            this.button = button;
            this.buttonReset = buttonReset;
            this.keyMapping = keyMapping;
        }

        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.button != null && this.buttonReset != null) {
                guiGraphics.method_27535(this.parentGui.method_64506(), (class_2561)class_2561.method_43471((String)this.keyMapping.method_1431()), this.method_46426() + 5, this.method_46427() + 5, -1);
                class_2561 tooltip = null;
                class_5250 keyText = this.keyMapping.method_16007().method_27661();
                if (GuiButtonRowListKeys.this.keyForEdit != null && GuiButtonRowListKeys.this.keyForEdit == this.keyMapping) {
                    keyText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"> ").method_27692(class_124.field_1054)).method_10852((class_2561)keyText.method_27661().method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" <").method_27692(class_124.field_1054));
                } else if (GuiButtonRowListKeys.this.duplicateKeys.containsKey(this.keyMapping)) {
                    keyText = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"[ ").method_27692(class_124.field_1054)).method_10852((class_2561)keyText.method_27661().method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" ]").method_27692(class_124.field_1054));
                    tooltip = GuiButtonRowListKeys.this.duplicateKeys.get(this.keyMapping);
                }
                if (tooltip != null) {
                    this.button.method_47400(class_7919.method_47407(tooltip));
                }
                this.button.method_25355((class_2561)keyText);
                this.button.method_46421(this.method_46426() + this.method_25368() - 135);
                this.button.method_46419(this.method_46427());
                this.button.method_25394(guiGraphics, mouseX, mouseY, tickDelta);
                this.buttonReset.field_22763 = !this.keyMapping.method_1427();
                this.buttonReset.method_46421(this.method_46426() + this.method_25368() - 55);
                this.buttonReset.method_46419(this.method_46427());
                this.buttonReset.method_25394(guiGraphics, mouseX, mouseY, tickDelta);
            }
        }

        public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClick) {
            GuiButtonRowListKeys.this.method_25313(this);
            boolean clicked = false;
            if (this.button != null && this.button.method_25402(mouseButtonEvent, doubleClick)) {
                clicked = true;
            } else if (this.buttonReset != null && this.buttonReset.method_25402(mouseButtonEvent, doubleClick)) {
                clicked = true;
            }
            return clicked;
        }
    }
}

