/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiButtonText;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiOptionButtonMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import net.minecraft.class_1074;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class GuiMinimapPerformance
extends GuiScreenMinimap {
    private static final EnumOptionsMinimap[] relevantOptions = new EnumOptionsMinimap[]{EnumOptionsMinimap.DYNAMIC_LIGHTING, EnumOptionsMinimap.TERRAIN_DEPTH, EnumOptionsMinimap.WATER_TRANSPARENCY, EnumOptionsMinimap.BLOCK_TRANSPARENCY, EnumOptionsMinimap.BIOMES, EnumOptionsMinimap.FILTERING, EnumOptionsMinimap.CHUNK_GRID, EnumOptionsMinimap.BIOME_OVERLAY, EnumOptionsMinimap.SLIME_CHUNKS, EnumOptionsMinimap.WORLD_BORDER};
    private GuiButtonText worldSeedButton;
    private GuiButtonText teleportCommandButton;
    private GuiOptionButtonMinimap slimeChunksButton;
    private final class_437 parentScreen;
    protected String screenTitle = "Details / Performance";
    private final MapSettingsManager options;

    public GuiMinimapPerformance(class_437 par1GuiScreen) {
        this.parentScreen = par1GuiScreen;
        this.setParentScreen(this.parentScreen);
        this.options = VoxelConstants.getVoxelMapInstance().getMapOptions();
    }

    private int getLeftBorder() {
        return this.getWidth() / 2 - 155;
    }

    public void method_25426() {
        this.screenTitle = class_1074.method_4662((String)"options.minimap.detailsPerformance", (Object[])new Object[0]);
        int leftBorder = this.getLeftBorder();
        int var2 = 0;
        for (EnumOptionsMinimap option : relevantOptions) {
            StringBuilder text = new StringBuilder().append(this.options.getKeyText(option));
            if ((option == EnumOptionsMinimap.WATER_TRANSPARENCY || option == EnumOptionsMinimap.BLOCK_TRANSPARENCY || option == EnumOptionsMinimap.BIOMES) && !this.options.multicore && this.options.getOptionBooleanValue(option)) {
                text.append("\u00a7c").append((CharSequence)text);
            }
            GuiOptionButtonMinimap optionButton = new GuiOptionButtonMinimap(leftBorder + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), option, (class_2561)class_2561.method_43470((String)text.toString()), this::optionClicked);
            this.method_37063((class_364)optionButton);
            ++var2;
            if (optionButton.returnEnumOptions() != EnumOptionsMinimap.SLIME_CHUNKS) continue;
            this.slimeChunksButton = optionButton;
            this.slimeChunksButton.field_22763 = VoxelConstants.getMinecraft().method_1496() || !VoxelConstants.getVoxelMapInstance().getWorldSeed().isEmpty();
        }
        String worldSeedDisplay = VoxelConstants.getVoxelMapInstance().getWorldSeed();
        if (worldSeedDisplay.isEmpty()) {
            worldSeedDisplay = class_1074.method_4662((String)"selectWorld.versionUnknown", (Object[])new Object[0]);
        }
        String buttonSeedText = class_1074.method_4662((String)"options.minimap.worldSeed", (Object[])new Object[0]) + ": " + worldSeedDisplay;
        this.worldSeedButton = new GuiButtonText(this.method_64506(), leftBorder + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), 150, 20, (class_2561)class_2561.method_43470((String)buttonSeedText), button -> this.worldSeedButton.setEditing(true));
        this.worldSeedButton.setText(VoxelConstants.getVoxelMapInstance().getWorldSeed());
        this.worldSeedButton.field_22763 = !VoxelConstants.getMinecraft().method_1496();
        this.method_37063((class_364)this.worldSeedButton);
        String buttonTeleportText = class_1074.method_4662((String)"options.minimap.teleportCommand", (Object[])new Object[0]) + ": " + VoxelConstants.getVoxelMapInstance().getMapOptions().teleportCommand;
        this.teleportCommandButton = new GuiButtonText(this.method_64506(), leftBorder + ++var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), 150, 20, (class_2561)class_2561.method_43470((String)buttonTeleportText), button -> this.teleportCommandButton.setEditing(true));
        this.teleportCommandButton.setText(VoxelConstants.getVoxelMapInstance().getMapOptions().teleportCommand);
        this.teleportCommandButton.field_22763 = VoxelConstants.getVoxelMapInstance().getMapOptions().serverTeleportCommand == null;
        this.method_37063((class_364)this.teleportCommandButton);
        ++var2;
        ++var2;
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"gui.done"), button -> VoxelConstants.getMinecraft().method_1507(this.parentScreen)).method_46434(this.getWidth() / 2 - 100, this.getHeight() - 28, 200, 20).method_46431());
    }

    @Override
    public void method_25432() {
    }

    protected void optionClicked(class_4185 par1GuiButton) {
        EnumOptionsMinimap option = ((GuiOptionButtonMinimap)par1GuiButton).returnEnumOptions();
        this.options.setOptionValue(option);
        String perfBomb = "";
        if ((option == EnumOptionsMinimap.WATER_TRANSPARENCY || option == EnumOptionsMinimap.BLOCK_TRANSPARENCY || option == EnumOptionsMinimap.BIOMES) && !this.options.multicore && this.options.getOptionBooleanValue(option)) {
            perfBomb = "\u00a7c";
        }
        par1GuiButton.method_25355((class_2561)class_2561.method_43470((String)(perfBomb + this.options.getKeyText(option))));
    }

    @Override
    public boolean method_25404(class_11908 keyEvent) {
        int keyCode = keyEvent.comp_4795();
        if (keyCode == 258) {
            this.worldSeedButton.method_25404(keyEvent);
            this.teleportCommandButton.method_25404(keyEvent);
        }
        if (keyCode == 257 || keyCode == 335) {
            if (this.worldSeedButton.isEditing()) {
                this.newSeed();
            } else if (this.teleportCommandButton.isEditing()) {
                this.newTeleportCommand();
            }
        }
        return super.method_25404(keyEvent);
    }

    public boolean method_25400(class_11905 characterEvent) {
        boolean OK = super.method_25400(characterEvent);
        if (characterEvent.comp_4793() == 13) {
            if (this.worldSeedButton.isEditing()) {
                this.newSeed();
            } else if (this.teleportCommandButton.isEditing()) {
                this.newTeleportCommand();
            }
        }
        return OK;
    }

    private void newSeed() {
        String newSeed = this.worldSeedButton.getText();
        VoxelConstants.getVoxelMapInstance().setWorldSeed(newSeed);
        String worldSeedDisplay = VoxelConstants.getVoxelMapInstance().getWorldSeed();
        if (worldSeedDisplay.isEmpty()) {
            worldSeedDisplay = class_1074.method_4662((String)"selectWorld.versionUnknown", (Object[])new Object[0]);
        }
        String buttonText = class_1074.method_4662((String)"options.minimap.worldSeed", (Object[])new Object[0]) + ": " + worldSeedDisplay;
        this.worldSeedButton.method_25355((class_2561)class_2561.method_43470((String)buttonText));
        this.worldSeedButton.setText(VoxelConstants.getVoxelMapInstance().getWorldSeed());
        VoxelConstants.getVoxelMapInstance().getMap().forceFullRender(true);
        this.slimeChunksButton.field_22763 = VoxelConstants.getMinecraft().method_1496() || !VoxelConstants.getVoxelMapInstance().getWorldSeed().isEmpty();
    }

    private void newTeleportCommand() {
        String newTeleportCommand;
        VoxelConstants.getVoxelMapInstance().getMapOptions().teleportCommand = newTeleportCommand = this.teleportCommandButton.getText().isEmpty() ? "tp %p %x %y %z" : this.teleportCommandButton.getText();
        String buttonText = class_1074.method_4662((String)"options.minimap.teleportCommand", (Object[])new Object[0]) + ": " + newTeleportCommand;
        this.teleportCommandButton.method_25355((class_2561)class_2561.method_43470((String)buttonText));
        this.teleportCommandButton.setText(VoxelConstants.getVoxelMapInstance().getMapOptions().teleportCommand);
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        drawContext.method_25300(this.method_64506(), this.screenTitle, this.getWidth() / 2, 20, -1);
        super.method_25394(drawContext, mouseX, mouseY, delta);
    }
}

