/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.gui.GuiWaypoints;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_10539;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_350;
import net.minecraft.class_6382;

class GuiSlotWaypoints
extends class_350<WaypointItem> {
    private final ArrayList<WaypointItem> waypoints;
    private ArrayList<?> waypointsFiltered;
    final GuiWaypoints parentGui;
    private String filterString = "";
    static final class_2561 TOOLTIP_ENABLE = class_2561.method_43471((String)"minimap.waypoints.enableTooltip");
    static final class_2561 TOOLTIP_DISABLE = class_2561.method_43471((String)"minimap.waypoints.disableTooltip");
    static final class_2561 TOOLTIP_HIGHLIGHT = class_2561.method_43471((String)"minimap.waypoints.highlightTooltip");
    static final class_2561 TOOLTIP_UNHIGHLIGHT = class_2561.method_43471((String)"minimap.waypoints.removeHighlightTooltip");
    final class_2960 visibleIconIdentifier = class_2960.method_60654((String)"textures/gui/sprites/container/beacon/confirm.png");
    final class_2960 invisibleIconIdentifier = class_2960.method_60654((String)"textures/gui/sprites/container/beacon/cancel.png");
    protected long lastClicked;
    public boolean doubleClicked;
    private final class_2960 targetIconLocation = class_2960.method_60655((String)"voxelmap", (String)"images/waypoints/target.png");
    private final TextureAtlas textureAtlas;

    GuiSlotWaypoints(GuiWaypoints par1GuiWaypoints) {
        super(VoxelConstants.getMinecraft(), par1GuiWaypoints.getWidth(), par1GuiWaypoints.getHeight() - 140, 54, 18);
        this.parentGui = par1GuiWaypoints;
        this.waypoints = new ArrayList();
        for (Waypoint pt : this.parentGui.waypointManager.getWaypoints()) {
            if (!pt.inWorld || !pt.inDimension) continue;
            this.waypoints.add(new WaypointItem(this.parentGui, pt));
        }
        this.waypointsFiltered = new ArrayList<WaypointItem>(this.waypoints);
        this.waypointsFiltered.forEach(x -> this.method_25321((WaypointItem)x));
        try {
            class_1043 targetIcon = new class_1043(() -> "Waypoint Target Icon", class_10539.method_65871((class_3300)VoxelConstants.getMinecraft().method_1478(), (class_2960)this.targetIconLocation).comp_3447());
            targetIcon.method_4527(true, false);
            this.field_22740.method_1531().method_4616(this.targetIconLocation, (class_1044)targetIcon);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.textureAtlas = VoxelConstants.getVoxelMapInstance().getWaypointManager().getTextureAtlasChooser();
    }

    public void setSelected(WaypointItem entry) {
        super.method_25313((class_350.class_351)entry);
        if (this.method_25334() instanceof WaypointItem) {
            class_333 narratorManager = new class_333(VoxelConstants.getMinecraft());
            narratorManager.method_44708((class_2561)class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{((WaypointItem)this.method_25334()).waypoint.name}));
        }
        this.parentGui.setSelectedWaypoint(entry.waypoint);
    }

    protected void sortBy(int sortKey, boolean ascending) {
        int order;
        int n = order = ascending ? 1 : -1;
        if (sortKey == 1) {
            ArrayList<Waypoint> masterWaypointsList = this.parentGui.waypointManager.getWaypoints();
            this.waypoints.sort((waypointEntry1, waypointEntry2) -> Double.compare(masterWaypointsList.indexOf(waypointEntry1.waypoint), masterWaypointsList.indexOf(waypointEntry2.waypoint)) * order);
        } else if (sortKey == 3) {
            if (ascending) {
                Collections.sort(this.waypoints);
            } else {
                this.waypoints.sort(Collections.reverseOrder());
            }
        } else if (sortKey == 2) {
            this.waypoints.sort((waypointEntry1, waypointEntry2) -> String.CASE_INSENSITIVE_ORDER.compare(waypointEntry1.waypoint.name, waypointEntry2.waypoint.name) * order);
        } else if (sortKey == 4) {
            this.waypoints.sort((waypointEntry1, waypointEntry2) -> {
                Waypoint waypoint1 = waypointEntry1.waypoint;
                Waypoint waypoint2 = waypointEntry2.waypoint;
                float hue1 = Color.RGBtoHSB((int)(waypoint1.red * 255.0f), (int)(waypoint1.green * 255.0f), (int)(waypoint1.blue * 255.0f), null)[0];
                float hue2 = Color.RGBtoHSB((int)(waypoint2.red * 255.0f), (int)(waypoint2.green * 255.0f), (int)(waypoint2.blue * 255.0f), null)[0];
                return Double.compare(hue1, hue2) * order;
            });
        }
        this.updateFilter(this.filterString);
    }

    protected void updateFilter(String filterString) {
        this.method_25339();
        this.filterString = filterString;
        this.waypointsFiltered = new ArrayList<WaypointItem>(this.waypoints);
        Iterator<?> iterator = this.waypointsFiltered.iterator();
        while (iterator.hasNext()) {
            Waypoint waypoint = ((WaypointItem)iterator.next()).waypoint;
            if (TextUtils.scrubCodes(waypoint.name).toLowerCase().contains(filterString)) continue;
            if (waypoint == this.parentGui.selectedWaypoint) {
                this.parentGui.setSelectedWaypoint(null);
            }
            iterator.remove();
        }
        this.waypointsFiltered.forEach(x -> this.method_25321((WaypointItem)x));
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClick) {
        this.doubleClicked = System.currentTimeMillis() - this.lastClicked < 250L;
        this.lastClicked = System.currentTimeMillis();
        return super.method_25402(mouseButtonEvent, doubleClick);
    }

    public class WaypointItem
    extends class_350.class_351<WaypointItem>
    implements Comparable<WaypointItem> {
        private final GuiWaypoints parentGui;
        private final Waypoint waypoint;

        protected WaypointItem(GuiWaypoints waypointScreen, Waypoint waypoint) {
            this.parentGui = waypointScreen;
            this.waypoint = waypoint;
        }

        public void method_25343(class_332 drawContext, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int x = this.method_46426();
            int y = this.method_46427();
            int entryHeight = this.method_25364();
            drawContext.method_25300(this.parentGui.method_64506(), this.waypoint.name, this.parentGui.getWidth() / 2, y + 3, this.waypoint.getUnifiedColor());
            int padding = 3;
            int iconWidth = 16;
            if (mouseX >= x - padding && mouseY >= y && mouseX <= x + 215 + padding && mouseY <= y + entryHeight) {
                class_2561 tooltip;
                if (mouseX >= x + 215 - iconWidth - padding && mouseX <= x + 215 + padding) {
                    drawContext.method_74037(class_11876.field_62455);
                    tooltip = this.waypoint.enabled ? TOOLTIP_DISABLE : TOOLTIP_ENABLE;
                } else if (mouseX >= x + padding && mouseX <= x + iconWidth + padding) {
                    drawContext.method_74037(class_11876.field_62455);
                    tooltip = this.waypoint == this.parentGui.highlightedWaypoint ? TOOLTIP_UNHIGHLIGHT : TOOLTIP_HIGHLIGHT;
                } else {
                    String tooltipText = "X: " + this.waypoint.getX() + ", Y: " + this.waypoint.getY() + ", Z: " + this.waypoint.getZ();
                    tooltip = class_2561.method_43470((String)tooltipText);
                }
                if (mouseX >= GuiSlotWaypoints.this.method_46426() && mouseX <= GuiSlotWaypoints.this.method_55442() && mouseY >= GuiSlotWaypoints.this.method_46427() && mouseY <= GuiSlotWaypoints.this.method_55443()) {
                    GuiWaypoints.setTooltip(GuiSlotWaypoints.this.parentGui, tooltip);
                }
            }
            drawContext.method_25290(class_10799.field_56883, this.waypoint.enabled ? GuiSlotWaypoints.this.visibleIconIdentifier : GuiSlotWaypoints.this.invisibleIconIdentifier, x + 198, y - 2, 0.0f, 0.0f, 18, 18, 18, 18);
            GuiSlotWaypoints.this.textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + this.waypoint.imageSuffix + ".png").blit(drawContext, class_10799.field_56883, x, y - 2, 18.0f, 18.0f, this.waypoint.getUnifiedColor());
            if (this.waypoint == this.parentGui.highlightedWaypoint) {
                drawContext.method_25291(class_10799.field_56883, GuiSlotWaypoints.this.targetIconLocation, x, y - 2, 0.0f, 1.0f, 18, 18, 18, 18, -65536);
            }
        }

        public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClick) {
            double mouseX = mouseButtonEvent.comp_4798();
            double mouseY = mouseButtonEvent.comp_4799();
            if (mouseY < (double)GuiSlotWaypoints.this.method_46427() || mouseY > (double)GuiSlotWaypoints.this.method_55443()) {
                return false;
            }
            GuiSlotWaypoints.this.setSelected(this);
            int leftEdge = this.parentGui.getWidth() / 2 - 92 - 16;
            int padding = 3;
            int iconWidth = 16;
            int width = 215;
            if (mouseX >= (double)(leftEdge + width - iconWidth - padding) && mouseX <= (double)(leftEdge + width + padding)) {
                this.parentGui.toggleWaypointVisibility();
            } else if (mouseX >= (double)(leftEdge + padding) && mouseX <= (double)(leftEdge + iconWidth + padding)) {
                this.parentGui.setHighlightedWaypoint();
            } else if (GuiSlotWaypoints.this.doubleClicked) {
                this.parentGui.editWaypoint(this.parentGui.selectedWaypoint);
            }
            return true;
        }

        @Override
        public int compareTo(WaypointItem o) {
            return this.waypoint.compareTo(o.waypoint);
        }
    }
}

