/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.persistent;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.util.CompressionUtils;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class CompressibleMapData
extends AbstractMapData {
    public static final int DATA_VERSION = 4;
    public static final int LAYERS = 22;
    private static final int HEIGHTPOS = 0;
    private static final int BLOCKSTATEPOS = 2;
    private static final int LIGHTPOS = 4;
    private static final int OCEANFLOORHEIGHTPOS = 5;
    private static final int OCEANFLOORBLOCKSTATEPOS = 7;
    private static final int OCEANFLOORLIGHTPOS = 9;
    private static final int TRANSPARENTHEIGHTPOS = 10;
    private static final int TRANSPARENTBLOCKSTATEPOS = 12;
    private static final int TRANSPARENTLIGHTPOS = 14;
    private static final int FOLIAGEHEIGHTPOS = 15;
    private static final int FOLIAGEBLOCKSTATEPOS = 17;
    private static final int FOLIAGELIGHTPOS = 19;
    private static final int BIOMEIDPOS = 20;
    private static final int REGION_SIZE = 256;
    private static final byte[] compressedEmptyData = CompressionUtils.compress(CompressibleMapData.generateEmptyData());
    private byte[] data;
    private boolean isCompressed;
    private BiMap<class_2680, Integer> blockStateToInt;
    int blockStateCount = 1;
    private BiMap<class_1959, Integer> biomeToInt;
    int biomeCount = 1;
    private final class_638 world;
    private final class_310 MINECRAFT = class_310.method_1551();

    public CompressibleMapData(class_638 world) {
        this.width = 256;
        this.height = 256;
        this.data = compressedEmptyData;
        this.world = world;
        this.isCompressed = true;
    }

    private static byte[] generateEmptyData() {
        byte[] data = new byte[0x160000];
        int value = Short.MIN_VALUE;
        byte b0 = (byte)(value >> 8);
        byte b1 = (byte)value;
        Arrays.fill(data, 0, 65536, b0);
        Arrays.fill(data, 65536, 131072, b1);
        return data;
    }

    @Override
    public int getHeight(int x, int z) {
        return this.getDataSignedShort(x, z, 0);
    }

    @Override
    public class_2680 getBlockstate(int x, int z) {
        int id = this.getDataUnsignedShort(x, z, 2);
        return this.getStateFromID(id);
    }

    @Override
    public int getBiomeTint(int x, int z) {
        return 0;
    }

    @Override
    public int getLight(int x, int z) {
        return this.getData(x, z, 4) & 0xFF;
    }

    @Override
    public int getOceanFloorHeight(int x, int z) {
        return this.getDataSignedShort(x, z, 5);
    }

    @Override
    public class_2680 getOceanFloorBlockstate(int x, int z) {
        int id = this.getDataUnsignedShort(x, z, 7);
        return this.getStateFromID(id);
    }

    @Override
    public int getOceanFloorBiomeTint(int x, int z) {
        return 0;
    }

    @Override
    public int getOceanFloorLight(int x, int z) {
        return this.getData(x, z, 9) & 0xFF;
    }

    @Override
    public int getTransparentHeight(int x, int z) {
        return this.getDataSignedShort(x, z, 10);
    }

    @Override
    public class_2680 getTransparentBlockstate(int x, int z) {
        int id = this.getDataUnsignedShort(x, z, 12);
        return this.getStateFromID(id);
    }

    @Override
    public int getTransparentBiomeTint(int x, int z) {
        return 0;
    }

    @Override
    public int getTransparentLight(int x, int z) {
        return this.getData(x, z, 14) & 0xFF;
    }

    @Override
    public int getFoliageHeight(int x, int z) {
        return this.getDataSignedShort(x, z, 15);
    }

    @Override
    public class_2680 getFoliageBlockstate(int x, int z) {
        int id = this.getDataUnsignedShort(x, z, 17);
        return this.getStateFromID(id);
    }

    @Override
    public int getFoliageBiomeTint(int x, int z) {
        return 0;
    }

    @Override
    public int getFoliageLight(int x, int z) {
        return this.getData(x, z, 19) & 0xFF;
    }

    @Override
    public class_1959 getBiome(int x, int z) {
        int biomeId = this.getBiomeId(x, z);
        if (biomeId == 0 && this.getHeight(x, z) != Short.MIN_VALUE) {
            return (class_1959)((class_6880.class_6883)this.MINECRAFT.field_1687.method_30349().method_30530(class_7924.field_41236).method_46746(class_1972.field_9451).get()).comp_349();
        }
        return this.getBiomeFromID(biomeId);
    }

    public int getBiomeId(int x, int z) {
        if (this.isCompressed) {
            this.decompress();
        }
        return this.getDataUnsignedShort(x, z, 20);
    }

    private synchronized byte getData(int x, int z, int layer) {
        if (this.isCompressed) {
            this.decompress();
        }
        int index = x + z * this.width + this.width * this.height * layer;
        return this.data[index];
    }

    private synchronized int getDataUnsignedShort(int x, int z, int layer) {
        return (this.getData(x, z, layer) & 0xFF) << 8 | this.getData(x, z, layer + 1) & 0xFF;
    }

    private synchronized int getDataSignedShort(int x, int z, int layer) {
        return this.getData(x, z, layer) << 8 | this.getData(x, z, layer + 1) & 0xFF;
    }

    @Override
    public void setHeight(int x, int z, int height) {
        this.setDataShort(x, z, 0, height);
    }

    @Override
    public void setBlockstate(int x, int z, class_2680 state) {
        int id = this.getIDFromState(state);
        this.setDataShort(x, z, 2, id);
    }

    @Override
    public void setBiomeTint(int x, int z, int tint) {
    }

    @Override
    public void setLight(int x, int z, int light) {
        this.setData(x, z, 4, (byte)light);
    }

    @Override
    public void setOceanFloorHeight(int x, int z, int height) {
        this.setDataShort(x, z, 5, height);
    }

    @Override
    public void setOceanFloorBlockstate(int x, int z, class_2680 state) {
        int id = this.getIDFromState(state);
        this.setDataShort(x, z, 7, id);
    }

    @Override
    public void setOceanFloorBiomeTint(int x, int z, int tint) {
    }

    @Override
    public void setOceanFloorLight(int x, int z, int light) {
        this.setData(x, z, 9, (byte)light);
    }

    @Override
    public void setTransparentHeight(int x, int z, int height) {
        this.setDataShort(x, z, 10, height);
    }

    @Override
    public void setTransparentBlockstate(int x, int z, class_2680 state) {
        int id = this.getIDFromState(state);
        this.setDataShort(x, z, 12, id);
    }

    @Override
    public void setTransparentBiomeTint(int x, int z, int tint) {
    }

    @Override
    public void setTransparentLight(int x, int z, int light) {
        this.setData(x, z, 14, (byte)light);
    }

    @Override
    public void setFoliageHeight(int x, int z, int height) {
        this.setDataShort(x, z, 15, height);
    }

    @Override
    public void setFoliageBlockstate(int x, int z, class_2680 state) {
        int id = this.getIDFromState(state);
        this.setDataShort(x, z, 17, id);
    }

    @Override
    public void setFoliageBiomeTint(int x, int z, int tint) {
    }

    @Override
    public void setFoliageLight(int x, int z, int light) {
        this.setData(x, z, 19, (byte)light);
    }

    @Override
    public void setBiome(int x, int z, class_1959 biome) {
        if (this.isCompressed) {
            this.decompress();
        }
        int id = this.getIDFromBiome(biome);
        this.setDataShort(x, z, 20, id);
    }

    private synchronized void setData(int x, int z, int layer, byte value) {
        if (this.isCompressed) {
            this.decompress();
        }
        int index = x + z * this.width + this.width * this.height * layer;
        this.data[index] = value;
    }

    private synchronized void setDataShort(int x, int z, int layer, int value) {
        this.setData(x, z, layer, (byte)(value >> 8));
        this.setData(x, z, layer + 1, (byte)value);
    }

    @Override
    public synchronized void moveX(int x) {
        if (this.isCompressed) {
            this.decompress();
        }
        if (x > 0) {
            System.arraycopy(this.data, x * 22, this.data, 0, this.data.length - x * 22);
        } else if (x < 0) {
            System.arraycopy(this.data, 0, this.data, -x * 22, this.data.length + x * 22);
        }
    }

    @Override
    public synchronized void moveZ(int z) {
        if (this.isCompressed) {
            this.decompress();
        }
        if (z > 0) {
            System.arraycopy(this.data, z * this.width * 22, this.data, 0, this.data.length - z * this.width * 22);
        } else if (z < 0) {
            System.arraycopy(this.data, 0, this.data, -z * this.width * 22, this.data.length + z * this.width * 22);
        }
    }

    public synchronized void setData(byte[] is, BiMap<class_2680, Integer> newStateToInt, BiMap<class_1959, Integer> newBiomeToInt, int version) {
        this.data = is;
        this.isCompressed = false;
        if (version < 4) {
            this.convertData(version);
        }
        this.blockStateToInt = newStateToInt;
        this.blockStateCount = this.blockStateToInt.size();
        this.biomeToInt = newBiomeToInt;
        this.biomeCount = this.biomeToInt.size();
    }

    private synchronized void convertData(int version) {
        if (this.isCompressed) {
            this.decompress();
        }
        if (version < 2) {
            int OLD_LAYERS = 18;
            byte[] newData = new byte[this.data.length];
            for (int x = 0; x < this.width; ++x) {
                for (int z = 0; z < this.height; ++z) {
                    for (int layer = 0; layer < 18; ++layer) {
                        int oldIndex = (x + z * this.width) * 18 + layer;
                        int newIndex = x + z * this.width + this.width * this.height * layer;
                        newData[newIndex] = this.data[oldIndex];
                    }
                }
            }
            this.data = newData;
        }
        if (version < 4) {
            boolean OLD_HEIGHTPOS = false;
            boolean OLD_BLOCKSTATEPOS = true;
            int OLD_LIGHTPOS = 3;
            int OLD_OCEANFLOORHEIGHTPOS = 4;
            int OLD_OCEANFLOORBLOCKSTATEPOS = 5;
            int OLD_OCEANFLOORLIGHTPOS = 7;
            int OLD_TRANSPARENTHEIGHTPOS = 8;
            int OLD_TRANSPARENTBLOCKSTATEPOS = 9;
            int OLD_TRANSPARENTLIGHTPOS = 11;
            int OLD_FOLIAGEHEIGHTPOS = 12;
            int OLD_FOLIAGEBLOCKSTATEPOS = 13;
            int OLD_FOLIAGELIGHTPOS = 15;
            int OLD_BIOMEIDPOS = 16;
            byte[] newData = new byte[this.width * this.height * 22];
            this.copyUnsignedByteLayerToShortLayer(this.data, newData, 0, 0);
            this.copyShortLayer(this.data, newData, 1, 2);
            this.copyByteLayer(this.data, newData, 3, 4);
            this.copyUnsignedByteLayerToShortLayer(this.data, newData, 4, 5);
            this.copyShortLayer(this.data, newData, 5, 7);
            this.copyByteLayer(this.data, newData, 7, 9);
            this.copyUnsignedByteLayerToShortLayer(this.data, newData, 8, 10);
            this.copyShortLayer(this.data, newData, 9, 12);
            this.copyByteLayer(this.data, newData, 11, 14);
            this.copyUnsignedByteLayerToShortLayer(this.data, newData, 12, 15);
            this.copyShortLayer(this.data, newData, 13, 17);
            this.copyByteLayer(this.data, newData, 15, 19);
            this.copyShortLayer(this.data, newData, 16, 20);
            this.data = newData;
            for (int z = 0; z < this.width; ++z) {
                for (int x = 0; x < this.height; ++x) {
                    if (this.getHeight(x, z) != 0) continue;
                    this.setHeight(x, z, Short.MIN_VALUE);
                }
            }
        }
    }

    private void copyUnsignedByteLayerToShortLayer(byte[] oldData, byte[] newData, int oldLayer, int newLayer) {
        this.copyByteLayer(oldData, newData, oldLayer, newLayer + 1);
    }

    private void copyByteLayer(byte[] oldData, byte[] newData, int oldLayer, int newLayer) {
        int start = this.width * this.height * oldLayer;
        int newStart = this.width * this.height * newLayer;
        int length = this.width * this.height;
        System.arraycopy(oldData, start, newData, newStart, length);
    }

    private void copyShortLayer(byte[] oldData, byte[] newData, int oldLayer, int newLayer) {
        int start = this.width * this.height * oldLayer;
        int newStart = this.width * this.height * newLayer;
        int length = this.width * this.height * 2;
        System.arraycopy(oldData, start, newData, newStart, length);
    }

    public synchronized byte[] getData() {
        if (this.isCompressed) {
            this.decompress();
        }
        return this.data;
    }

    public synchronized void compress() {
        if (!this.isCompressed) {
            this.isCompressed = true;
            this.data = CompressionUtils.compress(this.data);
        }
    }

    private synchronized void decompress() {
        if (this.blockStateToInt == null) {
            this.blockStateToInt = HashBiMap.create();
        }
        if (this.biomeToInt == null) {
            this.biomeToInt = HashBiMap.create();
        }
        if (this.isCompressed) {
            try {
                this.data = CompressionUtils.decompress(this.data);
                this.isCompressed = false;
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean isCompressed() {
        return this.isCompressed;
    }

    private synchronized int getIDFromState(class_2680 blockState) {
        Integer id = (Integer)this.blockStateToInt.get((Object)blockState);
        if (id == null && blockState != null) {
            while (this.blockStateToInt.inverse().containsKey((Object)this.blockStateCount)) {
                ++this.blockStateCount;
            }
            id = this.blockStateCount;
            this.blockStateToInt.put((Object)blockState, (Object)id);
        }
        return id;
    }

    private class_2680 getStateFromID(int id) {
        return (class_2680)this.blockStateToInt.inverse().get((Object)id);
    }

    public BiMap<class_2680, Integer> getStateToInt() {
        this.blockStateToInt = this.createKeyFromCurrentBlocks(this.blockStateToInt);
        return this.blockStateToInt;
    }

    private BiMap<class_2680, Integer> createKeyFromCurrentBlocks(BiMap<class_2680, Integer> oldMap) {
        this.blockStateCount = 1;
        HashBiMap newMap = HashBiMap.create();
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.height; ++z) {
                Integer id;
                class_2680 blockState;
                int oldID = (this.getData(x, z, 2) & 0xFF) << 8 | this.getData(x, z, 3) & 0xFF;
                if (oldID != 0) {
                    blockState = (class_2680)oldMap.inverse().get((Object)oldID);
                    id = (Integer)newMap.get((Object)blockState);
                    if (id == null && blockState != null) {
                        while (newMap.inverse().containsKey((Object)this.blockStateCount)) {
                            ++this.blockStateCount;
                        }
                        id = this.blockStateCount;
                        newMap.put((Object)blockState, (Object)id);
                    }
                    if (id == null) {
                        id = 0;
                    }
                    this.setData(x, z, 2, (byte)(id >> 8));
                    this.setData(x, z, 3, (byte)id.intValue());
                }
                if ((oldID = (this.getData(x, z, 7) & 0xFF) << 8 | this.getData(x, z, 8) & 0xFF) != 0) {
                    blockState = (class_2680)oldMap.inverse().get((Object)oldID);
                    id = (Integer)newMap.get((Object)blockState);
                    if (id == null && blockState != null) {
                        while (newMap.inverse().containsKey((Object)this.blockStateCount)) {
                            ++this.blockStateCount;
                        }
                        id = this.blockStateCount;
                        newMap.put((Object)blockState, (Object)id);
                    }
                    if (id == null) {
                        id = 0;
                    }
                    this.setData(x, z, 7, (byte)(id >> 8));
                    this.setData(x, z, 8, (byte)id.intValue());
                }
                if ((oldID = (this.getData(x, z, 12) & 0xFF) << 8 | this.getData(x, z, 13) & 0xFF) != 0) {
                    blockState = (class_2680)oldMap.inverse().get((Object)oldID);
                    id = (Integer)newMap.get((Object)blockState);
                    if (id == null && blockState != null) {
                        while (newMap.inverse().containsKey((Object)this.blockStateCount)) {
                            ++this.blockStateCount;
                        }
                        id = this.blockStateCount;
                        newMap.put((Object)blockState, (Object)id);
                    }
                    if (id == null) {
                        id = 0;
                    }
                    this.setData(x, z, 12, (byte)(id >> 8));
                    this.setData(x, z, 13, (byte)id.intValue());
                }
                if ((oldID = (this.getData(x, z, 17) & 0xFF) << 8 | this.getData(x, z, 18) & 0xFF) == 0) continue;
                blockState = (class_2680)oldMap.inverse().get((Object)oldID);
                id = (Integer)newMap.get((Object)blockState);
                if (id == null && blockState != null) {
                    while (newMap.inverse().containsKey((Object)this.blockStateCount)) {
                        ++this.blockStateCount;
                    }
                    id = this.blockStateCount;
                    newMap.put((Object)blockState, (Object)id);
                }
                if (id == null) {
                    id = 0;
                }
                this.setData(x, z, 17, (byte)(id >> 8));
                this.setData(x, z, 18, (byte)id.intValue());
            }
        }
        return newMap;
    }

    private synchronized int getIDFromBiome(class_1959 biome) {
        if (biome == null) {
            return 0;
        }
        Integer id = (Integer)this.biomeToInt.get((Object)biome);
        if (id == null) {
            while (this.biomeToInt.inverse().containsKey((Object)this.biomeCount)) {
                ++this.biomeCount;
            }
            id = this.biomeCount;
            this.biomeToInt.put((Object)biome, (Object)id);
        }
        return id;
    }

    private class_1959 getBiomeFromID(int id) {
        if (id == 0) {
            return null;
        }
        class_1959 biome = (class_1959)this.biomeToInt.inverse().get((Object)id);
        if (biome != null) {
            return biome;
        }
        return (class_1959)((class_6880.class_6883)this.world.method_30349().method_30530(class_7924.field_41236).method_46746(class_1972.field_9451).get()).comp_349();
    }

    public BiMap<class_1959, Integer> getBiomeToInt() {
        this.biomeToInt = this.createKeyFromCurrentBiomes(this.biomeToInt);
        return this.biomeToInt;
    }

    private BiMap<class_1959, Integer> createKeyFromCurrentBiomes(BiMap<class_1959, Integer> oldMap) {
        this.biomeCount = 1;
        HashBiMap newMap = HashBiMap.create();
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.height; ++z) {
                Integer id;
                int oldID = (this.getData(x, z, 20) & 0xFF) << 8 | this.getData(x, z, 21) & 0xFF;
                if (oldID == 0) continue;
                class_1959 biome = (class_1959)oldMap.inverse().get((Object)oldID);
                if (biome == null) {
                    biome = (class_1959)((class_6880.class_6883)this.world.method_30349().method_30530(class_7924.field_41236).method_46746(class_1972.field_9451).get()).comp_349();
                }
                if ((id = (Integer)newMap.get((Object)biome)) == null && biome != null) {
                    while (newMap.inverse().containsKey((Object)this.biomeCount)) {
                        ++this.biomeCount;
                    }
                    id = this.biomeCount;
                    newMap.put((Object)biome, (Object)id);
                }
                if (id == null) {
                    id = 0;
                }
                this.setData(x, z, 20, (byte)(id >> 8));
                this.setData(x, z, 21, (byte)id.intValue());
            }
        }
        return newMap;
    }

    public int getExpectedDataLength(int version) {
        int OLD_LAYERS_BEFORE_V4 = 18;
        return this.getWidth() * this.getHeight() * (version < 4 ? 18 : 22);
    }
}

