/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.persistent;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.VoxelMap;
import com.mamiyaotaru.voxelmap.WaypointManager;
import com.mamiyaotaru.voxelmap.gui.GuiAddWaypoint;
import com.mamiyaotaru.voxelmap.gui.GuiMinimapOptions;
import com.mamiyaotaru.voxelmap.gui.GuiSubworldsSelect;
import com.mamiyaotaru.voxelmap.gui.GuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.IGuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.Popup;
import com.mamiyaotaru.voxelmap.gui.overridden.PopupGuiButton;
import com.mamiyaotaru.voxelmap.gui.overridden.PopupGuiScreen;
import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.persistent.CachedRegion;
import com.mamiyaotaru.voxelmap.persistent.PersistentMap;
import com.mamiyaotaru.voxelmap.persistent.PersistentMapSettingsManager;
import com.mamiyaotaru.voxelmap.persistent.ThreadManager;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.BackgroundImageInfo;
import com.mamiyaotaru.voxelmap.util.BiomeMapData;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.EasingUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.VoxelMapGuiGraphics;
import com.mamiyaotaru.voxelmap.util.VoxelMapPipelines;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1664;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_642;
import org.lwjgl.glfw.GLFW;

public class GuiPersistentMap
extends PopupGuiScreen
implements IGuiWaypoints {
    private final Random generator = new Random();
    private final PersistentMap persistentMap;
    private final WaypointManager waypointManager;
    private final class_437 parent;
    private final MapSettingsManager mapOptions;
    private final PersistentMapSettingsManager options;
    protected String screenTitle = "World Map";
    protected String worldNameDisplay = "";
    protected int worldNameDisplayLength;
    protected int maxWorldNameDisplayLength;
    private String subworldName = "";
    private PopupGuiButton buttonMultiworld;
    private int top;
    private int bottom;
    private boolean oldNorth;
    private boolean lastStill;
    private boolean editingCoordinates;
    private boolean lastEditingCoordinates;
    private class_342 coordinates;
    int centerX;
    int centerY;
    float mapCenterX;
    float mapCenterZ;
    float deltaX;
    float deltaY;
    float deltaXonRelease;
    float deltaYonRelease;
    long timeOfRelease;
    boolean mouseCursorShown = true;
    long timeAtLastTick;
    long timeOfLastKBInput;
    long timeOfLastMouseInput;
    float lastMouseX;
    float lastMouseY;
    protected int mouseX;
    protected int mouseY;
    boolean leftMouseButtonDown;
    float zoom;
    float zoomStart;
    float zoomGoal;
    long timeOfZoom;
    float zoomDirectX;
    float zoomDirectY;
    private float scScale = 1.0f;
    private float guiToMap = 2.0f;
    private float mapToGui = 0.5f;
    private float mouseDirectToMap = 1.0f;
    private float guiToDirectMouse = 2.0f;
    private static boolean gotSkin;
    private boolean closed;
    private CachedRegion[] regions = new CachedRegion[0];
    BackgroundImageInfo backGroundImageInfo;
    private final BiomeMapData biomeMapData = new BiomeMapData(760, 360);
    private float mapPixelsX;
    private float mapPixelsY;
    private final Object closedLock = new Object();
    private class_2561 multiworldButtonName;
    private class_5250 multiworldButtonNameRed;
    int sideMargin = 10;
    int buttonCount = 5;
    int buttonSeparation = 4;
    int buttonWidth = 66;
    public boolean editClicked;
    public boolean deleteClicked;
    public boolean addClicked;
    Waypoint newWaypoint;
    Waypoint selectedWaypoint;
    public boolean passEvents;
    private PopupGuiButton buttonWaypoints;
    private final class_310 minecraft = class_310.method_1551();
    private final class_2960 voxelmapSkinLocation = class_2960.method_60655((String)"voxelmap", (String)"persistentmap/playerskin");
    private final class_2960 crosshairResource = class_2960.method_60654((String)"textures/gui/sprites/hud/crosshair.png");
    private boolean currentDragging;
    private boolean keySprintPressed;
    private boolean keyUpPressed;
    private boolean keyDownPressed;
    private boolean keyLeftPressed;
    private boolean keyRightPressed;
    private int iconsWidth = 16;
    private int iconsHeight = 16;

    public GuiPersistentMap(class_437 parent) {
        this.parent = parent;
        this.setParentScreen(this.parent);
        this.waypointManager = VoxelConstants.getVoxelMapInstance().getWaypointManager();
        this.mapOptions = VoxelConstants.getVoxelMapInstance().getMapOptions();
        this.persistentMap = VoxelConstants.getVoxelMapInstance().getPersistentMap();
        this.options = VoxelConstants.getVoxelMapInstance().getPersistentMapOptions();
        this.zoom = this.options.zoom;
        this.zoomStart = this.options.zoom;
        this.zoomGoal = this.options.zoom;
        this.persistentMap.setLightMapArray(VoxelConstants.getVoxelMapInstance().getMap().getLightmapArray());
        if (!gotSkin) {
            this.getSkin();
        }
    }

    private void getSkin() {
        BufferedImage skinImage = ImageUtils.createBufferedImageFromResourceLocation(VoxelConstants.getPlayer().method_52814().comp_1626().comp_3627());
        if (skinImage == null) {
            return;
        }
        gotSkin = true;
        boolean showHat = VoxelConstants.getPlayer().method_74091(class_1664.field_7563);
        skinImage = showHat ? ImageUtils.addImages(ImageUtils.loadImage(skinImage, 8, 8, 8, 8), ImageUtils.loadImage(skinImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8) : ImageUtils.loadImage(skinImage, 8, 8, 8, 8);
        float scale = (float)skinImage.getWidth() / 8.0f;
        skinImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(skinImage, 2.0f / scale)), true, 1);
        class_1043 texture = new class_1043(() -> "Voxelmap player", ImageUtils.nativeImageFromBufferedImage(skinImage));
        texture.method_4527(true, false);
        this.minecraft.method_1531().method_4616(this.voxelmapSkinLocation, (class_1044)texture);
    }

    public void method_25426() {
        this.passEvents = true;
        this.oldNorth = this.mapOptions.oldNorth;
        this.centerAt(this.options.mapX, this.options.mapZ);
        if (this.minecraft.field_1755 == this) {
            this.closed = false;
        }
        this.screenTitle = class_1074.method_4662((String)"worldmap.title", (Object[])new Object[0]);
        this.buildWorldName();
        this.leftMouseButtonDown = false;
        this.sideMargin = 10;
        this.buttonCount = 5;
        this.buttonSeparation = 4;
        this.buttonWidth = (this.field_22789 - this.sideMargin * 2 - this.buttonSeparation * (this.buttonCount - 1)) / this.buttonCount;
        this.buttonWaypoints = new PopupGuiButton(this.sideMargin, this.getHeight() - 28, this.buttonWidth, 20, (class_2561)class_2561.method_43471((String)"options.minimap.waypoints"), button -> this.minecraft.method_1507((class_437)new GuiWaypoints(this)), this);
        this.method_37063((class_364)this.buttonWaypoints);
        this.multiworldButtonName = class_2561.method_43471((String)(VoxelConstants.isRealmServer() ? "menu.online" : "options.worldmap.multiworld"));
        this.multiworldButtonNameRed = class_2561.method_43471((String)(VoxelConstants.isRealmServer() ? "menu.online" : "options.worldmap.multiworld")).method_27692(class_124.field_1061);
        if (!this.minecraft.method_1496() && !VoxelConstants.getVoxelMapInstance().getWaypointManager().receivedAutoSubworldName()) {
            this.buttonMultiworld = new PopupGuiButton(this.sideMargin + (this.buttonWidth + this.buttonSeparation), this.getHeight() - 28, this.buttonWidth, 20, this.multiworldButtonName, button -> this.minecraft.method_1507((class_437)new GuiSubworldsSelect(this)), this);
            this.method_37063((class_364)this.buttonMultiworld);
        }
        this.method_37063((class_364)new PopupGuiButton(this.sideMargin + 3 * (this.buttonWidth + this.buttonSeparation), this.getHeight() - 28, this.buttonWidth, 20, (class_2561)class_2561.method_43471((String)"menu.options"), button -> this.minecraft.method_1507((class_437)new GuiMinimapOptions(this)), this));
        this.method_37063((class_364)new PopupGuiButton(this.sideMargin + 4 * (this.buttonWidth + this.buttonSeparation), this.getHeight() - 28, this.buttonWidth, 20, (class_2561)class_2561.method_43471((String)"gui.done"), button -> this.minecraft.method_1507(this.parent), this));
        this.coordinates = new class_342(this.method_64506(), this.sideMargin, 10, 140, 20, null);
        this.top = 32;
        this.bottom = this.getHeight() - 32;
        this.centerX = this.getWidth() / 2;
        this.centerY = (this.bottom - this.top) / 2;
        this.scScale = this.minecraft.method_22683().method_4495();
        this.mapPixelsX = this.minecraft.method_22683().method_4489();
        this.mapPixelsY = this.minecraft.method_22683().method_4506() - (int)(64.0f * this.scScale);
        this.lastStill = false;
        this.timeAtLastTick = System.currentTimeMillis();
    }

    private void centerAt(int x, int z) {
        if (this.oldNorth) {
            this.mapCenterX = -z;
            this.mapCenterZ = x;
        } else {
            this.mapCenterX = x;
            this.mapCenterZ = z;
        }
    }

    private void buildWorldName() {
        String subworldName;
        AtomicReference<String> worldName = new AtomicReference<String>();
        VoxelConstants.getIntegratedServer().ifPresentOrElse(integratedServer -> {
            worldName.set(integratedServer.method_27728().method_150());
            if (worldName.get() == null || ((String)worldName.get()).isBlank()) {
                worldName.set("Singleplayer World");
            }
        }, () -> {
            class_642 info = this.minecraft.method_1558();
            if (info != null) {
                worldName.set(info.field_3752);
            }
            if (worldName.get() == null || ((String)worldName.get()).isBlank()) {
                worldName.set("Multiplayer Server");
            }
            if (VoxelConstants.isRealmServer()) {
                worldName.set("Realms");
            }
        });
        StringBuilder worldNameBuilder = new StringBuilder("\u00a7r").append((String)worldName.get());
        this.subworldName = subworldName = VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(true);
        if ((subworldName == null || subworldName.isEmpty()) && VoxelConstants.getVoxelMapInstance().getWaypointManager().isMultiworld()) {
            subworldName = "???";
        }
        if (subworldName != null && !subworldName.isEmpty()) {
            worldNameBuilder.append(" - ").append(subworldName);
        }
        this.worldNameDisplay = worldNameBuilder.toString();
        this.worldNameDisplayLength = this.method_64506().method_1727(this.worldNameDisplay);
        this.maxWorldNameDisplayLength = this.getWidth() / 2 - this.method_64506().method_1727(this.screenTitle) / 2 - this.sideMargin * 2;
        while (this.worldNameDisplayLength > this.maxWorldNameDisplayLength && ((String)worldName.get()).length() > 5) {
            worldName.set(((String)worldName.get()).substring(0, ((String)worldName.get()).length() - 1));
            worldNameBuilder = new StringBuilder((String)worldName.get());
            worldNameBuilder.append("...");
            if (subworldName != null && !subworldName.isEmpty()) {
                worldNameBuilder.append(" - ").append(subworldName);
            }
            this.worldNameDisplay = worldNameBuilder.toString();
            this.worldNameDisplayLength = this.method_64506().method_1727(this.worldNameDisplay);
        }
        if (subworldName != null && !subworldName.isEmpty()) {
            while (this.worldNameDisplayLength > this.maxWorldNameDisplayLength && subworldName.length() > 5) {
                worldNameBuilder = new StringBuilder((String)worldName.get());
                worldNameBuilder.append("...");
                subworldName = subworldName.substring(0, subworldName.length() - 1);
                worldNameBuilder.append(" - ").append(subworldName);
                this.worldNameDisplay = worldNameBuilder.toString();
                this.worldNameDisplayLength = this.method_64506().method_1727(this.worldNameDisplay);
            }
        }
    }

    private float bindZoom(float zoom) {
        zoom = Math.max(this.options.minZoom, zoom);
        return Math.min(this.options.maxZoom, zoom);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double amount) {
        this.timeOfLastMouseInput = System.currentTimeMillis();
        this.switchToMouseInput();
        float mouseDirectX = (float)this.minecraft.field_1729.method_1603();
        float mouseDirectY = (float)this.minecraft.field_1729.method_1604();
        if (amount != 0.0) {
            if (amount > 0.0) {
                this.zoomGoal *= 1.26f;
            } else if (amount < 0.0) {
                this.zoomGoal /= 1.26f;
            }
            this.zoomStart = this.zoom;
            this.zoomGoal = this.bindZoom(this.zoomGoal);
            this.timeOfZoom = System.currentTimeMillis();
            this.zoomDirectX = mouseDirectX;
            this.zoomDirectY = mouseDirectY;
        }
        return true;
    }

    public boolean method_25406(class_11909 mouseButtonEvent) {
        this.currentDragging = false;
        if (this.mouseY > this.top && this.mouseY < this.bottom && mouseButtonEvent.method_74245() == 1) {
            this.timeOfLastKBInput = 0L;
            int mouseDirectX = (int)this.minecraft.field_1729.method_1603();
            int mouseDirectY = (int)this.minecraft.field_1729.method_1604();
            if (VoxelMap.mapOptions.worldmapAllowed) {
                this.createPopup((int)mouseButtonEvent.comp_4798(), (int)mouseButtonEvent.comp_4799(), mouseDirectX, mouseDirectY);
            }
        }
        return super.method_25406(mouseButtonEvent);
    }

    @Override
    public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClick) {
        if (this.popupOpen()) {
            this.coordinates.method_25402(mouseButtonEvent, doubleClick);
            this.editingCoordinates = this.coordinates.method_25370();
            if (this.editingCoordinates && !this.lastEditingCoordinates) {
                int z;
                int x;
                if (this.oldNorth) {
                    x = (int)Math.floor(this.mapCenterZ);
                    z = -((int)Math.floor(this.mapCenterX));
                } else {
                    x = (int)Math.floor(this.mapCenterX);
                    z = (int)Math.floor(this.mapCenterZ);
                }
                this.coordinates.method_1852(x + ", " + z);
                this.coordinates.method_1868(0xFFFFFF);
            }
            this.lastEditingCoordinates = this.editingCoordinates;
        }
        if (mouseButtonEvent.method_74245() == 0) {
            this.currentDragging = true;
        }
        return super.method_25402(mouseButtonEvent, doubleClick) || mouseButtonEvent.method_74245() == 1;
    }

    @Override
    public boolean method_25404(class_11908 keyEvent) {
        if (!this.editingCoordinates && (this.minecraft.field_1690.field_1903.method_1417(keyEvent) || this.minecraft.field_1690.field_1832.method_1417(keyEvent))) {
            if (this.minecraft.field_1690.field_1903.method_1417(keyEvent)) {
                this.zoomGoal /= 1.26f;
            }
            if (this.minecraft.field_1690.field_1832.method_1417(keyEvent)) {
                this.zoomGoal *= 1.26f;
            }
            this.zoomStart = this.zoom;
            this.zoomGoal = this.bindZoom(this.zoomGoal);
            this.timeOfZoom = System.currentTimeMillis();
            this.zoomDirectX = (float)this.minecraft.method_22683().method_4489() / 2.0f;
            this.zoomDirectY = (float)this.minecraft.method_22683().method_4506() - (float)this.minecraft.method_22683().method_4506() / 2.0f;
            this.switchToKeyboardInput();
        }
        this.clearPopups();
        if (this.editingCoordinates) {
            this.coordinates.method_25404(keyEvent);
            boolean isGood = this.isAcceptable(this.coordinates.method_1882());
            this.coordinates.method_1868(isGood ? 0xFFFFFF : 0xFF0000);
            if ((keyEvent.comp_4795() == 257 || keyEvent.comp_4795() == 335) && this.coordinates.method_25370() && isGood) {
                String[] xz = this.coordinates.method_1882().split(",");
                this.centerAt(Integer.parseInt(xz[0].trim()), Integer.parseInt(xz[1].trim()));
                this.editingCoordinates = false;
                this.lastEditingCoordinates = false;
                this.switchToKeyboardInput();
            }
            if (keyEvent.comp_4795() == 258 && this.coordinates.method_25370()) {
                this.editingCoordinates = false;
                this.lastEditingCoordinates = false;
                this.switchToKeyboardInput();
            }
        }
        if (VoxelConstants.getVoxelMapInstance().getMapOptions().keyBindMenu.method_1417(keyEvent)) {
            keyEvent = new class_11908(256, -1, -1);
        }
        this.keySprintPressed = this.minecraft.field_1690.field_1867.method_1417(keyEvent) || this.keySprintPressed;
        this.keyUpPressed = this.minecraft.field_1690.field_1894.method_1417(keyEvent) || this.keyUpPressed;
        this.keyDownPressed = this.minecraft.field_1690.field_1881.method_1417(keyEvent) || this.keyDownPressed;
        this.keyLeftPressed = this.minecraft.field_1690.field_1913.method_1417(keyEvent) || this.keyLeftPressed;
        this.keyRightPressed = this.minecraft.field_1690.field_1849.method_1417(keyEvent) || this.keyRightPressed;
        return super.method_25404(keyEvent);
    }

    public boolean method_16803(class_11908 keyEvent) {
        this.keySprintPressed = !this.minecraft.field_1690.field_1867.method_1417(keyEvent) && this.keySprintPressed;
        this.keyUpPressed = !this.minecraft.field_1690.field_1894.method_1417(keyEvent) && this.keyUpPressed;
        this.keyDownPressed = !this.minecraft.field_1690.field_1881.method_1417(keyEvent) && this.keyDownPressed;
        this.keyLeftPressed = !this.minecraft.field_1690.field_1913.method_1417(keyEvent) && this.keyLeftPressed;
        this.keyRightPressed = !this.minecraft.field_1690.field_1849.method_1417(keyEvent) && this.keyRightPressed;
        return super.method_16803(keyEvent);
    }

    public boolean method_25400(class_11905 characterEvent) {
        this.clearPopups();
        if (this.editingCoordinates) {
            this.coordinates.method_25400(characterEvent);
            boolean isGood = this.isAcceptable(this.coordinates.method_1882());
            this.coordinates.method_1868(isGood ? 0xFFFFFF : 0xFF0000);
            if (characterEvent.comp_4793() == 13 && this.coordinates.method_25370() && isGood) {
                String[] xz = this.coordinates.method_1882().split(",");
                this.centerAt(Integer.parseInt(xz[0].trim()), Integer.parseInt(xz[1].trim()));
                this.editingCoordinates = false;
                this.lastEditingCoordinates = false;
                this.switchToKeyboardInput();
            }
        }
        return super.method_25400(characterEvent);
    }

    private boolean isAcceptable(String input) {
        try {
            String[] xz = this.coordinates.method_1882().split(",");
            Integer.valueOf(xz[0].trim());
            Integer.valueOf(xz[1].trim());
            return true;
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException var3) {
            return false;
        }
    }

    private void switchToMouseInput() {
        this.timeOfLastKBInput = 0L;
        if (!this.mouseCursorShown) {
            GLFW.glfwSetInputMode((long)this.minecraft.method_22683().method_4490(), (int)208897, (int)212993);
        }
        this.mouseCursorShown = true;
    }

    private void switchToKeyboardInput() {
        this.timeOfLastKBInput = System.currentTimeMillis();
        this.mouseCursorShown = false;
        GLFW.glfwSetInputMode((long)this.minecraft.method_22683().method_4490(), (int)208897, (int)212995);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        int bottom;
        int top;
        int right;
        int left;
        guiGraphics.method_51448().pushMatrix();
        this.buttonWaypoints.field_22763 = VoxelMap.mapOptions.waypointsAllowed;
        this.zoomGoal = this.bindZoom(this.zoomGoal);
        if (this.mouseX != mouseX || this.mouseY != mouseY) {
            this.timeOfLastMouseInput = System.currentTimeMillis();
            this.switchToMouseInput();
        }
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        float mouseDirectX = (float)this.minecraft.field_1729.method_1603();
        float mouseDirectY = (float)this.minecraft.field_1729.method_1604();
        if (this.zoom != this.zoomGoal) {
            float previousZoom = this.zoom;
            long timeSinceZoom = System.currentTimeMillis() - this.timeOfZoom;
            this.zoom = (float)timeSinceZoom < 700.0f ? EasingUtils.easeOutExpo(this.zoomStart, this.zoomGoal, timeSinceZoom, 700.0f) : this.zoomGoal;
            float scaledZoom = this.zoom;
            if (this.minecraft.method_22683().method_4489() > 1600) {
                scaledZoom = this.zoom * (float)this.minecraft.method_22683().method_4489() / 1600.0f;
            }
            float zoomDelta = this.zoom / previousZoom;
            float zoomOffsetX = (float)this.centerX * this.guiToDirectMouse - this.zoomDirectX;
            float zoomOffsetY = (float)(this.top + this.centerY) * this.guiToDirectMouse - this.zoomDirectY;
            float zoomDeltaX = zoomOffsetX - zoomOffsetX * zoomDelta;
            float zoomDeltaY = zoomOffsetY - zoomOffsetY * zoomDelta;
            this.mapCenterX += zoomDeltaX / scaledZoom;
            this.mapCenterZ += zoomDeltaY / scaledZoom;
        }
        this.options.zoom = this.zoomGoal;
        float scaledZoom = this.zoom;
        if (this.minecraft.method_22683().method_4480() > 1600) {
            scaledZoom = this.zoom * (float)this.minecraft.method_22683().method_4480() / 1600.0f;
        }
        this.guiToMap = this.scScale / scaledZoom;
        this.mapToGui = 1.0f / this.scScale * scaledZoom;
        this.mouseDirectToMap = 1.0f / scaledZoom;
        this.guiToDirectMouse = this.scScale;
        this.renderBackground(guiGraphics);
        if (this.currentDragging) {
            if (!this.leftMouseButtonDown && this.overPopup(mouseX, mouseY)) {
                this.deltaX = 0.0f;
                this.deltaY = 0.0f;
                this.lastMouseX = mouseDirectX;
                this.lastMouseY = mouseDirectY;
                this.leftMouseButtonDown = true;
            } else if (this.leftMouseButtonDown) {
                this.deltaX = (this.lastMouseX - mouseDirectX) * this.mouseDirectToMap;
                this.deltaY = (this.lastMouseY - mouseDirectY) * this.mouseDirectToMap;
                this.lastMouseX = mouseDirectX;
                this.lastMouseY = mouseDirectY;
                this.deltaXonRelease = this.deltaX;
                this.deltaYonRelease = this.deltaY;
                this.timeOfRelease = System.currentTimeMillis();
            }
        } else {
            long timeSinceRelease = System.currentTimeMillis() - this.timeOfRelease;
            if ((float)timeSinceRelease < 700.0f) {
                this.deltaX = EasingUtils.easeOutExpo(this.deltaXonRelease, 0.0f, timeSinceRelease, 700.0f);
                this.deltaY = EasingUtils.easeOutExpo(this.deltaYonRelease, 0.0f, timeSinceRelease, 700.0f);
            } else {
                this.deltaX = 0.0f;
                this.deltaY = 0.0f;
                this.deltaXonRelease = 0.0f;
                this.deltaYonRelease = 0.0f;
            }
            this.leftMouseButtonDown = false;
        }
        long timeSinceLastTick = System.currentTimeMillis() - this.timeAtLastTick;
        this.timeAtLastTick = System.currentTimeMillis();
        if (!this.editingCoordinates) {
            int kbDelta = 5;
            if (this.keySprintPressed) {
                kbDelta = 10;
            }
            if (this.keyUpPressed) {
                this.deltaY -= (float)kbDelta / scaledZoom * (float)timeSinceLastTick / 12.0f;
                this.switchToKeyboardInput();
            }
            if (this.keyDownPressed) {
                this.deltaY += (float)kbDelta / scaledZoom * (float)timeSinceLastTick / 12.0f;
                this.switchToKeyboardInput();
            }
            if (this.keyLeftPressed) {
                this.deltaX -= (float)kbDelta / scaledZoom * (float)timeSinceLastTick / 12.0f;
                this.switchToKeyboardInput();
            }
            if (this.keyRightPressed) {
                this.deltaX += (float)kbDelta / scaledZoom * (float)timeSinceLastTick / 12.0f;
                this.switchToKeyboardInput();
            }
        }
        this.mapCenterX += this.deltaX;
        this.mapCenterZ += this.deltaY;
        if (this.oldNorth) {
            this.options.mapX = (int)this.mapCenterZ;
            this.options.mapZ = -((int)this.mapCenterX);
        } else {
            this.options.mapX = (int)this.mapCenterX;
            this.options.mapZ = (int)this.mapCenterZ;
        }
        this.centerX = this.getWidth() / 2;
        this.centerY = (this.bottom - this.top) / 2;
        if (this.oldNorth) {
            left = (int)Math.floor((this.mapCenterZ - (float)this.centerY * this.guiToMap) / 256.0f);
            right = (int)Math.floor((this.mapCenterZ + (float)this.centerY * this.guiToMap) / 256.0f);
            top = (int)Math.floor((-this.mapCenterX - (float)this.centerX * this.guiToMap) / 256.0f);
            bottom = (int)Math.floor((-this.mapCenterX + (float)this.centerX * this.guiToMap) / 256.0f);
        } else {
            left = (int)Math.floor((this.mapCenterX - (float)this.centerX * this.guiToMap) / 256.0f);
            right = (int)Math.floor((this.mapCenterX + (float)this.centerX * this.guiToMap) / 256.0f);
            top = (int)Math.floor((this.mapCenterZ - (float)this.centerY * this.guiToMap) / 256.0f);
            bottom = (int)Math.floor((this.mapCenterZ + (float)this.centerY * this.guiToMap) / 256.0f);
        }
        Object zoomDeltaX = this.closedLock;
        synchronized (zoomDeltaX) {
            if (this.closed) {
                return;
            }
            this.regions = this.persistentMap.getRegions(left - 1, right + 1, top - 1, bottom + 1);
        }
        this.backGroundImageInfo = this.waypointManager.getBackgroundImageInfo();
        if (this.backGroundImageInfo != null) {
            guiGraphics.method_70846(class_10799.field_56883, this.backGroundImageInfo.getImageLocation(), this.backGroundImageInfo.left, this.backGroundImageInfo.top + 32, 0, 0, this.backGroundImageInfo.width, this.backGroundImageInfo.height, this.backGroundImageInfo.width, this.backGroundImageInfo.height);
        }
        guiGraphics.method_51448().translate((float)this.centerX - this.mapCenterX * this.mapToGui, (float)(this.top + this.centerY) - this.mapCenterZ * this.mapToGui);
        if (this.oldNorth) {
            guiGraphics.method_51448().rotate(1.5707964f);
        }
        float cursorCoordZ = 0.0f;
        float cursorCoordX = 0.0f;
        guiGraphics.method_51448().scale(this.mapToGui, this.mapToGui);
        if (VoxelMap.mapOptions.worldmapAllowed) {
            float cursorY;
            float cursorX;
            for (CachedRegion region : this.regions) {
                class_2960 resource = region.getTextureLocation();
                if (resource == null) continue;
                guiGraphics.method_25290(VoxelMapPipelines.GUI_TEXTURED_LESS_OR_EQUAL_DEPTH_PIPELINE, resource, region.getX() * 256, region.getZ() * 256, 0.0f, 0.0f, region.getWidth(), region.getWidth(), region.getWidth(), region.getWidth());
            }
            if (VoxelMap.mapOptions.worldborder) {
                class_2784 worldBorder = this.minecraft.field_1687.method_8621();
                float scale = 1.0f / (float)this.minecraft.method_22683().method_4495() / this.mapToGui;
                float x1 = (float)worldBorder.method_11976();
                float z1 = (float)worldBorder.method_11958();
                float x2 = (float)worldBorder.method_11963();
                float z2 = (float)worldBorder.method_11977();
                VoxelMapGuiGraphics.fillGradient(guiGraphics, x1 - scale, z1 - scale, x2 + scale, z1 + scale, -65536, -65536, -65536, -65536);
                VoxelMapGuiGraphics.fillGradient(guiGraphics, x1 - scale, z2 - scale, x2 + scale, z2 + scale, -65536, -65536, -65536, -65536);
                VoxelMapGuiGraphics.fillGradient(guiGraphics, x1 - scale, z1 - scale, x1 + scale, z2 + scale, -65536, -65536, -65536, -65536);
                VoxelMapGuiGraphics.fillGradient(guiGraphics, x2 - scale, z1 - scale, x2 + scale, z2 + scale, -65536, -65536, -65536, -65536);
            }
            if (this.mouseCursorShown) {
                cursorX = mouseDirectX;
                cursorY = mouseDirectY - (float)this.top * this.guiToDirectMouse;
            } else {
                cursorX = (float)this.minecraft.method_22683().method_4489() / 2.0f;
                cursorY = (float)this.minecraft.method_22683().method_4506() - (float)this.minecraft.method_22683().method_4506() / 2.0f - (float)this.top * this.guiToDirectMouse;
            }
            if (this.oldNorth) {
                cursorCoordX = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
                cursorCoordZ = -(cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap));
            } else {
                cursorCoordX = cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap);
                cursorCoordZ = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
            }
            if (this.oldNorth) {
                guiGraphics.method_51448().rotate(-1.5707964f);
            }
            guiGraphics.method_51448().scale(this.guiToMap, this.guiToMap);
            guiGraphics.method_51448().translate(-((float)this.centerX - this.mapCenterX * this.mapToGui), -((float)(this.top + this.centerY) - this.mapCenterZ * this.mapToGui));
            if (this.mapOptions.biomeOverlay != 0) {
                float biomeScaleX = this.mapPixelsX / 760.0f;
                float biomeScaleY = this.mapPixelsY / 360.0f;
                boolean still = !this.leftMouseButtonDown;
                still = still && this.zoom == this.zoomGoal;
                still = still && this.deltaX == 0.0f && this.deltaY == 0.0f;
                boolean bl = still = still && ThreadManager.executorService.getActiveCount() == 0;
                if (still && !this.lastStill) {
                    int column = this.oldNorth ? (int)Math.floor(Math.floor(this.mapCenterZ - (float)this.centerY * this.guiToMap) / 256.0) - (left - 1) : (int)Math.floor(Math.floor(this.mapCenterX - (float)this.centerX * this.guiToMap) / 256.0) - (left - 1);
                    for (int x = 0; x < this.biomeMapData.getWidth(); ++x) {
                        for (int z = 0; z < this.biomeMapData.getHeight(); ++z) {
                            float floatMapZ;
                            float floatMapX;
                            if (this.oldNorth) {
                                floatMapX = (float)z * biomeScaleY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
                                floatMapZ = -((float)x * biomeScaleX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap));
                            } else {
                                floatMapX = (float)x * biomeScaleX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap);
                                floatMapZ = (float)z * biomeScaleY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
                            }
                            int mapX = (int)Math.floor(floatMapX);
                            int mapZ = (int)Math.floor(floatMapZ);
                            int regionX = (int)Math.floor((float)mapX / 256.0f) - (left - 1);
                            int regionZ = (int)Math.floor((float)mapZ / 256.0f) - (top - 1);
                            if (!this.oldNorth && regionX != column || this.oldNorth && regionZ != column) {
                                this.persistentMap.compress();
                            }
                            column = !this.oldNorth ? regionX : regionZ;
                            CachedRegion region = this.regions[regionZ * (right + 1 - (left - 1) + 1) + regionX];
                            class_1959 biome = null;
                            if (region.getMapData() != null && region.isLoaded() && !region.isEmpty()) {
                                int inRegionX = mapX - region.getX() * region.getWidth();
                                int inRegionZ = mapZ - region.getZ() * region.getWidth();
                                int height = region.getMapData().getHeight(inRegionX, inRegionZ);
                                int light = region.getMapData().getLight(inRegionX, inRegionZ);
                                if (height != Short.MIN_VALUE || light != 0) {
                                    biome = region.getMapData().getBiome(inRegionX, inRegionZ);
                                }
                            }
                            this.biomeMapData.setBiome(x, z, biome);
                        }
                    }
                    this.persistentMap.compress();
                    this.biomeMapData.segmentBiomes();
                    this.biomeMapData.findCenterOfSegments(true);
                }
                this.lastStill = still;
                boolean displayStill = !this.leftMouseButtonDown;
                displayStill = displayStill && this.zoom == this.zoomGoal;
                boolean bl2 = displayStill = displayStill && this.deltaX == 0.0f && this.deltaY == 0.0f;
                if (displayStill) {
                    int minimumSize = (int)(20.0f * this.scScale / biomeScaleX);
                    minimumSize *= minimumSize;
                    ArrayList<AbstractMapData.BiomeLabel> labels = this.biomeMapData.getBiomeLabels();
                    for (AbstractMapData.BiomeLabel biomeLabel : labels) {
                        if (biomeLabel.segmentSize <= minimumSize) continue;
                        String label = biomeLabel.name;
                        int nameWidth = this.chkLen(label);
                        float x = (float)biomeLabel.x * biomeScaleX / this.scScale;
                        float z = (float)biomeLabel.z * biomeScaleY / this.scScale;
                        this.write(guiGraphics, label, x - (float)nameWidth / 2.0f, (float)this.top + z - 3.0f, -1);
                    }
                }
            }
        }
        guiGraphics.method_51448().popMatrix();
        if (VoxelMap.mapOptions.waypointsAllowed && this.options.showWaypoints) {
            for (Waypoint pt : this.waypointManager.getWaypoints()) {
                this.drawWaypoint(guiGraphics, pt, cursorCoordX, cursorCoordZ, null);
            }
            if (this.waypointManager.getHighlightedWaypoint() != null) {
                this.drawWaypoint(guiGraphics, this.waypointManager.getHighlightedWaypoint(), cursorCoordX, cursorCoordZ, VoxelConstants.getVoxelMapInstance().getWaypointManager().getTextureAtlas().getAtlasSprite("voxelmap:images/waypoints/target.png"));
            }
        }
        if (gotSkin) {
            boolean hover;
            float playerX = (float)GameVariableAccessShim.xCoordDouble();
            float playerZ = (float)GameVariableAccessShim.zCoordDouble();
            float width = (float)this.iconsWidth * 0.75f;
            float height = (float)this.iconsHeight * 0.75f;
            boolean bl = hover = cursorCoordX >= playerX - width / 2.0f * this.guiToMap && cursorCoordX <= playerX + width / 2.0f * this.guiToMap && cursorCoordZ >= playerZ - height / 2.0f * this.guiToMap && cursorCoordZ <= playerZ + height / 2.0f * this.guiToMap;
            if (hover) {
                guiGraphics.method_74037(class_11876.field_62454);
                this.renderTooltip(guiGraphics, (class_2561)class_2561.method_43470((String)("X: " + GameVariableAccessShim.xCoord() + ", Y: " + GameVariableAccessShim.yCoord() + ", Z: " + GameVariableAccessShim.zCoord())), this.mouseX, this.mouseY);
            }
            int x = this.field_22789 / 2;
            int y = this.field_22790 / 2;
            double wayX = this.mapCenterX - (this.oldNorth ? -playerZ : playerX);
            double wayY = this.mapCenterZ - (this.oldNorth ? playerX : playerZ);
            float locate = (float)Math.atan2(wayX, wayY);
            float hypot = (float)Math.sqrt(wayX * wayX + wayY * wayY) * this.mapToGui;
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().translate((float)x, (float)y);
            guiGraphics.method_51448().rotate(-locate);
            guiGraphics.method_51448().translate(0.0f, -hypot);
            guiGraphics.method_51448().rotate(locate);
            guiGraphics.method_51448().translate((float)(-x), (float)(-y));
            VoxelMapGuiGraphics.blitFloat(guiGraphics, VoxelMapPipelines.GUI_TEXTURED_LESS_OR_EQUAL_DEPTH_PIPELINE, this.voxelmapSkinLocation, (float)x - width / 2.0f, (float)y - height / 2.0f, width, height, 0.0f, 1.0f, 0.0f, 1.0f, -1);
            guiGraphics.method_51448().popMatrix();
        }
        if (System.currentTimeMillis() - this.timeOfLastKBInput < 2000L) {
            int scWidth = this.minecraft.method_22683().method_4486();
            int scHeight = this.minecraft.method_22683().method_4502();
            guiGraphics.method_25290(class_10799.field_56890, this.crosshairResource, scWidth / 2 - 8, scHeight / 2 - 8, 0.0f, 0.0f, 15, 15, 15, 15);
        } else {
            this.switchToMouseInput();
        }
        this.overlayBackground(guiGraphics, 0, this.top, 255, 255);
        this.overlayBackground(guiGraphics, this.bottom, this.getHeight(), 255, 255);
        if (VoxelMap.mapOptions.worldmapAllowed) {
            guiGraphics.method_25300(this.method_64506(), this.screenTitle, this.getWidth() / 2, 16, -1);
            int x = (int)Math.floor(cursorCoordX);
            int z = (int)Math.floor(cursorCoordZ);
            if (VoxelConstants.getVoxelMapInstance().getMapOptions().coords) {
                if (!this.editingCoordinates) {
                    guiGraphics.method_25303(this.method_64506(), "X: " + x, this.sideMargin, 16, -1);
                    guiGraphics.method_25303(this.method_64506(), "Z: " + z, this.sideMargin + 64, 16, -1);
                } else {
                    this.coordinates.method_25394(guiGraphics, mouseX, mouseY, delta);
                }
            }
            if (this.subworldName != null && !this.subworldName.equals(VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(true)) || VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(true) != null && !VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(true).equals(this.subworldName)) {
                this.buildWorldName();
            }
            guiGraphics.method_25303(this.method_64506(), this.worldNameDisplay, this.getWidth() - this.sideMargin - this.worldNameDisplayLength, 16, 0xFFFFFF);
            if (this.buttonMultiworld != null) {
                if ((this.subworldName == null || this.subworldName.isEmpty()) && VoxelConstants.getVoxelMapInstance().getWaypointManager().isMultiworld()) {
                    if ((int)(System.currentTimeMillis() / 1000L % 2L) == 0) {
                        this.buttonMultiworld.method_25355((class_2561)this.multiworldButtonNameRed);
                    } else {
                        this.buttonMultiworld.method_25355(this.multiworldButtonName);
                    }
                } else {
                    this.buttonMultiworld.method_25355(this.multiworldButtonName);
                }
            }
        } else {
            guiGraphics.method_27535(this.method_64506(), (class_2561)class_2561.method_43471((String)"worldmap.disabled"), this.sideMargin, 16, -1);
        }
        super.method_25394(guiGraphics, mouseX, mouseY, delta);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    private void drawWaypoint(class_332 guiGraphics, Waypoint pt, float cursorCoordX, float cursorCoordZ, Sprite icon) {
        boolean hover;
        if (!pt.inWorld || !pt.inDimension) {
            return;
        }
        float ptX = (float)pt.getX() + 0.5f;
        float ptZ = (float)pt.getZ() + 0.5f;
        Object name = pt.name;
        boolean bl = hover = pt.inWorld && pt.inDimension && cursorCoordX >= ptX - (float)(this.iconsWidth / 2) * this.guiToMap && cursorCoordX <= ptX + (float)(this.iconsWidth / 2) * this.guiToMap && cursorCoordZ >= ptZ - (float)(this.iconsHeight / 2) * this.guiToMap && cursorCoordZ <= ptZ + (float)(this.iconsHeight / 2) * this.guiToMap;
        if (hover) {
            guiGraphics.method_74037(class_11876.field_62454);
            this.renderTooltip(guiGraphics, (class_2561)class_2561.method_43470((String)("X: " + pt.getX() + ", Y: " + pt.getY() + ", Z: " + pt.getZ())), this.mouseX, this.mouseY);
        }
        boolean target = false;
        TextureAtlas atlas = VoxelConstants.getVoxelMapInstance().getWaypointManager().getTextureAtlas();
        if (icon == null) {
            icon = atlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + ".png");
            if (icon == atlas.getMissingImage()) {
                icon = atlas.getAtlasSprite("voxelmap:images/waypoints/waypoint.png");
            }
        } else {
            if (((String)name).isEmpty()) {
                name = "X:" + pt.getX() + ", Y:" + pt.getY() + ", Z:" + pt.getZ();
            }
            target = true;
        }
        int x = this.field_22789 / 2;
        int y = this.field_22790 / 2;
        double wayX = this.mapCenterX - (this.oldNorth ? -ptZ : ptX);
        double wayY = this.mapCenterZ - (this.oldNorth ? ptX : ptZ);
        float locate = (float)Math.atan2(wayX, wayY);
        float hypot = (float)Math.sqrt(wayX * wayX + wayY * wayY) * this.mapToGui;
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate((float)x, (float)y);
        guiGraphics.method_51448().rotate(-locate);
        guiGraphics.method_51448().translate(0.0f, -hypot);
        guiGraphics.method_51448().rotate(locate);
        guiGraphics.method_51448().translate((float)(-x), (float)(-y));
        int color = pt.getUnifiedColor(!pt.enabled && !target && !hover ? 0.3f : 1.0f);
        icon.blit(guiGraphics, VoxelMapPipelines.GUI_TEXTURED_LESS_OR_EQUAL_DEPTH_PIPELINE, x - this.iconsWidth / 2, y - this.iconsHeight / 2, this.iconsWidth, this.iconsHeight, color);
        if (this.mapOptions.biomeOverlay == 0 && this.options.showWaypointNames || target || hover) {
            float fontScale = 1.0f;
            int halfWidth = this.chkLen((String)name) / 2;
            guiGraphics.method_51448().pushMatrix();
            guiGraphics.method_51448().scale(fontScale, fontScale);
            this.write(guiGraphics, (String)name, (float)x / fontScale - (float)halfWidth, (float)y / fontScale + (float)(this.iconsHeight / 2), !pt.enabled && !target && !hover ? 0x55FFFFFF : -1);
            guiGraphics.method_51448().popMatrix();
        }
        guiGraphics.method_51448().popMatrix();
    }

    public void renderBackground(class_332 drawContext) {
        drawContext.method_25294(0, 0, this.getWidth(), this.getHeight(), -16777216);
    }

    protected void overlayBackground(class_332 guiGraphics, int startY, int endY, int startAlpha, int endAlpha) {
        int colorBase = 0x404040;
        int colorStart = startAlpha << 24 | colorBase;
        int colorEnd = endAlpha << 24 | colorBase;
        float renderedTextureSize = 32.0f;
        VoxelMapGuiGraphics.blitFloatGradient(guiGraphics, class_10799.field_56883, VoxelConstants.getOptionsBackgroundTexture(), 0.0f, (float)startY, (float)this.getWidth(), (float)endY, 0.0f, (float)this.field_22789 / renderedTextureSize, 0.0f, (float)endY / renderedTextureSize, colorStart, colorEnd);
    }

    public void method_25393() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void method_25432() {
        Object object = this.closedLock;
        synchronized (object) {
            this.closed = true;
            this.persistentMap.getRegions(0, -1, 0, -1);
            this.regions = new CachedRegion[0];
        }
    }

    private void createPopup(int x, int y, int directX, int directY) {
        Popup.PopupEntry entry;
        float cursorCoordZ;
        float cursorCoordX;
        ArrayList<Popup.PopupEntry> entries = new ArrayList<Popup.PopupEntry>();
        float cursorX = directX;
        float cursorY = (float)directY - (float)this.top * this.guiToDirectMouse;
        if (this.oldNorth) {
            cursorCoordX = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
            cursorCoordZ = -(cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap));
        } else {
            cursorCoordX = cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap);
            cursorCoordZ = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
        }
        Waypoint hovered = this.getHovered(cursorCoordX, cursorCoordZ);
        if (hovered != null && this.waypointManager.getWaypoints().contains(hovered)) {
            entry = new Popup.PopupEntry(class_1074.method_4662((String)"selectServer.edit", (Object[])new Object[0]), 4, true, true);
            entries.add(entry);
            entry = new Popup.PopupEntry(class_1074.method_4662((String)"selectServer.delete", (Object[])new Object[0]), 5, true, true);
            entries.add(entry);
            entry = new Popup.PopupEntry(class_1074.method_4662((String)(hovered != this.waypointManager.getHighlightedWaypoint() ? "minimap.waypoints.highlight" : "minimap.waypoints.removeHighlight"), (Object[])new Object[0]), 1, true, true);
        } else {
            entry = new Popup.PopupEntry(class_1074.method_4662((String)"minimap.waypoints.newWaypoint", (Object[])new Object[0]), 0, true, VoxelMap.mapOptions.waypointsAllowed);
            entries.add(entry);
            entry = new Popup.PopupEntry(class_1074.method_4662((String)(hovered == null ? "minimap.waypoints.highlight" : "minimap.waypoints.removeHighlight"), (Object[])new Object[0]), 1, true, VoxelMap.mapOptions.waypointsAllowed);
        }
        entries.add(entry);
        entry = new Popup.PopupEntry(class_1074.method_4662((String)"minimap.waypoints.teleportTo", (Object[])new Object[0]), 3, true, true);
        entries.add(entry);
        entry = new Popup.PopupEntry(class_1074.method_4662((String)"minimap.waypoints.share", (Object[])new Object[0]), 2, true, true);
        entries.add(entry);
        this.createPopup(x, y, directX, directY, 60, entries);
    }

    private Waypoint getHovered(float cursorCoordX, float cursorCoordZ) {
        Waypoint pt;
        if (!VoxelMap.mapOptions.waypointsAllowed) {
            return null;
        }
        Waypoint waypoint = null;
        for (Waypoint pt2 : this.waypointManager.getWaypoints()) {
            float ptX = (float)pt2.getX() + 0.5f;
            float ptZ = (float)pt2.getZ() + 0.5f;
            boolean hover = pt2.inWorld && pt2.inDimension && cursorCoordX >= ptX - (float)(this.iconsWidth / 2) * this.guiToMap && cursorCoordX <= ptX + (float)(this.iconsWidth / 2) * this.guiToMap && cursorCoordZ >= ptZ - (float)(this.iconsHeight / 2) * this.guiToMap && cursorCoordZ <= ptZ + (float)(this.iconsHeight / 2) * this.guiToMap;
            if (!hover) continue;
            waypoint = pt2;
        }
        if (waypoint == null && (pt = this.waypointManager.getHighlightedWaypoint()) != null) {
            boolean hover;
            float ptX = (float)pt.getX() + 0.5f;
            float ptZ = (float)pt.getZ() + 0.5f;
            boolean bl = hover = pt.inWorld && pt.inDimension && cursorCoordX >= ptX - (float)(this.iconsWidth / 2) * this.guiToMap && cursorCoordX <= ptX + (float)(this.iconsWidth / 2) * this.guiToMap && cursorCoordZ >= ptZ - (float)(this.iconsHeight / 2) * this.guiToMap && cursorCoordZ <= ptZ + (float)(this.iconsHeight / 2) * this.guiToMap;
            if (hover) {
                waypoint = pt;
            }
        }
        return waypoint;
    }

    @Override
    public void popupAction(Popup popup, int action) {
        float cursorCoordZ;
        float cursorCoordX;
        int mouseDirectX = popup.getClickedDirectX();
        int mouseDirectY = popup.getClickedDirectY();
        float cursorX = mouseDirectX;
        float cursorY = (float)mouseDirectY - (float)this.top * this.guiToDirectMouse;
        if (this.oldNorth) {
            cursorCoordX = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
            cursorCoordZ = -(cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap));
        } else {
            cursorCoordX = cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap);
            cursorCoordZ = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
        }
        int x = (int)Math.floor(cursorCoordX);
        int z = (int)Math.floor(cursorCoordZ);
        int y = this.persistentMap.getHeightAt(x, z);
        Waypoint hovered = this.getHovered(cursorCoordX, cursorCoordZ);
        this.editClicked = false;
        this.addClicked = false;
        this.deleteClicked = false;
        double dimensionScale = VoxelConstants.getPlayer().method_73183().method_8597().comp_646();
        switch (action) {
            case 0: {
                float b;
                float g;
                float r;
                if (hovered != null) {
                    x = hovered.getX();
                    z = hovered.getZ();
                }
                this.addClicked = true;
                if (this.waypointManager.getWaypoints().isEmpty()) {
                    r = 0.0f;
                    g = 1.0f;
                    b = 0.0f;
                } else {
                    r = this.generator.nextFloat();
                    g = this.generator.nextFloat();
                    b = this.generator.nextFloat();
                }
                TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
                dimensions.add(VoxelConstants.getVoxelMapInstance().getDimensionManager().getDimensionContainerByWorld(VoxelConstants.getPlayer().method_73183()));
                y = y > VoxelConstants.getPlayer().method_73183().method_31607() ? y : 64;
                this.newWaypoint = new Waypoint("", (int)((double)x * dimensionScale), (int)((double)z * dimensionScale), y, true, r, g, b, "", VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(false), dimensions);
                this.minecraft.method_1507((class_437)new GuiAddWaypoint(this, this.newWaypoint, false));
                break;
            }
            case 1: {
                if (hovered != null) {
                    this.waypointManager.setHighlightedWaypoint(hovered, true);
                    break;
                }
                y = y > VoxelConstants.getPlayer().method_73183().method_31607() ? y : 64;
                TreeSet<DimensionContainer> dimensions2 = new TreeSet<DimensionContainer>();
                dimensions2.add(VoxelConstants.getVoxelMapInstance().getDimensionManager().getDimensionContainerByWorld(VoxelConstants.getPlayer().method_73183()));
                Waypoint fakePoint = new Waypoint("", (int)((double)x * dimensionScale), (int)((double)z * dimensionScale), y, true, 1.0f, 0.0f, 0.0f, "", VoxelConstants.getVoxelMapInstance().getWaypointManager().getCurrentSubworldDescriptor(false), dimensions2);
                this.waypointManager.setHighlightedWaypoint(fakePoint, true);
                break;
            }
            case 2: {
                if (hovered != null) {
                    CommandUtils.sendWaypoint(hovered);
                    break;
                }
                y = y > VoxelConstants.getPlayer().method_73183().method_31607() ? y : 64;
                CommandUtils.sendCoordinate(x, y, z);
                break;
            }
            case 3: {
                if (hovered == null) {
                    if (y < VoxelConstants.getPlayer().method_73183().method_31607()) {
                        y = !VoxelConstants.getPlayer().method_73183().method_8597().comp_643() ? VoxelConstants.getPlayer().method_73183().method_31600() : 64;
                    }
                    VoxelConstants.playerRunTeleportCommand(x, y, z);
                    break;
                }
                this.selectedWaypoint = hovered;
                y = this.selectedWaypoint.getY() > VoxelConstants.getPlayer().method_73183().method_31607() ? this.selectedWaypoint.getY() : (!VoxelConstants.getPlayer().method_73183().method_8597().comp_643() ? VoxelConstants.getPlayer().method_73183().method_31600() : 64);
                VoxelConstants.playerRunTeleportCommand(this.selectedWaypoint.getX(), y, this.selectedWaypoint.getZ());
                break;
            }
            case 4: {
                if (hovered == null) break;
                this.editClicked = true;
                this.selectedWaypoint = hovered;
                this.minecraft.method_1507((class_437)new GuiAddWaypoint(this, hovered, true));
                break;
            }
            case 5: {
                if (hovered == null) break;
                this.deleteClicked = true;
                this.selectedWaypoint = hovered;
                class_5250 title = class_2561.method_43471((String)"minimap.waypoints.deleteConfirm");
                class_5250 explanation = class_2561.method_43469((String)"selectServer.deleteWarning", (Object[])new Object[]{this.selectedWaypoint.name});
                class_5250 affirm = class_2561.method_43471((String)"selectServer.deleteButton");
                class_5250 deny = class_2561.method_43471((String)"gui.cancel");
                class_410 confirmScreen = new class_410((BooleanConsumer)this, (class_2561)title, (class_2561)explanation, (class_2561)affirm, (class_2561)deny);
                this.minecraft.method_1507((class_437)confirmScreen);
                break;
            }
            default: {
                VoxelConstants.getLogger().warn("unimplemented command");
            }
        }
    }

    @Override
    public boolean isEditing() {
        return this.editClicked;
    }

    public void accept(boolean b) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (b) {
                this.waypointManager.deleteWaypoint(this.selectedWaypoint);
                this.selectedWaypoint = null;
            }
        }
        if (this.editClicked) {
            this.editClicked = false;
            if (b) {
                this.waypointManager.saveWaypoints();
            }
        }
        if (this.addClicked) {
            this.addClicked = false;
            if (b) {
                this.waypointManager.addWaypoint(this.newWaypoint);
            }
        }
        this.minecraft.method_1507((class_437)this);
    }

    private int chkLen(String string) {
        return this.method_64506().method_1727(string);
    }

    private void write(class_332 drawContext, String string, float x, float y, int color) {
        drawContext.method_25303(this.field_22793, string, (int)x, (int)y, color);
    }
}

