/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.textures;

import com.google.common.collect.Maps;
import com.mamiyaotaru.voxelmap.VoxelConstants;
import com.mamiyaotaru.voxelmap.textures.IIconCreator;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.Stitcher;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.TextureFormat;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_10539;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;

public class TextureAtlas
extends class_1044 {
    private final HashMap<Object, Sprite> mapRegisteredSprites = Maps.newHashMap();
    private final HashMap<Object, Sprite> mapUploadedSprites = Maps.newHashMap();
    private final String basePath;
    private final IIconCreator iconCreator;
    private final Sprite missingImage = new Sprite("missingno", this);
    private final Sprite failedImage = new Sprite("notfound", this);
    private Stitcher stitcher;
    private boolean linearFilter;
    private boolean mipmap;
    private class_2960 resourceLocation;

    public TextureAtlas(String basePath, class_2960 resourceLocation) {
        this(basePath, resourceLocation, null);
    }

    public TextureAtlas(String basePath, class_2960 resourceLocation, IIconCreator iconCreator) {
        this.basePath = basePath;
        this.iconCreator = iconCreator;
        this.resourceLocation = resourceLocation;
        class_310.method_1551().method_1531().method_4616(resourceLocation, (class_1044)this);
    }

    public void method_4527(boolean linearFilter, boolean mipmap) {
        this.linearFilter = linearFilter;
        this.mipmap = mipmap;
        if (this.field_56974 != null) {
            super.method_4527(linearFilter, mipmap);
        }
    }

    private void initMissingImage() {
        this.missingImage.setTextureData(new class_1011(1, 1, true));
        this.failedImage.copyFrom(this.missingImage);
        this.failedImage.setTextureData(new class_1011(1, 1, true));
    }

    public void load(class_3300 manager) {
        if (this.iconCreator != null) {
            this.loadTextureAtlas(this.iconCreator);
        }
    }

    public void reset() {
        for (Sprite e : this.mapRegisteredSprites.values()) {
            e.setTextureData(null);
        }
        for (Sprite e : this.mapUploadedSprites.values()) {
            e.setTextureData(null);
        }
        this.mapRegisteredSprites.clear();
        this.mapUploadedSprites.clear();
        this.initMissingImage();
        int glMaxTextureSize = RenderSystem.getDevice().getMaxTextureSize();
        this.stitcher = new Stitcher(glMaxTextureSize, glMaxTextureSize, 0);
    }

    public void loadTextureAtlas(IIconCreator iconCreator) {
        this.reset();
        iconCreator.addIcons(this);
        this.stitch();
    }

    public void stitch() {
        for (Map.Entry<Object, Sprite> entry : this.mapRegisteredSprites.entrySet()) {
            Sprite icon = entry.getValue();
            if (icon.getTextureData() == null) continue;
            this.stitcher.addSprite(icon);
        }
        this.stitcher.doStitch();
        VoxelConstants.getLogger().info("Created: {}x{} {}-atlas", new Object[]{this.stitcher.getCurrentImageWidth(), this.stitcher.getCurrentImageHeight(), this.basePath});
        this.field_56974 = RenderSystem.getDevice().createTexture("voxelmap-atlas", 7, TextureFormat.RGBA8, this.stitcher.getCurrentImageWidth(), this.stitcher.getCurrentImageHeight(), 1, 1);
        this.field_60597 = RenderSystem.getDevice().createTextureView(this.field_56974);
        super.method_4527(this.linearFilter, this.mipmap);
        HashMap tempMapRegisteredSprites = Maps.newHashMap(this.mapRegisteredSprites);
        for (Sprite icon : this.stitcher.getStitchSlots()) {
            Object iconName = icon.getIconName();
            tempMapRegisteredSprites.remove(iconName);
            this.mapUploadedSprites.put(iconName, icon);
            this.mapRegisteredSprites.remove(iconName);
            try {
                if (icon.getTextureData() == null) continue;
                RenderSystem.getDevice().createCommandEncoder().writeToTexture(this.field_56974, icon.getTextureData(), 0, 0, icon.getOriginX(), icon.getOriginY(), icon.getIconWidth(), icon.getIconHeight(), 0, 0);
            }
            catch (Throwable var10) {
                class_128 crashReport = class_128.method_560((Throwable)var10, (String)"Stitching texture atlas");
                class_129 crashReportCategory = crashReport.method_562("Texture being stitched together");
                crashReportCategory.method_578("Atlas path", (Object)this.basePath);
                crashReportCategory.method_578("Sprite", (Object)icon);
                throw new class_148(crashReport);
            }
        }
        for (Sprite icon : tempMapRegisteredSprites.values()) {
            if (icon.getTextureData() == null) continue;
            icon.copyFrom(this.missingImage);
            this.mapRegisteredSprites.remove(icon.getIconName());
        }
        this.missingImage.initSprite(this.getHeight(), this.getWidth(), 0, 0);
        this.failedImage.initSprite(this.getHeight(), this.getWidth(), 0, 0);
    }

    public void stitchNew() {
        for (Map.Entry<Object, Sprite> entry : this.mapRegisteredSprites.entrySet()) {
            Sprite icon = entry.getValue();
            if (icon.getTextureData() == null) continue;
            this.stitcher.addSprite(icon);
        }
        int oldWidth = this.stitcher.getCurrentImageWidth();
        int oldHeight = this.stitcher.getCurrentImageHeight();
        this.stitcher.doStitchNew();
        if (this.field_56974 == null || oldWidth != this.stitcher.getCurrentImageWidth() || oldHeight != this.stitcher.getCurrentImageHeight()) {
            if (this.field_56974 != null) {
                this.field_56974.close();
                this.field_56974 = null;
            }
            VoxelConstants.getLogger().info("Resized to: {}x{} {}-atlas", new Object[]{this.stitcher.getCurrentImageWidth(), this.stitcher.getCurrentImageHeight(), this.basePath});
            this.field_56974 = RenderSystem.getDevice().createTexture("voxelmap-atlas", 7, TextureFormat.RGBA8, this.stitcher.getCurrentImageWidth(), this.stitcher.getCurrentImageHeight(), 1, 1);
            this.field_60597 = RenderSystem.getDevice().createTextureView(this.field_56974);
            super.method_4527(this.linearFilter, this.mipmap);
        }
        HashMap tempMapRegisteredSprites = Maps.newHashMap(this.mapRegisteredSprites);
        for (Sprite icon : this.stitcher.getStitchSlots()) {
            Object iconName = icon.getIconName();
            tempMapRegisteredSprites.remove(iconName);
            this.mapUploadedSprites.put(iconName, icon);
            this.mapRegisteredSprites.remove(iconName);
            try {
                if (icon.getTextureData() == null) continue;
                RenderSystem.getDevice().createCommandEncoder().writeToTexture(this.field_56974, icon.getTextureData(), 0, 0, icon.getOriginX(), icon.getOriginY(), icon.getIconWidth(), icon.getIconHeight(), 0, 0);
            }
            catch (Throwable var11) {
                class_128 crashReport = class_128.method_560((Throwable)var11, (String)"Stitching texture atlas");
                class_129 crashReportCategory = crashReport.method_562("Texture being stitched together");
                crashReportCategory.method_578("Atlas path", (Object)this.basePath);
                crashReportCategory.method_578("Sprite", (Object)icon);
                throw new class_148(crashReport);
            }
        }
        for (Sprite icon : tempMapRegisteredSprites.values()) {
            if (icon.getTextureData() == null) continue;
            icon.copyFrom(this.missingImage);
            this.mapRegisteredSprites.remove(icon.getIconName());
        }
        this.missingImage.initSprite(this.getHeight(), this.getWidth(), 0, 0);
        this.failedImage.initSprite(this.getHeight(), this.getWidth(), 0, 0);
    }

    public void saveDebugImage() {
        ImageUtils.saveImage(this.basePath.replaceAll("/", "_"), this.method_68004(), 0, this.stitcher.getCurrentImageWidth(), this.stitcher.getCurrentImageHeight());
    }

    public Sprite getIconAt(float x, float y) {
        return this.mapUploadedSprites.entrySet().stream().map(stringSpriteEntry -> (Sprite)stringSpriteEntry.getValue()).filter(icon -> x >= (float)icon.originX && x < (float)(icon.originX + icon.width) && y >= (float)icon.originY && y < (float)(icon.originY + icon.height)).findFirst().orElse(this.missingImage);
    }

    public Sprite getAtlasSprite(Object name) {
        Sprite icon = this.mapUploadedSprites.get(name);
        if (icon == null) {
            icon = this.missingImage;
        }
        return icon;
    }

    public Sprite getAtlasSpriteIncludingYetToBeStitched(Object name) {
        Sprite icon = this.mapUploadedSprites.get(name);
        if (icon == null) {
            icon = this.mapRegisteredSprites.get(name);
        }
        if (icon == null) {
            icon = this.missingImage;
        }
        return icon;
    }

    public Sprite registerIconForResource(class_2960 resourceLocation) {
        if (resourceLocation == null) {
            throw new IllegalArgumentException("Location cannot be null!");
        }
        Sprite icon = this.mapRegisteredSprites.get(resourceLocation.toString());
        if (icon == null) {
            icon = Sprite.spriteFromResourceLocation(resourceLocation, this);
            try {
                class_10539 image = class_10539.method_65871((class_3300)class_310.method_1551().method_1478(), (class_2960)resourceLocation);
                icon.setTextureData(image.comp_3447());
            }
            catch (RuntimeException var6) {
                VoxelConstants.getLogger().error("Unable to parse metadata from " + String.valueOf(resourceLocation), (Throwable)var6);
            }
            catch (IOException var7) {
                VoxelConstants.getLogger().error("Using missing texture, unable to load " + String.valueOf(resourceLocation), (Throwable)var7);
            }
            this.mapRegisteredSprites.put(resourceLocation.toString(), icon);
        }
        return icon;
    }

    public Sprite registerIconForBufferedImage(Object name, BufferedImage bufferedImage) {
        class_1011 img = ImageUtils.nativeImageFromBufferedImage(bufferedImage);
        return this.registerIconForBufferedImage(name, img);
    }

    public Sprite registerIconForBufferedImage(Object name, class_1011 bufferedImage) {
        if (name != null) {
            Sprite icon = this.mapRegisteredSprites.get(name);
            if (icon == null) {
                icon = Sprite.spriteFromString(name, this);
                icon.setTextureData(bufferedImage);
                this.mapRegisteredSprites.put(name, icon);
            }
            return icon;
        }
        throw new IllegalArgumentException("Name cannot be null!");
    }

    public Sprite registerEmptyIcon(Object name) {
        Sprite icon = this.mapRegisteredSprites.get(name);
        if (icon == null) {
            icon = Sprite.spriteFromString(name, this);
            this.mapRegisteredSprites.put(name, icon);
        }
        return icon;
    }

    public Sprite getMissingImage() {
        return this.missingImage;
    }

    public Sprite getFailedImage() {
        return this.failedImage;
    }

    public void registerFailedIcon(String name) {
        this.mapUploadedSprites.put(name, this.failedImage);
    }

    public void registerMaskedIcon(Object name, Sprite originalIcon) {
        Sprite existingIcon = this.mapUploadedSprites.get(name);
        if (existingIcon == null) {
            existingIcon = this.mapRegisteredSprites.get(name);
        }
        if (existingIcon == null) {
            this.mapUploadedSprites.put(name, originalIcon);
        }
    }

    public int getWidth() {
        return this.stitcher.getCurrentWidth();
    }

    public int getHeight() {
        return this.stitcher.getCurrentHeight();
    }

    public int getImageWidth() {
        return this.stitcher.getCurrentImageWidth();
    }

    public int getImageHeight() {
        return this.stitcher.getCurrentImageHeight();
    }

    public class_2960 getResourceLocation() {
        return this.resourceLocation;
    }
}

